/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;

public class JSStringLiteralTypeImpl
extends JSStringType
implements JSPrimitiveLiteralType<String> {
    @NotNull
    protected final String myUnquotedValue;
    protected final boolean myAllowWidening;

    public JSStringLiteralTypeImpl(@NotNull String literal, boolean allowWidening, @NotNull JSTypeSource source) {
        if (literal == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myUnquotedValue = literal;
        this.myAllowWidening = allowWidening;
    }

    public JSStringLiteralTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
        this.myUnquotedValue = JSTypeSerializer.readString(inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myUnquotedValue, outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
    }

    @Override
    @NotNull
    public String getLiteral() {
        String string = this.myUnquotedValue;
        if (string == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        return "string";
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        if (this.isEcma() || format == JSType.TypeTextFormat.RESOLVED) {
            builder.append("String");
            return;
        }
        if (this.allowWidening() && this.isJavaScript()) {
            builder.append("string");
            return;
        }
        builder.append(!this.allowWidening() || format != JSType.TypeTextFormat.CODE ? StringUtil.wrapWithDoubleQuote((String)this.myUnquotedValue) : "string");
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        if (elementType instanceof JSStringLiteralTypeImpl && this.isSourceStrict() && (!this.myAllowWidening || processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) == Boolean.TRUE)) {
            return this.myUnquotedValue.equals(((JSStringLiteralTypeImpl)elementType).myUnquotedValue);
        }
        if (elementType instanceof JSStringType) {
            if (this.isJavaScript()) {
                return true;
            }
            if (!this.myAllowWidening) {
                return false;
            }
        }
        if (!this.myAllowWidening && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                String stringValue = value.getStringValue();
                return stringValue != null && stringValue.equals(this.myUnquotedValue);
            }
            if (resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        return this.myUnquotedValue.equals(((JSStringLiteralTypeImpl)type).myUnquotedValue) && super.isEquivalentToWithSameClass(type, processingContext, allowResolve);
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    protected JSStringLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return new JSStringLiteralTypeImpl(this.getLiteral(), this.myAllowWidening, source);
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = this;
            if (jSStringLiteralTypeImpl == null) {
                JSStringLiteralTypeImpl.$$$reportNull$$$0(12);
            }
            return jSStringLiteralTypeImpl;
        }
        return new JSStringLiteralTypeImpl(this.myUnquotedValue, allowWidening, this.getSource());
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        StringBuilder builder = new StringBuilder();
        JSStringUtil.escapeSimpleStringChars(this.myUnquotedValue, '\"', false, false, false, builder);
        String string = StringUtil.wrapWithDoubleQuote((String)builder.toString());
        if (string == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

