/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterTypeDecoratorImpl
implements JSParameterTypeDecorator {
    public static final JSParameterTypeDecorator EMPTY = new JSParameterTypeDecoratorImpl(null, false, false, false);
    @Nullable
    private final JSType myType;
    private final boolean myOptional;
    private final boolean myRest;
    private final boolean myExplicitlyDeclared;
    private final String myName;

    public JSParameterTypeDecoratorImpl(@NotNull JSParameterTypeDecorator toCopy, @Nullable JSType newType) {
        if (toCopy == null) {
            JSParameterTypeDecoratorImpl.$$$reportNull$$$0(0);
        }
        this(toCopy.getName(), newType, toCopy.isOptional(), toCopy.isRest(), toCopy.isExplicitlyDeclared());
    }

    public JSParameterTypeDecoratorImpl(@Nullable JSType type, boolean optional, boolean rest, boolean explicitlyDeclared) {
        this(null, type, optional, rest, explicitlyDeclared);
    }

    public JSParameterTypeDecoratorImpl(@Nullable String name, @Nullable JSType type, boolean optional, boolean rest, boolean explicitlyDeclared) {
        this.myName = name;
        this.myType = type;
        this.myOptional = optional;
        this.myRest = rest;
        this.myExplicitlyDeclared = explicitlyDeclared;
    }

    @NotNull
    public static JSParameterTypeDecoratorImpl withName(@NotNull JSParameterTypeDecorator p, @Nullable String name) {
        if (p == null) {
            JSParameterTypeDecoratorImpl.$$$reportNull$$$0(1);
        }
        return new JSParameterTypeDecoratorImpl(name, p.getSimpleType(), p.isOptional(), p.isRest(), p.isExplicitlyDeclared());
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public JSType getSimpleType() {
        return this.myType;
    }

    @Nullable
    public JSType getInferredType() {
        JSType type = this.getSimpleType();
        return this.isOptional() ? TypeScriptTypeGuard.wrapWithUndefined(type, null) : type;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    public boolean isRest() {
        return this.myRest;
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = this;
        if (jSParameterTypeDecoratorImpl == null) {
            JSParameterTypeDecoratorImpl.$$$reportNull$$$0(2);
        }
        return jSParameterTypeDecoratorImpl;
    }

    public boolean isExplicitlyDeclared() {
        return this.myExplicitlyDeclared;
    }

    public boolean isEquivalentTo(@Nullable JSParameterTypeDecorator next, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (next == null) {
            return false;
        }
        return this.isOptional() == next.isOptional() && this.isRest() == next.isRest() && this.isExplicitlyDeclared() == next.isExplicitlyDeclared() && Objects.equals(this.getName(), next.getName()) && JSType.isEquivalentToSafe((JSType)this.getSimpleType(), (JSType)next.getSimpleType(), (ProcessingContext)processingContext, (boolean)allowResolve);
    }

    public int hashCode() {
        return Objects.hash(this.myType, this.myName, this.myOptional, this.myRest, this.myExplicitlyDeclared);
    }

    @NotNull
    public JSParameterTypeDecorator copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        JSType newType;
        if (childTransform == null) {
            JSParameterTypeDecoratorImpl.$$$reportNull$$$0(3);
        }
        if ((newType = JSTypeUtils.transformTypeHierarchySafe(this.myType, childTransform)) == this.myType) {
            JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = this;
            if (jSParameterTypeDecoratorImpl == null) {
                JSParameterTypeDecoratorImpl.$$$reportNull$$$0(4);
            }
            return jSParameterTypeDecoratorImpl;
        }
        return new JSParameterTypeDecoratorImpl(this, newType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCopy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSParameterTypeDecoratorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSParameterTypeDecoratorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

