/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportType
extends JSNamedType
implements JSEvaluableType,
JSTypeWithDeclarations {
    private final String myTypeText;

    public JSImportType(String typeText, @NotNull JSTypeSource source, @NotNull JSTypeContext jsTypeContext) {
        if (source == null) {
            JSImportType.$$$reportNull$$$0(0);
        }
        if (jsTypeContext == null) {
            JSImportType.$$$reportNull$$$0(1);
        }
        super(source, jsTypeContext);
        this.myTypeText = typeText;
    }

    protected JSImportType(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSImportType.$$$reportNull$$$0(2);
        }
        if (serialized == null) {
            JSImportType.$$$reportNull$$$0(3);
        }
        super(source, serialized);
        this.myTypeText = JSTypeSerializer.readString(serialized);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        if (childTransform == null) {
            JSImportType.$$$reportNull$$$0(4);
        }
        JSImportType jSImportType = this;
        if (jSImportType == null) {
            JSImportType.$$$reportNull$$$0(5);
        }
        return jSImportType;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSImportType.$$$reportNull$$$0(6);
        }
        return new JSImportType(this.myTypeText, source, this.getTypeContext());
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSImportType.$$$reportNull$$$0(7);
        }
        return super.isEquivalentToWithSameClass(type, context, allowResolve) && this.myTypeText.equals(((JSImportType)type).myTypeText);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSImportType.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            JSImportType.$$$reportNull$$$0(9);
        }
        boolean isStatic = this.getTypeContext() == JSTypeContext.STATIC;
        builder.append((isStatic ? "typeof " : "") + this.myTypeText);
    }

    @Override
    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        Collection<? extends PsiElement> elements;
        if (context == null) {
            JSImportType.$$$reportNull$$$0(10);
        }
        if ((elements = this.resolveElements()).isEmpty()) {
            return JSAnyType.get(this.getSource());
        }
        return this.convertImportType(elements);
    }

    @NotNull
    private Collection<? extends PsiElement> resolveElements() {
        PsiElement element = this.getSourceElement();
        if (element == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                JSImportType.$$$reportNull$$$0(11);
            }
            return list2;
        }
        JSImportHandler handler = JSDialectSpecificHandlersFactory.forElement(element).getImportHandler();
        JSTypeResolveResult result2 = handler.resolveMainElementName(this.myTypeText, element, this.getJSContext());
        Collection<? extends PsiElement> collection = result2.getElements();
        if (collection == null) {
            JSImportType.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    private JSType convertImportType(Collection<? extends PsiElement> declarations) {
        SmartList types2 = new SmartList();
        boolean isStatic = this.getJSContext() == JSContext.STATIC;
        HashSet<String> qNameTypes = new HashSet<String>();
        for (PsiElement psiElement : declarations) {
            if (psiElement instanceof JSClass) {
                JSType type;
                JSType jSType = type = isStatic ? ((JSClass)psiElement).getStaticJSType() : ((JSClass)psiElement).getJSType();
                if (type instanceof JSNamedType && !qNameTypes.add(type.getTypeText())) continue;
                types2.add(type);
                continue;
            }
            if (!isStatic && !(psiElement instanceof JSFieldVariable) && !(psiElement instanceof JSFile) && !(psiElement instanceof JSFunction)) continue;
            ContainerUtil.addIfNotNull((Collection)types2, (Object)JSResolveUtil.getElementJSType(psiElement));
        }
        JSType jSType = JSCompositeTypeFactory.createContextualUnionType((Collection<? extends JSType>)types2, this.getSource());
        if (jSType == null) {
            JSImportType.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myTypeText, this.getTypeContext());
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSImportType.$$$reportNull$$$0(14);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myTypeText, outputStream);
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        return new ArrayList<PsiElement>(this.resolveElements());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsTypeContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSImportType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSImportType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertImportType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

