/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.TIntObjectHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSGenericTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    private static final Logger LOGGER = Logger.getInstance(JSGenericTypeImpl.class);
    @NotNull
    private final JSType myType;
    @NotNull
    private final List<JSType> myArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull JSType argument) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(1);
        }
        if (argument == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(2);
        }
        this(source, type, (List<JSType>)ContainerUtil.immutableList((Object[])new JSType[]{argument}));
    }

    JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(4);
        }
        this(source, JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream), JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream));
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(7);
        }
        super(source);
        this.myType = type;
        ImmutableList finalGenerics = JSGenericTypeImpl.computeActualArguments(type, arguments);
        this.myArguments = finalGenerics instanceof ImmutableList ? finalGenerics : ContainerUtil.immutableList(finalGenerics);
    }

    @NotNull
    private static List<JSType> computeActualArguments(@NotNull JSType type, @NotNull List<JSType> arguments) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(8);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(9);
        }
        return JSGenericTypeImpl.fixArguments(arguments, type);
    }

    @NotNull
    private static List<JSType> fixArguments(@NotNull List<JSType> arguments, @NotNull JSType type) {
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(10);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(11);
        }
        if (arguments.stream().noneMatch(arg -> arg instanceof JSNamedTypeSubstitutorType || arg == null)) {
            List<JSType> list2 = arguments;
            if (list2 == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(12);
            }
            return list2;
        }
        ArrayList<JSType> newArgs = new ArrayList<JSType>(arguments.size());
        PsiElement sourceElement = type.getSource().getSourceElement();
        List typeParameterNames = null;
        if (sourceElement instanceof TypeScriptTypeParameterListOwner) {
            typeParameterNames = ContainerUtil.map((Object[])((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameters(), p -> p.getName());
        }
        TIntObjectHashMap toInsert = new TIntObjectHashMap();
        for (JSType arg2 : arguments) {
            if (arg2 instanceof JSNamedTypeSubstitutorType) {
                int index;
                if (typeParameterNames == null || (index = typeParameterNames.indexOf(((JSNamedTypeSubstitutorType)arg2).getGenericName())) == -1) continue;
                toInsert.put(index, (Object)((JSNamedTypeSubstitutorType)arg2).getRealType());
                continue;
            }
            if (arg2 == null) {
                LOGGER.error("Generic argument must be not null");
                arg2 = JSAnyType.get(type.getSource());
            }
            newArgs.add(arg2);
        }
        int[] keys = toInsert.keys();
        Arrays.sort(keys);
        for (int key : keys) {
            if (key < newArgs.size()) continue;
            newArgs.add((JSType)toInsert.get(key));
        }
        ArrayList<JSType> arrayList = newArgs;
        if (arrayList == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(14);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myArguments, outputStream);
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(15);
        }
        visitor.visitJSGenericType((JSType)this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(16);
        }
        this.myType.accept(visitor);
        for (JSType argument : this.getArguments()) {
            argument.accept(visitor);
        }
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(17);
        }
        if (builder == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(18);
        }
        if (!this.isTypeScript()) {
            boolean wrapInBraces = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (wrapInBraces) {
                builder.append("(");
            }
            this.myType.buildTypeText(format, builder);
            if (wrapInBraces) {
                builder.append(")");
            }
            if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
                builder.append(".");
            }
            this.appendArgumentTypeText(format, builder);
            return;
        }
        boolean isNestedFunctionType = this.myType instanceof JSFunctionTypeImpl;
        if (isNestedFunctionType) {
            this.appendArgumentTypeText(format, builder);
            this.myType.buildTypeText(format, builder);
        } else {
            this.myType.buildTypeText(format, builder);
            this.appendArgumentTypeText(format, builder);
        }
    }

    @Override
    protected int hashCodeImpl() {
        int arguments = JSTypeHashCodeUtil.getHashCode(this.getArguments());
        return Objects.hash(this.getType(), arguments);
    }

    private void appendArgumentTypeText(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(20);
        }
        builder.append("<");
        String prefix = "";
        for (JSType argument : this.myArguments) {
            builder.append(prefix);
            argument.buildTypeText(format, builder);
            prefix = ", ";
        }
        builder.append(">");
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    private static boolean isResolvedTypeScript(@NotNull JSType type) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(21);
        }
        if (type.isEcma()) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSType nested = ((JSGenericTypeImpl)type).getType();
            return JSGenericTypeImpl.isResolvedTypeScript(nested);
        }
        if (type instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
            Collection<? extends PsiElement> declarations = info.getDeclarations();
            return !declarations.isEmpty() && declarations.stream().allMatch(el -> DialectDetector.isTypeScript(el));
        }
        return false;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(22);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(23);
        }
        if (this.myArguments.size() == 0) {
            return this.myType.isDirectlyAssignableType(elementType, processingContext);
        }
        if (this.isTypeScript() || JSGenericTypeImpl.isResolvedTypeScript(elementType)) {
            return this.isDirectAssignableTypeInTypeScript(elementType, processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                return false;
            }
            List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).getArguments();
            ListIterator<JSType> iterator = elementTypeArgs.listIterator();
            boolean allArgumentsEquivalent = true;
            for (JSType argument : this.getArguments()) {
                allArgumentsEquivalent &= iterator.hasNext() && this.jsOrASGenericsCompatible(argument, iterator.next(), processingContext);
            }
            return allArgumentsEquivalent && !iterator.hasNext();
        }
        if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
            return false;
        }
        if (elementType instanceof JSArrayType && !((JSArrayType)elementType).isPrimitive()) {
            return this.isDirectlyAssignableType(((JSArrayType)elementType).asGenericType(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    private boolean isDirectAssignableTypeInTypeScript(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult type;
        JSType resolved;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        if (elementType instanceof JSTupleType) {
            return this.isDirectlyAssignableType(((JSTupleType)elementType).toArrayType(true), processingContext);
        }
        if (elementType instanceof JSArrayType) {
            elementType = ((JSArrayType)elementType).asGenericType();
        } else {
            if (elementType instanceof JSUnionType) {
                JSUnionType composite = (JSUnionType)elementType;
                boolean isAssignable = true;
                for (JSType type2 : composite.getTypes()) {
                    if (this.isDirectlyAssignableType(type2, processingContext)) continue;
                    isAssignable = false;
                    break;
                }
                return isAssignable;
            }
            if (elementType instanceof JSRecordType && this != (resolved = this.substituteOrRecordType())) {
                return resolved.isDirectlyAssignableType(elementType, processingContext);
            }
        }
        if ((elementType instanceof JSGenericTypeImpl || elementType instanceof JSNamedType) && (type = JSTypeCastUtil.isDirectlyAssignableInClassHierarchy(this, elementType, processingContext)).isStrict()) {
            return type.isAssignable();
        }
        if (elementType instanceof JSIntersectionType && this.isDirectlyAssignableForIntersection(elementType, processingContext)) {
            return true;
        }
        resolved = this.substituteOrRecordType();
        if (resolved != this) {
            JSType rTypeNested = JSGenericTypeImpl.getGenericOwnerIdOrSelfId(elementType);
            JSType lTypeNested = this.getType();
            return JSRecursiveTypeUtil.computeGenericRecursiveTypes(lTypeNested, rTypeNested, elementType, processingContext, (arg_0, arg_1) -> ((JSType)resolved).isDirectlyAssignableType(arg_0, arg_1));
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private boolean isDirectlyAssignableForIntersection(@NotNull JSType type, @NotNull ProcessingContext context) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(25);
        }
        if (context == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(26);
        }
        if (!(type instanceof JSIntersectionType)) {
            return false;
        }
        boolean forGenerics = JSGenericTypesEvaluator.isGenericProcessingInProgress(context);
        return JSTypeCastUtil.executeJoinInferredGenerics((Processor<? super ProcessingContext>)((Processor)newContext -> {
            boolean isAssignable = false;
            for (JSType jsType : ((JSIntersectionType)type).getTypes()) {
                if (!(isAssignable |= this.isDirectlyAssignableType(jsType, (ProcessingContext)newContext)) || forGenerics) continue;
                return false;
            }
            return isAssignable;
        }), context, this.getSource(), true);
    }

    @NotNull
    public static JSType getGenericOwnerIdOrSelfId(@NotNull JSType elementType) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(27);
        }
        if (elementType instanceof JSAliasTypeImpl) {
            elementType = ((JSAliasTypeImpl)elementType).getAlias();
        }
        JSType jSType = elementType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)elementType).getType() : elementType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @NotNull
    private JSType substituteOrRecordType() {
        JSType resolved = this.substitute();
        if (resolved == this && !this.isJavaScript()) {
            resolved = resolved.asRecordType();
        }
        JSType jSType = resolved;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(29);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(30);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(31);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(32);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(33);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(34);
        }
        if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext, allowResolve)) {
            return false;
        }
        return JSTypeCastUtil.areListsEquivalent(this.myArguments, ((JSGenericTypeImpl)type).myArguments, processingContext, allowResolve);
    }

    private boolean jsOrASGenericsCompatible(@NotNull JSType type1, @NotNull JSType type2, @Nullable ProcessingContext processingContext) {
        if (type1 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(35);
        }
        if (type2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(36);
        }
        if (type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (this.isEcma()) {
            return false;
        }
        if ("Array".equals(JSTypeUtils.getQualifiedNameMatchingType(this.myType, false))) {
            return type1.isDirectlyAssignableType(type2, processingContext);
        }
        return type1.isDirectlyAssignableType(type2, processingContext) || type2.isDirectlyAssignableType(type1, processingContext);
    }

    @NotNull
    public static JSTypeCastUtil.AssignableResult areGenericArgumentsAssignable(@NotNull List<JSType> lArguments, @NotNull List<JSType> rArguments, @Nullable ProcessingContext processingContext) {
        if (lArguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(37);
        }
        if (rArguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(38);
        }
        Iterator<JSType> iterator = rArguments.iterator();
        for (JSType lArgument : lArguments) {
            if (!iterator.hasNext()) {
                JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
                if (assignableResult == null) {
                    JSGenericTypeImpl.$$$reportNull$$$0(39);
                }
                return assignableResult;
            }
            JSType rArgument = iterator.next();
            if (lArgument.isDirectlyAssignableType(rArgument, processingContext) || JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && lArgument instanceof JSGenericParameterType) continue;
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(40);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = iterator.hasNext() ? JSTypeCastUtil.AssignableResult.NOT_SURE : JSTypeCastUtil.AssignableResult.ASSIGNABLE;
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(41);
        }
        return assignableResult;
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl && type.getSource().isEcma()) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            return JSNamedType.isNamedTypeWithName(genericType.myType, "Vector") && genericType.getArguments().size() == 1;
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    @NotNull
    public List<JSType> getArguments() {
        List<JSType> list2 = this.myArguments;
        if (list2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(43);
        }
        return list2;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        if (childTransform == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(44);
        }
        JSType oldType = this.getType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        List<JSType> oldArgs = this.getArguments();
        List newArgs = ContainerUtil.map(oldArgs, type -> JSTypeUtils.transformTypeHierarchySafe(type, childTransform));
        if (newType == oldType && ContainerUtil.equalsIdentity(oldArgs, (List)newArgs)) {
            JSGenericTypeImpl jSGenericTypeImpl = this;
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(45);
            }
            return jSGenericTypeImpl;
        }
        if (newType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl newGenericType = (JSGenericTypeImpl)newType;
            return new JSGenericTypeImpl(this.getSource(), newGenericType.getType(), newGenericType.getArguments());
        }
        return new JSGenericTypeImpl(this.getSource(), newType, newArgs);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(46);
        }
        return new JSGenericTypeImpl(source, this.getType(), this.getArguments());
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType owner;
        if (context == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(47);
        }
        JSType type = this.getType();
        if (this.myArguments.size() == 0) {
            return type;
        }
        if (type instanceof TypeScriptGenericThisTypeImpl && (owner = ((TypeScriptGenericThisTypeImpl)type).getOwnerType()) != null) {
            return new JSGenericTypeImpl(this.getSource(), owner, this.getArguments()).substitute(context);
        }
        PsiElement sourceElement = this.getSourceElement();
        if (sourceElement instanceof JSDocComment && (!(type instanceof JSTypeImpl) || ((JSTypeImpl)type).resolveType().getAliasedType() == null)) {
            return this;
        }
        return JSGenericTypeImpl.expandForGenericType(context, this);
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        JSType substitute;
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(48);
        }
        if ((substitute = this.substitute()) == this) {
            substitute = substitute.asRecordType();
        }
        if (substitute != JSTypeCastUtil.NO_RECORD_TYPE) {
            List typeStream = substitute.getFunctionTypes(processingContext, newCallSignatures).collect(Collectors.toList());
            Stream<JSType> stream = typeStream.stream();
            if (stream == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(49);
            }
            return stream;
        }
        JSType innerType = this.getType();
        Stream<JSType> stream = innerType.getFunctionTypes(processingContext, newCallSignatures).map(functionType -> {
            if (this.isSourceStrict() && !this.isTypeScript()) {
                JSType resultType;
                PsiFile scope = this.getScope();
                JSType jSType = resultType = scope != null ? JSTypeUtils.applyJSGenericsForType(this.getArguments(), innerType, scope, functionType) : functionType;
                if (resultType != functionType) {
                    return resultType;
                }
            }
            PsiElement sourceElement = functionType.getSource().getSourceElement();
            if (functionType instanceof JSFunctionTypeImpl) {
                TypeScriptTypeParameter[] tsSignatureTypeParameters;
                if (sourceElement instanceof TypeScriptFunction && (tsSignatureTypeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement)).length > 0) {
                    JSTypeSubstitutor arguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(tsSignatureTypeParameters, this.getArguments());
                    return JSTypeUtils.applyGenericArguments(functionType, arguments);
                }
                return functionType;
            }
            return new JSGenericTypeImpl(this.getSource(), (JSType)functionType, this.getArguments());
        });
        if (stream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(50);
        }
        return stream;
    }

    @Nullable
    private static JSType expandForGenericType(@NotNull JSTypeSubstitutionContext context, @NotNull JSGenericTypeImpl originalType) {
        JSGenericTypeImpl aliasGenericType;
        JSType alias;
        List<JSType> originalArguments;
        List arguments;
        JSType nestedType;
        JSType expanded;
        if (context == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(51);
        }
        if (originalType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(52);
        }
        if ((expanded = (nestedType = originalType.getType()).substitute(context.withGenerics(arguments = ContainerUtil.map(originalArguments = originalType.getArguments(), type -> {
            JSType result2 = context.substituteNested(type);
            return result2 == null ? JSAnyType.get(type.getSource()) : result2;
        })))) == nestedType) {
            return originalType;
        }
        if (expanded instanceof JSAliasTypeImpl && (alias = ((JSAliasTypeImpl)expanded).getAlias()) instanceof JSGenericTypeImpl && (aliasGenericType = (JSGenericTypeImpl)alias).getType() == nestedType && ContainerUtil.equalsIdentity(aliasGenericType.getArguments(), originalArguments)) {
            return new JSAliasTypeImpl(originalType, ((JSAliasTypeImpl)expanded).getOriginalType(), expanded.getSource());
        }
        return expanded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 21: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 23: 
            case 31: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 26: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lArguments";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArguments";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fixArguments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericOwnerIdOrSelfId";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteOrRecordType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "areGenericArgumentsAssignable";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeActualArguments";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixArguments";
                break;
            }
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentTypeText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedTypeScript";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeInTypeScript";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableForIntersection";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getGenericOwnerIdOrSelfId";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "jsOrASGenericsCompatible";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "areGenericArgumentsAssignable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "expandForGenericType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

