/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSArrayType
extends JSNamespace,
JSUtilType {
    @NotNull
    public JSGenericTypeImpl asGenericType();

    @Nullable
    default public JSType getType() {
        return null;
    }

    public boolean isReadonly();

    public boolean isPrimitive();

    @NotNull
    default public String getDefaultValue() {
        return "[]";
    }

    @NotNull
    default public String getTypeName() {
        return this.isReadonly() ? "ReadonlyArray" : "Array";
    }

    public static boolean isGenericArray(JSGenericTypeImpl genericType) {
        JSType innerType = genericType.getType();
        return innerType instanceof JSArrayType && ((JSArrayType)innerType).isPrimitive() && genericType.getArguments().size() == 1;
    }

    public static final class GenericArrayBuilder {
        @NotNull
        public static JSGenericTypeImpl getGenericType(@NotNull JSType sourceType, @NotNull JSType generic, boolean isReadonly) {
            if (sourceType == null) {
                GenericArrayBuilder.$$$reportNull$$$0(0);
            }
            if (generic == null) {
                GenericArrayBuilder.$$$reportNull$$$0(1);
            }
            JSTypeSource source = sourceType.getSource();
            return GenericArrayBuilder.getGenericType(generic, source, isReadonly);
        }

        @NotNull
        private static JSGenericTypeImpl getGenericType(@NotNull JSType generic, JSTypeSource source, boolean isReadonly) {
            if (generic == null) {
                GenericArrayBuilder.$$$reportNull$$$0(2);
            }
            return new JSGenericTypeImpl(source, JSNamedTypeFactory.createType(isReadonly ? "ReadonlyArray" : "Array", source, JSContext.INSTANCE), generic);
        }

        @Contract(value="!null -> !null")
        public static JSType asArrayIfGenericType(@Nullable JSType sourceType) {
            if (!(sourceType instanceof JSGenericTypeImpl)) {
                return sourceType;
            }
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)sourceType;
            JSType type = genericType.getType();
            if (type instanceof JSArrayType && ((JSArrayType)type).isPrimitive() && genericType.getArguments().size() == 1) {
                return ((JSArrayType)type).isReadonly() ? new JSReadonlyArrayTypeImpl(genericType.getArguments().get(0), sourceType.getSource()) : new JSArrayTypeImpl(genericType.getArguments().get(0), sourceType.getSource());
            }
            return sourceType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "generic";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/types/JSArrayType$GenericArrayBuilder";
            objectArray[2] = "getGenericType";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

