/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSAliasTypeImpl
extends JSTypeBaseImpl
implements JSWrapperType {
    @NotNull
    private final JSType myAlias;
    @NotNull
    private final JSType myOriginal;

    public JSAliasTypeImpl(@NotNull JSType alias, @NotNull JSType expanded, @NotNull JSTypeSource source) {
        if (alias == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(0);
        }
        if (expanded == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myAlias = alias;
        this.myOriginal = expanded;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        JSType alias;
        JSType newAlias;
        if (childTransform == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(3);
        }
        if ((newAlias = JSTypeUtils.transformTypeHierarchySafe(alias = this.getAlias(), childTransform)) == alias) {
            JSAliasTypeImpl jSAliasTypeImpl = this;
            if (jSAliasTypeImpl == null) {
                JSAliasTypeImpl.$$$reportNull$$$0(4);
            }
            return jSAliasTypeImpl;
        }
        JSType newOriginal = JSTypeUtils.transformTypeHierarchySafe(this.getOriginalType(), childTransform);
        if (!JSAliasTypeImpl.shouldPreserveAlias(newOriginal)) {
            JSType jSType = newOriginal;
            if (jSType == null) {
                JSAliasTypeImpl.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        return new JSAliasTypeImpl(newAlias, newOriginal, this.getSource());
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType lId;
        if (elementType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(7);
        }
        if ((lId = this.getIdForGuard()) != null) {
            JSType rId = JSGenericTypeImpl.getGenericOwnerIdOrSelfId(elementType);
            return JSRecursiveTypeUtil.computeGenericRecursiveTypes(lId, rId, elementType, processingContext, this::isDirectlyAssignableTypeWithOriginal);
        }
        return this.isDirectlyAssignableTypeWithOriginal(elementType, processingContext);
    }

    @Nullable
    private JSType getIdForGuard() {
        if (this.myAlias instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)this.myAlias).getType();
        }
        return null;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(8);
        }
        return new JSAliasTypeImpl(this.myAlias, this.myOriginal, source);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(10);
        }
        this.myAlias.buildTypeText(format, builder);
    }

    @NotNull
    public JSType getOriginalType() {
        JSType jSType = this.myOriginal;
        if (jSType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @NotNull
    public JSType getAlias() {
        JSType jSType = this.myAlias;
        if (jSType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType jSRecordType = this.getOriginalType().asRecordType();
        if (jSRecordType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(13);
        }
        return jSRecordType;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(14);
        }
        this.getOriginalType().accept(visitor);
    }

    @Override
    protected int hashCodeImpl() {
        return JSTypeHashCodeUtil.getHashCodeSafe(this.getAlias());
    }

    private boolean isDirectlyAssignableTypeWithOriginal(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(15);
        }
        if (processingContext == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(16);
        }
        return this.getOriginalType().isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(17);
        }
        return this.getAlias().isEquivalentTo(((JSAliasTypeImpl)type).getAlias(), context, allowResolve);
    }

    @NotNull
    public JSType distributeType() {
        JSType originalType = this.getOriginalType();
        if (originalType instanceof JSDistributedType) {
            JSType afterType = ((JSDistributedType)originalType).distributeType();
            JSAliasTypeImpl jSAliasTypeImpl = afterType == originalType ? this : afterType;
            if (jSAliasTypeImpl == null) {
                JSAliasTypeImpl.$$$reportNull$$$0(18);
            }
            return jSAliasTypeImpl;
        }
        JSAliasTypeImpl jSAliasTypeImpl = this;
        if (jSAliasTypeImpl == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(19);
        }
        return jSAliasTypeImpl;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean shouldPreserveAlias(@Nullable JSType afterProcessing) {
        return afterProcessing instanceof JSRecordType || afterProcessing instanceof TypeScriptMappedJSTypeImpl || afterProcessing instanceof JSAliasTypeImpl && !JSAliasTypeImpl.isAliasDepthExceeded((JSAliasTypeImpl)afterProcessing);
    }

    private static boolean isAliasDepthExceeded(@NotNull JSAliasTypeImpl processing) {
        if (processing == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(20);
        }
        int i = 0;
        JSAliasTypeImpl currentType = processing;
        while (currentType instanceof JSAliasTypeImpl) {
            currentType = currentType.getOriginalType();
            if (++i <= 10) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expanded";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSAliasTypeImpl";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSAliasTypeImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlias";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeWithOriginal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAliasDepthExceeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

