/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumSetStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitElementStructureImpl
implements JSImplicitElementStructure {
    protected static final BooleanStructureElement NAMESPACE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    protected static final EnumSetStructureElement<JSImplicitElement.Property> PROPERTIES_FLAG = new EnumSetStructureElement<JSImplicitElement.Property>(JSImplicitElement.Property.class);
    protected static final EnumStructureElement<JSImplicitElement.Type> TYPE_FLAG = new EnumStructureElement<JSImplicitElement.Type>(JSImplicitElement.Type.class);
    protected static final EnumStructureElement<JSContext> JS_CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    protected static final EnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new EnumStructureElement<JSAttributeList.AccessType>(JSAttributeList.AccessType.class);
    protected static final BooleanStructureElement DEPRECATED_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_TYPE_STRING_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_USER_STRING_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_CLASS_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_OPTIONAL_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_JSDOC_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(NAMESPACE_EXPLICITLY_DECLARED_FLAG, PROPERTIES_FLAG, TYPE_FLAG, JS_CONTEXT_FLAG, ACCESS_TYPE_FLAG, DEPRECATED_FLAG, HAS_TYPE_STRING_FLAG, HAS_USER_STRING_FLAG, IS_CLASS_FLAG, IS_OPTIONAL_FLAG, IS_INTERFACE_FLAG, HAS_JSDOC_FLAG);
    protected final int myFlags;
    @NotNull
    protected final String myName;
    @Nullable
    private final JSQualifiedName myNamespace;
    @Nullable
    protected final String myTypeString;
    @Nullable
    private final String myUserString;

    public JSImplicitElementStructureImpl(@NotNull JSImplicitElementImpl.Builder builder) {
        PsiElement provider;
        if (builder == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(0);
        }
        this.myName = builder.myName;
        this.myNamespace = builder.myNamespace;
        this.myTypeString = builder.myTypeString;
        this.myUserString = builder.myUserString;
        int flags = builder.myFlags;
        JSImplicitElement.Type type = JSImplicitElementStructureImpl.readFlag(TYPE_FLAG, flags);
        if (type.providesNamespace()) {
            flags = JSImplicitElementStructureImpl.writeFlag(flags, type == JSImplicitElement.Type.Interface ? IS_INTERFACE_FLAG : IS_CLASS_FLAG, true);
        }
        if ((provider = builder.myProvider) != null && builder.myAllowAstAccess) {
            JSDocComment ownDocComment;
            boolean isRealElementMirror = !(provider instanceof PsiComment);
            PsiElement docComment = JSDocumentationUtils.findCommentForImplicitElement(provider);
            if (!((EnumSet)JSImplicitElementStructureImpl.readFlag(PROPERTIES_FLAG, flags = JSImplicitElementStructureImpl.writeFlag(flags, HAS_JSDOC_FLAG, isRealElementMirror && docComment != null))).contains(JSImplicitElement.Property.MinorImportance) && (ownDocComment = JSDocumentationUtils.findOwnDocCommentForImplicitElement(provider)) != null && ownDocComment.hasDeprecatedTag()) {
                flags = JSImplicitElementStructureImpl.writeFlag(flags, DEPRECATED_FLAG, true);
            }
        }
        this.myFlags = flags = JSImplicitElementStructureImpl.writeFlag(flags, IS_OPTIONAL_FLAG, builder.myOptional);
        assert (this.getType() == JSImplicitElement.Type.Function == this instanceof JSImplicitFunctionStructureImpl);
    }

    protected JSImplicitElementStructureImpl(int flags, @NotNull String name, @Nullable JSQualifiedName namespace, @Nullable String typeString, @Nullable String userString) {
        if (name == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(1);
        }
        this.myFlags = flags;
        this.myName = name;
        this.myNamespace = namespace;
        this.myTypeString = typeString;
        this.myUserString = userString;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public String getQualifiedName() {
        String prefix = this.myNamespace != null ? this.myNamespace.getQualifiedName() + "." : "";
        String string = prefix + this.myName;
        if (string == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.readFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG);
    }

    @Nullable
    public String getUserString() {
        return this.myUserString;
    }

    protected final <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return JSImplicitElementStructureImpl.readFlag(structureElement, this.myFlags);
    }

    protected static <T> T readFlag(FlagsStructureElement<T> structureElement, int flags) {
        return IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, structureElement, flags);
    }

    @Contract(pure=true)
    protected static <T> int writeFlag(int currentFlags, FlagsStructureElement<T> structureElement, T value) {
        return IntFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, structureElement, value, currentFlags);
    }

    public void serialize(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(4);
        }
        JSQualifiedNameImpl qName = JSQualifiedNameImpl.create(this.myName, this.myNamespace);
        JSQualifiedNameImpl.serialize((JSQualifiedName)qName, dataStream);
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myFlags);
        if (this.myTypeString != null) {
            assert (this.readFlag(HAS_TYPE_STRING_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myTypeString);
        }
        if (this.myUserString != null) {
            assert (this.readFlag(HAS_USER_STRING_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myUserString);
        }
    }

    @NotNull
    public static JSImplicitElementStructureImpl deserialize(DataInput dataStream) throws IOException {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.deserialize(dataStream);
        assert (name != null);
        int flags = DataInputOutputUtil.readINT((DataInput)dataStream);
        boolean hasType = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_STRING_FLAG, flags);
        String typeString = hasType ? IOUtil.readUTF((DataInput)dataStream) : null;
        boolean hasUserString = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_USER_STRING_FLAG, flags);
        String userString = hasUserString ? IOUtil.readUTF((DataInput)dataStream) : null;
        JSImplicitElement.Type type = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TYPE_FLAG, flags);
        if (!type.isFunction()) {
            return new JSImplicitElementStructureImpl(flags, name.getName(), name.getParent(), typeString, userString);
        }
        List<JSImplicitParameterStructure> parameters = JSImplicitFunctionStructureImpl.deserializeParameters(dataStream);
        return new JSImplicitFunctionStructureImpl(flags, name.getName(), name.getParent(), typeString, userString, parameters);
    }

    @NotNull
    public JSImplicitElement.Type getType() {
        JSImplicitElement.Type type = this.readFlag(TYPE_FLAG);
        if (type == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(5);
        }
        return type;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(JS_CONTEXT_FLAG);
        if (jSContext == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(6);
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.readFlag(ACCESS_TYPE_FLAG);
        if (accessType == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(7);
        }
        return accessType;
    }

    public boolean hasMinorImportance() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.MinorImportance);
    }

    public boolean isDeprecated() {
        return this.readFlag(DEPRECATED_FLAG);
    }

    public boolean isOptional() {
        return this.readFlag(IS_OPTIONAL_FLAG);
    }

    @Nullable
    public String getTypeString() {
        return this.myTypeString;
    }

    public boolean isConst() {
        return ((EnumSet)this.readFlag(PROPERTIES_FLAG)).contains(JSImplicitElement.Property.Constant);
    }

    @NotNull
    public JSImplicitElementImpl.Builder toBuilder() {
        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(this.myName, null);
        this.fillBuilder(builder);
        JSImplicitElementImpl.Builder builder2 = builder;
        if (builder2 == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(8);
        }
        return builder2;
    }

    protected void fillBuilder(@NotNull JSImplicitElementImpl.Builder builder) {
        if (builder == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(9);
        }
        builder.setName(this.myName).setNamespace(this.myNamespace).setFlags(this.myFlags).setTypeString(this.myTypeString).setPossiblyUnregisteredUserString(this.myUserString);
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = this.readFlag(IS_INTERFACE_FLAG) != false ? JSElementBase.ClassOrInterface.INTERFACE : (this.readFlag(IS_CLASS_FLAG) != false ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(10);
        }
        return classOrInterface;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = JSNamedTypeFactory.buildJSNamespace((JSElementBase)this);
        if (jSNamespace == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(11);
        }
        return jSNamespace;
    }

    public boolean hasJSDoc() {
        return this.readFlag(HAS_JSDOC_FLAG);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSImplicitElementStructureImpl structure = (JSImplicitElementStructureImpl)o;
        if (this.myFlags != structure.myFlags) {
            return false;
        }
        if (!this.myName.equals(structure.myName)) {
            return false;
        }
        if (!Objects.equals(this.myNamespace, structure.myNamespace)) {
            return false;
        }
        if (!Objects.equals(this.myTypeString, structure.myTypeString)) {
            return false;
        }
        return Objects.equals(this.myUserString, structure.myUserString);
    }

    public int hashCode() {
        int result2 = this.myFlags;
        result2 = 31 * result2 + this.myName.hashCode();
        result2 = 31 * result2 + (this.myNamespace != null ? this.myNamespace.hashCode() : 0);
        result2 = 31 * result2 + (this.myTypeString != null ? this.myTypeString.hashCode() : 0);
        result2 = 31 * result2 + (this.myUserString != null ? this.myUserString.hashCode() : 0);
        return result2;
    }

    @NotNull
    public JSIndexableImplicitElement toImplicitElement(@Nullable PsiElement provider) {
        return new JSImplicitElementImpl(this, provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

