/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResolveProcessor
extends JSResolveProcessorBase {
    static final Key<String> ASKING_FOR_QUALIFIED_IMPORT = Key.create((String)"asking.for.import.of.qname");
    protected static final Key<Boolean> LOOKING_FOR_USE_NAMESPACES = Key.create((String)"looking.for.use.directive");
    public static final Key<ProcessingOptions> PROCESSING_OPTIONS = Key.create((String)"PROCESSING_OPTIONS");
    private final Set<JSClass> visitedClasses = new HashSet<JSClass>();
    private boolean toProcessHierarchy;
    private boolean toSkipClassDeclarationOnce;
    private boolean toProcessMembers = true;
    private boolean toProcessActionScriptImplicits = true;
    private boolean encounteredDynamicClasses;
    private boolean encounteredDynamicClassesSet;
    private boolean myTypeContext;
    private boolean localResolve;
    protected boolean isWalkingUpTree;
    protected final PsiElement place;
    protected PsiElement nearestVarWeAreIn;
    private static final Key<Boolean> skipResolveKey = Key.create((String)"skip.package.local.check");
    private boolean myNeedsAllVariants;
    private boolean myForceImportsForPlace;
    public static final PsiScopeProcessor.Event SCOPE_CHANGE = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event INHERITED_CLASSES_STARTED = new PsiScopeProcessor.Event(){};
    public static final PsiScopeProcessor.Event INHERITED_CLASSES_FINISHED = new PsiScopeProcessor.Event(){};
    private ProcessingOptions myProcessingOptions = DEFAULT_RESOLVE;
    public static final ProcessingOptions DEFAULT_RESOLVE = new ProcessingOptions(){};
    protected final AccessibilityProcessingHandler accessibilityProcessingHandler;

    public ResolveProcessor(@Nullable String name) {
        this(name, null);
    }

    public ResolveProcessor(@Nullable String name, @Nullable PsiElement _place) {
        super(name);
        this.place = _place;
        this.accessibilityProcessingHandler = JSDialectSpecificHandlersFactory.forElement(_place).createAccessibilityProcessingHandler(this.place, false);
        if (this.place != null) {
            ProcessingOptions processingOptionsOverride;
            PsiElement element = PsiTreeUtil.getContextOfType((PsiElement)this.place, (boolean)false, (Class[])new Class[]{JSVariable.class, JSFunction.class});
            if (element instanceof JSVariable) {
                this.nearestVarWeAreIn = element;
            }
            if ((processingOptionsOverride = (ProcessingOptions)this.place.getContainingFile().getOriginalFile().getUserData(PROCESSING_OPTIONS)) != null) {
                this.setProcessingOptions(processingOptionsOverride);
            }
        }
    }

    static boolean completeConstructorName(PsiElement place) {
        PsiElement placeParent = place.getParent();
        return placeParent instanceof JSNewExpression && ((JSNewExpression)placeParent).getMethodExpression() == place;
    }

    public void prefixResolved() {
    }

    @Nullable
    public static String getName(PsiElement element) {
        String name;
        if (element instanceof JSNamedElementBase) {
            return ((JSNamedElementBase)element).getName();
        }
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttributeValue("name");
        }
        if (element instanceof XmlToken) {
            return element.getText();
        }
        if (element instanceof CssClass && (name = ((CssClass)element).getName()) != null) {
            return CssClass.kebabToCamelCase((String)name);
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            ResolveProcessor.$$$reportNull$$$0(0);
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER) {
            boolean toProcessParent = true;
            if (associated instanceof JSClass) {
                JSClass jsClass = (JSClass)associated;
                if (!this.toSkipClassDeclarationOnce) {
                    if (!this.encounteredDynamicClassesSet) {
                        JSAttributeList attributeList = jsClass.getAttributeList();
                        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC) || jsClass instanceof TypeScriptInterface) {
                            this.encounteredDynamicClasses = true;
                        }
                        this.encounteredDynamicClassesSet = true;
                    }
                } else {
                    toProcessParent = false;
                }
            }
            if (toProcessParent) {
                this.startingParent((PsiElement)associated);
            }
        } else if (event == INHERITED_CLASSES_STARTED) {
            this.accessibilityProcessingHandler.myProcessingInheritedClasses = true;
        } else if (event == INHERITED_CLASSES_FINISHED) {
            this.accessibilityProcessingHandler.myProcessingInheritedClasses = false;
        }
    }

    protected void startingParent(PsiElement associated) {
        this.accessibilityProcessingHandler.startingParent(associated);
    }

    public boolean isToProcessHierarchy() {
        return this.toProcessHierarchy;
    }

    public void setToProcessHierarchy(boolean toProcessHierarchy) {
        this.toProcessHierarchy = toProcessHierarchy;
    }

    public boolean isToProcessActionScriptImplicits() {
        return this.toProcessActionScriptImplicits;
    }

    public void setToProcessActionScriptImplicits(boolean toProcessActionScriptImplicits) {
        this.toProcessActionScriptImplicits = toProcessActionScriptImplicits;
    }

    public boolean isToSkipClassDeclarationOnce() {
        return this.toSkipClassDeclarationOnce;
    }

    public void setToSkipClassDeclarationsOnce(boolean toSkipClassDeclarationOnce) {
        this.toSkipClassDeclarationOnce = toSkipClassDeclarationOnce;
    }

    public void setTypeContext(boolean b) {
        this.myTypeContext = b;
    }

    public boolean isTypeContext() {
        return this.myTypeContext;
    }

    public boolean isToProcessMembers() {
        return this.toProcessMembers;
    }

    public void setToProcessMembers(boolean toProcessMembers) {
        this.toProcessMembers = toProcessMembers;
    }

    public boolean checkVisited(@NotNull JSClass clazz) {
        if (clazz == null) {
            ResolveProcessor.$$$reportNull$$$0(1);
        }
        return !this.visitedClasses.add(clazz);
    }

    public boolean isLocalResolve() {
        return this.localResolve;
    }

    public boolean setWalkingUpTree(boolean isWalkingUpTree) {
        boolean wasWalkingUpTree = this.isWalkingUpTree;
        this.isWalkingUpTree = isWalkingUpTree;
        return wasWalkingUpTree;
    }

    public void setLocalResolve(boolean localResolve) {
        this.localResolve = localResolve;
    }

    public boolean specificallyAskingToResolveQualifiedNames() {
        return this.getUserData(ASKING_FOR_QUALIFIED_IMPORT) != null;
    }

    public String getQualifiedNameToImport() {
        return (String)this.getUserData(ASKING_FOR_QUALIFIED_IMPORT);
    }

    public boolean lookingForUseNamespaces() {
        return this.getUserData(LOOKING_FOR_USE_NAMESPACES) != null;
    }

    public boolean isEncounteredDynamicClasses() {
        return this.encounteredDynamicClasses;
    }

    public static void setSkipPackageLocalCheck(PsiElement el, boolean state) {
        el.putUserData(skipResolveKey, (Object)(state ? Boolean.TRUE : null));
    }

    public static boolean toSkipPackageLocalCheck(PsiElement el) {
        return el.getUserData(skipResolveKey) != null;
    }

    public void setNeedsAllVariants() {
        this.myNeedsAllVariants = true;
    }

    public boolean needsAllVariants() {
        return this.myNeedsAllVariants || this.specificallyAskingToResolveQualifiedNames();
    }

    public boolean isForceImportsForPlace() {
        return this.myForceImportsForPlace;
    }

    public void setForceImportsForPlace(boolean forceImportsForPlace) {
        this.myForceImportsForPlace = forceImportsForPlace;
    }

    public boolean needPackages() {
        return this.myProcessingOptions.needPackages();
    }

    @NotNull
    public ProcessingOptions getProcessingOptions() {
        ProcessingOptions processingOptions = this.myProcessingOptions;
        if (processingOptions == null) {
            ResolveProcessor.$$$reportNull$$$0(2);
        }
        return processingOptions;
    }

    public void setProcessingOptions(@NotNull ProcessingOptions processingOptions) {
        if (processingOptions == null) {
            ResolveProcessor.$$$reportNull$$$0(3);
        }
        this.myProcessingOptions = processingOptions;
    }

    @NotNull
    public AccessibilityProcessingHandler getAccessibilityProcessingHandler() {
        AccessibilityProcessingHandler accessibilityProcessingHandler = this.accessibilityProcessingHandler;
        if (accessibilityProcessingHandler == null) {
            ResolveProcessor.$$$reportNull$$$0(4);
        }
        return accessibilityProcessingHandler;
    }

    public void configureClassScope(JSClass clazzOfContext) {
        this.accessibilityProcessingHandler.configureClassScope(clazzOfContext);
    }

    public void setAllowUnqualifiedStaticsFromInstance(boolean b) {
        this.accessibilityProcessingHandler.setAllowUnqualifiedStaticsFromInstance(b);
    }

    public void setTypeName(String qualifiedName) {
        this.accessibilityProcessingHandler.setTypeName(qualifiedName);
    }

    public boolean skipTopLevelItems() {
        assert (this.myName != null || this.place == null);
        return false;
    }

    public boolean needTopLevelClassName(String name) {
        assert (this.myName != null || this.place == null);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ResolveProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ResolveProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibilityProcessingHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkVisited";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProcessingOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ProcessingOptions {
        public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
            if (fun == null) {
                ProcessingOptions.$$$reportNull$$$0(0);
            }
            return lastParent != null && lastParent.getContext() == fun;
        }

        public boolean toProcessFunctionArguments() {
            return true;
        }

        public boolean toProcessPackageImports(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return lastParent != null && packageStatement == lastParent.getParent();
        }

        public boolean toProcessPackageContent(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return false;
        }

        public boolean needPackages() {
            return false;
        }

        @Nullable
        public Condition<JSClass> getFilter() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/ResolveProcessor$ProcessingOptions", "toProcessFunctionBodyDeclarations"));
        }
    }
}

