/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSLocalTypeEvaluatorBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.FlowJSFunction;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSThisExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationCache;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElvisType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    public static final String JQUERY_NS = "jQuery";
    @NotNull
    protected JSEvaluateContext myContext;
    @NotNull
    protected final JSTypeEvaluationResultProcessor myTypeProcessor;
    @NotNull
    private static final JSTypeProcessor NOP_TYPE_PROCESSOR = new JSTypeProcessor(){

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
            if (type == null) {
                1.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
            if (type == null) {
                1.$$$reportNull$$$0(2);
            }
            if (evaluateContext == null) {
                1.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAdditionalType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Predicate<JSInitializerOwner> WITH_TYPE_DECLARATION_PREDICATE = owner -> {
        JSFunction function2;
        if (owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getTypeElement() != null) {
            return true;
        }
        if (owner instanceof JSDestructuringParameter && (function2 = ((JSDestructuringParameter)owner).getDeclaringFunction()) instanceof JSFunctionBaseImpl) {
            return ((JSFunctionBaseImpl)function2).getTypeFromComments((JSParameterItem)((JSDestructuringParameter)owner)) != null;
        }
        return false;
    };

    protected JSTypeEvaluator(@NotNull JSEvaluateContext context) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(0);
        }
        this.myTypeProcessor = new JSTypeEvaluationResultProcessor();
        this.myContext = context;
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(2);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)expr, expr.getContainingFile(), typeProcessor, false);
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(5);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)expr, targetFile, typeProcessor, false);
    }

    public static void evaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(8);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes(element, targetFile, typeProcessor, false);
    }

    public void doEvaluateExpressionOrElementTypes(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element)) {
            this.doEvaluateTypes((JSExpression)element);
        } else if (element instanceof JSDestructuringContainer) {
            this.evaluateDestructuringContainer((JSDestructuringContainer)element);
        } else {
            this.doAddTypeFromResolveResult(element);
        }
    }

    public static boolean isEvaluatedAsExpression(@NotNull JSExpression element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(10);
        }
        return !(element instanceof JSDefinitionExpression);
    }

    @NotNull
    public static JSTypeEvaluator createEvaluator(@Nullable PsiElement element, @NotNull JSEvaluateContext context) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(11);
        }
        JSTypeEvaluator jSTypeEvaluator = JSDialectSpecificHandlersFactory.forElement(element).newTypeEvaluator(context, NOP_TYPE_PROCESSOR);
        if (jSTypeEvaluator == null) {
            JSTypeEvaluator.$$$reportNull$$$0(12);
        }
        return jSTypeEvaluator;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static JSTypeEvaluationResult getExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(13);
        }
        return JSTypeEvaluator.getElementType((PsiElement)expression);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(14);
        }
        return JSEvaluationCache.getElementType(element, new JSEvaluateContext(element.getContainingFile(), false));
    }

    static void addTypeEvaluationResultElement(@NotNull JSEvaluationResultElement element, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor typeProcessor) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(17);
        }
        JSReferenceExpression originalExpression = context.getProcessedExpression();
        PsiElement originalSource = context.getSource();
        JSEvaluateContext combinedContext = context.combineWith(element.getEvaluateContext());
        JSType type = element.getTypeOrAdditionalType();
        if (element.isAdditionalType()) {
            typeProcessor.processAdditionalType(type, combinedContext);
            return;
        }
        if (originalExpression != null) {
            type = JSTypeGuardEvaluator.applyToExpressionType(type, (JSExpression)originalExpression, originalSource, combinedContext);
        } else if (originalSource != null) {
            type = JSTypeGuardEvaluator.applyToResolveResultType(type, originalSource, combinedContext);
        }
        typeProcessor.process(type, combinedContext);
    }

    public void addType(@Nullable JSType type) {
        if (type == null) {
            return;
        }
        this.doAddType(type);
    }

    protected void doAddType(@NotNull JSType type) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(18);
        }
        this.addAdditionalTypesForType(type);
        this.myTypeProcessor.process(type, this.myContext);
    }

    @Deprecated
    public void addType(@Nullable JSType type, @Nullable PsiElement source) {
        this.addType(type);
    }

    @Deprecated
    protected void doAddType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(19);
        }
        this.doAddType(type);
    }

    private void addAdditionalTypesForType(@Nullable JSType type) {
        PsiElement element;
        JSType referenceType;
        Object object = type instanceof JSReferenceType || type instanceof JSQualifiedReferenceType ? type : (referenceType = type instanceof JSApplyCallType ? ((JSApplyCallType)type).getBaseType() : null);
        if (referenceType instanceof JSReferenceItem && (element = referenceType.getSourceElement()) != null) {
            JSReferenceItem refType = (JSReferenceItem)referenceType;
            JSTypeEvaluator.addAdditionalTypes(element, refType, this.myTypeProcessor, this.myContext);
        }
    }

    public void addAdditionalType(@NotNull JSType type) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(20);
        }
        this.myTypeProcessor.processAdditionalType(type, this.myContext);
    }

    private void doEvaluateTypes(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(21);
        }
        if (this.myContext.isAstAccessAllowed((PsiElement)rawqualifier) && JSElvisType.isElvisContext(rawqualifier)) {
            JSType qualifierType = JSEvaluableOnlyTypeBase.substituteWithEvaluator(JSAnyType.get((PsiElement)rawqualifier, true), evaluator -> {
                evaluator.doEvaluateTypesImpl(rawqualifier);
                return JSEvaluationTasks.fromList(Collections.unmodifiableList(evaluator.getResult().getResults()));
            });
            qualifierType = JSElvisType.applyElvisContext(rawqualifier, qualifierType);
            this.addType(qualifierType);
            return;
        }
        this.doEvaluateTypesImpl(rawqualifier);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEvaluateTypesImpl(@NotNull JSExpression rawqualifier) {
        JSType typecast;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(22);
        }
        if (this.myContext.isAstAccessAllowed((PsiElement)rawqualifier) && (typecast = this.evaluateTypeFromInlineComment(rawqualifier)) != null) {
            this.addType(typecast);
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            rawqualifier = ((JSDefinitionExpression)rawqualifier).getExpression();
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)rawqualifier;
            if (referenceExpression.getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)));
                return;
            }
            this.processRefExpr(referenceExpression);
            return;
        }
        if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPrefixExpression) {
            JSPrefixExpression prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            JSType evaluatedJsType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (JSSymbolUtil.isLiteralOrLiteralWithSign((JSExpression)prefixExpression)) {
                    this.addTypeFromLiteralExpression((JSExpression)prefixExpression);
                    return;
                }
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.addNumericOperatorType(prefixExpression.getExpression(), null, (JSExpression)prefixExpression);
                    return;
                }
                JSType type = this.getExpressionTypeInContext(prefixExpression.getExpression());
                if (type != null) {
                    evaluatedType = type.getTypeText();
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                    evaluatedJsType = JSCompositeTypeFactory.createUnionType(typeSource, ContainerUtil.map((Object[])JSCommonTypeNames.TYPEOF_VALUES, v -> new JSStringLiteralTypeImpl((String)v, false, typeSource)));
                } else {
                    evaluatedType = "string";
                }
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign) {
                this.addCodeBasedType(rawqualifier);
                return;
            }
            if (evaluatedJsType != null) {
                this.addType(evaluatedJsType);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSType type = JSNamedTypeFactory.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type);
                return;
            }
            this.setUnknownElement((PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPostfixExpression) {
            JSPostfixExpression postfixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = postfixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS != sign) {
                if (JSTokenTypes.MINUSMINUS != sign) return;
            }
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                this.simpleEvalType(rawqualifier, postfixExpression.getExpression());
                return;
            }
            this.addNumericOperatorType(postfixExpression.getExpression(), null, rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand == null) return;
            if (rOperand == null) return;
            this.processBinaryOperation(binaryExpression, sign, lOperand, rOperand);
            return;
        }
        if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSType type;
            JSArrayLiteralExpression literal = (JSArrayLiteralExpression)rawqualifier;
            if (!literal.isEmpty()) {
                type = this.getArrayTypeFromExpressions(literal, literal.getExpressionStream());
            } else {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                type = new JSArrayTypeImpl(JSAnyType.get((PsiElement)rawqualifier, true), typeSource);
            }
            this.addType(type);
            return;
        }
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.addType(this.getIndexedPropertyAccessType((JSIndexedPropertyAccessExpression)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.myContext.isAstAccessAllowed((PsiElement)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression());
            return;
        }
        if (rawqualifier instanceof JSThisExpression) {
            this.processThisQualifierExpression((JSThisExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSSuperExpression) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
            return;
        }
        if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunction)((JSFunctionExpression)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = conditionalExpression.getThen();
            JSExpression elsePart = conditionalExpression.getElse();
            JSType thenType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, thenPart);
            JSType elseType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, elsePart);
            if (thenType == null) {
                if (elseType == null) return;
            }
            JSType common = TypeScriptTypeRelations.getBestChoiceType(thenType, elseType, (PsiElement)conditionalExpression);
            this.addType(common);
            return;
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false)));
            return;
        }
        if (this.evaluateDialectSpecificTypes(rawqualifier)) return;
        if (rawqualifier == null) return;
        this.setUnknownElement((PsiElement)rawqualifier);
    }

    private void processBinaryOperation(@NotNull JSBinaryExpression binaryExpression, @Nullable IElementType sign, @Nullable JSExpression lOperand, @Nullable JSExpression rOperand) {
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(23);
        }
        if (sign == JSTokenTypes.AS_KEYWORD) {
            this.resolveAsBinaryOperationExpression((JSExpression)binaryExpression, rOperand);
        } else if (JSTokenTypes.BOOLEAN_RESULT_OPERATIONS.contains(sign)) {
            this.addType(new JSBooleanType(true, JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression, true), JSTypeContext.INSTANCE));
        } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR || sign == JSTokenTypes.QUEST_QUEST || sign == JSTokenTypes.MULTMULT) {
            if (sign == JSTokenTypes.DIV || (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.MULTMULT || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign)) && !DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                this.addNumericOperatorType(lOperand, rOperand, (JSExpression)binaryExpression);
            } else {
                JSType lProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(lOperand));
                JSType rProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(rOperand));
                if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.QUEST_QUEST) {
                    this.evaluateAndOrOrType((JSExpression)binaryExpression, sign, lProcType, rProcType);
                } else {
                    this.evaluatePlusType(binaryExpression, lProcType, rProcType);
                }
            }
        } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(sign)) {
            JSTypeEvaluationResult result2 = null;
            if (lOperand instanceof JSDefinitionExpression) {
                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
            }
            if (lOperand != null && DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                result2 = this.getTypeEvaluationResultInContext((PsiElement)lOperand);
            }
            if (result2 == null) {
                result2 = this.getTypeEvaluationResultInContext((PsiElement)rOperand);
            }
            if (result2 != null) {
                for (JSEvaluationResultElement element : result2.getResults()) {
                    JSTypeEvaluator.addTypeEvaluationResultElement(element, this.myContext, this.myTypeProcessor);
                }
            } else {
                this.setUnknownElement((PsiElement)binaryExpression);
            }
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) {
            this.simpleEvalType((JSExpression)binaryExpression, lOperand);
        }
    }

    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(24);
        }
        return JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier);
    }

    private void addNumericOperatorType(@Nullable JSExpression firstOperand, @Nullable JSExpression secondOperand, @NotNull JSExpression evaluatedExpression) {
        if (evaluatedExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(25);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)evaluatedExpression, true);
        JSType expressionType = this.getExpressionTypeInContext(firstOperand);
        if (expressionType instanceof JSBigIntType) {
            this.addType(new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE));
        } else {
            JSType otherExpressionType = this.getExpressionTypeInContext(secondOperand);
            if (otherExpressionType instanceof JSBigIntType) {
                this.addType(new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE));
            } else {
                this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE));
            }
        }
    }

    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        JSType evaluatedType;
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(26);
        }
        if ((evaluatedType = JSLocalTypeEvaluatorBase.evaluatePlusForExpandedTypes((PsiElement)binaryExpression, lProcType, rProcType)) != null) {
            this.addType(evaluatedType);
        } else {
            this.setUnknownElement((PsiElement)binaryExpression);
        }
    }

    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(27);
        }
        if (sign == null) {
            JSTypeEvaluator.$$$reportNull$$$0(28);
        }
        if (lProcType != null) {
            this.addType(lProcType);
        }
        if (rProcType != null) {
            this.addType(rProcType);
        }
        if (lProcType == null && rProcType == null) {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        JSExpression qualifier;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(29);
        }
        if ((qualifier = rawqualifier.getQualifier()) == null) {
            return null;
        }
        JSPsiBasedTypeOfType qualifierType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)qualifier, this.myContext);
        JSExpression indexExpression = rawqualifier.getIndexExpression();
        JSType indexExpressionType = indexExpression == null ? null : (JSPsiImplUtils.isSymbolRef(indexExpression) || indexExpression instanceof JSReferenceExpression && ((JSReferenceExpression)indexExpression).getQualifier() == null ? JSResolveUtil.getExpressionJSType(indexExpression) : JSTypeEvaluator.getTypeFromConstant(indexExpression));
        return new JSApplyIndexedAccessType(qualifierType, indexExpressionType, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true));
    }

    private void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier) {
        JSClass jsClass;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(30);
        }
        JSClass jSClass = jsClass = JSResolveUtil.ownerHasExplicitThisParameter((JSExpression)rawqualifier) ? null : (JSClass)ObjectUtils.tryCast((Object)JSThisExpressionImpl.resolveThisContext((PsiElement)rawqualifier), JSClass.class);
        if (jsClass != null) {
            JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
            this.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
        } else {
            PsiElement thisScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)rawqualifier);
            this.processThisQualifierInExecutionScope(rawqualifier, thisScope);
        }
    }

    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(31);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(32);
        }
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(33);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        this.addType(this.createTypeForThisExpression(staticOrInstance, jsClass, typeSource));
    }

    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull JSClass jsClass, @NotNull JSTypeSource typeSource) {
        JSNamespace ns;
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(34);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(35);
        }
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(36);
        }
        if ((ns = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)jsClass, typeSource.isStrict())) == null) {
            ns = JSAnyType.get(typeSource);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.copyWithJSContext(ns, staticOrInstance);
        if (jSNamespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(37);
        }
        return jSNamespace;
    }

    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        JSType typeFromParameter;
        if (thisQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(38);
        }
        if (thisScope instanceof FlowJSFunction && (typeFromParameter = TypeScriptPsiUtil.getThisParameterType((JSFunction)thisScope)) != null) {
            this.addType(typeFromParameter);
            return;
        }
        JSType type = JSDocumentationUtils.findContextType(thisScope);
        if (type != null) {
            this.addType(type);
        } else {
            JSNamespace thisType = JSContextResolver.resolveContext((PsiElement)thisQualifier, this.myContext.isAstAccessAllowed((PsiElement)thisQualifier));
            if (thisType != null) {
                this.addType((JSType)thisType);
            } else if (thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                JSType funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)thisScope), this.getContextualExpectedTypeKind());
                if ((funcType = JSTypeUtils.getValuableType(funcType)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                    this.addType((JSType)thisType);
                }
            }
            if (thisType == null) {
                this.setUnknownElement((PsiElement)thisQualifier);
            }
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        JSType type;
        PsiElement resolve;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && (type = ((JSVariable)resolve).getJSType()) instanceof JSNamedType && "Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, false));
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand, false);
            this.addType(JSTypeUtils.createType(rOperand.getText(), source));
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        JSClass aClass;
        String name;
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0 && (name = (aClass = classes[0]).getQualifiedName()) != null) {
            this.addType(JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)aClass, false), JSContext.UNKNOWN));
        }
    }

    @Nullable
    private JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = this.getExpressionTypeInContext(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression, false);
        }
        return partType;
    }

    protected boolean isContextualOverloadEvaluation() {
        return this.myContext.isContextualOverloadEvaluation();
    }

    @Nullable
    protected JSType getExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        return JSResolveUtil.getElementJSType((PsiElement)toEvaluate, this.isContextualOverloadEvaluation());
    }

    @Nullable
    protected JSType getLazyExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        if (toEvaluate == null) {
            return null;
        }
        return JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)toEvaluate, this.myContext);
    }

    @Nullable
    protected JSTypeEvaluationResult getTypeEvaluationResultInContext(@Nullable PsiElement toEvaluate) {
        return toEvaluate == null ? null : JSEvaluationCache.getElementType(toEvaluate, this.myContext);
    }

    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(39);
        }
        if (expressions == null) {
            JSTypeEvaluator.$$$reportNull$$$0(40);
        }
        List providers = expressions.map(el -> () -> JSTypeEvaluator.getTypeOrSpread(el, this.getExpressionTypeForArrayLiteral((JSExpression)rawQualifier, (JSExpression)el, null))).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)rawQualifier, true);
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true));
    }

    @Nullable
    protected static JSType getTypeOrSpread(@NotNull JSExpression el, @Nullable JSType type) {
        if (el == null) {
            JSTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (el instanceof JSSpreadExpression) {
            return new JSSpreadTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)el, true), type == null ? JSAnyType.get((PsiElement)el, true) : type);
        }
        return type;
    }

    @Nullable
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression arrayLiteralExpression, @Nullable JSExpression expression, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType exprType;
        JSType jSType = expression instanceof JSSpreadExpression ? this.getArrayElementTypeFromSpread((JSSpreadExpression)expression) : (exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression) : this.createNullType(arrayLiteralExpression));
        if (exprType == null && (typesToEvaluateLimit == null || typesToEvaluateLimit.decrementAndGet() >= 0)) {
            exprType = this.getLazyExpressionTypeInContext(expression);
        }
        return exprType;
    }

    @Nullable
    private JSType getArrayElementTypeFromSpread(@NotNull JSSpreadExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(42);
        }
        return this.getExpressionTypeInContext(expression.getExpression());
    }

    @NotNull
    protected JSType createNullType(@Nullable JSExpression rawqualifier) {
        JSType jSType = JSNamedTypeFactory.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(43);
        }
        return jSType;
    }

    protected void addTypeFromLocalName(PsiNamedElement resolveResult) {
        String name = resolveResult.getName();
        if (name != null && DialectDetector.isJavaScript((PsiElement)resolveResult)) {
            JSNamespace ns = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, (PsiElement)resolveResult, false, true, true);
            this.addAdditionalType((JSType)ns);
        }
    }

    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        return false;
    }

    protected void evaluateNewExpressionTypes(@NotNull JSNewExpression newExpression) {
        if (newExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(44);
        }
        this.addCodeBasedType((JSExpression)newExpression);
    }

    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression) {
        JSClass jsClass;
        JSFunction parentFunction;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(45);
        }
        if (callExpression instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)callExpression);
            return;
        }
        if (!this.myContext.isAstAccessAllowed((PsiElement)callExpression)) {
            JSExpression methodExpression = callExpression.getStubSafeMethodExpression();
            if (methodExpression != null) {
                JSApplyCallType type = new JSApplyCallType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)methodExpression, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, true));
                this.addType(type);
            }
            return;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)callExpression);
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                boolean processed = this.processCreateMethodCall(callExpression, invoked);
                if (processed) {
                    return;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processApplyOrCallMethodCall(methodExpression, invoked);
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processReduceMethodCall(methodExpression, invoked);
            } else {
                if (!this.processRequireMethodCall(callExpression)) {
                    return;
                }
                if (JSGclReferenceContributor.isGoogRequireCall(methodExpression)) {
                    this.addTypeFromGclRequireCall(callExpression);
                    return;
                }
            }
        }
        if (methodExpression instanceof JSSuperExpression && !DialectDetector.isTypeScript((PsiElement)callExpression) && (parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)methodExpression)) != null && parentFunction.isConstructor() && (jsClass = JSResolveUtil.getClassOfContext((PsiElement)parentFunction)) != null) {
            this.addType(jsClass.getJSType());
        }
        if (methodExpression != null) {
            JSApplyCallType type = new JSApplyCallType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)methodExpression, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, true));
            this.addType(type);
        }
    }

    private void addTypeFromGclRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(46);
        }
        JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(DialectDetector.isTypeScript((PsiElement)callExpression)));
        boolean resolvedToModule = false;
        JSGclModuleReference reference = JSGclReferenceContributor.getGclModuleReference(callExpression);
        if (reference != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = reference.multiResolve(false)) {
                PsiFile file2;
                PsiElement element = result2.getElement();
                if (!(element instanceof JSImplicitElement) || !"gcl".equals(((JSImplicitElement)element).getUserString()) || !((file2 = element.getContainingFile()) instanceof JSFile)) continue;
                resolvedToModule = true;
                this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)file2);
                List<JSPsiElementBase> exportsList = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit("exports", file2);
                if (exportsList.size() != 1) continue;
                JSPsiElementBase exportElement = (JSPsiElementBase)exportsList.iterator().next();
                this.addTypeFromResolveResult((PsiElement)exportElement);
            }
            if (!resolvedToModule) {
                JSQualifiedName qName = reference.getQualifiedName();
                JSNamespace namespace = JSNamedTypeFactory.createNamespace(qName, JSContext.STATIC, reference.getElement(), true);
                reference.getElement();
                this.addAdditionalType((JSType)namespace);
            }
        }
        this.finishEvaluationWithContext(previousContext);
    }

    protected boolean processRequireMethodCall(@NotNull JSCallExpression callExpression) {
        String value;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(47);
        }
        if (!callExpression.isRequireCall() || !this.getEvaluateContext().isAstAccessAllowed((PsiElement)callExpression)) {
            return true;
        }
        if (JSAmdPsiUtil.isWithinAmdModule((PsiElement)callExpression)) {
            JSLiteralExpression amdModuleReference = (JSLiteralExpression)callExpression.getArguments()[0];
            Collection<PsiElement> modules = CommonJSUtil.findReferencedModulesIfRequireCall(callExpression);
            if (!modules.isEmpty() && modules.size() <= JSRequireCallExpressionType.MAX_MODULES_TO_EVALUATE) {
                for (PsiElement module : modules) {
                    this.addTypeFromAmdModule(amdModuleReference, module);
                }
            }
            return true;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression && (value = ((JSLiteralExpression)arguments[0]).getStringValue()) != null) {
            boolean isJavaScript = DialectDetector.isJavaScript((PsiElement)callExpression);
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, isJavaScript);
            JSRequireCallExpressionType type = new JSRequireCallExpressionType(value, typeSource);
            this.addType(type);
            return !isJavaScript && CommonJSUtil.findReferencedModulesIfRequireCall(callExpression).isEmpty();
        }
        return true;
    }

    private static JSExpression processReduceMethodCall(JSExpression methodExpression, JSReferenceExpression invoked) {
        Optional first;
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier instanceof JSArrayLiteralExpression && (first = ((JSArrayLiteralExpression)qualifier).getExpressionStream().findFirst()).isPresent()) {
            return (JSExpression)first.get();
        }
        return methodExpression;
    }

    @NotNull
    private static JSExpression processApplyOrCallMethodCall(@NotNull JSExpression methodExpression, @NotNull JSReferenceExpression invoked) {
        JSExpression qualifier;
        if (methodExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(48);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(49);
        }
        if ((qualifier = invoked.getQualifier()) != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = invoked.multiResolve(false)) {
                String fileName;
                PsiElement element = result2.getElement();
                if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !JSCorePredefinedLibrariesProvider.isECMAScriptLibraryFileName(fileName)) continue;
                JSExpression jSExpression = qualifier;
                if (jSExpression == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(50);
                }
                return jSExpression;
            }
        }
        JSExpression jSExpression = methodExpression;
        if (jSExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(51);
        }
        return jSExpression;
    }

    private boolean processCreateMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked) {
        JSType type;
        JSFunctionItem functionItem;
        JSExpression[] arguments;
        JSExpression firstArgument;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(52);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(53);
        }
        JSExpression jSExpression = firstArgument = (arguments = callExpression.getArguments()).length > 0 ? arguments[0] : null;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(invoked, "Object", "create")) {
            JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(false));
            this.evaluateTypes(firstArgument);
            this.finishEvaluationWithContext(previousContext);
            return true;
        }
        boolean hasExplicitReturnType = false;
        PsiElement resolve = invoked.resolve();
        if (resolve != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)invoked, true)) != null && JSTypeUtils.isStrictType(type = functionItem.getReturnType())) {
            hasExplicitReturnType = true;
        }
        if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
            String typeString;
            String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : ((JSLiteralExpression)firstArgument).getStringValue();
            if (typeString != null) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument, false);
                JSType type2 = JSNamedTypeFactory.createType(typeString, typeSource, JSTypeContext.UNKNOWN);
                this.addType(type2);
            }
            return true;
        }
        return false;
    }

    public final void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        this.addTypeFromExternalModuleReferenceResolveResult(element, false);
    }

    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement resolve, boolean fromRequire) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(54);
        }
        if (resolve instanceof JSFile) {
            this.addType(new JSModuleTypeImpl((JSFile)resolve, fromRequire));
        } else {
            this.addTypeFromResolveResult(resolve);
        }
    }

    @NotNull
    public JSEvaluateContext getEvaluateContext() {
        JSEvaluateContext jSEvaluateContext = this.myContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(55);
        }
        return jSEvaluateContext;
    }

    protected void runWithContext(@NotNull JSEvaluateContext context, @NotNull Runnable runnable) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(56);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(57);
        }
        JSEvaluateContext previousContext = this.myContext;
        this.myContext = context;
        runnable.run();
        this.myContext = previousContext;
    }

    @NotNull
    public JSEvaluateContext startEvaluationWithContext(@NotNull JSEvaluateContext context) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(58);
        }
        JSEvaluateContext previousContext = this.myContext;
        this.myContext = context;
        JSEvaluateContext jSEvaluateContext = previousContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(59);
        }
        return jSEvaluateContext;
    }

    public void finishEvaluationWithContext(@NotNull JSEvaluateContext previousContext) {
        if (previousContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(60);
        }
        this.myContext = previousContext;
    }

    protected boolean processFunction(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(61);
        }
        if (!this.myContext.isAstAccessAllowed((PsiElement)function2, true)) {
            this.addType((JSType)TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2));
            this.addTypeFromLocalName((PsiNamedElement)function2);
            return true;
        }
        if (function2.isGetProperty()) {
            JSType returnType = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function2, (PsiElement)this.myContext.getProcessedExpression(), this.getContextualExpectedTypeKind());
            if (returnType != null) {
                this.addType(returnType);
            }
        } else if (function2.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)function2);
            if (parameterType != null) {
                this.addType(parameterType);
            }
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)function2, false);
            if (source.isTypeScript()) {
                JSFunctionType type = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2);
                if (function2 instanceof JSOptionalOwner && ((JSOptionalOwner)function2).isOptional()) {
                    type = TypeScriptTypeGuard.wrapWithUndefined((JSType)type, type.getSource());
                }
                this.addType((JSType)type);
            } else if (source.isJavaScript()) {
                boolean canBeConstructorAndFunction;
                JSExpression returnedExpression;
                JSType functionType = JSApplyNewType.getTypeFromConstructorName(function2, this.myContext, false, false);
                if (functionType == null && this.myContext.isAstAccessAllowed((PsiElement)function2) && (returnedExpression = JSPsiImplUtils.getReturnedExpressionIfSingle(function2)) != null) {
                    JSType type = JSCodeBasedTypeFactory.getCodeBasedType(returnedExpression, true, this.myContext.isContextualOverloadEvaluation());
                    functionType = TypeScriptTypeParser.buildFunctionTypeWithCustomReturnType((JSFunctionItem)function2, type);
                }
                boolean bl = canBeConstructorAndFunction = functionType == null;
                if (functionType == null) {
                    functionType = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2);
                }
                this.addType(functionType);
                if (canBeConstructorAndFunction) {
                    this.setUnknownElement((PsiElement)function2);
                }
            } else {
                this.addType(JSNamedTypeFactory.createFunctionType(source));
            }
        }
        return true;
    }

    private void processRefExpr(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(62);
        }
        new JSReferenceExpressionType(expression).evaluate(this.myContext).applyWithContext(this.myTypeProcessor, this.myContext);
    }

    public boolean addTypeFromResolveResult(String referenceName, ResolveResult resolveResult) {
        PsiElement element = resolveResult.getElement();
        if (element == null) {
            return true;
        }
        this.addTypeFromResolveResult(element);
        this.addLocalNamespaceFromImport(referenceName, resolveResult);
        return true;
    }

    protected void addLocalNamespaceFromImport(String referenceName, ResolveResult r) {
        ES6ImportExportDeclarationPart anImport;
        if (r instanceof JSResolveResult && (anImport = ((JSResolveResult)r).getES6Import()) instanceof ES6ImportExportSpecifier && Objects.equals(referenceName, anImport.getDeclaredName())) {
            JSNamespace nsFromImport = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(referenceName, null), JSContext.STATIC, (PsiElement)anImport, true, true, true);
            this.addAdditionalType((JSType)nsFromImport);
        }
    }

    public void addTypeFromElement(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(63);
        }
        if (element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element)) {
            this.evaluateTypes((JSExpression)element);
        } else {
            this.addTypeFromResolveResult(element);
        }
    }

    protected final void addTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(64);
        }
        if (resolveResult instanceof JSArrayLiteralExpression) {
            return;
        }
        this.addType(JSCodeBasedTypeFactory.getPsiBasedType(resolveResult, this.myContext));
    }

    private void doAddTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(65);
        }
        this.startEvaluationWithContext(this.myContext.withSource(resolveResult));
        if (resolveResult instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            resolveResult = ((TypeScriptProxyImplicitElementWithBackingItem)resolveResult).getBackingElement();
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            if (!(handler.addTypeFromResolveResult(this, this.myContext, resolveResult) | handler.addTypeFromResolveResult(this, resolveResult, false))) continue;
            return;
        }
        JSType alias = JSTypeEvaluator.findAliasTypeFromDocComment(resolveResult);
        if (alias != null) {
            this.addType(alias);
        }
        if (resolveResult instanceof JSFieldVariable) {
            this.addTypeFromVariableResolveResult((JSFieldVariable)resolveResult);
        } else {
            this.addTypeFromElementResolveResult(resolveResult);
        }
    }

    @Nullable
    public static JSType findAliasTypeFromDocComment(@NotNull PsiElement resolveResult) {
        String alias;
        JSDocComment docComment;
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(66);
        }
        if ((docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(resolveResult)) != null && (alias = docComment.getAlias()) != null) {
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedName(alias), JSContext.STATIC, (PsiElement)docComment);
        }
        return null;
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(67);
        }
        this.addTypeFromVariableResolveResult(jsVariable, jsVariable.getJSType());
    }

    public void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        JSNamespace namespace;
        boolean useVariableType;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(68);
        }
        if (jsVariable instanceof JSParameter) {
            if (variableType == null && this.myContext.isAstAccessAllowed((PsiElement)jsVariable) && this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            variableType = this.processParameterType((JSParameter)jsVariable, variableType);
        }
        boolean bl = useVariableType = variableType != null;
        if (useVariableType && variableType.isJavaScript() && !jsVariable.requiresTypeChecking() && this.myContext.isAstAccessAllowed((PsiElement)jsVariable)) {
            useVariableType = false;
        }
        if (useVariableType) {
            this.addType(variableType);
        } else if (this.myContext.isAstAccessAllowed((PsiElement)jsVariable)) {
            if ((variableType = this.addTypeFromVariableInitializer(jsVariable, variableType)) == null) {
                this.addTypeForAutoTypeVariable(jsVariable);
            }
        } else {
            JSExpression initializer = jsVariable.getInitializerOrStub();
            if (initializer != null) {
                JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withAstAccessForbidden());
                this.evaluateTypes(initializer);
                this.finishEvaluationWithContext(previousContext);
            }
        }
        if ((!useVariableType || variableType instanceof JSCodeBasedType && variableType.isJavaScript() || JSTypeUtils.isNewPropertiesDefinitionAllowed(variableType, false)) && (namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)jsVariable, false)) != null) {
            this.addAdditionalType((JSType)namespace);
        }
    }

    private void addTypeForAutoTypeVariable(@NotNull JSFieldVariable variable) {
        if (variable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(69);
        }
        if (JSTypeGuardUtil.isAutoTypeField((PsiElement)variable)) {
            JSType typeFromGuard = JSTypeGuardEvaluator.applyToResolveResultType(null, (PsiElement)variable, this.myContext);
            this.addType(Objects.requireNonNullElseGet(typeFromGuard, () -> JSAnyType.get((PsiElement)variable, true)));
        }
    }

    @Nullable
    private JSType addTypeFromVariableInitializer(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        JSDestructuringContext destructuringContext;
        JSInitializerOwner initializerOwner;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(70);
        }
        JSExpression initializer = (initializerOwner = (destructuringContext = this.findDestructuringParents(jsVariable)).getOuterElement()) != null ? (JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(initializerOwner.getContainingFile(), () -> initializerOwner.getInitializer()) : null;
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)jsVariable);
        if (isTypeScript && initializerOwner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)initializerOwner).getTypeElement() != null) {
            JSType type = ((JSTypeDeclarationOwner)initializerOwner).getJSType();
            this.addType(destructuringContext.applyToOuterType(type));
        } else if (initializer != null) {
            JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(!(jsVariable instanceof JSVariable) || JSVariableBaseImpl.isStrictVariableInitializer((JSVariable)jsVariable)));
            JSTypeWithContext typeFromInitializer = this.getTypeFromInitializer(initializer);
            if (typeFromInitializer != null) {
                this.addType(destructuringContext.applyToOuterType(typeFromInitializer.getJSType()));
            }
            this.finishEvaluationWithContext(previousContext);
        } else if (variableType == null && jsVariable instanceof JSVariable && JSTypeEvaluator.isForStatementDeclaration((JSVariable)jsVariable)) {
            PsiElement forOf = JSResolveUtil.findParent((PsiElement)jsVariable);
            List<JSType> types2 = this.getLoopVariableTypes(expression, (PsiElement)jsVariable, (JSForInStatement)forOf);
            for (JSType type : types2) {
                this.addType(destructuringContext.applyToOuterType(type));
            }
            variableType = (JSType)ContainerUtil.getFirstItem(types2);
        } else if (variableType != null) {
            this.addType(variableType);
        }
        return variableType;
    }

    @Nullable
    private JSType processParameterType(@NotNull JSParameter jsVariable, JSType variableType) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(71);
        }
        if (variableType == null && this.myContext.isAstAccessAllowed((PsiElement)jsVariable)) {
            variableType = JSContextTypeEvaluator.getParameterType((JSParameterListElement)jsVariable, this.myContext, this.getContextualExpectedTypeKind());
        }
        if (jsVariable.isRest()) {
            if (!(variableType instanceof JSRestTypeImpl)) {
                JSTypeSource typeSource = variableType != null && variableType.getSourceElement() != null ? variableType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, jsVariable.getTypeDecorator().isExplicitlyDeclared());
                variableType = new JSArrayTypeImpl(variableType, typeSource);
            } else {
                variableType = ((JSRestTypeImpl)variableType).getIterableType();
            }
        }
        return this.substituteThisType(variableType, (JSFieldVariable)jsVariable);
    }

    @NotNull
    protected JSDestructuringContext findDestructuringParents(@NotNull JSFieldVariable jsVariable) {
        JSDestructuringContext context;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(72);
        }
        if (DialectDetector.isTypeScript((PsiElement)jsVariable) && (context = JSDestructuringContext.findDestructuringParents((PsiElement)jsVariable, WITH_TYPE_DECLARATION_PREDICATE)).getOuterElement() != null) {
            JSDestructuringContext jSDestructuringContext = context;
            if (jSDestructuringContext == null) {
                JSTypeEvaluator.$$$reportNull$$$0(73);
            }
            return jSDestructuringContext;
        }
        JSDestructuringContext jSDestructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)jsVariable, JSInitializerOwner::hasOwnInitializer);
        if (jSDestructuringContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(74);
        }
        return jSDestructuringContext;
    }

    private static boolean isForStatementDeclaration(@NotNull JSVariable jsVariable) {
        PsiElement forOfCandidate;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(75);
        }
        return (forOfCandidate = JSResolveUtil.findParent((PsiElement)jsVariable)) instanceof JSForInStatement && PsiTreeUtil.isAncestor((PsiElement)((JSForInStatement)forOfCandidate).getVarDeclaration(), (PsiElement)jsVariable, (boolean)true);
    }

    @Nullable
    private JSTypeWithContext getTypeFromInitializer(@Nullable JSExpression initializer) {
        if (initializer == null) {
            return null;
        }
        if (DialectDetector.isTypeScript((PsiElement)initializer)) {
            JSType contextType = this.getExpressionTypeInContext(initializer);
            if (contextType != null) {
                return new JSTypeWithContext(contextType, true);
            }
            return null;
        }
        JSPsiBasedTypeOfType type = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)initializer, this.myContext);
        if (JSTypeEvaluator.isEmptyJSObjectLiteral(initializer)) {
            type = type.copyWithStrict(false);
        }
        return new JSTypeWithContext(type, false);
    }

    public static boolean isEmptyJSObjectLiteral(@NotNull JSExpression initializer) {
        if (initializer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(76);
        }
        return DialectDetector.isJavaScript((PsiElement)initializer) && initializer instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)initializer).isEmpty();
    }

    private void evaluateDestructuringContainer(@NotNull JSDestructuringContainer destructuringContainer) {
        JSType type;
        JSDestructuringContext destructuringContext;
        JSInitializerOwner owner;
        if (destructuringContainer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(77);
        }
        if ((owner = (destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)destructuringContainer, e -> e.hasOwnInitializer() || JSTypeEvaluator.isApplicableTypeDeclaration(e) || e instanceof JSParameterListElement)).getOuterElement()) == null) {
            return;
        }
        JSType typeFromDestructuringInLoop = this.getTypeFromDestructuringInLoop(owner);
        if (typeFromDestructuringInLoop != null) {
            this.addType(destructuringContext.applyToOuterType(typeFromDestructuringInLoop));
            return;
        }
        if (WITH_TYPE_DECLARATION_PREDICATE.test(owner) && (type = ((JSTypeDeclarationOwner)owner).getJSType()) != null) {
            this.addType(destructuringContext.applyToOuterType(type));
        }
        if (owner.hasOwnInitializer()) {
            JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getJSType() instanceof JSDestructuringTypeImpl));
            JSTypeWithContext typeFromInitializer = this.getTypeFromInitializer((JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(owner.getContainingFile(), () -> owner.getInitializer()));
            if (typeFromInitializer != null) {
                this.addType(destructuringContext.applyToOuterType(typeFromInitializer.getJSType()));
            }
            this.finishEvaluationWithContext(previousContext);
        }
        if (owner instanceof JSParameterListElement) {
            JSType parameterType;
            if (destructuringContext.isEmpty()) {
                for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                    if (!handler.addTypeFromResolveResult(this, this.myContext, (PsiElement)owner)) continue;
                    return;
                }
            }
            if ((parameterType = JSContextTypeEvaluator.getParameterType((JSParameterListElement)owner, this.myContext, JSExpectedTypeKind.EXPECTED)) != null) {
                this.addType(destructuringContext.applyToOuterType(parameterType));
            }
        }
    }

    @Nullable
    private JSType getTypeFromDestructuringInLoop(JSInitializerOwner owner) {
        PsiElement parent = owner.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSForInStatement) || !((JSForInStatement)grandParent).isForEach()) {
            return null;
        }
        JSExpression expression = ((JSForInStatement)grandParent).getCollectionExpression();
        if (expression == null) {
            return null;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)owner, true);
        JSPsiBasedTypeOfType expressionType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)expression, this.myContext);
        return new JSIterableComponentTypeImpl(expressionType, source);
    }

    private static boolean isApplicableTypeDeclaration(JSInitializerOwner e) {
        if (!(e instanceof JSTypeDeclarationOwner)) {
            return false;
        }
        if (WITH_TYPE_DECLARATION_PREDICATE.test(e)) {
            return true;
        }
        PsiElement parent = e.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).isForEach();
    }

    protected JSType substituteThisType(@Nullable JSType type, @NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(78);
        }
        return type;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JSTypeEvaluator.$$$reportNull$$$0(79);
        }
        boolean result2 = false;
        if (!this.myContext.isAstAccessAllowed((PsiElement)parameter)) {
            return false;
        }
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null) {
            PsiReference[] references = amdModuleReference.getReferences();
            Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)parameter, references);
            for (PsiElement resolve : modules) {
                result2 |= this.addTypeFromAmdModule(amdModuleReference, resolve);
            }
        }
        return result2;
    }

    private boolean addTypeFromAmdModule(@NotNull JSLiteralExpression amdModuleReference, @NotNull PsiElement resolve) {
        if (amdModuleReference == null) {
            JSTypeEvaluator.$$$reportNull$$$0(80);
        }
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(81);
        }
        boolean result2 = false;
        JSFunctionExpression moduleInitializer = null;
        if (resolve instanceof JSFile) {
            JSFunctionExpression amdModule = JSAmdModulesIndex.findDefaultAmdModule((JSFile)resolve);
            if (amdModule != null) {
                moduleInitializer = amdModule;
            } else {
                this.addTypeFromExternalModuleReferenceResolveResult(resolve, true);
            }
            result2 = true;
        } else if (resolve instanceof JSFunctionExpression) {
            moduleInitializer = (JSFunctionExpression)resolve;
            JSType type = JSNamedTypeFactory.createType(JSAmdPsiUtil.unifyModuleName(amdModuleReference), JSTypeSourceFactory.createTypeSource(resolve, true), JSContext.STATIC);
            this.addType(type);
            result2 = true;
        }
        if (moduleInitializer != null) {
            this.addType(new JSApplyCallType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)moduleInitializer, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)amdModuleReference, true)));
            this.addExportsNamespace((PsiElement)moduleInitializer);
        }
        return result2;
    }

    private void addExportsNamespace(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(82);
        }
        JSNamespace exportsNamespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, source, true, false, true);
        this.addAdditionalType((JSType)exportsNamespace);
    }

    protected void evaluateTypes(@Nullable JSExpression expression) {
        if (expression == null) {
            return;
        }
        this.addType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)expression, this.myContext));
    }

    public void doEvaluateTypesStubSafely(JSExpression expression) {
        if (expression instanceof JSFunction) {
            this.processFunction((JSFunction)expression);
        } else if (expression instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)expression);
        } else if (expression instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)expression);
        } else if (expression instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expression, false);
        }
    }

    public void addTypeFromClassExpression(JSClassExpression classExpression) {
    }

    protected void addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptMergedTypeImplicitElement) {
            this.addTypeFromMergedElementResolveResult((TypeScriptMergedTypeImplicitElement)resolveResult);
        } else if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            this.addTypeFromImplicitElementResolveResult(implicitElement);
        } else if (resolveResult instanceof JSProperty) {
            this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult);
        } else if (resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getContext() instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult.getContext());
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getContext();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                List<JSType> types2 = this.getLoopVariableTypes(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
                for (JSType type : types2) {
                    this.addType(type);
                }
                parameterType = (JSType)ContainerUtil.getFirstItem(types2);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
        } else if (resolveResult instanceof JSFunction) {
            this.processFunction((JSFunction)resolveResult);
        } else if (resolveResult instanceof JSNamedElement) {
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
            if (name != null) {
                JSType jsType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult, false), JSContext.STATIC);
                this.addType(jsType);
            }
        } else if (resolveResult instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression((JSExpression)resolveResult);
        } else if (resolveResult instanceof JsonElement) {
            this.addType(JsonElementType.createJsonElementType((JsonElement)resolveResult, null));
        } else if (resolveResult instanceof JSFile) {
            this.addTypeFromExternalModuleReferenceResolveResult(resolveResult);
        } else if (resolveResult instanceof StylesheetFile) {
            this.addType(new JSCustomElementType(resolveResult));
        }
    }

    private void addTypeFromImplicitElementResolveResult(@NotNull JSImplicitElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(83);
        }
        boolean typeAdded = false;
        if (resolveResult instanceof JSLocalImplicitElementImpl) {
            this.addType(((JSLocalImplicitElementImpl)resolveResult).getJSType());
            return;
        }
        String typeString = resolveResult.getTypeString();
        if (typeString != null) {
            JSType type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, true));
            this.addType(type);
            typeAdded = true;
        }
        JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)resolveResult), JSContext.STATIC, (PsiElement)resolveResult, resolveResult.isNamespaceExplicitlyDeclared());
        if (!typeAdded && resolveResult.getType().providesNamespace()) {
            this.addType((JSType)namespace);
        } else {
            this.addAdditionalType((JSType)namespace);
        }
    }

    private void addTypeFromMergedElementResolveResult(TypeScriptMergedTypeImplicitElement resolveResult) {
        PsiElement explicitElement = resolveResult.getExplicitElement();
        JSType jsType = resolveResult.getJSType();
        if (resolveResult.isOptional() && jsType != null) {
            jsType = TypeScriptTypeGuard.wrapWithUndefined(jsType, jsType.getSource());
        }
        this.addType(jsType);
    }

    private void addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(84);
        }
        boolean skipEvaluatingProps = false;
        boolean hasType = false;
        JSType jsType = property.getJSType();
        if (jsType != null) {
            this.addType(jsType);
            hasType = true;
            boolean bl = skipEvaluatingProps = !JSTypeUtils.isNewPropertiesDefinitionAllowed(jsType, false);
        }
        if (!skipEvaluatingProps) {
            JSDocComment docComment;
            JSNamespace type;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (type = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)property, (docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property)) != null && docComment.isClassExplicitly())) != null) {
                this.addAdditionalType((JSType)type);
            }
            if (!hasType) {
                JSExpression value;
                if (functionInitializer != null || objectLiteralExpression != null) {
                    if (functionInitializer != null) {
                        if (functionInitializer == property) {
                            this.processFunction(functionInitializer);
                        } else {
                            this.addType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)functionInitializer, this.myContext));
                        }
                    } else {
                        this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                    }
                } else if (this.myContext.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                    this.evaluateTypes(value);
                }
            }
        }
    }

    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(85);
        }
    }

    @NotNull
    private List<JSType> getLoopVariableTypes(@Nullable JSReferenceExpression expression, @NotNull PsiElement element, @Nullable JSForInStatement forInStatement) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(86);
        }
        if (forInStatement == null) {
            List<JSType> list2 = Collections.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(87);
            }
            return list2;
        }
        if (forInStatement.isForEach()) {
            List<JSType> list3 = this.getComponentTypeFromArrayExpression((JSExpression)expression, forInStatement.getCollectionExpression());
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(88);
            }
            return list3;
        }
        List<JSType> list4 = Collections.singletonList(new JSForInStringType(JSTypeSourceFactory.createTypeSource(element, true), JSTypeContext.INSTANCE));
        if (list4 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(89);
        }
        return list4;
    }

    @Nullable
    public final JSType addComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        List<JSType> types2 = this.getComponentTypeFromArrayExpression(rawqualifier, collectionExpression);
        for (JSType type : types2) {
            this.addType(type);
        }
        return types2.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types2) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        String propertyName;
        if (collectionExpression == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(90);
            }
            return list2;
        }
        JSTypeEvaluationResult result2 = this.getTypeEvaluationResultInContext((PsiElement)collectionExpression);
        if (result2 == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(91);
            }
            return list3;
        }
        List<JSEvaluationResultElement> results = result2.getResults();
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        result2.applyToProcessor(processor);
        JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(processor.getType());
        int index = -1;
        JSExpression indexExpression = null;
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral()) {
            Object value = ((JSLiteralExpression)indexExpression).getValue();
            assert (value instanceof Double || value instanceof Long || value instanceof BigInteger) : indexExpression.getText();
            if (value instanceof Long && (Long)value >= 0L && (Long)value <= Integer.MAX_VALUE) {
                index = Math.toIntExact((Long)value);
            } else if (value instanceof BigInteger && ((BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && ((BigInteger)value).compareTo(JSLiteralExpressionImpl.INT_MAX_VALUE_AS_BIGINT) <= 0) {
                index = ((BigInteger)value).intValueExact();
            }
        }
        boolean processed = false;
        JSPrimitiveType indexType = null;
        if (index >= 0) {
            indexType = new JSNumberLiteralTypeImpl(index, false, JSTypeSourceFactory.createTypeSource((PsiElement)indexExpression, true), null);
        } else if (indexExpression instanceof JSLiteralExpression && (propertyName = ((JSLiteralExpression)indexExpression).getValueAsPropertyName()) != null) {
            indexType = new JSStringLiteralTypeImpl(propertyName, false, JSTypeSourceFactory.createTypeSource((PsiElement)indexExpression, true));
        }
        if (indexType != null) {
            for (JSEvaluationResultElement element : results) {
                JSType jsonComponentType;
                JSType jsType = element.getType();
                if (!(jsType instanceof JsonElementType) || (jsonComponentType = ((JsonElementType)jsType).getComponentType(indexType, (PsiElement)collectionExpression)) == null) continue;
                this.addType(jsonComponentType);
                processed = true;
            }
        }
        if (!processed && type instanceof JSTupleType && ((JSTupleType)type).hasTypeByIndex(index)) {
            List<JSType> list4 = Collections.singletonList(((JSTupleType)type).getTypeByIndex(index));
            if (list4 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(92);
            }
            return list4;
        }
        List<JSType> list5 = this.getComponentTypeFromProcessor(rawqualifier, type);
        if (list5 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(93);
        }
        return list5;
    }

    @Nullable
    public final JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        List<JSType> types2 = this.getComponentTypeFromProcessor(rawqualifier, type);
        for (JSType jsType : types2) {
            if (type == null) continue;
            this.addType(jsType);
        }
        return types2.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types2) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        SmartList result2 = this.getComponentTypeWithExpandingComposite(rawqualifier, type);
        SmartList smartList = result2.isEmpty() ? new SmartList((Object)JSAnyType.get((PsiElement)rawqualifier, false)) : result2;
        if (smartList == null) {
            JSTypeEvaluator.$$$reportNull$$$0(94);
        }
        return smartList;
    }

    @NotNull
    protected final List<JSType> getComponentTypeWithExpandingComposite(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(95);
            }
            return list2;
        }
        if (type instanceof JSUnionType) {
            ArrayList<JSType> result2 = new ArrayList<JSType>();
            for (JSType typeOption : ((JSUnionType)type).getTypes()) {
                result2.addAll(this.getComponentTypeFromProcessor(rawqualifier, typeOption));
            }
            ArrayList<JSType> arrayList = result2;
            if (arrayList == null) {
                JSTypeEvaluator.$$$reportNull$$$0(96);
            }
            return arrayList;
        }
        JSTypeSource prevSource = type.getSource();
        if ((type = JSTypeUtils.getIndexableComponentType(type)) == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(97);
            }
            return list3;
        }
        type = JSTypeUtils.copyWithStrict(type, prevSource.isStrict() && type.isSourceStrict());
        List<JSType> list4 = Collections.singletonList(type);
        if (list4 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(98);
        }
        return list4;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawQualifier) {
        JSType type;
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(99);
        }
        if ((type = JSTypeEvaluator.getTypeFromConstant(rawQualifier)) != null) {
            this.addType(type);
        } else {
            this.setUnknownElement((PsiElement)rawQualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier) {
        IElementType constantType;
        IElementType sign;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(100);
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            return JSTypeEvaluator.createConstantNamedType("undefined", rawqualifier);
        }
        if (rawqualifier instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)rawqualifier).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS)) {
            JSExpression expression = ((JSPrefixExpression)rawqualifier).getExpression();
            if (expression != null) {
                JSType innerType = JSTypeEvaluator.getTypeFromConstant(expression);
                if (innerType instanceof JSNumberLiteralTypeImpl || innerType instanceof JSBigIntLiteralTypeImpl) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, innerType.isSourceStrict());
                    if (sign == JSTokenTypes.MINUS) {
                        boolean allowWidening = ((JSTypeWithWidening)innerType).allowWidening();
                        innerType = innerType instanceof JSNumberLiteralTypeImpl ? new JSNumberLiteralTypeImpl(-((JSNumberLiteralTypeImpl)innerType).getLiteral().doubleValue(), allowWidening, typeSource, "-" + ((JSNumberLiteralTypeImpl)innerType).getValueAsString()) : new JSBigIntLiteralTypeImpl(((JSBigIntLiteralTypeImpl)innerType).getLiteral().negate(), allowWidening, typeSource, "-" + ((JSBigIntLiteralTypeImpl)innerType).getValueAsString());
                    }
                    return innerType.withNewSource(typeSource);
                }
                if (innerType instanceof JSNumberType || innerType instanceof JSBigIntType) {
                    return innerType;
                }
            }
            return JSTypeEvaluator.createConstantNamedType("number", rawqualifier);
        }
        ASTNode childNode = rawqualifier.getNode().getFirstChildNode();
        IElementType iElementType = constantType = childNode != null ? childNode.getElementType() : null;
        if (constantType == JSTokenTypes.XML_START_TAG_START || constantType == JSTokenTypes.XML_START_TAG_LIST) {
            if (DialectDetector.isTypeScript((PsiElement)rawqualifier) || DialectDetector.isJSX((PsiElement)rawqualifier)) {
                return null;
            }
            String type = constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : "XMLList";
            return JSTypeEvaluator.createConstantNamedType(type, rawqualifier);
        }
        if (JSSymbolUtil.isUndefinedExpression(rawqualifier)) {
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                return null;
            }
            return JSTypeEvaluator.createConstantNamedType("undefined", rawqualifier);
        }
        if (!(rawqualifier instanceof JSLiteralExpression)) {
            return null;
        }
        JSLiteralExpression literalExpression = (JSLiteralExpression)rawqualifier;
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        JSLiteralExpressionKind kind = literalExpression.getExpressionKind(false);
        switch (kind) {
            case TEMPLATE_WITH_ARGS: {
                if (rawqualifier instanceof JSStringTemplateExpression && DialectDetector.isTypeScript((PsiElement)rawqualifier) && JSWidenType.isConstContext((PsiElement)rawqualifier)) {
                    return null;
                }
            }
            case QUOTED: 
            case TEMPLATE_NO_ARGS: {
                if (rawqualifier.getTextLength() > 4096) {
                    return new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
                }
                String value = literalExpression.getStringValue();
                if (value != null) {
                    return new JSStringLiteralTypeImpl(value, true, typeSource);
                }
                return JSTypeEvaluator.createConstantNamedType("string", rawqualifier);
            }
            case REGEXP: {
                return JSTypeEvaluator.createConstantNamedType("RegExp", rawqualifier);
            }
            case TRUE: 
            case FALSE: {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    return JSTypeEvaluator.createConstantNamedType("boolean", rawqualifier);
                }
                return new JSBooleanLiteralTypeImpl(kind == JSLiteralExpressionKind.TRUE, true, typeSource);
            }
            case NULL: {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    return JSAnyType.get((PsiElement)rawqualifier, false);
                }
                return JSTypeEvaluator.createConstantNamedType("null", rawqualifier);
            }
        }
        if (kind.isNumeric()) {
            Object value = literalExpression.getValue();
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                return value instanceof Long ? JSTypeEvaluator.createConstantNamedType("int", rawqualifier) : JSTypeEvaluator.createConstantNamedType("number", rawqualifier);
            }
            if (value instanceof BigInteger) {
                return new JSBigIntLiteralTypeImpl((BigInteger)value, true, typeSource, literalExpression.getText());
            }
            if (value instanceof Long) {
                value = ((Long)value).doubleValue();
            }
            if (value != null) {
                return new JSNumberLiteralTypeImpl((Double)value, true, typeSource, literalExpression.getText());
            }
            return JSTypeEvaluator.createConstantNamedType("number", rawqualifier);
        }
        return null;
    }

    @NotNull
    private static JSType createConstantNamedType(@NotNull String name, @NotNull JSExpression rawqualifier) {
        if (name == null) {
            JSTypeEvaluator.$$$reportNull$$$0(101);
        }
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(102);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        JSType jSType = JSNamedTypeFactory.createType(name, typeSource, JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(103);
        }
        return jSType;
    }

    public static boolean addAdditionalTypes(@NotNull PsiElement context, @NotNull JSReferenceItem qualifier, @NotNull JSTypeProcessor processor, @NotNull JSEvaluateContext evaluateContext) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(104);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(105);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(106);
        }
        if (evaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(107);
        }
        JSEvaluationTask types2 = JSTypeEvaluator.getAdditionalTypes(context, qualifier, evaluateContext);
        types2.applyWithContext(processor, evaluateContext);
        return types2 != JSEvaluationTasks.EMPTY;
    }

    @NotNull
    public static JSEvaluationTask getAdditionalTypes(@NotNull PsiElement context, @NotNull JSReferenceItem qualifier, @NotNull JSEvaluateContext evaluateContext) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(108);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(109);
        }
        if (evaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(110);
        }
        if (DialectDetector.isTypeScript(context) || DialectDetector.isActionScript(context)) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSTypeEvaluator.$$$reportNull$$$0(111);
            }
            return jSEvaluationTaskList;
        }
        JSReferenceItem topmostQualifier = qualifier instanceof JSReferenceExpression ? JSUtils.findRefExprThatStartCallChaining((JSReferenceExpression)qualifier) : qualifier;
        ArrayList<JSEvaluationTask> types2 = new ArrayList<JSEvaluationTask>(2);
        if (JSSymbolUtil.isAccurateReferenceExpressionName(topmostQualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(topmostQualifier, JQUERY_NS) || JSSymbolUtil.isAccurateReferenceExpressionName(topmostQualifier, JQUERY_NS, "$")) {
            types2.add(new JSEvaluationResultElement(JSTypeEvaluator.getJQueryType(context), false, evaluateContext));
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, JQUERY_NS)) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context, false);
            JSType htmlElementType = JSNamedTypeFactory.createType("HTMLElement", typeSource, JSContext.UNKNOWN);
            types2.add(new JSEvaluationResultElement(htmlElementType, false, evaluateContext));
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(types2);
        if (jSEvaluationTask == null) {
            JSTypeEvaluator.$$$reportNull$$$0(112);
        }
        return jSEvaluationTask;
    }

    @NotNull
    public static JSType getJQueryType(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(113);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, false);
        JSType jSType = JSNamedTypeFactory.createType(JQUERY_NS, typeSource, JSContext.UNKNOWN);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(114);
        }
        return jSType;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    protected void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
        this.addType(recordType);
    }

    @NotNull
    protected JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return new JSObjectType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, false), JSTypeContext.UNKNOWN);
        }
        if (DialectDetector.isTypeScript((PsiElement)expression)) {
            evaluatePropertyTypes = true;
        }
        JSElement[] properties = expression.getPropertiesIncludingSpreads();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true);
        HashMap<String, JSRecordType.PropertySignature> propertyMembers = new HashMap<String, JSRecordType.PropertySignature>();
        ArrayList<JSRecordType.TypeMember> nonPropertyMembers = new ArrayList<JSRecordType.TypeMember>();
        SmartList syntheticStringIndexerTypes = new SmartList();
        SmartList syntheticNumericIndexerTypes = new SmartList();
        ArrayList<JSType> unexpandedTypes = new ArrayList<JSType>();
        boolean hasComputedProps = false;
        for (JSElement property : properties) {
            JSType spreadType;
            if (property instanceof JSProperty) {
                ES6ComputedName computedPropertyName;
                JSRecordType.PropertySignature member = this.getTypeMemberFromSimplePropertyValue((JSProperty)property, evaluatePropertyTypes);
                if (member != null && member.hasValidName()) {
                    propertyMembers.put(member.getMemberName(), member);
                }
                boolean hasComputedName = false;
                if (property instanceof JSComputedPropertyNameOwner && (computedPropertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName()) != null) {
                    hasComputedName = true;
                    hasComputedProps = true;
                    if (evaluatePropertyTypes) {
                        JSExpression jsExpression = computedPropertyName.getExpression();
                        JSType propNameType = this.getExpressionTypeInContext(jsExpression);
                        JSType propNameValuableType = JSTypeUtils.getValuableType(propNameType);
                        if (propNameValuableType instanceof JSStringType) {
                            ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                        }
                        if (propNameValuableType instanceof JSNumberType) {
                            JSType widenedPropertyType = this.getWidenedPropertyType((JSProperty)property);
                            ContainerUtil.addIfNotNull((Collection)syntheticNumericIndexerTypes, (Object)widenedPropertyType);
                            ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)widenedPropertyType);
                        }
                    }
                }
                if (hasComputedName) continue;
                ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                continue;
            }
            if (!(property instanceof JSSpreadExpression) || (spreadType = JSTypeUtils.getValuableType(((JSSpreadExpression)property).getInnerExpressionType())) == null) continue;
            if (spreadType instanceof JSAnyType) {
                JSTypeSource source = spreadType.getSource();
                if (spreadType.isTypeScript()) {
                    JSType jSType = spreadType;
                    if (jSType == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(115);
                    }
                    return jSType;
                }
                PsiElement sourceElement = spreadType.getSourceElement();
                if (sourceElement == null) {
                    sourceElement = property;
                }
                return new JSRecordTypeImpl(source, Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, source, JSTypeContext.INSTANCE), spreadType, JSRecordMemberSourceFactory.createSource(sourceElement), false)));
            }
            if (JSTypeUtils.hasForeignGenericParameter(spreadType) || spreadType instanceof JSEvaluableOnlyType && spreadType.isJavaScript()) {
                unexpandedTypes.add(spreadType);
                continue;
            }
            for (JSRecordType.TypeMember member : spreadType.asRecordType().getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    if (member instanceof PsiElement && JSUtils.isPrivateSharpItem((PsiElement)member)) continue;
                    propertyMembers.put(((JSRecordType.PropertySignature)member).getMemberName(), JSTypeEvaluator.mergeIfOptional(typeSource, propertyMembers, (JSRecordType.PropertySignature)member));
                    continue;
                }
                if (spreadType.getSourceElement() instanceof TypeScriptEnum && member instanceof JSRecordType.IndexSignature) continue;
                JSTypeEvaluator.addMember(nonPropertyMembers, member);
            }
        }
        if (hasComputedProps && syntheticStringIndexerTypes.size() > 0) {
            JSTypeEvaluator.addMember(nonPropertyMembers, (JSRecordType.TypeMember)new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(JSCompositeTypeFactory.createUnionType(typeSource, (Collection<? extends JSType>)syntheticStringIndexerTypes)), (PsiElement)null, true));
        }
        if (hasComputedProps && syntheticNumericIndexerTypes.size() > 0) {
            JSTypeEvaluator.addMember(nonPropertyMembers, (JSRecordType.TypeMember)new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(JSCompositeTypeFactory.createUnionType(typeSource, (Collection<? extends JSType>)syntheticNumericIndexerTypes)), (PsiElement)null, true));
        }
        JSFreshObjectLiteralTypeImpl literalType = new JSFreshObjectLiteralTypeImpl(typeSource, ContainerUtil.concat(nonPropertyMembers, new ArrayList(propertyMembers.values())));
        if (unexpandedTypes.size() == 0) {
            JSFreshObjectLiteralTypeImpl jSFreshObjectLiteralTypeImpl = literalType;
            if (jSFreshObjectLiteralTypeImpl == null) {
                JSTypeEvaluator.$$$reportNull$$$0(116);
            }
            return jSFreshObjectLiteralTypeImpl;
        }
        if (literalType.hasMembers()) {
            unexpandedTypes.add(literalType);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(unexpandedTypes, typeSource, true);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(117);
        }
        return jSType;
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeIfOptional(@NotNull JSTypeSource typeSource, @NotNull Map<String, JSRecordType.PropertySignature> propertyMembers, @NotNull JSRecordType.PropertySignature member) {
        String memberName;
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(118);
        }
        if (propertyMembers == null) {
            JSTypeEvaluator.$$$reportNull$$$0(119);
        }
        if (member == null) {
            JSTypeEvaluator.$$$reportNull$$$0(120);
        }
        if (propertyMembers.containsKey(memberName = member.getMemberName()) && member.isOptional()) {
            JSRecordType.PropertySignature oldMember = propertyMembers.get(memberName);
            member = new JSRecordTypeImpl.PropertySignatureImpl(memberName, JSCompositeTypeImpl.getCommonType((JSType)ObjectUtils.coalesce((Object)oldMember.getJSType(), (Object)JSAnyType.get(typeSource)), (JSType)ObjectUtils.coalesce((Object)member.getJSType(), (Object)JSAnyType.get(typeSource)), typeSource, true), oldMember.isOptional() && member.isOptional(), oldMember.isConst() || member.isConst());
        }
        JSRecordType.PropertySignature propertySignature = member;
        if (propertySignature == null) {
            JSTypeEvaluator.$$$reportNull$$$0(121);
        }
        return propertySignature;
    }

    private static void addMember(ArrayList<JSRecordType.TypeMember> nonPropertyMembers, JSRecordType.TypeMember member) {
        boolean memberSet = false;
        if (member instanceof JSRecordType.IndexSignature) {
            for (int i = 0; i < nonPropertyMembers.size(); ++i) {
                JSRecordType.TypeMember propertyMember = nonPropertyMembers.get(i);
                if (!(propertyMember instanceof JSRecordType.IndexSignature) || ((JSRecordType.IndexSignature)propertyMember).getIndexSignatureKind() != ((JSRecordType.IndexSignature)member).getIndexSignatureKind()) continue;
                nonPropertyMembers.set(i, member);
                memberSet = true;
            }
        }
        if (!memberSet) {
            nonPropertyMembers.add(member);
        }
    }

    @Nullable
    protected JSType getWidenedPropertyType(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(122);
        }
        return JSTypeUtils.widenLiteralTypes(property.getJSType());
    }

    @Nullable
    private JSRecordType.PropertySignature getTypeMemberFromSimplePropertyValue(@NotNull JSProperty property, boolean evaluatePropertyTypes) {
        JSFunctionType type;
        String name;
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(123);
        }
        if ((name = property.getName()) == null && property instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)property);
        }
        if (name == null && !(property instanceof JSComputedPropertyNameOwner)) {
            return null;
        }
        if (property instanceof JSFunctionProperty) {
            type = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)((JSFunction)property));
        } else {
            type = this.getWidenedPropertyType(property);
            if (!DialectDetector.isTypeScript((PsiElement)property) && !property.requiresTypeChecking() && evaluatePropertyTypes) {
                type = this.getExpressionTypeInContext(property.getValue());
            }
        }
        type = JSTypeEvaluator.modifyTypeIfAccessor(property, (JSType)type);
        if (name == null) {
            String referenceName;
            ES6ComputedName propertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName();
            String string = referenceName = propertyName == null ? null : propertyName.getExpressionAsReferenceName();
            if (referenceName != null) {
                return new JSRecordTypeImpl.ComputedPropertySignatureImpl(referenceName, (JSType)type, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)property).isConst(), JSRecordMemberSourceFactory.createSource((PsiElement)property));
            }
            return null;
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(name, (JSType)type, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)property).isConst(), (PsiElement)property);
    }

    @Nullable
    private static JSType modifyTypeIfAccessor(@NotNull JSProperty property, @Nullable JSType type) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(124);
        }
        boolean isGetter = property.isGetProperty();
        boolean isSetter = property.isSetProperty();
        if (!isGetter && !isSetter) {
            return type;
        }
        if (type instanceof JSFunctionTypeImpl) {
            if (isGetter) {
                return ((JSFunctionTypeImpl)type).getReturnType();
            }
            List<JSParameterTypeDecorator> parameters = ((JSFunctionTypeImpl)type).getParameters();
            if (parameters.size() >= 1) {
                return parameters.get(0).getSimpleType();
            }
        }
        return JSAnyType.get(JSTypeSourceFactory.createTypeSource((PsiElement)property, false));
    }

    protected void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        JSDocComment comment;
        JSNamespace providedNs;
        JSType jsType;
        boolean isExportDefinition;
        if (psiElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(125);
        }
        if (isExportDefinition = CommonJSUtil.isExportNamespace(JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)psiElement, true))) {
            this.addExportsNamespace((PsiElement)psiElement);
        }
        if ((jsType = psiElement.getJSType()) instanceof JSStubBasedExpressionType) {
            jsType = null;
        }
        boolean hasType = false;
        if (jsType != null) {
            this.addType(jsType);
            hasType = true;
            if (jsType instanceof JSReferenceType && CommonJSUtil.isExportNamespace(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)psiElement))) {
                String referencedName = ((JSReferenceType)jsType).getReferenceName();
                JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.create(referencedName, null);
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)psiElement, true);
                for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getExtensions((PsiElement)psiElement)) {
                    JSType type = indexingHandler.getExportsInnerAliasType(qualifiedName, typeSource);
                    if (type == null) continue;
                    this.addType(type);
                }
            }
            if (jsType.isSourceStrict()) {
                return;
            }
        }
        JSFunctionExpression functionInitializer = null;
        if (!hasType) {
            boolean evaluateInitializer;
            JSExpression initializer = psiElement.getInitializerOrStub();
            functionInitializer = initializer instanceof JSFunctionExpression ? (JSFunctionExpression)initializer : null;
            boolean bl = evaluateInitializer = this.myContext.isStrict() || isExportDefinition;
            if (evaluateInitializer) {
                if (this.myContext.isAstAccessAllowed((PsiElement)psiElement)) {
                    JSExpression expr = JSPsiImplUtils.getRightmostOperand(psiElement);
                    if (expr != null) {
                        this.evaluateTypes(expr);
                    }
                } else if (initializer != null) {
                    JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withAstAccessForbidden());
                    this.evaluateTypes(initializer);
                    this.finishEvaluationWithContext(previousContext);
                }
            }
        }
        boolean explicitType = false;
        if (psiElement.isNamespaceExplicitlyDeclared() && (providedNs = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)psiElement, explicitType = (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement)) != null && comment.hasNamespaceTag())) != null) {
            if (explicitType) {
                this.addType((JSType)providedNs);
            } else {
                this.addAdditionalType((JSType)providedNs);
            }
        }
        if (jsType == null && !explicitType && !CommonJSUtil.isModuleExportsAssigmentTarget((JSElementBase)psiElement) && functionInitializer == null) {
            this.setUnknownElement((PsiElement)psiElement);
        }
    }

    @NotNull
    protected JSExpectedTypeKind getContextualExpectedTypeKind() {
        JSExpectedTypeKind jSExpectedTypeKind = this.myContext.getContextualExpectedTypeKind();
        if (jSExpectedTypeKind == null) {
            JSTypeEvaluator.$$$reportNull$$$0(126);
        }
        return jSExpectedTypeKind;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = this.getExpressionTypeInContext(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType);
        } else {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    public void setUnknownElement(@NotNull PsiElement unknownElement) {
        if (unknownElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(127);
        }
        this.addType(JSAnyType.get(unknownElement, false));
    }

    protected void addCodeBasedType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(128);
        }
        JSType type = JSCodeBasedTypeFactory.getCodeBasedType(expression, this.myContext.isAstAccessAllowed((PsiElement)expression), this.isContextualOverloadEvaluation());
        this.addType(type);
    }

    @NotNull
    public JSTypeEvaluationResult getResult() {
        JSTypeEvaluationResult jSTypeEvaluationResult = this.myTypeProcessor.getResult();
        if (jSTypeEvaluationResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(129);
        }
        return jSTypeEvaluationResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 37: 
            case 43: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 73: 
            case 74: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 103: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 126: 
            case 129: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 37: 
            case 43: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 73: 
            case 74: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 103: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 126: 
            case 129: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 63: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 37: 
            case 43: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 73: 
            case 74: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 103: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 126: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 13: 
            case 42: 
            case 62: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluatedExpression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 36: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 39: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 54: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousContext";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringContainer";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amdModuleReference";
                break;
            }
            case 82: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 84: 
            case 122: 
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 105: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyMembers";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluator";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createNullType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "processApplyOrCallMethodCall";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluateContext";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "startEvaluationWithContext";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "findDestructuringParents";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoopVariableTypes";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromArrayExpression";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeWithExpandingComposite";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantNamedType";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalTypes";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getJQueryType";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralType";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeIfOptional";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextualExpectedTypeKind";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateExpressionOrElementTypes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEvaluatedAsExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluator";
                break;
            }
            case 12: 
            case 37: 
            case 43: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 73: 
            case 74: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 103: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 126: 
            case 129: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTypeEvaluationResultElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypesImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryOperation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addNumericOperatorType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOrSpread";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementTypeFromSpread";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNewExpressionTypes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromGclRequireCall";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processRequireMethodCall";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processApplyOrCallMethodCall";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processCreateMethodCall";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "runWithContext";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "startEvaluationWithContext";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "finishEvaluationWithContext";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processRefExpr";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromElement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "doAddTypeFromResolveResult";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findAliasTypeFromDocComment";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addTypeForAutoTypeVariable";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableInitializer";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processParameterType";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "findDestructuringParents";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isForStatementDeclaration";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyJSObjectLiteral";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDestructuringContainer";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "substituteThisType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModule";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addExportsNamespace";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromImplicitElementResolveResult";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromProperty";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getLoopVariableTypes";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstant";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createConstantNamedType";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalTypes";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalTypes";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getJQueryType";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "mergeIfOptional";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getWidenedPropertyType";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMemberFromSimplePropertyValue";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeIfAccessor";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromDefExpr";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "setUnknownElement";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "addCodeBasedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 37: 
            case 43: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 73: 
            case 74: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 103: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 126: 
            case 129: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSTypeWithContext {
        @NotNull
        private final JSType myType;
        private final boolean myIsExplicit;

        private JSTypeWithContext(@NotNull JSType type, boolean explicit) {
            if (type == null) {
                JSTypeWithContext.$$$reportNull$$$0(0);
            }
            this.myType = type;
            this.myIsExplicit = explicit;
        }

        @NotNull
        public JSType getJSType() {
            JSType jSType = this.myType;
            if (jSType == null) {
                JSTypeWithContext.$$$reportNull$$$0(1);
            }
            return jSType;
        }

        public boolean isExplicit() {
            return this.myIsExplicit;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSTypeWithContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSTypeWithContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJSType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

