/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionResolver
implements ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> {
    private static final Key<ParameterizedCachedValue<Map<String, ResolveResult[]>, PsiFile>> TOP_LEVEL_RESULTS_KEY = Key.create((String)"top.level.cached.results");
    private static final Key<ParameterizedCachedValue<Map<String, ResolveResult[]>, PsiFile>> TOP_LEVEL_RESULTS_WITH_IGNORE_PERF_LIMITS_KEY = Key.create((String)"top.level.cached.results.with.ignore.perf.limits");
    private static final Function<ResolveResult, PsiElement> RESOLVE_RESULT_TO_VALID_ELEMENT = el -> el.isValidResult() ? el.getElement() : null;
    public static final int MAX_RESULTS_COUNT_TO_KEEP = Integer.valueOf(System.getProperty("js.max.results.count.to.keep", "20"));
    protected final JSReferenceExpressionImpl myRef;
    protected final PsiElement myParent;
    protected final PsiFile myContainingFile;
    @Nullable
    protected final String myReferencedName;
    protected final JSExpression myQualifier;
    protected final boolean myUnqualifiedOrLocalResolve;
    protected final boolean myIgnorePerformanceLimits;
    @Nullable
    private PsiFile myLimitingScopeFile;

    public JSReferenceExpressionResolver(@NotNull JSReferenceExpressionImpl expression, boolean ignorePerformanceLimits) {
        if (expression == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(0);
        }
        this.myRef = expression;
        this.myContainingFile = expression.getContainingFile();
        this.myReferencedName = this.adjustReferencedName(this.myRef);
        this.myParent = this.myRef.getParent();
        this.myQualifier = this.myRef.getResolveQualifier();
        this.myUnqualifiedOrLocalResolve = JSReferenceExpressionImpl.isLocalResolveQualifier(this.myQualifier);
        this.myIgnorePerformanceLimits = ignorePerformanceLimits;
        this.myLimitingScopeFile = null;
    }

    public ResolveResult @NotNull [] resolve(@NotNull JSReferenceExpressionImpl expression, boolean incompleteCode) {
        SinkResolveProcessor<ResolveResultSink> localProcessor;
        if (expression == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(1);
        }
        if (this.myReferencedName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (JSResolveUtil.isSelfReference(currentParent, (PsiElement)this.myRef)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(currentParent)};
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        ResolveResult[] resultsFromProviders = this.resolveFromProviders();
        if (resultsFromProviders != null) {
            if (resultsFromProviders == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(4);
            }
            return resultsFromProviders;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName, false, incompleteCode);
        if (this.myUnqualifiedOrLocalResolve) {
            localProcessor = this.createLocalResolveProcessor(sink);
            localProcessor.setToProcessHierarchy(true);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)this.myRef, this.myQualifier, localProcessor, false, false, null);
            PsiElement jsElement = localProcessor.getResult();
            if (jsElement != null) {
                ResolveResult[] results = localProcessor.getResultsAsResolveResults();
                if (jsElement instanceof JSImplicitElement && ((JSImplicitElement)jsElement).hasMinorImportance()) {
                    return this.mergeIncompleteLocalResolveWithGlobal(results, incompleteCode);
                }
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.LOCAL, (Object)results.length);
                if (results == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(5);
                }
                return results;
            }
            if (this.myQualifier == null) {
                ResolveResult[] globalResults = this.resolveGlobalReference(incompleteCode);
                if (this.isDummyResolve(localProcessor, globalResults)) {
                    ResolveResult[] resolveResultArray = this.dummyResult(this.myRef);
                    if (resolveResultArray == null) {
                        JSReferenceExpressionResolver.$$$reportNull$$$0(6);
                    }
                    return resolveResultArray;
                }
                if (globalResults == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(7);
                }
                return globalResults;
            }
        } else {
            QualifiedItemProcessor<ResolveResultSink> processor = this.createQualifiedItemProcessor(sink);
            processor.setTypeContext(true);
            processor.setToProcessActionScriptImplicits(false);
            processor.evaluateExpressionOrElementType((PsiElement)this.myQualifier, this.myContainingFile);
            if (processor.noMoreResultsPossible() || ((ResolveResultSink)processor.getResultSink()).getCompleteResult() != null) {
                ResolveResult[] results = processor.getResultsAsResolveResults();
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.QUALIFIED, (Object)results.length);
                if (results == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(8);
                }
                return results;
            }
            localProcessor = processor;
        }
        ResolveResult[] results = this.resolveFromIndices(localProcessor, false, false);
        if (this.isDummyResolve(localProcessor, results = TypeScriptPsiUtil.removeDuplicates(Arrays.asList(results), RESOLVE_RESULT_TO_VALID_ELEMENT, (PsiElement)this.myRef).toArray(ResolveResult.EMPTY_ARRAY))) {
            ResolveResult[] resolveResultArray = this.dummyResult(this.myRef);
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(9);
            }
            return resolveResultArray;
        }
        if (results == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(10);
        }
        return results;
    }

    private boolean isDummyResolve(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor, ResolveResult @Nullable [] results) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(11);
        }
        if (this.undefinedResolve(results)) {
            return true;
        }
        if (results != null && results.length != 0) {
            return false;
        }
        return localProcessor.isEncounteredXmlLiteral() || this.isGlobalThis();
    }

    protected boolean isGlobalThis() {
        return this.myQualifier == null && "globalThis".equals(this.myReferencedName);
    }

    private ResolveResult @NotNull [] mergeIncompleteLocalResolveWithGlobal(ResolveResult @NotNull [] localResults, boolean incompleteCode) {
        PsiElement resolve;
        ResolveResult[] globalResults;
        if (localResults == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(12);
        }
        if ((globalResults = this.resolveGlobalReference(incompleteCode)).length == 0) {
            if (localResults == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(13);
            }
            return localResults;
        }
        if (globalResults.length == 1 && (resolve = globalResults[0].getElement()) != null && JSResolveUtil.isSameReference(this.myRef, resolve)) {
            if (localResults == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(14);
            }
            return localResults;
        }
        if (globalResults == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(15);
        }
        return globalResults;
    }

    private ResolveResult @NotNull [] resolveGlobalReference(boolean incompleteCode) {
        ResolveResult[] results;
        Map<String, ResolveResult[]> cachedResultsMap = null;
        if (!(this.myParent instanceof JSDefinitionExpression) && TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)this.myRef) == null && (cachedResultsMap = this.getCachedTopLevelResultsMap()) != null && (results = cachedResultsMap.get(this.myReferencedName)) != null) {
            if (results == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(16);
            }
            return results;
        }
        results = this.doResolveGlobalReference(incompleteCode);
        if (cachedResultsMap != null) {
            cachedResultsMap.put(this.myReferencedName, results);
        }
        if (results == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(17);
        }
        return results;
    }

    private ResolveResult @NotNull [] doResolveGlobalReference(boolean incompleteCode) {
        assert (this.myReferencedName != null);
        QualifiedItemProcessor<ResolveResultSink> processor = JSReferenceExpressionResolver.processGlobalDeclarations(this.myReferencedName, (PsiElement)this.myRef, incompleteCode);
        ResolveResult[] results = this.resolveFromIndices(processor, true, false);
        if ((results = TypeScriptPsiUtil.removeDuplicates(Arrays.asList(results), RESOLVE_RESULT_TO_VALID_ELEMENT, (PsiElement)this.myRef).toArray(ResolveResult.EMPTY_ARRAY)) == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(18);
        }
        return results;
    }

    @NotNull
    private static QualifiedItemProcessor<ResolveResultSink> processGlobalDeclarations(@NotNull String referenceName, @NotNull PsiElement place, boolean incompleteCode) {
        if (referenceName == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(19);
        }
        if (place == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(20);
        }
        ResolveResultSink sink = new ResolveResultSink(place, referenceName, false, incompleteCode);
        QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement(place).createQualifiedItemProcessor(sink, place);
        processor.setTypeContext(true);
        TypeScriptResolveHelper.processGlobalThings(processor, ResolveState.initial(), place);
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = processor;
        if (qualifiedItemProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(21);
        }
        return qualifiedItemProcessor;
    }

    public static ResolveResult @NotNull [] resolveGlobalReference(@NotNull String referenceName, @NotNull PsiElement place, boolean incompleteCode, boolean includeTypeOnlyContextSymbols) {
        if (referenceName == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(22);
        }
        if (place == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(23);
        }
        QualifiedItemProcessor<ResolveResultSink> processor = JSReferenceExpressionResolver.processGlobalDeclarations(referenceName, place, incompleteCode);
        ResolveResult[] processorResults = processor.getResultsAsResolveResults();
        GlobalSearchScope scope = TypeScriptClassResolver.excludeGlobalTypeScript(JSResolveUtil.getResolveScope(place));
        if (!JSIndexBasedResolveUtil.cheapEnoughToProcessByQName(scope, JSClassResolver.IncludeLocalMembersOptions.ALL, place.getProject(), referenceName)) {
            if (processorResults == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(24);
            }
            return processorResults;
        }
        WalkUpResolveProcessor walkUpResolveProcessor = new WalkUpResolveProcessor(referenceName, place.getContainingFile(), place);
        walkUpResolveProcessor.addLocalResults(processor);
        JSIndexBasedResolveUtil.processAllSymbols(walkUpResolveProcessor, false, null, false, includeTypeOnlyContextSymbols);
        ResolveResult[] results = walkUpResolveProcessor.getResults();
        results = TypeScriptPsiUtil.removeDuplicates(Arrays.asList(results), RESOLVE_RESULT_TO_VALID_ELEMENT, place).toArray(ResolveResult.EMPTY_ARRAY);
        if (results == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(25);
        }
        return results;
    }

    protected ResolveResult @Nullable [] resolveFromProviders() {
        for (PsiReference reference : ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myRef)) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                if (results.length <= 0) continue;
                return results;
            }
            PsiElement resolve = reference.resolve();
            if (resolve == null) continue;
            return new ResolveResult[]{new JSResolveResult(resolve)};
        }
        return null;
    }

    @NotNull
    protected SinkResolveProcessor<ResolveResultSink> createLocalResolveProcessor(@NotNull ResolveResultSink sink) {
        if (sink == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(26);
        }
        return new SinkResolveProcessor<ResolveResultSink>(this.myReferencedName, (PsiElement)this.myRef, sink);
    }

    @NotNull
    protected QualifiedItemProcessor<ResolveResultSink> createQualifiedItemProcessor(@NotNull ResolveResultSink sink) {
        if (sink == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(27);
        }
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.myRef).createQualifiedItemProcessor(sink, (PsiElement)this.myRef);
        if (qualifiedItemProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(28);
        }
        return qualifiedItemProcessor;
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(29);
        }
        return this.resolveFromIndices(localProcessor, false, true);
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor, boolean excludeGlobalTypeScript, boolean includeTypeOnlyContextSymbols) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(30);
        }
        assert (this.myReferencedName != null);
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(this.myReferencedName, this.myContainingFile, (PsiElement)this.myRef);
        excludeGlobalTypeScript &= processor.myTypeInfo.isGlobalContext();
        processor.addLocalResults(localProcessor);
        if (this.prepareProcessor(processor, localProcessor)) {
            JSResolveUtil.tryProcessXmlFileImplicitElements((PsiElement)this.myRef, processor);
            JSResolveUtil.tryProcessAllElementsInInjectedContext(this.myContainingFile, (Processor<? super JSPsiElementBase>)((Processor)element -> {
                if (this.myReferencedName.equals(element.getName())) {
                    processor.doQualifiedCheck((JSPsiElementBase)element);
                }
                return true;
            }));
            JSIndexBasedResolveUtil.processAllSymbols(processor, this.myIgnorePerformanceLimits, this.myLimitingScopeFile, excludeGlobalTypeScript, includeTypeOnlyContextSymbols);
        }
        ResolveResult[] results = this.getResultsFromProcessor(processor);
        JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.SYMBOL, (Object)results.length);
        if (results.length == 0 && (this.myParent instanceof JSDefinitionExpression || JSDestructuringUtil.parentIsDestructuringAssignmentLHS(this.myRef))) {
            return this.getResultsForDefinition();
        }
        return this.myIgnorePerformanceLimits || results.length <= MAX_RESULTS_COUNT_TO_KEEP ? results : JSResolveResult.tooManyCandidatesResult();
    }

    protected ResolveResult[] getResultsFromProcessor(WalkUpResolveProcessor processor) {
        return processor.getResults();
    }

    public boolean undefinedResolve(ResolveResult[] resolveResults) {
        if ("undefined".equals(this.myReferencedName) && this.myQualifier == null) {
            if (resolveResults == null || resolveResults.length == 0) {
                return true;
            }
            for (ResolveResult result2 : resolveResults) {
                if (!result2.isValidResult()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(31);
        }
        return ref.getReferenceName();
    }

    protected boolean prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(32);
        }
        boolean searchInIndexes = true;
        boolean inDefinition = this.myParent instanceof JSDefinitionExpression;
        if (processor.myContext instanceof JSReferenceExpression && inDefinition) {
            JSExpression qualifier = ((JSReferenceExpression)processor.myContext).getQualifier();
            if (qualifier == null) {
                processor.setSkipDefinitions(true);
            } else {
                JSType _qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
                searchInIndexes = JSTypeUtils.isInstanceOrPrototype(_qualifierType);
            }
        }
        if (inDefinition) {
            processor.forceSetAddOnlyCompleteMatches();
        }
        return searchInIndexes;
    }

    protected ResolveResult[] getResultsForDefinition() {
        if (this.myQualifier == null && JSResolveUtil.isEcmaScript5((PsiElement)this.myRef)) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    protected ResolveResult[] dummyResult(JSReferenceExpression expression) {
        return new ResolveResult[]{new JSResolveResult((PsiElement)expression)};
    }

    @Nullable
    private Map<String, ResolveResult[]> getCachedTopLevelResultsMap() {
        if (this.myLimitingScopeFile != null) {
            return null;
        }
        Key<ParameterizedCachedValue<Map<String, ResolveResult[]>, PsiFile>> key = this.myIgnorePerformanceLimits ? TOP_LEVEL_RESULTS_WITH_IGNORE_PERF_LIMITS_KEY : TOP_LEVEL_RESULTS_KEY;
        return (Map)CachedValuesManager.getManager((Project)this.myContainingFile.getProject()).getParameterizedCachedValue((UserDataHolder)this.myContainingFile, key, p -> new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap()), new Object[]{p, PsiModificationTracker.MODIFICATION_COUNT}), false, (Object)this.myContainingFile);
    }

    public void setLimitingScopeFile(@Nullable PsiFile limitingScopeFile) {
        if (!this.myIgnorePerformanceLimits) {
            throw new IllegalStateException("To ensure that all elements in limitingScopeFile will be checked, myIgnorePerformanceLimits must be set.");
        }
        this.myLimitingScopeFile = limitingScopeFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver";
                break;
            }
            case 11: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localResults";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeIncompleteLocalResolveWithGlobal";
                break;
            }
            case 16: 
            case 17: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobalReference";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveGlobalReference";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "processGlobalDeclarations";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedItemProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDummyResolve";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergeIncompleteLocalResolveWithGlobal";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalDeclarations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalReference";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLocalResolveProcessor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedItemProcessor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromIndices";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferencedName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "prepareProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

