/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSuperMemberResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.lang.javascript.validation.JSFunctionCollector;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSInheritanceUtil {
    private static final ThreadLocal<GlobalSearchScope> ourEnforcedScope = new ThreadLocal();
    private static final JBTreeTraverser<JSPsiElementBase> SUBCLASS_TRAVERSAL = (JBTreeTraverser)JBTreeTraverser.from(JSInheritanceUtil::findDirectSubClasses).unique();

    public static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase method, boolean recursive, @NotNull PairFunction<? super List<T>, ? super String, Boolean> methodsProcessor, boolean onlyFunctions) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(0);
        }
        if (methodsProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(1);
        }
        return JSInheritanceUtil.iterateOverriddenMembersUp(method, recursive, methodsProcessor, (Set<? super String>)new THashSet(), onlyFunctions);
    }

    private static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase member, final boolean recursive, final @NotNull PairFunction<? super List<T>, ? super String, Boolean> membersProcessor, final @NotNull Set<? super String> visitedTypes, final boolean onlyFunctions) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(2);
        }
        if (membersProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(3);
        }
        if (visitedTypes == null) {
            JSInheritanceUtil.$$$reportNull$$$0(4);
        }
        if (ActionScriptResolveUtil.isActionScriptClassMemberExceptOverride(member)) {
            return true;
        }
        return JSResolveUtil.iterateOverrides(member, null, new JSOverrideHandler(){

            @Override
            public boolean process(@NotNull List<? extends JSPsiElementBase> elements, PsiElement scope, @Nullable String className2) {
                if (elements == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (className2 == null || !visitedTypes.add(className2)) {
                    return true;
                }
                ArrayList<JSPsiElementBase> results = new ArrayList<JSPsiElementBase>(elements.size());
                for (PsiElement psiElement : elements) {
                    results.add((JSPsiElementBase)psiElement);
                }
                if (!((Boolean)membersProcessor.fun(results, (Object)className2)).booleanValue()) {
                    return false;
                }
                if (recursive) {
                    for (JSPsiElementBase jSPsiElementBase : elements) {
                        if (onlyFunctions && !(jSPsiElementBase instanceof JSFunctionItem) || JSInheritanceUtil.iterateOverriddenMembersUp(jSPsiElementBase, true, membersProcessor, visitedTypes, onlyFunctions)) continue;
                        return false;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$1", "process"));
            }
        }, false);
    }

    public static boolean iterateOverriddenMethodsUp(@NotNull JSFunction method, @NotNull Processor<? super JSFunction> methodsProcessor) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(5);
        }
        if (methodsProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(6);
        }
        return JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)method, (Processor<? super JSPsiElementBase>)((Processor)el -> !(el instanceof JSFunction) || methodsProcessor.process((Object)((JSFunction)el))));
    }

    public static boolean iterateOverriddenMemberUp(@NotNull JSPsiElementBase el, @NotNull Processor<? super JSPsiElementBase> methodsProcessor) {
        if (el == null) {
            JSInheritanceUtil.$$$reportNull$$$0(7);
        }
        if (methodsProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(8);
        }
        return JSInheritanceUtil.iterateOverriddenMemberUp(el, methodsProcessor, false);
    }

    public static boolean iterateOverriddenMemberUp(@NotNull JSPsiElementBase el, @NotNull Processor<? super JSPsiElementBase> memberProcessor, boolean onlyFunctions) {
        if (el == null) {
            JSInheritanceUtil.$$$reportNull$$$0(9);
        }
        if (memberProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(10);
        }
        return JSInheritanceUtil.iterateOverriddenMembersUp(el, true, (jsNamedElements, s) -> {
            if (jsNamedElements.isEmpty()) {
                return false;
            }
            JSPsiElementBase toProcess = (JSPsiElementBase)ContainerUtil.getFirstItem((List)jsNamedElements);
            if (onlyFunctions && !(toProcess instanceof JSFunction)) {
                return false;
            }
            if (!memberProcessor.process((Object)toProcess)) {
                return false;
            }
            return true;
        }, onlyFunctions);
    }

    public static Collection<JSFunction> findImplementedMethods(@NotNull JSFunction implementingFunction) {
        if (implementingFunction == null) {
            JSInheritanceUtil.$$$reportNull$$$0(11);
        }
        return JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)implementingFunction).stream().filter(el -> el instanceof JSFunction).map(el -> (JSFunction)el).collect(Collectors.toList());
    }

    @NotNull
    public static Collection<JSPsiElementBase> findImplementedMembers(@NotNull JSQualifiedNamedElement implementingMember) {
        if (implementingMember == null) {
            JSInheritanceUtil.$$$reportNull$$$0(12);
        }
        if (!(implementingMember instanceof JSAttributeListOwner) || !(implementingMember instanceof TypeScriptTypeMember) && !JSInheritanceUtil.canHaveSuperMember(((JSAttributeListOwner)implementingMember).getAttributeList())) {
            List<JSPsiElementBase> list2 = Collections.emptyList();
            if (list2 == null) {
                JSInheritanceUtil.$$$reportNull$$$0(13);
            }
            return list2;
        }
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)implementingMember);
        if (containingClass == null) {
            List<JSPsiElementBase> list3 = Collections.emptyList();
            if (list3 == null) {
                JSInheritanceUtil.$$$reportNull$$$0(14);
            }
            return list3;
        }
        final HashSet collectedObjects = new HashSet();
        final String name = implementingMember.getName();
        if (name == null) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                JSInheritanceUtil.$$$reportNull$$$0(15);
            }
            return list4;
        }
        JSCollectMembersToImplementProcessor processor = new JSCollectMembersToImplementProcessor((PsiElement)implementingMember, true){

            @Override
            protected void processMembers(@NotNull List<? extends PsiElement> processorResults) {
                if (processorResults == null) {
                    2.$$$reportNull$$$0(0);
                }
                collectedObjects.addAll(processorResults);
            }

            @Override
            @Contract(value=" -> new")
            @NotNull
            protected ResultSink createResultSink() {
                return new ResolveResultSink(this.place, name);
            }

            @Override
            protected boolean shouldProcessClass(@NotNull JSClass jsClass) {
                if (jsClass == null) {
                    2.$$$reportNull$$$0(1);
                }
                return !DialectDetector.isTypeScript((PsiElement)jsClass) || containingClass.isEquivalentTo((PsiElement)jsClass) || jsClass.findFunctionByName(name) == null && jsClass.findFieldByName(name) == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processorResults";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jsClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processMembers";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldProcessClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSResolveUtil.processInterfaceMembers(containingClass, processor);
        List list5 = ContainerUtil.map(collectedObjects, el -> (JSPsiElementBase)el);
        if (list5 == null) {
            JSInheritanceUtil.$$$reportNull$$$0(16);
        }
        return list5;
    }

    @NotNull
    public static Collection<JSPsiElementBase> findNearestOverriddenMembers(@NotNull JSPsiElementBase method, boolean onlyFunctions) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(17);
        }
        THashSet result2 = new THashSet();
        JSInheritanceUtil.iterateOverriddenMembersUp(method, false, (arg_0, arg_1) -> JSInheritanceUtil.lambda$findNearestOverriddenMembers$5((Collection)result2, arg_0, arg_1), onlyFunctions);
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            JSInheritanceUtil.$$$reportNull$$$0(18);
        }
        return tHashSet;
    }

    public static boolean processNearestOverriddenMethods(@NotNull JSFunctionItem method, @NotNull Processor<? super JSFunctionItem> processor) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(20);
        }
        Ref result2 = Ref.create((Object)Boolean.TRUE);
        JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)method, false, (functions, s) -> {
            for (JSPsiElementBase function2 : functions) {
                JSFunctionItem overridden = JSPsiImplUtils.getPossibleFunctionItem((PsiElement)function2);
                if (processor.process((Object)overridden)) continue;
                result2.set((Object)Boolean.FALSE);
                return false;
            }
            return true;
        }, true);
        return (Boolean)result2.get();
    }

    @Nullable
    public static JSClass findSomeDeclaringClass(@NotNull JSQualifiedNamedElement method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(21);
        }
        return (JSClass)ContainerUtil.getFirstItem(JSInheritanceUtil.findDeclaringClasses(method), null);
    }

    public static Map<JSClass, JSPsiElementBase> findDeclaringClassesMap(@NotNull JSQualifiedNamedElement method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(22);
        }
        LinkedHashMap<JSClass, JSPsiElementBase> result2 = new LinkedHashMap<JSClass, JSPsiElementBase>();
        Collection<JSPsiElementBase> topMethods = JSInheritanceUtil.findTopMembers(method);
        for (JSPsiElementBase topMethod : topMethods) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)topMethod);
            if (containingClass == null) continue;
            result2.put(containingClass, topMethod);
        }
        return result2;
    }

    public static Collection<JSClass> findDeclaringClasses(@NotNull JSQualifiedNamedElement method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(23);
        }
        return JSInheritanceUtil.findDeclaringClassesMap(method).keySet();
    }

    @NotNull
    public static Collection<JSPsiElementBase> findTopMembers(@NotNull JSQualifiedNamedElement member) {
        Collection<JSPsiElementBase> implementedMembers;
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(24);
        }
        JSQualifiedNamedElement currentMember = member;
        JSPsiElementBase topParent = JSInheritanceUtil.findTopOverriddenMember((JSPsiElementBase)member);
        if (topParent != null) {
            currentMember = topParent;
        }
        if (!(implementedMembers = JSInheritanceUtil.findImplementedMembers(currentMember)).isEmpty()) {
            ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>(implementedMembers.size());
            for (JSPsiElementBase implementedMember : implementedMembers) {
                JSPsiElementBase toOverriddenForInterface = JSInheritanceUtil.findTopOverriddenMember(implementedMember);
                result2.add(toOverriddenForInterface != null ? toOverriddenForInterface : implementedMember);
            }
            ArrayList<JSPsiElementBase> arrayList = result2;
            if (arrayList == null) {
                JSInheritanceUtil.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        List<JSQualifiedNamedElement> list2 = Collections.singletonList(currentMember);
        if (list2 == null) {
            JSInheritanceUtil.$$$reportNull$$$0(26);
        }
        return list2;
    }

    public static Collection<JSFunction> findTopMethods(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(27);
        }
        return JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)method).stream().filter(el -> el instanceof JSFunction).map(el -> (JSFunction)el).collect(Collectors.toList());
    }

    @Nullable
    public static JSPsiElementBase findTopOverriddenMember(@NotNull JSPsiElementBase member) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(28);
        }
        Ref result2 = new Ref();
        JSInheritanceUtil.iterateOverriddenMemberUp(member, (Processor<? super JSPsiElementBase>)((Processor)currentMember -> {
            result2.set(currentMember);
            return true;
        }));
        return (JSPsiElementBase)result2.get();
    }

    @Nullable
    public static JSFunction findTopOverriddenMethod(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(29);
        }
        Ref result2 = new Ref();
        JSInheritanceUtil.iterateOverriddenMethodsUp(method, (Processor<? super JSFunction>)((Processor)function2 -> {
            result2.set(function2);
            return true;
        }));
        return (JSFunction)result2.get();
    }

    public static Collection<JSClass> findAllParentsForClass(@NotNull JSClass clazz, boolean includeNotProject) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(30);
        }
        HashSet<JSClass> supers = new HashSet<JSClass>();
        JSInheritanceUtil.findAllParentsForClass(clazz, supers, includeNotProject);
        return supers;
    }

    public static void findAllParentsForClass(@NotNull JSClass clazz, @NotNull Collection<JSClass> result2, boolean includeNotProject) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            JSInheritanceUtil.$$$reportNull$$$0(32);
        }
        for (JSClass superClass : clazz.getSupers()) {
            if (!includeNotProject && !clazz.getManager().isInProject((PsiElement)superClass) || superClass.isEquivalentTo((PsiElement)clazz) || JSPsiImplUtils.containsEquivalent(result2, (PsiElement)superClass)) continue;
            if (!JSResolveUtil.isObjectClass((JSPsiElementBase)superClass)) {
                result2.add(superClass);
                JSInheritanceUtil.findAllParentsForClass(superClass, result2, includeNotProject);
                continue;
            }
            if (clazz.isInterface()) continue;
            result2.add(superClass);
        }
    }

    public static boolean canBeSuperMember(@NotNull JSAttributeListOwner member) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(33);
        }
        if (member instanceof TypeScriptTypeMember) {
            return true;
        }
        if (member instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)member)) {
            return false;
        }
        if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
            return false;
        }
        return JSInheritanceUtil.canBeSuperMember(member.getAttributeList());
    }

    public static boolean canBeSuperMember(@Nullable JSAttributeList methodAttributeList) {
        return methodAttributeList == null || !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && methodAttributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE;
    }

    public static boolean canHaveSuperMember(@NotNull JSAttributeListOwner member) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(34);
        }
        if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
            return false;
        }
        return member instanceof TypeScriptTypeMember || JSInheritanceUtil.canHaveSuperMember(member.getAttributeList());
    }

    public static boolean canHaveSuperMethod(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(35);
        }
        return JSInheritanceUtil.canHaveSuperMember((JSAttributeListOwner)method);
    }

    @Contract(value="null -> false")
    public static boolean canHaveSuperMember(@Nullable JSAttributeList methodAttributeList) {
        if (methodAttributeList != null) {
            return !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
        }
        return false;
    }

    @Nullable
    public static JSClass findNearestBaseClass(@NotNull JSClass aClass, boolean includeNonProject) {
        JSClass[] supers;
        if (aClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(36);
        }
        if ((supers = aClass.getSupers()).length > 0) {
            JSClass superClass = supers[0];
            if (JSResolveUtil.isObjectClass((JSPsiElementBase)superClass) && supers.length > 1) {
                superClass = supers[1];
            }
            if (includeNonProject || superClass.getManager().isInProject((PsiElement)superClass)) {
                return superClass;
            }
        }
        return null;
    }

    public static boolean isMemberOfSubclass(@NotNull JSClass superClass, @NotNull JSElement classMember, boolean allowSuperClass) {
        JSClass memberClass;
        if (superClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(37);
        }
        if (classMember == null) {
            JSInheritanceUtil.$$$reportNull$$$0(38);
        }
        if ((memberClass = JSUtils.getMemberContainingClass((PsiElement)classMember)) == null) {
            return false;
        }
        if (superClass.isEquivalentTo((PsiElement)memberClass)) {
            return allowSuperClass;
        }
        return JSInheritanceUtil.isParentClass(memberClass, superClass);
    }

    public static Collection<JSClass> findDirectSubClasses(@NotNull JSClass jsClass, boolean skipSubInterfaces) {
        if (jsClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(39);
        }
        ArrayList<JSClass> result2 = new ArrayList<JSClass>();
        if (!jsClass.isInterface() || !skipSubInterfaces) {
            JSClassSearch.searchClassInheritors(jsClass, false).forEach(jsClass1 -> {
                if (!JSPsiImplUtils.containsEquivalent(result2, (PsiElement)jsClass1)) {
                    result2.add((JSClass)jsClass1);
                }
                return true;
            });
        }
        if (jsClass.isInterface()) {
            JSClassSearch.searchInterfaceImplementations(jsClass, false).forEach(candidate -> {
                if ((skipSubInterfaces || JSPsiImplUtils.containsEquivalent((PsiElement[])candidate.getSupers(), (PsiElement)jsClass)) && !JSPsiImplUtils.containsEquivalent(result2, (PsiElement)candidate)) {
                    result2.add((JSClass)candidate);
                }
                return true;
            });
        }
        return result2;
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(40);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(41);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)clazz));
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict, @Nullable PsiElement context) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(42);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(43);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)(context != null ? context : clazz)));
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict, @NotNull GlobalSearchScope resolveScope) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(44);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(45);
        }
        if (resolveScope == null) {
            JSInheritanceUtil.$$$reportNull$$$0(46);
        }
        if (!strict && clazz.isEquivalentTo((PsiElement)parentClass)) {
            return true;
        }
        if (DialectDetector.isActionScript((PsiElement)clazz)) {
            return (Boolean)JSInheritanceUtil.withEnforcedScope(() -> JSInheritanceUtil.isParentClass(clazz, parentClass, (Set<? super JSClass>)new THashSet()), resolveScope);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, (Set<? super JSClass>)new THashSet());
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(47);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(48);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, true);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static JSFunction findMethodInClass(@Nullable JSFunction pattern, @NotNull JSClass aClass, boolean lookInSupers) {
        if (aClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(49);
        }
        if (pattern == null) {
            return null;
        }
        JSFunction method = aClass.findFunctionByNameAndKind(pattern.getName(), pattern.getKind());
        if (method != null) {
            return method;
        }
        if (lookInSupers && JSInheritanceUtil.canHaveSuperMethod(pattern)) {
            final Ref result2 = new Ref();
            JSResolveUtil.iterateOverrides((JSPsiElementBase)pattern, aClass, new JSOverrideHandler(){

                @Override
                public boolean process(@NotNull List<? extends JSPsiElementBase> elements, PsiElement scope, @Nullable String className2) {
                    if (elements == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    result2.set((Object)((JSFunction)elements.iterator().next()));
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$3", "process"));
                }
            }, true);
            return (JSFunction)result2.get();
        }
        return null;
    }

    public static boolean participatesInHierarchy(JSFunction fun) {
        return !JSInheritanceUtil.processHierarchy(fun, (Processor<? super JSFunction>)CommonProcessors.alwaysFalse());
    }

    public static boolean participatesInMemberHierarchy(JSQualifiedNamedElement el) {
        return !JSInheritanceUtil.processMemberHierarchy(el, (Processor<? super JSPsiElementBase>)CommonProcessors.alwaysFalse());
    }

    public static boolean processHierarchy(@NotNull JSFunction fun, @NotNull Processor<? super JSFunction> processor) {
        if (fun == null) {
            JSInheritanceUtil.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(51);
        }
        Processor functionsProcessor = elementBase -> !(elementBase instanceof JSFunction) || processor.process((Object)((JSFunction)elementBase));
        return JSInheritanceUtil.processMemberHierarchy((JSQualifiedNamedElement)fun, (Processor<? super JSPsiElementBase>)functionsProcessor);
    }

    public static boolean processMemberHierarchy(@NotNull JSQualifiedNamedElement member, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(53);
        }
        if (JSUtils.getMemberContainingClass((PsiElement)member) == null) {
            return true;
        }
        if (!ContainerUtil.process(JSInheritanceUtil.findImplementedMembers(member), processor)) {
            return false;
        }
        if (!JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)member, processor, false)) {
            return false;
        }
        return JSInheritanceUtil.iterateMembersDown((JSPsiElementBase)member, processor);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, @NotNull Processor<? super JSFunction> processor) {
        if (fun == null) {
            JSInheritanceUtil.$$$reportNull$$$0(54);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(55);
        }
        return JSInheritanceUtil.iterateMethodsDown(fun, processor, false);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, @NotNull Processor<? super JSFunction> processor, boolean checkOverrideModifier) {
        if (fun == null) {
            JSInheritanceUtil.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(57);
        }
        Processor functionsProcessor = elementBase -> !(elementBase instanceof JSFunction) || processor.process((Object)((JSFunction)elementBase));
        return JSInheritanceUtil.iterateMembersDown((JSPsiElementBase)fun, (Processor<? super JSPsiElementBase>)functionsProcessor, checkOverrideModifier);
    }

    public static boolean iterateMembersDown(@NotNull JSPsiElementBase fun, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (fun == null) {
            JSInheritanceUtil.$$$reportNull$$$0(58);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(59);
        }
        return JSInheritanceUtil.iterateMembersDown(fun, processor, false);
    }

    public static boolean iterateMembersDown(@NotNull JSPsiElementBase member, @NotNull Processor<? super JSPsiElementBase> processor, boolean checkOverrideModifier) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(60);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(61);
        }
        Processor overridesProcessor = jsFunction -> {
            if (checkOverrideModifier && jsFunction instanceof JSFunction && !JSPsiImplUtils.hasModifier((JSAttributeListOwner)((JSFunction)jsFunction), JSAttributeList.ModifierType.OVERRIDE)) {
                return true;
            }
            return processor.process(jsFunction);
        };
        if (!JSMembersSearch.searchOverridingMembers(member, true).forEach(overridesProcessor)) {
            return false;
        }
        return JSMembersSearch.searchImplementingMembers(member, true).forEach(processor);
    }

    public static boolean hasSuperMembers(@NotNull JSPsiElementBase member) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(62);
        }
        return !JSInheritanceUtil.iterateOverriddenMemberUp(member, (Processor<? super JSPsiElementBase>)CommonProcessors.alwaysFalse());
    }

    public static Collection<JSFunction> collectFunctionsToOverride(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(63);
        }
        if (clazz.isInterface()) {
            return Collections.emptyList();
        }
        JSFunctionCollector _functionsToOverride = null;
        Predicate<JSFunction> functionFilter = function2 -> {
            JSAttributeList attributeList = function2.getAttributeList();
            if (attributeList != null && (attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE)) {
                return false;
            }
            return ActionScriptResolveUtil.isAccessibleFromCurrentActionScriptPackage((PsiElement)function2, (PsiElement)clazz);
        };
        for (JSClass superClazz : clazz.getSuperClasses()) {
            _functionsToOverride = JSFunctionCollector.collectAllVisibleClassFunctions(superClazz, _functionsToOverride, functionFilter);
        }
        final JSFunctionCollector functionsToOverride = _functionsToOverride;
        ResolveProcessor collectOwnFunctions = new ResolveProcessor(null, (PsiElement)clazz){
            {
                super(name, _place);
                this.setToProcessMembers(true);
                this.setToProcessHierarchy(false);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (element instanceof JSFunction) {
                    JSFunction function2 = (JSFunction)element;
                    if (function2.isConstructor() || functionsToOverride == null) {
                        return true;
                    }
                    functionsToOverride.removeFunctionByNameAndKind(function2.getName(), function2.getKind());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$4";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        clazz.processDeclarations((PsiScopeProcessor)collectOwnFunctions, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
        return functionsToOverride != null ? functionsToOverride.getFunctions() : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(@NotNull JSFunction constructor) {
        JSClass clazz;
        if (constructor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(64);
        }
        return (clazz = JSUtils.getMemberContainingClass((PsiElement)constructor)) != null ? JSInheritanceUtil.findSuperConstructorCalls(clazz) : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(65);
        }
        ArrayList<JSCallExpression> result2 = new ArrayList<JSCallExpression>();
        Processor p = jsCallExpression -> {
            result2.add((JSCallExpression)jsCallExpression);
            return true;
        };
        Collection<JSClass> subClasses = JSInheritanceUtil.findDirectSubClasses(clazz, true);
        for (JSClass subClass : subClasses) {
            JSInheritanceUtil.processSuperCallsIn(subClass, (Processor<? super JSCallExpression>)p);
        }
        return result2;
    }

    public static boolean processSuperCallsIn(@NotNull JSClass subClass, @NotNull Processor<? super JSCallExpression> processor) {
        JSCallExpression superCall;
        JSFunction subClassConstructor;
        if (subClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(66);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(67);
        }
        return (subClassConstructor = subClass.getConstructor()) == null || (superCall = (JSCallExpression)SyntaxTraverser.psiTraverser((PsiElement)subClassConstructor).filter(JSCallExpression.class).filter(c -> c.getMethodExpression() instanceof JSSuperExpression).first()) == null || processor.process((Object)superCall);
    }

    @NotNull
    private static JSSuperMemberResolveProcessor createFindSuperMemberByNameProcessor(@NotNull String name, @Nullable String namespace, @Nullable PsiElement context, boolean onlyFunctions) {
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(68);
        }
        return new JSSuperMemberResolveProcessor(name, context, onlyFunctions, namespace);
    }

    public static boolean isRealOverride(@NotNull JSAttributeListOwner member, @Nullable String namespace, @Nullable PsiElement context) {
        JSAttributeList attributeList;
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(69);
        }
        if ((attributeList = member.getAttributeList()) != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            if (type == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (type == JSAttributeList.AccessType.PACKAGE_LOCAL && ActionScriptPsiImplUtil.getNamespace(attributeList) == null && !(member.getParent() instanceof JSFile)) {
                return ActionScriptResolveUtil.isAccessibleFromCurrentActionScriptPackage((PsiElement)member, context);
            }
        }
        String elementNs = ActionScriptPsiImplUtil.getNamespaceValue(attributeList);
        return (namespace != null || elementNs == null) && (namespace == null || namespace.equals(elementNs));
    }

    public static boolean processOverrides(@NotNull JSClass clazz, @NotNull JSOverrideHandler handler, @NotNull String name, @Nullable String namespace, @NotNull PsiElement context, boolean onlyFunctions) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(70);
        }
        if (handler == null) {
            JSInheritanceUtil.$$$reportNull$$$0(71);
        }
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(72);
        }
        if (context == null) {
            JSInheritanceUtil.$$$reportNull$$$0(73);
        }
        JSSuperMemberResolveProcessor resolveProcessor = JSInheritanceUtil.createFindSuperMemberByNameProcessor(name, namespace, context, onlyFunctions);
        for (JSClass superClazz : clazz.getSuperClasses()) {
            List results;
            JSClass resultMemberContainingClass;
            if (superClazz == clazz) break;
            superClazz.processDeclarations((PsiScopeProcessor)resolveProcessor, ResolveState.initial(), (PsiElement)superClazz, context);
            List<PsiElement> elements = resolveProcessor.getResults();
            PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
            if (element == null || (resultMemberContainingClass = JSUtils.getMemberContainingClass(element)) == null || handler.process(results = ContainerUtil.mapNotNull((Collection)ContainerUtil.notNullize(elements), el -> (JSPsiElementBase)ObjectUtils.tryCast((Object)el, JSPsiElementBase.class)), (PsiElement)superClazz, resultMemberContainingClass.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    private static boolean searchClassInHierarchy(@NotNull JSClass classToSearch, @NotNull Ref<JSPsiElementBase> overriddenMember) {
        if (classToSearch == null) {
            JSInheritanceUtil.$$$reportNull$$$0(74);
        }
        if (overriddenMember == null) {
            JSInheritanceUtil.$$$reportNull$$$0(75);
        }
        Ref success = Ref.create();
        JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)overriddenMember.get(), (Processor<? super JSPsiElementBase>)((Processor)el -> {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)el);
            if (classToSearch.isEquivalentTo((PsiElement)containingClass)) {
                success.set((Object)true);
                return false;
            }
            overriddenMember.set(el);
            JSAttributeList attributeList = el instanceof JSAttributeListOwner ? ((JSAttributeListOwner)el).getAttributeList() : null;
            return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
        }));
        return !success.isNull();
    }

    public static boolean checkMemberHierarchyIncludeClass(@NotNull JSPsiElementBase resolvedElement, @NotNull JSClass elementParent) {
        Ref topOverriddenMember;
        if (resolvedElement == null) {
            JSInheritanceUtil.$$$reportNull$$$0(76);
        }
        if (elementParent == null) {
            JSInheritanceUtil.$$$reportNull$$$0(77);
        }
        if (JSInheritanceUtil.searchClassInHierarchy(elementParent, (Ref<JSPsiElementBase>)(topOverriddenMember = new Ref((Object)resolvedElement)))) {
            return true;
        }
        JSPsiElementBase base = (JSPsiElementBase)topOverriddenMember.get();
        if (!(base instanceof JSQualifiedNamedElement)) {
            return false;
        }
        Collection<JSPsiElementBase> implementedMembers = JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)base);
        for (JSPsiElementBase member : implementedMembers) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)member);
            if (elementParent.isEquivalentTo((PsiElement)containingClass)) {
                return true;
            }
            if (!JSInheritanceUtil.searchClassInHierarchy(elementParent, (Ref<JSPsiElementBase>)Ref.create((Object)member))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Pair<JSClass, JSPsiElementBase> findSuperMembersFromContextType(@NotNull JSPsiElementBase element) {
        JSClass aClass;
        PsiElement singleElement;
        PsiElement parent;
        if (element == null) {
            JSInheritanceUtil.$$$reportNull$$$0(78);
        }
        if (element instanceof JSFunctionExpression && (parent = element.getParent()) instanceof JSProperty) {
            element = (JSPsiElementBase)parent;
        }
        parent = element.getParent();
        if (!(element instanceof JSProperty && parent instanceof JSExpression && DialectDetector.isTypeScript((PsiElement)element))) {
            return null;
        }
        JSType expectedType = JSTypeUtils.getValuableType(JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent, JSExpectedTypeKind.CONTEXTUAL));
        if (expectedType == null) {
            return null;
        }
        String name = element.getName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        JSRecordType.PropertySignature property = expectedType.asRecordType().findPropertySignature(name);
        if (property == null) {
            return null;
        }
        PsiElement psiElement = singleElement = property instanceof PsiElement ? (PsiElement)property : property.getMemberSource().getSingleElement();
        if (singleElement instanceof JSPsiElementBase && (aClass = JSUtils.getMemberContainingClass(singleElement)) != null) {
            return Pair.create((Object)aClass, (Object)((JSPsiElementBase)singleElement));
        }
        return null;
    }

    @NotNull
    public static Collection<JSPsiElementBase> findDirectSubClasses(@NotNull JSPsiElementBase clazz) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(79);
        }
        if (clazz instanceof JSClass) {
            Collection<JSClass> collection = Collections.unmodifiableCollection(JSInheritanceUtil.findDirectSubClasses((JSClass)clazz, true));
            if (collection == null) {
                JSInheritanceUtil.$$$reportNull$$$0(80);
            }
            return collection;
        }
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(clazz);
        if (qName == null) {
            List<JSPsiElementBase> list2 = Collections.emptyList();
            if (list2 == null) {
                JSInheritanceUtil.$$$reportNull$$$0(81);
            }
            return list2;
        }
        final ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>();
        HashSet<JSPsiElementBase> initialElements = new HashSet<JSPsiElementBase>(Collections.singletonList(clazz));
        JSTypeEvaluateManager.iterateSubclasses((PsiElement)clazz, qName, new JSResolveUtil.MyNamespaceProcessor(initialElements, true){

            @Override
            protected boolean doProcess(PsiElement elt) {
                if (elt instanceof JSPsiElementBase) {
                    result2.add((JSPsiElementBase)elt);
                }
                return true;
            }
        });
        ArrayList<JSPsiElementBase> arrayList = result2;
        if (arrayList == null) {
            JSInheritanceUtil.$$$reportNull$$$0(82);
        }
        return arrayList;
    }

    @Nullable
    public static JSFunctionItem findMethodInClass(@NotNull JSFunctionItem baseMethod, @NotNull JSPsiElementBase clazz) {
        if (baseMethod == null) {
            JSInheritanceUtil.$$$reportNull$$$0(83);
        }
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(84);
        }
        if (baseMethod instanceof JSFunction && clazz instanceof JSClass) {
            return JSInheritanceUtil.findMethodInClass((JSFunction)baseMethod, (JSClass)clazz, false);
        }
        String name = baseMethod.getName();
        if (name == null) {
            return null;
        }
        JSQualifiedName classNs = JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)clazz);
        if (classNs == null) {
            return null;
        }
        String qName = JSQualifiedNameImpl.create(name, classNs).getQualifiedName();
        List<JSPsiElementBase> methods = JSDialectSpecificHandlersFactory.forElement((PsiElement)clazz).getClassResolver().findElementsByQNameIncludingImplicit(qName, clazz.getContainingFile());
        Optional methodInCurrentClass = StreamEx.of(methods).map(it -> {
            JSExpression initializer;
            if (!(it instanceof JSFunctionItem) && it instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)it).getInitializer()) instanceof JSFunctionItem) {
                return initializer;
            }
            return it;
        }).select(JSFunctionItem.class).findFirst();
        return methodInCurrentClass.orElse(null);
    }

    @NotNull
    public static @NotNull JBIterable<@NotNull JSFunctionItem> findOverrides(@NotNull JSFunctionItem baseMethod) {
        JSPsiElementBase baseClass;
        if (baseMethod == null) {
            JSInheritanceUtil.$$$reportNull$$$0(85);
        }
        if ((baseClass = JSInheritanceUtil.getContainingClass((JSPsiElementBase)baseMethod)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JSInheritanceUtil.$$$reportNull$$$0(86);
            }
            return jBIterable;
        }
        JBIterable jBIterable = ((JBTreeTraverser)SUBCLASS_TRAVERSAL.withRoot((Object)baseClass)).bfsTraversal().filterMap(subClass -> subClass != baseClass ? JSInheritanceUtil.findMethodInClass(baseMethod, subClass) : null);
        if (jBIterable == null) {
            JSInheritanceUtil.$$$reportNull$$$0(87);
        }
        return jBIterable;
    }

    @Nullable
    public static JSPsiElementBase getContainingClass(@NotNull JSPsiElementBase method) {
        JSClass jsClass;
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(88);
        }
        if ((jsClass = JSResolveUtil.getClassOfContext((PsiElement)method)) != null) {
            return jsClass;
        }
        JSQualifiedName parentNs = method.getJSNamespace().getQualifiedName();
        if (parentNs == null) {
            return null;
        }
        JSClassResolver classResolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)method).getClassResolver();
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)method.getContainingFile());
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        classResolver.processElementsByQNameIncludingImplicit(parentNs.getQualifiedName(), scope, (Processor<? super JSPsiElementBase>)processor);
        return (JSPsiElementBase)processor.getFoundValue();
    }

    @Nullable
    public static JSQualifiedNamedElement findMember(@NotNull String name, @NotNull JSClass jsClass, @NotNull SearchedMemberType searchedMemberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSupers) {
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(89);
        }
        if (jsClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(90);
        }
        if (searchedMemberType == null) {
            JSInheritanceUtil.$$$reportNull$$$0(91);
        }
        return JSInheritanceUtil.findMember(name, jsClass, searchedMemberType, limitByFunctionKind, lookInSupers, (Set<? super JSClass>)(lookInSupers ? new THashSet() : Collections.emptySet()));
    }

    @Nullable
    private static JSQualifiedNamedElement findMember(@NotNull String name, @NotNull JSClass jsClass, @NotNull SearchedMemberType memberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSuperClasses, @NotNull Set<? super JSClass> visited) {
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(92);
        }
        if (jsClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(93);
        }
        if (memberType == null) {
            JSInheritanceUtil.$$$reportNull$$$0(94);
        }
        if (visited == null) {
            JSInheritanceUtil.$$$reportNull$$$0(95);
        }
        if (visited.contains(jsClass)) {
            return null;
        }
        if (memberType == SearchedMemberType.Fields || memberType == SearchedMemberType.FieldsAndMethods) {
            JSFieldVariable fieldParameter;
            JSField field = jsClass.findFieldByName(name);
            if (field != null) {
                return field;
            }
            if (jsClass instanceof TypeScriptClass && (fieldParameter = ((TypeScriptClass)jsClass).findFieldParameterByName(name)) != null) {
                return fieldParameter;
            }
        }
        if (memberType == SearchedMemberType.Methods || memberType == SearchedMemberType.FieldsAndMethods) {
            JSFunction function2;
            JSFunction jSFunction = function2 = limitByFunctionKind == null ? jsClass.findFunctionByName(name) : jsClass.findFunctionByNameAndKind(name, limitByFunctionKind);
            if (function2 != null) {
                return function2;
            }
        }
        if (lookInSuperClasses) {
            visited.add((JSClass)jsClass);
            for (JSClass superClass : jsClass.getSuperClasses()) {
                JSQualifiedNamedElement inSuper = JSInheritanceUtil.findMember(name, superClass, memberType, limitByFunctionKind, true, visited);
                if (inSuper == null) continue;
                return inSuper;
            }
        }
        return null;
    }

    private static boolean isParentClass(@NotNull JSClass aClass, @Nullable JSClass parent, @NotNull Set<? super JSClass> visited) {
        if (aClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(96);
        }
        if (visited == null) {
            JSInheritanceUtil.$$$reportNull$$$0(97);
        }
        if (visited.contains(aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if (superClazz.isEquivalentTo((PsiElement)parent)) {
                return true;
            }
            visited.add((JSClass)aClass);
            if (!JSInheritanceUtil.isParentClass(superClazz, parent, visited)) continue;
            return true;
        }
        return false;
    }

    public static <T> T withEnforcedScope(Computable<T> r, GlobalSearchScope scope) {
        assert (JSInheritanceUtil.getEnforcedScope() == null);
        ourEnforcedScope.set(scope);
        try {
            Object object = r.compute();
            return (T)object;
        }
        finally {
            ourEnforcedScope.set(null);
        }
    }

    public static GlobalSearchScope getEnforcedScope() {
        return ourEnforcedScope.get();
    }

    @Nullable
    public static JSParameterItem findMatchedSuperParameter(@NotNull JSParameter parameter, @NotNull JSFunction function2) {
        if (parameter == null) {
            JSInheritanceUtil.$$$reportNull$$$0(98);
        }
        if (function2 == null) {
            JSInheritanceUtil.$$$reportNull$$$0(99);
        }
        int _parameterIndex = Integer.MAX_VALUE;
        JSParameter[] parameters = function2.getParameterVariables();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            _parameterIndex = i;
            break;
        }
        int parameterIndex = _parameterIndex;
        Ref matchedSuperParameter = Ref.create(null);
        JSInheritanceUtil.processNearestOverriddenMethods((JSFunctionItem)function2, (Processor<? super JSFunctionItem>)((Processor)overridden -> {
            if (overridden == null) {
                return true;
            }
            JSParameterItem[] overriddenParameters = overridden.getParameterVariables();
            if (parameterIndex < overriddenParameters.length) {
                matchedSuperParameter.set((Object)overriddenParameters[parameterIndex]);
                return false;
            }
            return true;
        }));
        return (JSParameterItem)matchedSuperParameter.get();
    }

    public static boolean iterateAllMembersInHierarchy(@NotNull JSQualifiedNamedElement function2, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (function2 == null) {
            JSInheritanceUtil.$$$reportNull$$$0(100);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(101);
        }
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        Collection<JSPsiElementBase> topMethods = JSInheritanceUtil.findTopMembers(function2);
        for (JSPsiElementBase topMethod : topMethods) {
            if (uniqueProcessor.process((Object)topMethod) && JSInheritanceUtil.iterateMembersDown(topMethod, (Processor<? super JSPsiElementBase>)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ Boolean lambda$findNearestOverriddenMembers$5(Collection result2, List functions, String s) {
        result2.addAll(functions);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 80: 
            case 81: 
            case 82: 
            case 86: 
            case 87: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 80: 
            case 81: 
            case 82: 
            case 86: 
            case 87: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsProcessor";
                break;
            }
            case 2: 
            case 24: 
            case 28: 
            case 33: 
            case 34: 
            case 52: 
            case 60: 
            case 62: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedTypes";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementingFunction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementingMember";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 80: 
            case 81: 
            case 82: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil";
                break;
            }
            case 20: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 67: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: 
            case 31: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 63: 
            case 65: 
            case 70: 
            case 79: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 36: 
            case 49: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 39: 
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 41: 
            case 43: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 50: 
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 68: 
            case 72: 
            case 89: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToSearch";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenMember";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementParent";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseMethod";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchedMemberType";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberType";
                break;
            }
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findImplementedMembers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findNearestOverriddenMembers";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopMembers";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectSubClasses";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "findOverrides";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverriddenMembersUp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverriddenMethodsUp";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverriddenMemberUp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findImplementedMethods";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findImplementedMembers";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 80: 
            case 81: 
            case 82: 
            case 86: 
            case 87: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findNearestOverriddenMembers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processNearestOverriddenMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findSomeDeclaringClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaringClassesMap";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaringClasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findTopMembers";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findTopMethods";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findTopOverriddenMember";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findTopOverriddenMethod";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentsForClass";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "canBeSuperMember";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSuperMember";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSuperMethod";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findNearestBaseClass";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isMemberOfSubclass";
                break;
            }
            case 39: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findDirectSubClasses";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isParentClass";
                break;
            }
            case 49: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInClass";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processMemberHierarchy";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "iterateMethodsDown";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "iterateMembersDown";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperMembers";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "collectFunctionsToOverride";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findSuperConstructorCalls";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "processSuperCallsIn";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createFindSuperMemberByNameProcessor";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isRealOverride";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processOverrides";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "searchClassInHierarchy";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberHierarchyIncludeClass";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMembersFromContextType";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findOverrides";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "findMember";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedSuperParameter";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "iterateAllMembersInHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 80: 
            case 81: 
            case 82: 
            case 86: 
            case 87: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class CacheByEnforcedResolveScope<T> {
        private static final GlobalSearchScope NO_ENFORCED_SCOPE_MARKER = new NoEnforcedScopeMarker();
        private final Map<GlobalSearchScope, T> myCache = new ConcurrentHashMap<GlobalSearchScope, T>();

        public T compute() {
            GlobalSearchScope enforcedScope = JSInheritanceUtil.getEnforcedScope();
            GlobalSearchScope key = enforcedScope != null ? enforcedScope : NO_ENFORCED_SCOPE_MARKER;
            T value = this.myCache.get(key);
            if (value == null) {
                value = this.computeForScope(enforcedScope);
                this.myCache.put(key, value);
            }
            return value;
        }

        protected abstract T computeForScope(@Nullable GlobalSearchScope var1);

        private static class NoEnforcedScopeMarker
        extends GlobalSearchScope {
            private NoEnforcedScopeMarker() {
            }

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    NoEnforcedScopeMarker.$$$reportNull$$$0(0);
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    NoEnforcedScopeMarker.$$$reportNull$$$0(1);
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static enum SearchedMemberType {
        Fields,
        Methods,
        FieldsAndMethods;

    }
}

