/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSGenericTypesEvaluator {
    public static final Key<JSGenericMappings> ourGenericArgumentsMapKey = Key.create((String)"generic.arguments");
    public static final Key<Boolean> ourHadContravariantGenerics = Key.create((String)"generic.had.contravariant");
    public static final Key<Pair<JSTypeSubstitutor.JSTypeGenericId, Integer>> impliedArity = Key.create((String)"generic.implied.arity");
    public static final Key<Set<JSTypeSubstitutor.JSTypeGenericId>> nonWideningLiterals = Key.create((String)"generic.non.widening.literals");
    public static final GenericEvaluationContext DEFAULT_CONTEXT = new GenericEvaluationContext();
    public static final JSGenericTypesEvaluator NO_OP = new JSGenericTypesEvaluator(){

        @Override
        public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            return type;
        }

        @Override
        @NotNull
        public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
            if (type == null) {
                1.$$$reportNull$$$0(1);
            }
            if (qualifier == null) {
                1.$$$reportNull$$$0(2);
            }
            if (methodExpression == null) {
                1.$$$reportNull$$$0(3);
            }
            JSType jSType = type;
            if (jSType == null) {
                1.$$$reportNull$$$0(4);
            }
            return jSType;
        }

        @Override
        @NotNull
        public JSGenericTypeEvaluationFunction getEvaluationFunction(@NotNull JSCallLikeExpression callLikeExpression, @NotNull PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
            if (callLikeExpression == null) {
                1.$$$reportNull$$$0(5);
            }
            if (resolvedFunction == null) {
                1.$$$reportNull$$$0(6);
            }
            if (context == null) {
                1.$$$reportNull$$$0(7);
            }
            JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = JSGenericTypeEvaluationFunction.SELF;
            if (jSGenericTypeEvaluationFunction == null) {
                1.$$$reportNull$$$0(8);
            }
            return jSGenericTypeEvaluationFunction;
        }

        @Override
        public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSCallItem callItem, @Nullable PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(9);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodExpression";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callLikeExpression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluateGenericsFromQualifier";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEvaluationFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateGenerics";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateGenericsFromQualifier";
                    break;
                }
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getEvaluationFunction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @Contract(value="null -> false")
    public static boolean isGenericProcessingInProgress(@Nullable ProcessingContext context) {
        return JSGenericTypesEvaluator.getGenericMappings(context) != null;
    }

    @Nullable
    public static JSGenericMappings getGenericMappings(@Nullable ProcessingContext context) {
        return context != null ? (JSGenericMappings)context.get(ourGenericArgumentsMapKey) : null;
    }

    @NotNull
    public static JSGenericTypesEvaluator getEvaluator(@Nullable PsiElement context) {
        JSGenericTypesEvaluator jSGenericTypesEvaluator = JSDialectSpecificHandlersFactory.forElement(context).getGenericTypeEvaluator();
        if (jSGenericTypesEvaluator == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        return jSGenericTypesEvaluator;
    }

    public static void setImpliedArity(@NotNull JSGenericParameterType type, int count, @NotNull ProcessingContext context) {
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        Pair pair = Pair.create((Object)type.getGenericId(), (Object)count);
        context.put(impliedArity, (Object)pair);
    }

    public static int getImpliedArity(@NotNull JSType type, @NotNull ProcessingContext context) {
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        if (!(type instanceof JSGenericParameterType)) {
            return -1;
        }
        Pair pair = (Pair)context.get(impliedArity);
        return ((JSTypeSubstitutor.JSTypeGenericId)pair.first).equals((Object)((JSGenericParameterType)type).getGenericId()) ? (Integer)pair.second : -1;
    }

    @Contract(value="!null,_,_->!null")
    default public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, DEFAULT_CONTEXT);
    }

    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType var1, @Nullable JSExpression var2, @Nullable PsiElement var3, @NotNull GenericEvaluationContext var4);

    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType var1, @NotNull JSCallItem var2, @Nullable PsiElement var3, @NotNull GenericEvaluationContext var4);

    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType var1, @NotNull JSExpression var2, @NotNull JSExpression var3);

    @NotNull
    public JSGenericTypeEvaluationFunction getEvaluationFunction(@NotNull JSCallLikeExpression var1, @NotNull PsiElement var2, @NotNull GenericEvaluationContext var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setImpliedArity";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImpliedArity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface GenericErrorReporter {
        public void error(@NotNull @InspectionMessage String var1);
    }

    public static class GenericEvaluationContext {
        public final int paramToSkip;
        public final JSExpectedTypeKind expectedTypeKind;
        @Nullable
        public final GenericErrorReporter reporter;

        public GenericEvaluationContext(@Nullable GenericErrorReporter reporter) {
            this(reporter, -1, JSExpectedTypeKind.EXPECTED);
        }

        public GenericEvaluationContext() {
            this(null, -1, JSExpectedTypeKind.EXPECTED);
        }

        public GenericEvaluationContext(@Nullable GenericErrorReporter reporter, int paramToSkip, JSExpectedTypeKind expectedTypeKind) {
            this.paramToSkip = paramToSkip;
            this.reporter = reporter;
            this.expectedTypeKind = expectedTypeKind;
        }
    }
}

