/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluationLogger {
    private static final boolean PRINT_TO_STDOUT = false;
    private static final boolean PRINT_CONSISTENTLY = true;
    @NotNull
    private static final Logger LOG = Logger.getInstance(JSEvaluationLogger.class);
    @NotNull
    private static final JSEvaluationLogger DUMMY = new JSEvaluationLogger(){

        @Override
        public void cachedValueUsed(int complexity, Object key, Object value) {
        }

        @Override
        public void startTask(@Nullable Supplier<String> taskName) {
        }

        @Override
        public void finishTask(@Nullable Supplier<String> messageSuffix) {
        }

        @Override
        public void cachingProhibited() {
        }
    };
    @NotNull
    private static final ThreadLocal<JSEvaluationLogger> ourLoggers = ThreadLocal.withInitial(JSEvaluationLogger::new);
    @Nullable
    private JSEvaluationCallNode myCurrentNode = null;

    @NotNull
    public static JSEvaluationLogger getInstance() {
        JSEvaluationLogger jSEvaluationLogger = LOG.isTraceEnabled() ? ourLoggers.get() : DUMMY;
        if (jSEvaluationLogger == null) {
            JSEvaluationLogger.$$$reportNull$$$0(0);
        }
        return jSEvaluationLogger;
    }

    public static void startLogging() {
        ourLoggers.set(new JSEvaluationLogger());
    }

    public static void stopLogging() {
        ourLoggers.set(DUMMY);
    }

    public void cachedValueUsed(int complexity, Object key, Object value) {
        String s = String.format("Cached value for %s used. Complexity %d, Value = %s", key, complexity, JSEvaluationLogger.toPresentable(value));
        JSEvaluationCallNode.addChild(this.myCurrentNode, s);
    }

    public void cachingProhibited() {
        JSEvaluationCallNode.addChild(this.myCurrentNode, "Caching prohibited");
    }

    public void startTask(@Nullable Supplier<String> taskName) {
        String name;
        String string = name = taskName != null ? taskName.get() : null;
        if (name == null) {
            name = "Task";
        }
        this.myCurrentNode = JSEvaluationCallNode.addChild(this.myCurrentNode, name);
    }

    public void finishTask(@Nullable Supplier<String> messageSuffix) {
        String message;
        if (this.myCurrentNode == null) assert (false) : "myCurrentNode is null";
        if (messageSuffix != null && (message = messageSuffix.get()) != null) {
            this.myCurrentNode.myMessage = this.myCurrentNode.myMessage + message;
        }
        JSEvaluationCallNode prevNode = this.myCurrentNode;
        this.myCurrentNode = this.myCurrentNode.myParent;
        if (this.myCurrentNode == null) {
            prevNode.printTree();
        }
    }

    @Nullable
    public static String toPresentable(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ResolveResult[]) {
            return "[" + StringUtil.join((Object[])((ResolveResult[])object), Object::toString, (String)"; ") + "]";
        }
        if (object instanceof PsiElement) {
            return JSEvaluationLogger.psiToPresentable((PsiElement)object);
        }
        return object.toString();
    }

    @Nullable
    private static String psiToPresentable(@Nullable PsiElement psiElement) {
        String location;
        if (psiElement == null) {
            return null;
        }
        Object suffix = "";
        if (psiElement instanceof StubBasedPsiElement && ((StubBasedPsiElement)psiElement).getStub() != null) {
            location = "stub tree";
        } else {
            TextRange textRange;
            String text = psiElement.getText();
            if (text != null) {
                suffix = "(" + StringUtil.trimMiddle((String)text, (int)30) + ")";
            }
            location = (textRange = psiElement.getTextRange()) != null ? textRange.toString() : null;
        }
        return psiElement + (String)suffix + " at " + location;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger", "getInstance"));
    }

    private static class JSEvaluationCallNode {
        private String myMessage;
        private final List<JSEvaluationCallNode> myChildren;
        @Nullable
        private final JSEvaluationCallNode myParent;
        private final long myStartTime;

        private JSEvaluationCallNode(@Nullable JSEvaluationCallNode parent, @NotNull String message) {
            if (message == null) {
                JSEvaluationCallNode.$$$reportNull$$$0(0);
            }
            this.myChildren = new SmartList();
            this.myParent = parent;
            this.myMessage = message;
            this.myStartTime = System.currentTimeMillis();
        }

        @NotNull
        static JSEvaluationCallNode addChild(@Nullable JSEvaluationCallNode parent, @NotNull String message) {
            if (message == null) {
                JSEvaluationCallNode.$$$reportNull$$$0(1);
            }
            JSEvaluationCallNode child = new JSEvaluationCallNode(parent, message);
            if (parent != null) {
                parent.myChildren.add(child);
            }
            JSEvaluationCallNode jSEvaluationCallNode = child;
            if (jSEvaluationCallNode == null) {
                JSEvaluationCallNode.$$$reportNull$$$0(2);
            }
            return jSEvaluationCallNode;
        }

        void printTree() {
            StringBuilder builder = new StringBuilder();
            this.printToBuilder(builder, 0);
            LOG.trace(builder.insert(0, '\n').toString());
        }

        private void printToBuilder(StringBuilder builder, int prefix) {
            builder.append(StringUtil.repeat((String)" ", (int)prefix)).append(this.myMessage.replace('\n', ' ')).append(":\n");
            for (JSEvaluationCallNode child : this.myChildren) {
                child.printToBuilder(builder, prefix + 2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger$JSEvaluationCallNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationLogger$JSEvaluationCallNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChild";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

