/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSEvaluateContext {
    @Nullable
    public final PsiFile targetFile;
    private final boolean myContextualOverloadEvaluation;
    @Nullable
    private final PsiElement source;
    @Nullable
    private final JSReferenceExpression myProcessedExpression;
    private final boolean myStrict;
    private final boolean myAstAccessAllowed;

    public JSEvaluateContext(@Nullable PsiFile targetFile) {
        this(targetFile, false);
    }

    public JSEvaluateContext(@Nullable PsiFile targetFile, boolean contextualOverloadEvaluation) {
        this(targetFile, contextualOverloadEvaluation, null, null, true, true);
    }

    private JSEvaluateContext(@Nullable PsiFile targetFile, boolean contextualOverloadEvaluation, @Nullable PsiElement source, @Nullable JSReferenceExpression processedExpression, boolean isEvaluationStrict, boolean isAstAccessAllowed) {
        this.targetFile = targetFile;
        this.myContextualOverloadEvaluation = contextualOverloadEvaluation;
        this.source = source;
        this.myProcessedExpression = processedExpression;
        this.myStrict = isEvaluationStrict;
        this.myAstAccessAllowed = isAstAccessAllowed;
    }

    @Nullable
    public JSReferenceExpression getProcessedExpression() {
        return this.myProcessedExpression;
    }

    @NotNull
    public JSEvaluateContext withProcessedExpression(@Nullable JSReferenceExpression expression) {
        return new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, this.source, expression, this.myStrict, this.myAstAccessAllowed);
    }

    @Nullable
    public PsiElement getSource() {
        return this.source;
    }

    @NotNull
    public JSEvaluateContext withSource(@Nullable PsiElement source) {
        return new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed);
    }

    public boolean isStrict() {
        return this.myStrict;
    }

    @NotNull
    public JSEvaluateContext withCombinedStrictness(boolean isStrict) {
        JSEvaluateContext jSEvaluateContext = this.myStrict && !isStrict ? new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, false, this.myAstAccessAllowed) : this;
        if (jSEvaluateContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(0);
        }
        return jSEvaluateContext;
    }

    @NotNull
    public JSEvaluateContext combineWith(@NotNull JSEvaluateContext subContext) {
        if (subContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(1);
        }
        return new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, (PsiElement)ObjectUtils.chooseNotNull((Object)subContext.source, (Object)this.source), (JSReferenceExpression)ObjectUtils.chooseNotNull((Object)subContext.myProcessedExpression, (Object)this.myProcessedExpression), this.myStrict && subContext.myStrict, this.myAstAccessAllowed);
    }

    public boolean isAstAccessAllowedInCurrentFile() {
        return this.myAstAccessAllowed;
    }

    public boolean isAstAccessAllowed(@NotNull PsiElement context) {
        if (context == null) {
            JSEvaluateContext.$$$reportNull$$$0(2);
        }
        return this.isAstAccessAllowed(context, false);
    }

    @Deprecated
    public boolean isAstAccessAllowed(@NotNull PsiElement context, boolean allowAccessInNonTargetFile) {
        if (context == null) {
            JSEvaluateContext.$$$reportNull$$$0(3);
        }
        return this.isAstAccessAllowedInCurrentFile() && (allowAccessInNonTargetFile || this.isFromCurrentFile(context));
    }

    public boolean isFromCurrentFile(@NotNull PsiElement element) {
        PsiFile context;
        if (element == null) {
            JSEvaluateContext.$$$reportNull$$$0(4);
        }
        if ((context = this.targetFile) == null) {
            context = this.getProcessedExpression();
        }
        if (context == null) {
            return false;
        }
        PsiFile contextOriginalFile = context.getContainingFile().getOriginalFile();
        PsiFile elementFile = element.getContainingFile();
        if (elementFile == null) {
            return false;
        }
        return contextOriginalFile.isEquivalentTo((PsiElement)elementFile.getOriginalFile());
    }

    @NotNull
    public JSEvaluateContext withAstAccessForbidden() {
        JSEvaluateContext jSEvaluateContext = this.myAstAccessAllowed ? new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, false) : this;
        if (jSEvaluateContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(5);
        }
        return jSEvaluateContext;
    }

    public boolean isContextualOverloadEvaluation() {
        return this.myContextualOverloadEvaluation;
    }

    @NotNull
    public JSExpectedTypeKind getContextualExpectedTypeKind() {
        JSExpectedTypeKind jSExpectedTypeKind = this.isContextualOverloadEvaluation() ? JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS : JSExpectedTypeKind.CONTEXTUAL;
        if (jSExpectedTypeKind == null) {
            JSEvaluateContext.$$$reportNull$$$0(6);
        }
        return jSExpectedTypeKind;
    }

    @NotNull
    public JSEvaluateContext withTargetFile(@Nullable PsiFile file2) {
        return new JSEvaluateContext(file2, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSEvaluateContext context = (JSEvaluateContext)o;
        return this.myContextualOverloadEvaluation == context.myContextualOverloadEvaluation && this.myStrict == context.myStrict && this.myAstAccessAllowed == context.myAstAccessAllowed && Objects.equals(this.targetFile, context.targetFile) && Objects.equals(this.source, context.source) && Objects.equals(this.myProcessedExpression, context.myProcessedExpression);
    }

    public int hashCode() {
        return Objects.hash(this.targetFile, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withCombinedStrictness";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withAstAccessForbidden";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextualExpectedTypeKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "combineWith";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAstAccessAllowed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFromCurrentFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

