/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSCachingNamespaceOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSFunctionNodesVisitor;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReturnedExpressionType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionBaseImpl<T extends JSFunctionStubBase<?>>
extends JSQualifiedNamedElementBaseImpl<T>
implements JSFunction,
JSCachingNamespaceOwner,
StubBasedPsiElement<T> {
    static final int OPTIONAL_STATUS = 1;
    private static final int REST_PARAMETER = 2;
    private String name;
    private static final Key<ParameterizedCachedValue<JSVariable, JSFunctionBaseImpl<?>>> ARGUMENTS_VAR_KEY = Key.create((String)"js.arguments.var");
    private static final ParameterizedCachedValueProvider<JSVariable, JSFunctionBaseImpl<?>> ARGUMENTS_VAR_PROVIDER = fun -> {
        String type = fun.getArgumentsClassName();
        JSParameterList parameterList = fun.getParameterList();
        ImplicitJSVariableImpl argumentsVar = new ImplicitJSVariableImpl("arguments", type, (PsiElement)(parameterList != null ? parameterList : fun));
        return CachedValueProvider.Result.create((Object)((Object)argumentsVar), (Object[])new Object[]{fun});
    };
    private static final Key<ParameterizedCachedValue<JSFunctionCachedData, JSFunctionBaseImpl<?>>> DATA_KEY = Key.create((String)"js.function.base.cached.data");
    private static final ParameterizedCachedValueProvider<JSFunctionCachedData, JSFunctionBaseImpl<?>> DATA_PROVIDER = psi -> {
        JSFunctionCachedData value = psi.initCachedData();
        return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{psi.getContainingFile()});
    };
    private static final Key<ParameterizedCachedValue<JSType, JSFunctionBaseImpl<?>>> TYPE_KEY = Key.create((String)"js.function.base.type");
    private static final ParameterizedCachedValueProvider<JSType, JSFunctionBaseImpl<?>> TYPE_PROVIDER = new ParameterizedCachedValueProvider<JSType, JSFunctionBaseImpl<?>>(){

        @NotNull
        public CachedValueProvider.Result<JSType> compute(JSFunctionBaseImpl<?> psi) {
            CachedValueProvider.Result<JSType> result2 = this.captureCompute(psi);
            if (result2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private <StubT extends JSFunctionStubBase<?>> CachedValueProvider.Result<JSType> captureCompute(JSFunctionBaseImpl<StubT> psi) {
            PsiElement element;
            JSFunctionStubBase stub = (JSFunctionStubBase)psi.getGreenStub();
            JSType returnType = stub != null ? psi.doGetStubReturnType(stub) : ((element = psi.getReturnTypeElement()) != null ? JSPsiImplUtils.getTypeFromElement(element, psi) : psi.getCachedData().returnTypeToSerialize);
            return CachedValueProvider.Result.create((Object)returnType, (Object[])new Object[]{psi});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$2", "compute"));
        }
    };

    public JSFunctionBaseImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionBaseImpl(T stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.name = null;
        JSParameterList parameterList = this.getParameterList();
        if (parameterList != null) {
            for (JSParameter p : parameterList.getParameterVariables()) {
                ((JSParameterImpl)p).clearCaches();
            }
        }
    }

    @Nullable
    public JSBlockStatement getBlock() {
        ASTNode[] blocks = this.getNode().getChildren(JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS);
        return blocks.length == 1 ? (JSBlockStatement)ObjectUtils.tryCast((Object)blocks[0].getPsi(), JSBlockStatement.class) : null;
    }

    public JSParameterList getParameterList() {
        return (JSParameterList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.PARAMETER_LIST);
    }

    public String getReturnTypeString() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getReturnTypeString();
        }
        return JSTypeUtils.serializeType(this.getCachedData().returnTypeToSerialize);
    }

    public PsiElement getReturnTypeElement() {
        return JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(0);
        }
        if (JSVariableBaseImpl.setComputedPropertyName(name, (PsiElement)this)) {
            return this;
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            ASTNode newNameElement = JSChangeUtil.createPropertyNameWithContext(name, nameIdentifier);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, newNameElement);
        }
        this.name = null;
        return this;
    }

    protected boolean canHaveAccessorKeywordAfterFunctionName() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this);
        return holder != null && holder.hasFeature(JSLanguageFeature.E4X);
    }

    public boolean isGetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isGetProperty();
        }
        return this.checkIsModifier(JSAttributeList.ModifierType.GET, JSTokenTypes.GET_KEYWORD);
    }

    private boolean checkIsModifier(@NotNull JSAttributeList.ModifierType modifierType, @NotNull IElementType elementType) {
        JSAttributeList attributeList;
        if (modifierType == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(2);
        }
        if ((attributeList = this.getAttributeList()) != null && attributeList.hasModifier(modifierType)) {
            return true;
        }
        if (!this.canHaveAccessorKeywordAfterFunctionName()) {
            return false;
        }
        ASTNode node = this.getNode().findChildByType(elementType);
        return node != null && node != this.findNameIdentifier();
    }

    public boolean isSetProperty() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isSetProperty();
        }
        return this.checkIsModifier(JSAttributeList.ModifierType.SET, JSTokenTypes.SET_KEYWORD);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.doGetName();
        }
        return this.name;
    }

    protected String doGetName() {
        String nameFromComputed;
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)this).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        ASTNode name = this.findNameIdentifier();
        boolean computed = false;
        if (name == null) {
            name = JSPsiImplUtils.getComputedNameOfFunction(this.getNode(), false);
            computed = true;
        }
        if (name != null) {
            if (computed) {
                PsiElement psi = name.getPsi();
                if (psi instanceof ES6ComputedName) {
                    return ((ES6ComputedName)psi).getExpressionAsPropertyName();
                }
                return JSPsiImplUtils.getNameFromIdentifier(name);
            }
            return JSPsiImplUtils.getNameFromIdentifier(name);
        }
        return null;
    }

    public ASTNode findNameIdentifier() {
        return JSPsiImplUtils.findNameIdentifierOfFunction(this.getNode());
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions;
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(5);
        }
        if ((funInternalDefsProcessingOptions = JSFunctionBaseImpl.getProcessingOptions(processor)).toProcessFunctionBodyDeclarations(lastParent, this)) {
            return this.processInnerAndBodyDeclarations(processor, state, lastParent, place, funInternalDefsProcessingOptions);
        }
        return this.processOuterDeclarations(processor, state, place);
    }

    protected boolean processOuterDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(6);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(7);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(8);
        }
        processor.handleEvent(ResolveProcessor.SCOPE_CHANGE, (Object)this);
        return processor.execute((PsiElement)this, state);
    }

    protected boolean processInnerAndBodyDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions) {
        boolean result2;
        boolean b;
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(11);
        }
        if (place instanceof JSReferenceExpression && (!(b = JSImportHandlingUtil.tryResolveImports(processor, (PsiNamedElement)this, place)) || JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place))) {
            return b;
        }
        if (funInternalDefsProcessingOptions.toProcessFunctionArguments()) {
            JSParameterList parameterList = this.getParameterList();
            if (!this.processArguments(parameterList, processor, state, lastParent, place)) {
                return false;
            }
            if (!this.processImplicitArguments(processor, state)) {
                return false;
            }
        }
        if (result2 = JSResolveUtil.processDeclarationsInScope(this, processor, state, lastParent, place)) {
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        }
        return result2;
    }

    protected boolean processImplicitArguments(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(13);
        }
        JSVariable argumentsVar = this.getImplicitArgumentsVar();
        return processor.execute((PsiElement)argumentsVar, state);
    }

    @NotNull
    private JSVariable getImplicitArgumentsVar() {
        JSVariable jSVariable = (JSVariable)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, ARGUMENTS_VAR_KEY, ARGUMENTS_VAR_PROVIDER, false, (Object)this);
        if (jSVariable == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(14);
        }
        return jSVariable;
    }

    public boolean processArguments(@Nullable JSParameterList parameterList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(17);
        }
        if (parameterList != null) {
            for (JSParameter param : parameterList.getParameterVariables()) {
                if (param.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    protected static ResolveProcessor.ProcessingOptions getProcessingOptions(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(18);
        }
        ResolveProcessor.ProcessingOptions funInternalDefsProcessingOptions = processor instanceof ResolveProcessor ? ((ResolveProcessor)processor).getProcessingOptions() : ResolveProcessor.DEFAULT_RESOLVE;
        return funInternalDefsProcessingOptions;
    }

    protected String getArgumentsClassName() {
        return "IArguments";
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(19);
        }
        if (anchor == this.getFirstChild() && element instanceof JSAttributeList && anchor.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD) {
            return JSChangeUtil.doDoAddBefore((PsiElement)this, element, anchor);
        }
        return super.addBefore(element, anchor);
    }

    @NotNull
    public JSFunction.FunctionKind getKind() {
        if (this.isGetProperty()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.GETTER;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(20);
            }
            return functionKind;
        }
        if (this.isSetProperty()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.SETTER;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(21);
            }
            return functionKind;
        }
        if (this.isConstructor()) {
            JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.CONSTRUCTOR;
            if (functionKind == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(22);
            }
            return functionKind;
        }
        JSFunction.FunctionKind functionKind = JSFunction.FunctionKind.SIMPLE;
        if (functionKind == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(23);
        }
        return functionKind;
    }

    @Override
    public boolean isDeprecated() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        if (ActionScriptPsiImplUtil.isDeprecatedFromAttribute((JSAttributeListOwner)this)) {
            return true;
        }
        return JSDocumentationUtils.calculateDeprecated((PsiElement)this);
    }

    public boolean isReferencesArguments() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isReferencesArguments();
        }
        return this.getCachedData().referencesArguments;
    }

    public boolean constructorCanBeInvokedWithoutNew() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.constructorCanBeInvokedWithoutNew();
        }
        return this.getCachedData().constructorCanBeInvokedWithoutNew;
    }

    public boolean isReferencesThis() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isReferencesThis();
        }
        return this.getCachedData().referencesThis;
    }

    public JSParameterListElement @NotNull [] getParameters() {
        JSParameterList parameterList = this.getParameterList();
        Object[] objectArray = parameterList != null ? parameterList.getParameters() : JSParameter.EMPTY_ARRAY;
        if (objectArray == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(24);
        }
        return objectArray;
    }

    public JSParameter @NotNull [] getParameterVariables() {
        JSParameterList parameterList = this.getParameterList();
        JSParameter[] jSParameterArray = parameterList != null ? parameterList.getParameterVariables() : JSParameter.EMPTY_ARRAY;
        if (jSParameterArray == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(25);
        }
        return jSParameterArray;
    }

    @NotNull
    protected JSFunctionCachedData initCachedData() {
        JSType evaluated;
        JSFunctionCachedData cachedData = new JSFunctionCachedData();
        ArrayList<JSFunction> nestedFuns = new ArrayList<JSFunction>(2);
        TObjectIntHashMap declaredParameters = new TObjectIntHashMap(2);
        JSFunctionNodesVisitor cachedDataEvaluator = this.createCachingVisitor(cachedData, nestedFuns);
        cachedDataEvaluator.visitElement(this.getNode());
        cachedDataEvaluator.summarizeNamesUsages((TObjectIntHashMap<String>)declaredParameters);
        JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(this);
        if (expression != null) {
            cachedDataEvaluator.appendReturnType(expression.getNode(), expression);
        }
        for (JSFunction f : nestedFuns) {
            JSParameter[] fun = (JSParameter[])f;
            for (Map.Entry<String, EnumSet<JSFunctionCachedData.ReferenceStatus>> entry : fun.getCachedData().referencedVariableNames.entrySet()) {
                String name = entry.getKey();
                EnumSet<JSFunctionCachedData.ReferenceStatus> status = entry.getValue();
                if (cachedData.declaredParameters.contains(name) && !cachedData.declaredVariableNames.contains(name) && status.contains((Object)JSFunctionCachedData.ReferenceStatus.Optional)) {
                    declaredParameters.put((Object)name, 1);
                    continue;
                }
                if (cachedData.declaredVariableNames.contains(name)) continue;
                EnumSet<JSFunctionCachedData.ReferenceStatus> baseStatus = cachedData.referencedVariableNames.get(name);
                if (baseStatus == null) {
                    baseStatus = EnumSet.noneOf(JSFunctionCachedData.ReferenceStatus.class);
                    cachedData.referencedVariableNames.put(name, baseStatus);
                }
                baseStatus.addAll(status);
            }
        }
        this.fillInfoFromDocComment(cachedData);
        PsiElement element = this.getReturnTypeElement();
        boolean hasExplicitType = false;
        if (element != null) {
            hasExplicitType = true;
            if (DialectDetector.isActionScript((PsiElement)this)) {
                cachedData.returnTypeToSerialize = JSPsiImplUtils.getTypeFromElement(element, this);
            }
        }
        for (JSParameter p : this.getParameterVariables()) {
            JSParameterTypeDecorator parameterType;
            boolean explicitlyDeclared;
            boolean optional;
            JSType type;
            String parameterName = p.getName();
            if (parameterName == null) continue;
            JSParameterTypeDecorator typeDecorator = this.getParameterTypeDecorator(cachedData, (JSParameterItem)p);
            JSType jSType = type = typeDecorator != null ? typeDecorator.getSimpleType() : null;
            boolean bl = typeDecorator != null ? typeDecorator.isOptional() : (optional = (declaredParameters.get((Object)parameterName) & 1) != 0);
            boolean rest = typeDecorator != null ? typeDecorator.isRest() : (declaredParameters.get((Object)parameterName) & 2) != 0;
            boolean bl2 = explicitlyDeclared = typeDecorator != null && typeDecorator.isExplicitlyDeclared();
            if (type == null && (parameterType = JSDocumentationUtils.getParameterTypeFromPrecedingComment(p)) != null) {
                type = parameterType.getSimpleType();
                optional = parameterType.isOptional();
                rest = parameterType.isRest();
                explicitlyDeclared = true;
            }
            if (type != null) {
                type = JSTypeBaseImpl.replaceEmptySourceRecursive(type, JSTypeSourceFactory.createTypeSource((PsiElement)p, true));
            }
            if (type == null && !optional && !rest) continue;
            cachedData.parameterTypes.put(parameterName, new JSParameterTypeDecoratorImpl(parameterName, type, optional, rest, explicitlyDeclared));
        }
        if (!cachedData.declaredVariableNames.contains("arguments") && cachedData.referencedVariableNames.containsKey("arguments")) {
            cachedData.referencesArguments = true;
            cachedData.referencedVariableNames.remove("arguments");
        }
        if (cachedData.returnTypeToSerialize == null && !hasExplicitType) {
            cachedData.returnTypeToSerialize = JSDocumentationUtils.getTypeFromReturnTypeComment(this);
        }
        JSType declaredType = cachedData.returnTypeToSerialize;
        if (!hasExplicitType && JSFunctionBaseImpl.useEvaluatedTypeInsteadOfDeclared(declaredType) && (evaluated = cachedDataEvaluator.getReturnTypeFromEvaluated()) != null) {
            cachedData.returnTypeToSerialize = evaluated;
        }
        JSFunctionCachedData jSFunctionCachedData = cachedData;
        if (jSFunctionCachedData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(26);
        }
        return jSFunctionCachedData;
    }

    private static boolean useEvaluatedTypeInsteadOfDeclared(@Nullable JSType declaredType) {
        if (declaredType == null) {
            return true;
        }
        if (!(declaredType.getSourceElement() instanceof JSDocComment)) {
            return false;
        }
        return declaredType instanceof JSObjectType || declaredType instanceof JSPrimitiveFunctionType;
    }

    @NotNull
    protected JSFunctionNodesVisitor createCachingVisitor(JSFunctionCachedData cachedData, List<JSFunction> nestedFuns) {
        return new JSFunctionNodesVisitor(this, cachedData, nestedFuns){
            private int myVisitedReturnedExpressions;
            {
                this.myVisitedReturnedExpressions = 0;
            }

            @Override
            @NotNull
            protected JSType getTypeFromReturnedExpression(@NotNull ASTNode context, @Nullable JSExpression expression) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((expression = JSUtils.unparenthesize(expression)) != null && JSReturnedExpressionType.isCountableReturnedExpression(expression)) {
                    ++this.myVisitedReturnedExpressions;
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)JSFunctionBaseImpl.this, true);
                    return new JSReturnedExpressionType(this.myVisitedReturnedExpressions - 1, typeSource);
                }
                if (expression == null) {
                    return new JSVoidType(JSTypeSourceFactory.createTypeSource(context.getPsi(), true));
                }
                JSType type = super.getTypeFromReturnedExpression(context, expression);
                Object object = type != null ? type : JSAnyType.get(context.getPsi(), false);
                if (object == null) {
                    1.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeFromReturnedExpression";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeFromReturnedExpression";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    protected JSFunctionCachedData getCachedData() {
        JSFunctionCachedData jSFunctionCachedData = (JSFunctionCachedData)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, DATA_KEY, DATA_PROVIDER, false, (Object)this);
        if (jSFunctionCachedData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(27);
        }
        return jSFunctionCachedData;
    }

    public void addReferencedExternalNames(Set<String> names) {
        names.addAll(this.getCachedData().referencedVariableNames.keySet());
    }

    public void addWrittenExternalNames(Set<String> names) {
        for (Map.Entry<String, EnumSet<JSFunctionCachedData.ReferenceStatus>> entry : this.getCachedData().referencedVariableNames.entrySet()) {
            if (!entry.getValue().contains((Object)JSFunctionCachedData.ReferenceStatus.Write)) continue;
            names.add(entry.getKey());
        }
    }

    protected boolean seemsToBePropertyAccessor() {
        if (this.isGetProperty() || this.isSetProperty()) {
            return true;
        }
        String name = this.getName();
        return name != null && (name.startsWith("get") || name.startsWith("set"));
    }

    protected void fillInfoFromDocComment(@NotNull JSFunctionCachedData cachedFunctionData) {
        JSType typeFromTrailingComment;
        PsiElement docComment;
        if (cachedFunctionData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(28);
        }
        if ((docComment = this.findFunctionOrPropertyDocComment()) != null) {
            JSTypeSource functionTypeSource = JSTypeSourceFactory.createTypeSource(docComment, true);
            MyJSDocumentationProcessor processor = new MyJSDocumentationProcessor(cachedFunctionData, functionTypeSource, !(this instanceof JSExpression));
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), processor);
        }
        if ((typeFromTrailingComment = JSDocumentationUtils.getTypeFromTrailingComment(this)) != null && cachedFunctionData.returnTypeToSerialize == null) {
            cachedFunctionData.returnTypeToSerialize = typeFromTrailingComment;
        }
    }

    private JSType getReturnTypeFromDeclaration(boolean stubSafe) {
        if (stubSafe && DialectDetector.isActionScript((PsiElement)this)) {
            return null;
        }
        PsiElement typeElement = this.getReturnTypeElement();
        return JSPsiImplUtils.getTypeFromElement(typeElement, this);
    }

    private PsiElement findFunctionOrPropertyDocComment() {
        PsiComment docComment = JSDocumentationUtils.findFunctionComment(this);
        if (docComment == null && this.seemsToBePropertyAccessor()) {
            JSExpression rOperand;
            JSExpression expression;
            JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)this, JSStatement.class);
            JSStatement prevStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, JSStatement.class);
            JSFunctionBaseImpl prevFunction = null;
            if (prevStatement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)prevStatement).getExpression()) instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)expression).getROperand()) instanceof JSFunctionBaseImpl) {
                prevFunction = (JSFunctionBaseImpl)rOperand;
            }
            if (prevFunction != null && prevFunction.seemsToBePropertyAccessor()) {
                docComment = JSDocumentationUtils.findFunctionComment(prevFunction);
            }
        }
        return docComment;
    }

    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getCachedData().hasConstructorTag;
    }

    public boolean isOverride() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isOverride();
        }
        return this.getCachedData().overrides;
    }

    public boolean isOptional(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getParameterTypeDecorator(this.getCachedData(), (JSParameterItem)parameter);
        return decorator != null && decorator.isOptional();
    }

    public boolean isRest(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getParameterTypeDecorator(this.getCachedData(), (JSParameterItem)parameter);
        return decorator != null && decorator.isRest();
    }

    public boolean isTypeExplicitlyDeclared(JSParameter parameter) {
        JSParameterTypeDecorator decorator = this.getParameterTypeDecorator(this.getCachedData(), (JSParameterItem)parameter);
        return decorator != null && decorator.isExplicitlyDeclared();
    }

    @Nullable
    private JSParameterTypeDecorator getParameterTypeDecorator(@NotNull JSFunctionCachedData cachedData, @NotNull JSParameterItem parameterItem) {
        if (cachedData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(29);
        }
        if (parameterItem == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(30);
        }
        if (parameterItem instanceof JSParameter) {
            JSParameterTypeDecorator decorator;
            JSParameter jsParameter = (JSParameter)parameterItem;
            String name = jsParameter.getName();
            JSParameterTypeDecorator jSParameterTypeDecorator = decorator = name != null ? cachedData.parameterTypes.get(jsParameter.getName()) : null;
            if (decorator != null) {
                return decorator;
            }
            if (JSDestructuringUtil.isDestructuring(jsParameter.getParent())) {
                JSParameterTypeDecorator appliedContext;
                JSParameterTypeDecorator dummyTypeDecorator;
                JSDestructuringContext destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)jsParameter, JSDestructuringParameter.class::isInstance);
                JSDestructuringParameter destructuringParameter = (JSDestructuringParameter)destructuringContext.getOuterElement();
                if (destructuringParameter != null && (dummyTypeDecorator = this.getDestructuringParameterTypeDecorator(cachedData, destructuringParameter)) != null && (appliedContext = destructuringContext.applyToOuterParameterTypeDecorator(dummyTypeDecorator)).getSimpleType() != null) {
                    return appliedContext;
                }
            }
        } else if (parameterItem instanceof JSDestructuringParameter) {
            return this.getDestructuringParameterTypeDecorator(cachedData, (JSDestructuringParameter)parameterItem);
        }
        return null;
    }

    @Nullable
    private JSParameterTypeDecorator getDestructuringParameterTypeDecorator(@NotNull JSFunctionCachedData cachedData, @NotNull JSDestructuringParameter destructuringParameter) {
        PsiElement comment;
        if (cachedData == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(31);
        }
        if (destructuringParameter == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(32);
        }
        if (!((comment = this.findFunctionOrPropertyDocComment()) instanceof JSDocComment)) {
            return null;
        }
        JSDocComment docComment = (JSDocComment)comment;
        HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
        JSDocumentationUtils.JSTagToParameterMap tagToParameterMap = JSDocumentationUtils.getTagToParameterMap(docComment, this, tagNames);
        int tagIndex = tagToParameterMap.getTagForParameter((JSParameterListElement)destructuringParameter);
        if (tagIndex >= 0) {
            String dummyName = (String)tagNames.get(tagIndex);
            return cachedData.parameterTypes.get(dummyName);
        }
        return null;
    }

    @Nullable
    public JSType getTypeFromComments(@NotNull JSParameterItem jsParameter) {
        JSParameterTypeDecorator decorator;
        if (jsParameter == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(33);
        }
        return (decorator = this.getParameterTypeDecorator(this.getCachedData(), jsParameter)) != null ? decorator.getSimpleType() : null;
    }

    protected static boolean isInJS(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return parent == null || parent.getElementType().getLanguage() instanceof JavascriptLanguage;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public JSType getReturnType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_KEY, TYPE_PROVIDER, false, (Object)this);
    }

    protected JSType doGetStubReturnType(@NotNull T stub) {
        JSDocComment docComment;
        JSType typeFromDeclaration;
        if (stub == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(34);
        }
        if ((typeFromDeclaration = this.getReturnTypeFromDeclaration(true)) != null) {
            return typeFromDeclaration;
        }
        String returnTypeString = stub.getReturnTypeString();
        if (returnTypeString == null) {
            return null;
        }
        JSFunctionBaseImpl sourceElement = this;
        if (stub.isReturnTypeFromJSDoc() && (docComment = JSStubBasedPsiTreeUtil.findOwnDocComment((PsiElement)this)) != null) {
            sourceElement = docComment;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, stub.isReturnTypeStrict());
        return JSTypeUtils.parseSerializedType(returnTypeString, source);
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(35);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(36);
        }
        return accessType;
    }

    public boolean isAnonymousFunctionCall() {
        return false;
    }

    @NotNull
    public JSContext getJSContext() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(37);
            }
            return jSContext;
        }
        JSContext jSContext = JSSymbolUtil.getContext(this, this.useTypesFromJSDoc());
        if (jSContext == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(38);
        }
        return jSContext;
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return JSUtils.getAttributeList(this);
    }

    public boolean isGenerator() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isGenerator();
        }
        JSAttributeList list2 = this.getAttributeList();
        if (list2 != null && list2.hasModifier(JSAttributeList.ModifierType.GENERATOR)) {
            return true;
        }
        return this.getNode().findChildByType(JSTokenTypes.MULT) != null;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            JSElementBase.ClassOrInterface classOrInterface = stub.isClassOrInterface();
            if (classOrInterface == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(39);
            }
            return classOrInterface;
        }
        if (this.getParent() instanceof JSClass) {
            JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
            if (classOrInterface == null) {
                JSFunctionBaseImpl.$$$reportNull$$$0(40);
            }
            return classOrInterface;
        }
        JSElementBase.ClassOrInterface classOrInterface = super.isClassOrInterface();
        JSElementBase.ClassOrInterface classOrInterface2 = classOrInterface != JSElementBase.ClassOrInterface.NONE ? classOrInterface : (this.isConstructor() ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface2 == null) {
            JSFunctionBaseImpl.$$$reportNull$$$0(41);
        }
        return classOrInterface2;
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return true;
    }

    public boolean isArrowFunction() {
        return false;
    }

    public boolean isShorthandArrowFunction() {
        return false;
    }

    public boolean hasExplicitlyDeclaredReturnType() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasExplicitlyDeclaredReturnType();
        }
        PsiElement element = this.getReturnTypeElement();
        if (element != null) {
            return true;
        }
        JSType returnType = this.getReturnType();
        if (returnType == null) {
            return false;
        }
        PsiElement sourceElement = returnType.getSource().getSourceElement();
        return sourceElement instanceof PsiComment || sourceElement instanceof JSTypeDeclaration || returnType.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedFunctionData";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterItem";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringParameter";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsParameter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitArgumentsVar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterVariables";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "initCachedData";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedData";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkIsModifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processOuterDeclarations";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processInnerAndBodyDeclarations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitArguments";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processArguments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProcessingOptions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fillInfoFromDocComment";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeDecorator";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDestructuringParameterTypeDecorator";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromComments";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doGetStubReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyJSDocumentationProcessor
    implements JSDocumentationProcessor {
        @NotNull
        private final Set<JSQualifiedName> myOptionalParameters;
        @NotNull
        private final Map<String, JSParameterTypeDecorator> myParameterTypes;
        @NotNull
        private final Map<JSQualifiedName, String> myParameterProperties;
        @NotNull
        private final JSTypeSource myFunctionTypeSource;
        @NotNull
        private final JSFunctionCachedData myCachedFunctionData;
        @Nullable
        private String lastParameterName;
        @Nullable
        private @Nullable Map<@NotNull String, @Nullable String> genericParameters;
        private boolean parametersAreOptional;
        private boolean docCommentHasOverrides;
        private final boolean treatTypeAsReturnType;

        MyJSDocumentationProcessor(@NotNull JSFunctionCachedData cachedFunctionData, @NotNull JSTypeSource functionTypeSource, boolean treatTypeAsReturnType) {
            if (cachedFunctionData == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(0);
            }
            if (functionTypeSource == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(1);
            }
            this.myOptionalParameters = new THashSet();
            this.myCachedFunctionData = cachedFunctionData;
            this.myFunctionTypeSource = functionTypeSource;
            this.myParameterTypes = new LinkedHashMap<String, JSParameterTypeDecorator>();
            this.myParameterProperties = new LinkedHashMap<JSQualifiedName, String>();
            this.treatTypeAsReturnType = treatTypeAsReturnType;
        }

        @Override
        public boolean needsPlainCommentData() {
            return false;
        }

        @Override
        public boolean onCommentLine(@NotNull String line) {
            if (line == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
            if (type == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(3);
            }
            if (line == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(4);
            }
            if (patternMatched == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(5);
            }
            if (type == JSDocumentationProcessor.MetaDocType.PARAMETER && matchName != null) {
                this.registerParameter(matchName, matchValue);
                this.lastParameterName = matchName;
            } else if (type == JSDocumentationProcessor.MetaDocType.OVERRIDE || type == JSDocumentationProcessor.MetaDocType.INHERIT_DOC) {
                this.docCommentHasOverrides = true;
            } else if (type == JSDocumentationProcessor.MetaDocType.FIELD) {
                if (matchName != null) {
                    this.registerParameter(matchName, matchValue);
                }
            } else if (type == JSDocumentationProcessor.MetaDocType.TEMPLATE && matchName != null) {
                List generics = StringUtil.split((String)matchName, (String)",");
                if (this.genericParameters == null) {
                    this.genericParameters = new HashMap<String, String>();
                }
                for (String generic : generics) {
                    this.genericParameters.put(generic.trim(), matchValue);
                }
            }
            if (type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS || type == JSDocumentationProcessor.MetaDocType.PARAMETER) {
                String optionalParameterName = matchName != null && matchValue == null ? matchName : this.lastParameterName;
                JSParameterTypeDecorator parameterType = JSTypeUtils.createParameterType(matchValue, this.myFunctionTypeSource);
                boolean parameterIsOptional = type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && (matchName == null || matchName.indexOf(46) == -1) || type == JSDocumentationProcessor.MetaDocType.PARAMETER && parameterType != null && parameterType.isOptional();
                this.parametersAreOptional |= type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && matchName == null;
                if ((parameterIsOptional || this.parametersAreOptional) && optionalParameterName != null) {
                    this.myOptionalParameters.add(JSQualifiedNameImpl.fromQualifiedName(optionalParameterName));
                }
                if (type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && matchName != null && matchName.indexOf(46) >= 0) {
                    this.makeFieldOptional(matchName);
                }
            } else {
                this.processFunctionLevelDocTag(type, matchValue, this.myCachedFunctionData, this.myFunctionTypeSource);
            }
            return true;
        }

        private void registerParameter(@NotNull String matchName, @Nullable String matchValue) {
            if (matchName == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(6);
            }
            JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName(matchName);
            JSParameterTypeDecorator parameterType = JSTypeUtils.createParameterType(matchValue, this.myFunctionTypeSource, false, true);
            if (parameterType != null && parameterType.isOptional()) {
                this.myOptionalParameters.add(qName);
            }
            if (qName.getParent() == null) {
                String name = qName.getName();
                JSParameterTypeDecorator oldType = this.myParameterTypes.get(name);
                JSParameterTypeDecorator newType = JSTypeUtils.createParameterType(matchValue, this.myFunctionTypeSource, false, true);
                if (oldType == null || oldType.getSimpleType() == null && newType != null && newType.getSimpleType() != null) {
                    this.myParameterTypes.put(name, newType);
                } else if (newType != null) {
                    JSType composite = oldType.getSimpleType() == null ? newType.getSimpleType() : (newType.getSimpleType() == null ? oldType.getSimpleType() : JSCompositeTypeFactory.createUnionType(this.myFunctionTypeSource, oldType.getSimpleType(), newType.getSimpleType()));
                    JSParameterTypeDecoratorImpl newDecorator = new JSParameterTypeDecoratorImpl(composite, oldType.isOptional() || newType.isOptional(), oldType.isRest() || newType.isRest(), true);
                    this.myParameterTypes.put(matchName, newDecorator);
                }
            } else {
                this.myParameterProperties.put(qName, matchValue);
            }
        }

        private void makeFieldOptional(@NotNull String matchName) {
            if (matchName == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(7);
            }
            this.myOptionalParameters.add(JSQualifiedNameImpl.fromQualifiedName(matchName));
        }

        @Override
        public void postProcess() {
            this.myCachedFunctionData.overrides = this.docCommentHasOverrides;
            THashSet declaredParameters = new THashSet();
            LinkedHashMap<String, JSType> evaluatedTypes = new LinkedHashMap<String, JSType>();
            THashSet restParameters = new THashSet();
            for (Map.Entry<String, JSParameterTypeDecorator> entry : this.myParameterTypes.entrySet()) {
                JSParameterTypeDecorator parameterType = entry.getValue();
                if (parameterType == null) continue;
                evaluatedTypes.put(entry.getKey(), parameterType.getSimpleType());
                if (parameterType.isOptional()) {
                    this.myOptionalParameters.add(JSQualifiedNameImpl.create((String)entry.getKey(), null));
                }
                if (!parameterType.isRest()) continue;
                restParameters.add((String)entry.getKey());
            }
            if (!this.myParameterProperties.isEmpty()) {
                JSRecordType dummyType = JSTypeUtils.buildRecordTypeFromProperties(this.myParameterProperties, this.myOptionalParameters, this.myFunctionTypeSource);
                assert (dummyType != null);
                for (JSRecordType.TypeMember typeMember : dummyType.getTypeMembers()) {
                    assert (typeMember instanceof JSRecordType.PropertySignature);
                    String name = ((JSRecordType.PropertySignature)typeMember).getMemberName();
                    JSType rawType = (JSType)evaluatedTypes.get(name);
                    JSType propertyType = ((JSRecordType.PropertySignature)typeMember).getJSType();
                    Ref objectReplaced = Ref.create((Object)false);
                    if (rawType != null && propertyType != null) {
                        JSType typeWithObjectReplaced = JSTypeUtils.applyCompositeMapping(rawType, (Function<? super JSType, ? extends JSType>)((Function)type -> {
                            if (type instanceof JSObjectType && !((Boolean)objectReplaced.get()).booleanValue()) {
                                objectReplaced.set((Object)true);
                                return propertyType;
                            }
                            return type;
                        }));
                        if (((Boolean)objectReplaced.get()).booleanValue()) {
                            evaluatedTypes.put(name, typeWithObjectReplaced);
                        }
                    } else if (rawType == null && propertyType != null) {
                        evaluatedTypes.put(name, propertyType);
                        objectReplaced.set((Object)true);
                    }
                    if (((Boolean)objectReplaced.get()).booleanValue() || rawType == null || propertyType == null) continue;
                    JSType compositeType = JSCompositeTypeFactory.createUnionType(this.myFunctionTypeSource, rawType, propertyType);
                    evaluatedTypes.put(name, compositeType);
                }
            }
            declaredParameters.addAll(evaluatedTypes.keySet());
            for (JSQualifiedName optionalParameter : this.myOptionalParameters) {
                if (optionalParameter.getParent() != null) continue;
                declaredParameters.add((Object)optionalParameter.getName());
            }
            this.addGenericParameters(evaluatedTypes);
            for (String parameter : declaredParameters) {
                JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl((JSType)evaluatedTypes.get(parameter), this.myOptionalParameters.contains(JSQualifiedNameImpl.fromQualifiedName(parameter)), restParameters.contains(parameter), true);
                this.myCachedFunctionData.parameterTypes.put(parameter, decorator);
            }
        }

        private void addGenericParameters(@NotNull Map<String, JSType> types2) {
            if (types2 == null) {
                MyJSDocumentationProcessor.$$$reportNull$$$0(8);
            }
            if (this.genericParameters == null) {
                return;
            }
            for (Map.Entry<String, JSType> entry : types2.entrySet()) {
                JSType type = entry.getValue();
                if (type == null || this.genericParameters.isEmpty()) continue;
                entry.setValue(JSTypeUtils.addJSGenericParameters(type, this.genericParameters));
            }
            if (this.myCachedFunctionData.returnTypeToSerialize != null && !this.genericParameters.isEmpty()) {
                this.myCachedFunctionData.returnTypeToSerialize = JSTypeUtils.addJSGenericParameters(this.myCachedFunctionData.returnTypeToSerialize, this.genericParameters);
            }
        }

        private void processFunctionLevelDocTag(JSDocumentationProcessor.MetaDocType type, String matchValue, JSFunctionCachedData cachedFunctionData, JSTypeSource typeSource) {
            if (type == JSDocumentationProcessor.MetaDocType.RETURN) {
                cachedFunctionData.returnTypeToSerialize = JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource);
            } else if (type == JSDocumentationProcessor.MetaDocType.TYPE) {
                JSType jsType = JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource);
                if (jsType != null) {
                    if (!this.treatTypeAsReturnType) {
                        jsType = new JSApplyCallType(jsType, typeSource);
                    }
                    cachedFunctionData.returnTypeToSerialize = jsType;
                }
            } else if (type == JSDocumentationProcessor.MetaDocType.CONSTRUCTOR || type == JSDocumentationProcessor.MetaDocType.CONSTRUCTS || type == JSDocumentationProcessor.MetaDocType.CLASS || type == JSDocumentationProcessor.MetaDocType.INTERFACE) {
                cachedFunctionData.hasConstructorTag = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedFunctionData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionTypeSource";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternMatched";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFunctionBaseImpl$MyJSDocumentationProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCommentLine";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onPatternMatch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerParameter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeFieldOptional";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGenericParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

