/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSIndexingDataHolder;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSCachingTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JavaScriptTypeHelper;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefinitionExpressionImpl
extends JSQualifiedNamedElementBaseImpl<JSDefinitionExpressionStub>
implements JSDefinitionExpression,
JSCachingTypeOwner,
StubBasedPsiElement<JSDefinitionExpressionStub>,
JSIndexingDataHolder {
    private static final String NULL_NAME = "^null";
    private String myName;
    private static final Key<ParameterizedCachedValue<JSNamespace, JSDefinitionExpressionImpl>> SYMBOL_NAMESPACE_PROVIDER_KEY = Key.create((String)"js.definition.expression.symbol.namespace");
    private static final ParameterizedCachedValueProvider<JSNamespace, JSDefinitionExpressionImpl> SYMBOL_NAMESPACE_PROVIDER = param -> {
        JSNamespace data = param.calculateSymbolNamespace(null);
        return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{param.getContainingFile()});
    };

    public JSDefinitionExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSDefinitionExpressionImpl(@NotNull JSDefinitionExpressionStub stub) {
        if (stub == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
    }

    @Nullable
    public JSExpression getExpression() {
        ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode(this.getNode());
        return expressionNode != null ? (JSExpression)expressionNode.getPsi() : null;
    }

    @Nullable
    public static ASTNode getExpressionNode(@NotNull ASTNode definitionNode) {
        if (definitionNode == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(1);
        }
        return definitionNode.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    @Nullable
    public JSExpression getInitializer() {
        return JSPsiImplUtils.getRightmostOperand(this);
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    public JSExpression getInitializerOrStub() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getStub();
        if (stub != null) {
            if (!stub.keepsInitializerStub()) {
                return null;
            }
            StubElement nextSibling = StubTreeUtil.getNextSibling(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
            while (nextSibling != null) {
                if (nextSibling.getStubType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
                    nextSibling = StubTreeUtil.getNextSibling((StubElement)nextSibling.getChildrenStubs().get(0), JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
                    continue;
                }
                return (JSExpression)nextSibling.getPsi();
            }
            return null;
        }
        return this.getInitializer();
    }

    @Override
    @Nullable
    public JSType calculateType() {
        JSExpression operand;
        boolean isExportsAssignment;
        JSExpression expression = this.getExpression();
        boolean bl = isExportsAssignment = expression instanceof JSReferenceExpression && JSSymbolUtil.isExplicitExportReference((JSReferenceExpression)expression);
        if (!DialectDetector.isJavaScript(this) && !isExportsAssignment) {
            return null;
        }
        if (this.getInitializerOrStub() instanceof JSFunctionItem) {
            return null;
        }
        JSType type = this.doGetTypeFromComment();
        PsiElement parent = this.getParent();
        if (type == null && parent instanceof JSAssignmentExpression && (operand = ((JSAssignmentExpression)parent).getROperand()) != null) {
            JSQualifiedName referenceName;
            JSExpression initializer;
            if (isExportsAssignment && (initializer = this.getInitializer()) instanceof JSReferenceExpression && (referenceName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)initializer))) != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource(this, true);
                for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                    JSType typeFromFramework = handler.getExportsInnerAliasType(referenceName, source);
                    if (typeFromFramework == null) continue;
                    type = typeFromFramework;
                    break;
                }
            }
            if (type == null) {
                type = JavaScriptTypeHelper.getInstance().getTypeForIndexing(operand, this);
            }
            if (type != null && !isExportsAssignment) {
                type = JSTypeUtils.copyWithStrict(type, false);
            }
        }
        return type;
    }

    @Nullable
    public JSType getTypeFromComment() {
        if (this.getInitializerOrStub() instanceof JSFunctionItem) {
            return null;
        }
        return this.doGetTypeFromComment();
    }

    @Nullable
    private JSType doGetTypeFromComment() {
        PsiComment docComment = JSDocumentationUtils.findDocComment(this);
        if (docComment instanceof JSDocComment) {
            String typeString = ((JSDocComment)docComment).getType();
            if (typeString != null) {
                return JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true));
            }
        } else {
            PsiComment scopeComment = JSDocumentationUtils.findScopeComment(this);
            if (scopeComment instanceof JSDocComment) {
                String propertyType;
                Map properties = ((JSDocComment)scopeComment).getProperties();
                String name = this.getName();
                if (properties != null && name != null && (propertyType = (String)properties.get(JSQualifiedNameImpl.create(name, null))) != null) {
                    return JSTypeUtils.createType(propertyType, JSTypeSourceFactory.createTypeSource((PsiElement)scopeComment, true));
                }
            }
        }
        return null;
    }

    @Override
    public void clearCaches() {
        this.myName = null;
    }

    public String getName() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = this.myName;
        if (name == null) {
            JSExpression expression = this.getExpression();
            if (expression instanceof JSReferenceExpression) {
                name = ((JSReferenceExpression)expression).getReferenceName();
            } else if (expression instanceof JSIndexedPropertyAccessExpression) {
                name = JSSymbolUtil.getIndexedPropertyName((JSIndexedPropertyAccessExpression)expression);
            }
            if (name == null) {
                name = NULL_NAME;
            }
            this.myName = name;
        }
        if (name != NULL_NAME && DialectDetector.hasFeature(this, JSLanguageFeature.PRIVATE_SHARP_SYNTAX) && JSUtils.isPrivateFieldSharpAccessContext((PsiElement)this.getExpression())) {
            name = NULL_NAME;
        }
        return name != NULL_NAME ? name : null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        JSExpression expression;
        if (name == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(2);
        }
        if ((expression = this.getExpression()) instanceof JSReferenceExpressionImpl) {
            return ((JSReferenceExpressionImpl)expression).handleElementRenameInternal(name);
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDefinitionExpression((JSDefinitionExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public Icon getIcon(int flags) {
        JSExpression value = this.getInitializerOrStub();
        if (value instanceof JSCallExpression) {
            Collection baseTypes;
            JSElementIndexingData indexingData = ((JSCallExpression)value).getIndexingData();
            Collection collection = baseTypes = indexingData != null ? indexingData.getBaseTypes() : null;
            if (baseTypes != null) {
                return JSIconProvider.getForLanguage(this).getClassIcon();
            }
        }
        Icon baseIcon = value instanceof JSFunction ? JSFunctionImpl.getFunctionBaseIcon((JSFunctionItem)((JSFunction)value)) : (value instanceof JSClassBase ? value.getIcon(flags) : PlatformIcons.FIELD_ICON);
        return JSDefinitionExpressionImpl.getIcon((JSPsiElementBase)this, baseIcon, flags);
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof JSAssignmentExpression) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSStatement) {
                if (grandParent instanceof JSExpressionStatement) {
                    grandParent.delete();
                } else {
                    parent.delete();
                }
                return;
            }
            if (grandParent instanceof JSBinaryExpression) {
                ((JSBinaryExpression)grandParent).getROperand().replace(((JSAssignmentExpression)parent).getROperand());
                return;
            }
            if (grandParent instanceof JSVariable) {
                JSExpression initializerExpression = ((JSVariable)grandParent).getInitializer();
                initializerExpression.replace(((JSAssignmentExpression)parent).getROperand());
                return;
            }
        }
        super.delete();
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getNode() : null;
    }

    public PsiElement getNameIdentifier() {
        JSExpression expression = this.getExpression();
        return expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceNameElement() : null;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return JSPsiImplUtils.getNamespaceFromJSNamespace((JSElementBase)this);
    }

    @NotNull
    private JSNamespace getSymbolNamespace() {
        JSNamespace jSNamespace = (JSNamespace)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, SYMBOL_NAMESPACE_PROVIDER_KEY, SYMBOL_NAMESPACE_PROVIDER, false, (Object)this);
        if (jSNamespace == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(4);
        }
        return jSNamespace;
    }

    @NotNull
    public JSNamespace calculateSymbolNamespace(@Nullable Set<PsiElement> visited) {
        JSContext jsContext;
        boolean namespaceExplicitlyDeclared;
        JSQualifiedName namespace;
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        boolean isDeclaration = true;
        boolean isLocal = false;
        if (stub != null) {
            namespace = stub.getNamespace();
            namespaceExplicitlyDeclared = stub.isNamespaceExplicitlyDeclared();
            jsContext = stub.getJSContext();
            isDeclaration = stub.isDeclaration();
        } else {
            namespace = null;
            namespaceExplicitlyDeclared = false;
            JSExpression expression = this.getExpression();
            JSExpression qualifier = expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getQualifier() : (expression instanceof JSIndexedPropertyAccessExpression ? ((JSIndexedPropertyAccessExpression)expression).getQualifier() : null);
            PsiComment docComment = JSDocumentationUtils.findDocComment(this);
            if (docComment instanceof JSDocComment && ((namespaceExplicitlyDeclared = ((JSDocComment)docComment).isNamespaceExplicitlyDeclared()) || qualifier == null)) {
                namespace = ((JSDocComment)docComment).getNamespace();
            }
            if (!namespaceExplicitlyDeclared && qualifier != null) {
                if (expression instanceof JSReferenceExpression && JSSymbolUtil.isExplicitExportReference((JSReferenceExpression)expression)) {
                    namespace = JSSymbolUtil.getReferencedNamespace(qualifier);
                    JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(namespace, JSContext.STATIC, this, true, true, true);
                    if (jSNamespace == null) {
                        JSDefinitionExpressionImpl.$$$reportNull$$$0(5);
                    }
                    return jSNamespace;
                }
                JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally(qualifier, visited);
                if (ns != null) {
                    if (ns.getTypeContext() == JSTypeContext.UNKNOWN) {
                        ns = ns.copyWithTypeContext(JSTypeContext.fromJSContext((JSContext)JSSymbolUtil.getContext(this, true), (boolean)true));
                    }
                    JSNamespace jSNamespace = ns;
                    if (jSNamespace == null) {
                        JSDefinitionExpressionImpl.$$$reportNull$$$0(6);
                    }
                    return jSNamespace;
                }
                namespace = JSSymbolUtil.getReferencedNamespace(qualifier);
                namespaceExplicitlyDeclared = false;
                if (namespace != null && namespace.getParent() == null) {
                    isLocal = true;
                }
            } else if (!namespaceExplicitlyDeclared) {
                namespaceExplicitlyDeclared = !JSTreeUtil.withinWithStatement(this.getNode());
                String name = this.getName();
                if (name != null) {
                    PsiElement element = JSStubBasedPsiTreeUtil.resolveLocally(name, this);
                    isLocal = element instanceof JSPsiElementBase && !(element instanceof JSDefinitionExpression) && ((JSPsiElementBase)element).getJSNamespace().isLocal();
                }
            }
            jsContext = JSSymbolUtil.getContext(this, true);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(namespace, jsContext, this, namespaceExplicitlyDeclared, isDeclaration, isLocal);
        if (jSNamespace == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(7);
        }
        return jSNamespace;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getSymbolNamespace().isSourceStrict();
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            JSNamespace jSNamespace = stub.getJSNamespace();
            if (jSNamespace == null) {
                JSDefinitionExpressionImpl.$$$reportNull$$$0(8);
            }
            return jSNamespace;
        }
        return this.getSymbolNamespace();
    }

    @NotNull
    public JSContext getJSContext() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSDefinitionExpressionImpl.$$$reportNull$$$0(9);
            }
            return jSContext;
        }
        JSContext jSContext = this.getSymbolNamespace().getJSContext();
        if (jSContext == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(10);
        }
        return jSContext;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSDefinitionExpressionImpl.$$$reportNull$$$0(11);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            JSDefinitionExpressionImpl.$$$reportNull$$$0(12);
        }
        return accessType;
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        PsiComment comment;
        JSExpression rOperand;
        JSNamespace rOpNamespace;
        PsiElement parent;
        JSElementIndexingDataImpl result2 = null;
        String name = this.getName();
        if ("prototype".equals(name) && (parent = this.getParent()) instanceof JSAssignmentExpression && (rOpNamespace = JSSymbolUtil.evaluateNamespaceLocally(rOperand = ((JSAssignmentExpression)parent).getROperand())) != null) {
            result2 = this.createBaseTypeIndexingData(rOpNamespace);
        }
        if ((comment = JSDocumentationUtils.findDocComment(this)) instanceof JSDocComment && (((JSDocComment)comment).isClassExplicitly() || ((JSDocComment)comment).hasInterfaceTag())) {
            if (result2 == null) {
                result2 = new JSElementIndexingDataImpl();
            }
            if (((JSDocComment)comment).isClassExplicitly()) {
                result2.setIsClassExplicitly();
            }
            if (((JSDocComment)comment).hasInterfaceTag()) {
                result2.setIsInterfaceExplicitly();
            }
        }
        return result2;
    }

    @Nullable
    public JSElementIndexingData getIndexingData() {
        return JSImplicitElementProviderImpl.getIndexingData(this);
    }

    @Nullable
    private JSElementIndexingData createBaseTypeIndexingData(@Nullable JSNamespace superType) {
        JSQualifiedName namespace = this.getNamespace();
        if (this.getJSContext() != JSContext.INSTANCE && namespace != null && superType != null) {
            JSElementIndexingDataImpl data = new JSElementIndexingDataImpl();
            String superName = JSBaseTypesIndex.serializeHierarchyElement(superType);
            data.addBaseType(namespace.getQualifiedName(), superName);
            return data;
        }
        return null;
    }

    public boolean isDeclaration() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDeclaration();
        }
        return this.getSymbolNamespace().isDeclaration();
    }

    public boolean isUnderCondition() {
        JSDefinitionExpressionStub stub = (JSDefinitionExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isUnderCondition();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{JSIfStatement.class, JSExecutionScope.class}) instanceof JSIfStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDefinitionExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolNamespace";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSymbolNamespace";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

