/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ChangeUtil {
    private ES6ChangeUtil() {
    }

    @Nullable
    public static JSProperty replaceWithShorthand(@NotNull JSProperty source) {
        JSExpression value;
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(0);
        }
        if ((value = source.getValue()) == null) {
            return null;
        }
        String text = String.format("{%s}", value.getText());
        return ES6ChangeUtil.replacePropertyWithText(source, text);
    }

    public static JSProperty expandShorthandPropertyWithValue(@NotNull JSProperty source, @NotNull String value) {
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(1);
        }
        if (value == null) {
            ES6ChangeUtil.$$$reportNull$$$0(2);
        }
        String text = String.format("{%s:%s}", source.getName(), value);
        return ES6ChangeUtil.replacePropertyWithText(source, text);
    }

    public static void expandShorthandPropertyWithName(@NotNull ES6Property source, @NotNull String name) {
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            ES6ChangeUtil.$$$reportNull$$$0(4);
        }
        String text = String.format("{%s:%s}", name, source.getName());
        ES6ChangeUtil.replacePropertyWithText((JSProperty)source, text);
    }

    @Nullable
    public static JSDestructuringProperty replaceWithShorthand(@NotNull JSDestructuringProperty property) {
        JSInitializerOwner element;
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(5);
        }
        if ((element = property.getDestructuringElement()) == null) {
            return null;
        }
        JSDestructuringProperty replacement = ES6ChangeUtil.destructuringPropertyFromText(element.getText(), property);
        return (JSDestructuringProperty)property.replace((PsiElement)replacement);
    }

    @Nullable
    public static JSDestructuringProperty expandDestructuringProperty(@NotNull JSDestructuringShorthandedProperty property) {
        String name;
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(6);
        }
        if ((name = property.getName()) == null) {
            return null;
        }
        return ES6ChangeUtil.expandDestructuringPropertyWithVariableName(property, name);
    }

    @NotNull
    public static JSDestructuringProperty expandDestructuringPropertyWithVariableName(@NotNull JSDestructuringShorthandedProperty property, @NotNull String variableName) {
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(7);
        }
        if (variableName == null) {
            ES6ChangeUtil.$$$reportNull$$$0(8);
        }
        Object text = String.format("%s : %s", property.getName(), variableName);
        JSVariable variable = property.getDestructuringElement();
        if (variable != null && variable.getInitializer() != null) {
            text = (String)text + "=" + variable.getInitializer().getText();
        }
        JSDestructuringProperty expanded = ES6ChangeUtil.destructuringPropertyFromText((String)text, (JSDestructuringProperty)property);
        JSDestructuringProperty jSDestructuringProperty = (JSDestructuringProperty)property.replace((PsiElement)expanded);
        if (jSDestructuringProperty == null) {
            ES6ChangeUtil.$$$reportNull$$$0(9);
        }
        return jSDestructuringProperty;
    }

    private static JSDestructuringProperty destructuringPropertyFromText(String text, @NotNull JSDestructuringProperty property) {
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(10);
        }
        PsiElement container = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)property);
        JSDestructuringElement destructuringElement = (JSDestructuringElement)JSPsiElementFactory.createParameterOrVariableItem(String.format("{%s}", text), (PsiElement)property, container instanceof JSCatchBlock, container instanceof JSParameterList);
        return (JSDestructuringProperty)SyntaxTraverser.psiTraverser((PsiElement)destructuringElement).filter(JSDestructuringProperty.class).first();
    }

    private static JSProperty replacePropertyWithText(@NotNull JSProperty source, @NotNull String text) {
        JSObjectLiteralExpression jsObjectLiteralExpression;
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(11);
        }
        if (text == null) {
            ES6ChangeUtil.$$$reportNull$$$0(12);
        }
        if ((jsObjectLiteralExpression = JSChangeUtil.createExpressionPsiWithContext(text, (PsiElement)source, JSObjectLiteralExpression.class)) == null) {
            return source;
        }
        return (JSProperty)source.replace((PsiElement)Objects.requireNonNull(jsObjectLiteralExpression.getFirstProperty()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "expandDestructuringPropertyWithVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithShorthand";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expandShorthandPropertyWithValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandShorthandPropertyWithName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandDestructuringProperty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandDestructuringPropertyWithVariableName";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "destructuringPropertyFromText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replacePropertyWithText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

