/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.patterns;

import com.intellij.lang.javascript.JSLanguageInjector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.injections.JSInjectionController;
import com.intellij.lang.javascript.patterns.JSCallExpressionPattern;
import com.intellij.lang.javascript.patterns.JSElementPattern;
import com.intellij.lang.javascript.patterns.JSLiteralExpressionPattern;
import com.intellij.lang.javascript.patterns.JSReferenceExpressionPattern;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPatterns
extends PlatformPatterns {
    @NotNull
    public static JSElementPattern.Capture<JSStringTemplateExpression> stringTemplate() {
        return new JSElementPattern.Capture<JSStringTemplateExpression>(JSStringTemplateExpression.class);
    }

    @NotNull
    public static JSElementPattern.Capture<ES6TaggedTemplateExpression> taggedTemplate(@NotNull ElementPattern<? extends JSExpression> tagPattern) {
        if (tagPattern == null) {
            JSPatterns.$$$reportNull$$$0(0);
        }
        JSElementPattern.Capture capture = (JSElementPattern.Capture)new JSElementPattern.Capture<ES6TaggedTemplateExpression>(ES6TaggedTemplateExpression.class).withFirstChild(tagPattern);
        if (capture == null) {
            JSPatterns.$$$reportNull$$$0(1);
        }
        return capture;
    }

    @NotNull
    public static JSElementPattern.Capture<ES6TaggedTemplateExpression> taggedTemplate(@NotNull String tag) {
        if (tag == null) {
            JSPatterns.$$$reportNull$$$0(2);
        }
        return JSPatterns.taggedTemplate((ElementPattern<? extends JSExpression>)JSPatterns.jsReferenceExpression().withQualifiedName(tag));
    }

    @NotNull
    public static JSElementPattern.Capture<JSStringTemplateExpression> taggedString(@NotNull String tag) {
        if (tag == null) {
            JSPatterns.$$$reportNull$$$0(3);
        }
        JSElementPattern.Capture capture = (JSElementPattern.Capture)JSPatterns.stringTemplate().withParent((ElementPattern)JSPatterns.taggedTemplate(tag));
        if (capture == null) {
            JSPatterns.$$$reportNull$$$0(4);
        }
        return capture;
    }

    public static JSElementPattern.Capture<JSLiteralExpression> jsLiteralExpression() {
        return new JSElementPattern.Capture<JSLiteralExpression>(JSLiteralExpression.class);
    }

    public static JSLiteralExpressionPattern jsLiteralExpression(final @NotNull ElementPattern<? extends JSExpression> literalOrConcatenationPattern) {
        if (literalOrConcatenationPattern == null) {
            JSPatterns.$$$reportNull$$$0(5);
        }
        return (JSLiteralExpressionPattern)new JSLiteralExpressionPattern().with((PatternCondition)new PatternCondition<JSLiteralExpression>("jsLiteralConcatParent"){

            public boolean accepts(@NotNull JSLiteralExpression literalExpression, ProcessingContext context) {
                if (literalExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSLiteralExpression literalOrConcatenation = literalExpression;
                while (literalOrConcatenation.getParent() instanceof JSBinaryExpression && ((JSBinaryExpression)literalOrConcatenation.getParent()).getOperationSign() == JSTokenTypes.PLUS) {
                    literalOrConcatenation = literalOrConcatenation.getParent();
                }
                return literalOrConcatenationPattern.accepts((Object)literalOrConcatenation);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/patterns/JSPatterns$1", "accepts"));
            }
        });
    }

    public static JSLiteralExpressionPattern jsLiteral() {
        return new JSLiteralExpressionPattern();
    }

    @NotNull
    public static JSElementPattern.Capture<JSProperty> jsProperty() {
        return new JSElementPattern.Capture<JSProperty>(JSProperty.class);
    }

    @NotNull
    public static JSElementPattern.Capture<JSExpression> jsExpression() {
        return new JSElementPattern.Capture<JSExpression>(JSExpression.class);
    }

    @NotNull
    public static JSReferenceExpressionPattern jsReferenceExpression() {
        return new JSReferenceExpressionPattern();
    }

    @NotNull
    public static JSCallExpressionPattern jsCallExpression() {
        return new JSCallExpressionPattern();
    }

    @NotNull
    public static JSElementPattern.Capture<JSExpression> jsArgument(JSReferenceExpressionPattern pattern, int index) {
        JSElementPattern.Capture<JSExpression> capture = JSPatterns.jsArgument(pattern, index, -1);
        if (capture == null) {
            JSPatterns.$$$reportNull$$$0(6);
        }
        return capture;
    }

    public static JSElementPattern.Capture<JSExpression> jsArgument(String functionName, int index) {
        return JSPatterns.jsArgument(functionName, index, -1);
    }

    public static JSElementPattern.Capture<JSExpression> jsArgument(String functionName, int index, int argCount) {
        return JSPatterns.jsArgument(JSPatterns.jsReferenceExpression().withReferenceName(functionName), index, argCount);
    }

    private static JSElementPattern.Capture<JSExpression> jsArgument(final JSReferenceExpressionPattern methodPattern, final int index, final int argCount) {
        return new JSElementPattern.Capture<JSExpression>(new InitialPatternCondition<JSExpression>(JSExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof JSExpression)) {
                    return false;
                }
                PsiElement parent = ((JSExpression)o).getParent();
                if (!(parent instanceof JSArgumentList)) {
                    return false;
                }
                PsiElement parent1 = parent.getParent();
                if (!(parent1 instanceof JSCallExpression)) {
                    return false;
                }
                if (!methodPattern.accepts(((JSCallExpression)parent1).getMethodExpression(), context)) {
                    return false;
                }
                JSExpression[] children = ((JSArgumentList)parent).getArguments();
                return (argCount == -1 || argCount == children.length) && index < children.length && children[index] == o;
            }
        });
    }

    public static JSElementPattern.Capture<JSExpression> asAssignedValue(final String propertyName, final String className2, final String ... varNames) {
        return new JSElementPattern.Capture<JSExpression>(new InitialPatternCondition<JSExpression>(JSExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof JSExpression)) {
                    return false;
                }
                PsiElement parent = ((JSExpression)o).getParent();
                if (!(parent instanceof JSAssignmentExpression)) {
                    return false;
                }
                if (parent.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                    return false;
                }
                JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)parent;
                if (assignmentExpression.getROperand() != o) {
                    return false;
                }
                JSExpression exp = assignmentExpression.getLOperand();
                if (!(exp instanceof JSDefinitionExpression)) {
                    return false;
                }
                if (!((exp = ((JSDefinitionExpression)exp).getExpression()) instanceof JSReferenceExpression)) {
                    return false;
                }
                JSReferenceExpression refExp = (JSReferenceExpression)exp;
                if (!propertyName.equals(refExp.getReferencedName())) {
                    return false;
                }
                if (varNames.length > 0) {
                    PsiElement firstChild = refExp.getFirstChild();
                    if (!(firstChild instanceof JSReferenceExpression)) {
                        return false;
                    }
                    if (ArrayUtil.find((Object[])varNames, (Object)((JSReferenceExpression)firstChild).getReferencedName()) < 0) {
                        return false;
                    }
                }
                if (className2 != null && className2.length() > 0 && !className2.equals("*")) {
                    PsiElement resolved = refExp.resolve();
                    if (!(resolved instanceof JSFunction) || !((JSFunction)resolved).isSetProperty()) {
                        return false;
                    }
                    PsiElement jsClass = resolved.getParent();
                    if (!(jsClass instanceof JSClass) || !className2.equals(((JSClass)jsClass).getQualifiedName())) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public static StringPattern hasUnicodeRegexpFlag() {
        return (StringPattern)JSPatterns.string().with((PatternCondition)new PatternCondition<String>("hasUnicodeRegexpFlag"){

            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    4.$$$reportNull$$$0(0);
                }
                return JSLanguageInjector.hasUnicodeFlag(s, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/patterns/JSPatterns$4", "accepts"));
            }
        });
    }

    public static JSElementPattern.Capture<JSExpression> jqueryArgument() {
        return (JSElementPattern.Capture)JSPatterns.jsExpression().with((PatternCondition)new PatternCondition<JSExpression>("jqueryArgument"){

            public boolean accepts(@NotNull JSExpression expression, ProcessingContext context) {
                if (expression == null) {
                    5.$$$reportNull$$$0(0);
                }
                return JSInjectionController.willInjectCss((PsiElement)expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/patterns/JSPatterns$5", "accepts"));
            }
        });
    }

    public static JSElementPattern.Capture<JSExpression> isHtmlLikeText() {
        return (JSElementPattern.Capture)JSPatterns.jsExpression().with((PatternCondition)new PatternCondition<JSExpression>("isHtmlLikeText"){

            public boolean accepts(@NotNull JSExpression expression, ProcessingContext context) {
                if (expression == null) {
                    6.$$$reportNull$$$0(0);
                }
                return JSInjectionController.willInjectHtml((PsiElement)expression) == JSInjectionController.HtmlInjectionKind.HTML;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/patterns/JSPatterns$6", "accepts"));
            }
        });
    }

    public static JSElementPattern.Capture<JSExpression> isReactJSXLikeText() {
        return (JSElementPattern.Capture)JSPatterns.jsExpression().with((PatternCondition)new PatternCondition<JSExpression>("isReactJSXLikeText"){

            public boolean accepts(@NotNull JSExpression expression, ProcessingContext context) {
                if (expression == null) {
                    7.$$$reportNull$$$0(0);
                }
                return JSInjectionController.willInjectHtml((PsiElement)expression) == JSInjectionController.HtmlInjectionKind.REACT_JSX;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/patterns/JSPatterns$7", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPattern";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/patterns/JSPatterns";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalOrConcatenationPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/patterns/JSPatterns";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "taggedTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "taggedString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "jsArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "taggedTemplate";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "taggedString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "jsLiteralExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

