/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.xml.psi.XmlPsiBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXmlTokensParser
implements JSXmlParser {
    private static final WhitespacesAndCommentsBinder INCOMPLETE_TAG_WHITESPACE_BINDER = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            IElementType last = tokens.get(tokens.size() - 1);
            IElementType prev = tokens.get(tokens.size() - 2);
            return last == JSTokenTypes.WHITE_SPACE && prev != JSTokenTypes.XML_TAG_END && prev != JSTokenTypes.XML_END_TAG_LIST && prev != JSTokenTypes.XML_EMPTY_TAG_END && !JSTokenTypes.COMMENTS.contains(prev) ? 1 : 0;
        }
    };
    protected PsiBuilder builder;
    private final TokenSet myEmbeddedJsxElementTypes;
    private boolean myEmptyTagNameAllowed;

    public JSXmlTokensParser(PsiBuilder builder) {
        this(builder, TokenSet.EMPTY);
    }

    public JSXmlTokensParser(PsiBuilder builder, @NotNull TokenSet embeddedJsxElementTypes) {
        if (embeddedJsxElementTypes == null) {
            JSXmlTokensParser.$$$reportNull$$$0(0);
        }
        this.myEmptyTagNameAllowed = false;
        this.builder = builder;
        this.myEmbeddedJsxElementTypes = embeddedJsxElementTypes;
    }

    public JSXmlTokensParser withEmptyTagNameAllowed(boolean emptyTagNameAllowed) {
        this.myEmptyTagNameAllowed = emptyTagNameAllowed;
        return this;
    }

    @Override
    public boolean isXmlTagStart(IElementType currentToken) {
        return currentToken == JSTokenTypes.XML_START_TAG_START || currentToken == JSTokenTypes.XML_START_TAG_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean parseTag(Stack<String> tagNames) {
        tokenType = this.builder.getTokenType();
        if (!JSXmlTokensParser.$assertionsDisabled && JSTokenTypes.XML_START_TAG_START != tokenType && JSTokenTypes.XML_START_TAG_LIST != tokenType) {
            throw new AssertionError();
        }
        marker = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            nameBuilder = new StringBuilder();
            this.collapseXmlJsScript(nameBuilder);
            name = nameBuilder.toString();
        } else {
            name = this.builder.getTokenText();
        }
        seenEnd = JSTokenTypes.XML_START_TAG_LIST == tokenType;
        tagNames.push((Object)name);
        hasErrors = false;
        try {
            currentTokenType = this.builder.getTokenType();
            while (currentTokenType != null) {
                if (JSTokenTypes.XML_TOKENS.contains(currentTokenType) || this.myEmbeddedJsxElementTypes.contains(currentTokenType) || currentTokenType == JSTokenTypes.LBRACE) ** GOTO lbl41
                if (this.parseSpecialTagEntity(currentTokenType)) ** GOTO lbl130
                if (seenEnd) break block25;
                this.builder.error(XmlPsiBundle.message((String)"xml.parsing.tag.start.is.not.closed", (Object[])new Object[0]));
                hasErrors = true;
                var8_10 = false;
            }
        }
        catch (Throwable var12_18) {
            tagNames.pop();
            marker.done(this.getXmlLiteralExpression());
            marker.setCustomEdgeTokenBinders(null, JSXmlTokensParser.INCOMPLETE_TAG_WHITESPACE_BINDER);
            return hasErrors == false;
        }
        {
            block27: {
                block31: {
                    block29: {
                        block28: {
                            block26: {
                                block30: {
                                    block25: {
                                        tagNames.pop();
                                        marker.done(this.getXmlLiteralExpression());
                                        marker.setCustomEdgeTokenBinders(null, JSXmlTokensParser.INCOMPLETE_TAG_WHITESPACE_BINDER);
                                        return hasErrors == false;
                                    }
                                    errorMarker = this.builder.mark();
                                    this.builder.advanceLexer();
                                    errorMarker.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.xml.element", (Object[])new Object[0]));
                                    ** GOTO lbl130
lbl41:
                                    // 1 sources

                                    if (currentTokenType != JSTokenTypes.XML_START_TAG_START && currentTokenType != JSTokenTypes.XML_START_TAG_LIST) break block30;
                                    this.parseTag(tagNames);
                                    ** GOTO lbl130
                                }
                                if (currentTokenType != JSTokenTypes.XML_EMPTY_TAG_END && currentTokenType != JSTokenTypes.XML_END_TAG_LIST) break block26;
                                this.builder.advanceLexer();
                                errorMarker = true;
                                tagNames.pop();
                                marker.done(this.getXmlLiteralExpression());
                                marker.setCustomEdgeTokenBinders(null, JSXmlTokensParser.INCOMPLETE_TAG_WHITESPACE_BINDER);
                                return hasErrors == false;
                            }
                            if (currentTokenType != JSTokenTypes.XML_END_TAG_START) break block27;
                            if (seenEnd) break block28;
                            this.builder.error(XmlPsiBundle.message((String)"xml.parsing.tag.start.is.not.closed", (Object[])new Object[0]));
                            hasErrors = true;
                            errorMarker = false;
                            tagNames.pop();
                            marker.done(this.getXmlLiteralExpression());
                            marker.setCustomEdgeTokenBinders(null, JSXmlTokensParser.INCOMPLETE_TAG_WHITESPACE_BINDER);
                            return hasErrors == false;
                        }
                        endTagStart = this.builder.mark();
                        this.builder.advanceLexer();
                        type = this.builder.getTokenType();
                        if (type != XmlTokenType.XML_TAG_NAME && !this.myEmbeddedJsxElementTypes.contains(type) && type != JSTokenTypes.LBRACE) ** GOTO lbl95
                        if (type == JSTokenTypes.LBRACE) {
                            nameBuilder = new StringBuilder();
                            this.collapseXmlJsScript(nameBuilder);
                            endName = nameBuilder.toString();
                        } else {
                            endName = this.builder.getTokenText();
                        }
                        if (StringUtil.equals((CharSequence)name, (CharSequence)endName) || endName != null && endName.endsWith("IntellijIdeaRulezzz")) ** GOTO lbl92
                        if (!tagNames.contains((Object)endName)) break block29;
                        endTagStart.rollbackTo();
                        this.builder.error(XmlPsiBundle.message((String)"xml.parsing.named.element.is.not.closed", (Object[])new Object[]{name}));
                        var11_15 = false;
                        tagNames.pop();
                        marker.done(this.getXmlLiteralExpression());
                        marker.setCustomEdgeTokenBinders(null, JSXmlTokensParser.INCOMPLETE_TAG_WHITESPACE_BINDER);
                        return hasErrors == false;
                    }
                    this.builder.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]));
                    hasErrors = true;
lbl92:
                    // 2 sources

                    if (type != JSTokenTypes.LBRACE) {
                        this.builder.advanceLexer();
                    }
                    break block31;
lbl95:
                    // 1 sources

                    if (!this.myEmptyTagNameAllowed && JSTokenTypes.XML_START_TAG_LIST != tokenType) {
                        this.builder.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.name.missing", (Object[])new Object[0]));
                        hasErrors = true;
                    }
                }
                if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END) {
                    this.builder.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.is.not.done", (Object[])new Object[0]));
                    hasErrors = true;
                } else {
                    this.builder.advanceLexer();
                }
                endTagStart.drop();
                var10_17 = true;
                tagNames.pop();
                marker.done(this.getXmlLiteralExpression());
                marker.setCustomEdgeTokenBinders(null, JSXmlTokensParser.INCOMPLETE_TAG_WHITESPACE_BINDER);
                return hasErrors == false;
            }
            if (currentTokenType == JSTokenTypes.XML_NAME) {
                this.parseAttribute();
            } else if (currentTokenType == JSTokenTypes.XML_TAG_CONTENT) {
                xmlTextMarker = this.builder.mark();
                this.builder.advanceLexer();
                xmlTextMarker.done(JSElementTypes.XML_TEXT);
            } else {
                if (currentTokenType == JSTokenTypes.XML_TAG_END) {
                    seenEnd = true;
                }
                if (currentTokenType == JSTokenTypes.LBRACE) {
                    this.collapseXmlJsScript(null);
                } else {
                    this.builder.advanceLexer();
                }
                if (currentTokenType != JSTokenTypes.LBRACE && this.builder.getTokenType() == JSTokenTypes.XML_ATTR_EQUAL) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.missing.attribute.name", (Object[])new Object[0]));
                    hasErrors = true;
                }
            }
lbl130:
            // 8 sources

            currentTokenType = this.builder.getTokenType();
            continue;
        }
        tagNames.pop();
        marker.done(this.getXmlLiteralExpression());
        marker.setCustomEdgeTokenBinders(null, JSXmlTokensParser.INCOMPLETE_TAG_WHITESPACE_BINDER);
        return hasErrors == false;
    }

    private void collapseXmlJsScript(@Nullable StringBuilder text) {
        assert (this.builder.getTokenType() == JSTokenTypes.LBRACE);
        if (text != null) {
            text.append(this.builder.getTokenText());
        }
        PsiBuilder.Marker xmlJsScript = this.builder.mark();
        this.builder.advanceLexer();
        int braceBalance = 1;
        while (braceBalance > 0 && !this.builder.eof()) {
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.LBRACE) {
                ++braceBalance;
            } else if (tokenType == JSTokenTypes.RBRACE) {
                --braceBalance;
            }
            if (text != null) {
                text.append(this.builder.getTokenText());
            }
            this.builder.advanceLexer();
        }
        xmlJsScript.collapse(JSStubElementTypes.XML_JS_SCRIPT);
    }

    @NotNull
    protected IElementType getXmlLiteralExpression() {
        IElementType iElementType = JSElementTypes.XML_LITERAL_EXPRESSION;
        if (iElementType == null) {
            JSXmlTokensParser.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    protected boolean parseSpecialTagEntity(IElementType currentTokenType) {
        return false;
    }

    private void parseAttribute() {
        assert (this.builder.getTokenType() == XmlTokenType.XML_NAME);
        PsiBuilder.Marker att = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == XmlTokenType.XML_EQ) {
            this.builder.advanceLexer();
            this.parseAttributeValue();
        }
        att.done((IElementType)JSStubElementTypes.XML_ATTRIBUTE);
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.builder.mark();
        if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.builder.getTokenType()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(XmlPsiBundle.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END && this.builder.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                this.collapseXmlJsScript(null);
            } else {
                this.builder.advanceLexer();
            }
        }
        attValue.done(JSElementTypes.XML_ATTRIBUTE_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedJsxElementTypes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JSXmlTokensParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JSXmlTokensParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlLiteralExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

