/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JSDocParsing {
    private static final Set<String> ourTagsWithDocTagValue = ContainerUtil.set((Object[])new String[]{"augments", "base", "borrows", "copy", "event", "extends", "external", "fires", "implements", "lends", "link", "listens", "member", "memberOf", "mixes", "name", "ngModule", "requires", "this", "type", "typedef"});
    private static final Set<String> ourTagsWithOptionalDocTagValue = ContainerUtil.set((Object[])new String[]{"cfg", "class", "enum", "interface", "namespace", "module", "property", "return", "returns", "throws"});

    public static void parseJSDoc(PsiBuilder builder) {
        PsiBuilder.Marker root = builder.mark();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JSDocTokenTypes.DOC_TAG_NAME && JSDocParsing.parseDocTag(builder)) continue;
            builder.advanceLexer();
        }
        root.done(JSTokenTypes.DOC_COMMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean parseDocTag(PsiBuilder builder) {
        assert (builder.getTokenType() == JSDocTokenTypes.DOC_TAG_NAME);
        PsiBuilder.Marker docTagMarker = builder.mark();
        try {
            @NonNls String tagName = builder.getTokenText();
            builder.advanceLexer();
            if ("@param".equals(tagName)) {
                if (JSDocParsing.isInvalidTokenType(builder)) {
                    builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.doc.tag.name", (Object[])new Object[0]));
                    boolean bl = false;
                    return bl;
                }
                boolean typeFoundAfterParam = false;
                if (builder.getTokenType() == JSDocTokenTypes.DOC_LBRACE) {
                    JSDocParsing.createDocTagValue(builder);
                    typeFoundAfterParam = true;
                } else {
                    if (JSDocParsing.isInvalidTokenType(builder)) {
                        boolean bl = true;
                        return bl;
                    }
                    builder.advanceLexer();
                }
                if (!typeFoundAfterParam && builder.getTokenType() == JSDocTokenTypes.DOC_LBRACE) {
                    JSDocParsing.createDocTagValue(builder);
                } else if (!typeFoundAfterParam && ":".equals(builder.getTokenText())) {
                    builder.advanceLexer();
                    JSDocParsing.createDocTagValue(builder);
                } else if (typeFoundAfterParam && !JSDocParsing.isInvalidTokenType(builder)) {
                    builder.advanceLexer();
                }
                boolean bl = true;
                return bl;
            }
            if ("@link".equals(tagName)) {
                while (builder.getTokenType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
                    builder.advanceLexer();
                }
            } else {
                if ("@typedef".equals(tagName)) {
                    if (JSDocParsing.isInvalidTokenType(builder)) {
                        builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.doc.tag.value", (Object[])new Object[0]));
                        boolean typeFoundAfterParam = false;
                        return typeFoundAfterParam;
                    }
                    boolean isType = builder.getTokenType() == JSDocTokenTypes.DOC_LBRACE;
                    JSDocParsing.createDocTagValue(builder);
                    if (isType && builder.getTokenType() == JSDocTokenTypes.DOC_COMMENT_DATA) {
                        JSDocParsing.parseNamepath(builder);
                    }
                    boolean bl = true;
                    return bl;
                }
                if ("@callback".equals(tagName)) {
                    if (builder.getTokenType() == JSDocTokenTypes.DOC_COMMENT_DATA) {
                        JSDocParsing.parseNamepath(builder);
                        boolean isType = true;
                        return isType;
                    }
                } else {
                    boolean hasDocTagValue;
                    if ("@see".equals(tagName)) {
                        if (builder.getTokenType() == JSDocTokenTypes.DOC_COMMENT_DATA && builder.lookAhead(1) != JSDocTokenTypes.DOC_COMMENT_DATA || builder.getTokenType() == JSDocTokenTypes.DOC_LBRACE) {
                            JSDocParsing.createDocTagValue(builder);
                        } else if (JSDocParsing.isInvalidTokenType(builder)) {
                            builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.doc.tag.value", (Object[])new Object[0]));
                            boolean isType = false;
                            return isType;
                        }
                        boolean isType = true;
                        return isType;
                    }
                    String tagNameWithoutAt = StringUtil.isEmpty((String)tagName) ? "" : tagName.substring(1);
                    boolean allowNoTagValue = ourTagsWithOptionalDocTagValue.contains(tagNameWithoutAt);
                    boolean bl = hasDocTagValue = ourTagsWithDocTagValue.contains(tagNameWithoutAt) || allowNoTagValue;
                    if (!hasDocTagValue) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (JSDocParsing.isInvalidTokenType(builder)) {
                        if (!allowNoTagValue) {
                            builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.doc.tag.value", (Object[])new Object[0]));
                        }
                        boolean bl3 = false;
                        return bl3;
                    }
                }
            }
            JSDocParsing.createDocTagValue(builder);
            if (("@property".equals(tagName) || "@prop".equals(tagName)) && builder.getTokenType() == JSDocTokenTypes.DOC_COMMENT_DATA) {
                JSDocParsing.parseNamepath(builder);
            }
            if ("@cfg".equals(tagName) && !JSDocParsing.isInvalidTokenType(builder)) {
                builder.advanceLexer();
            }
        }
        finally {
            docTagMarker.done(JSDocTokenTypes.DOC_TAG);
        }
        return true;
    }

    private static void parseNamepath(PsiBuilder builder) {
        PsiBuilder.Marker docNamepath = builder.mark();
        builder.advanceLexer();
        docNamepath.done(JSDocTokenTypes.DOC_TAG_NAMEPATH);
    }

    private static void createDocTagValue(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType firstToken = builder.getTokenType();
        builder.advanceLexer();
        if (firstToken == JSDocTokenTypes.DOC_LBRACE) {
            int braceBalance = 1;
            while (braceBalance > 0 && !builder.eof()) {
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSDocTokenTypes.DOC_LBRACE) {
                    ++braceBalance;
                } else if (tokenType == JSDocTokenTypes.DOC_RBRACE) {
                    --braceBalance;
                } else if (tokenType == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK && builder.lookAhead(1) == JSDocTokenTypes.DOC_TAG_NAME || tokenType == JSDocTokenTypes.DOC_COMMENT_END) break;
                builder.advanceLexer();
            }
        }
        marker.done(JSDocTokenTypes.DOC_TAG_VALUE);
    }

    private static boolean isInvalidTokenType(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        return builder.eof() || tokenType == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK || tokenType == JSDocTokenTypes.DOC_COMMENT_END || tokenType == JSDocTokenTypes.DOC_TAG_NAME;
    }

    public static boolean isInsideJSDoc(PsiElement element) {
        return JSDocTokenTypes.ALL.contains(element.getParent().getNode().getElementType());
    }

    public static boolean isTagValue(@NotNull IElementType elementType, @NotNull LeafPsiElement element) {
        PsiElement tagName;
        String name;
        if (elementType == null) {
            JSDocParsing.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSDocParsing.$$$reportNull$$$0(1);
        }
        if (elementType != JSDocTokenTypes.DOC_COMMENT_DATA) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof JSDocTag ? ("param".equals(name = ((JSDocTag)parent).getName()) || "typedef".equals(name) || "callback".equals(name)) && (tagName = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, JSDocTagValue.class})) != null && tagName.getNode().getElementType() == JSDocTokenTypes.DOC_TAG_NAME : parent instanceof JSDocTagNamepath || parent instanceof JSDocTagValue && parent.getFirstChild() == parent.getLastChild();
    }

    public static boolean isType(@NotNull JSDocTagValue value) {
        if (value == null) {
            JSDocParsing.$$$reportNull$$$0(2);
        }
        ASTNode node = value.getNode();
        ASTNode firstChildNode = node.getFirstChildNode();
        ASTNode lastChildNode = node.getLastChildNode();
        return firstChildNode != null && firstChildNode.getElementType() == JSDocTokenTypes.DOC_LBRACE && lastChildNode != null && lastChildNode.getElementType() == JSDocTokenTypes.DOC_RBRACE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/parsing/JSDocParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTagValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

