/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSNodeModulesHandlerScope;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.ES6ImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSImportedElementDescriptor;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ImportDeclarationPartIndex;
import com.intellij.lang.javascript.psi.stubs.JSLazyIndexedPackagesIndex;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileExportsImpl;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportedCandidatesProvider
extends JSImportCandidatesBase {
    @Nullable
    private MultiMap<String, JSElement> myAllRegularExternalModules;
    @Nullable
    private Map<String, Pair<List<JSFile>, CompactVirtualFileSet>> myResolvedPackageJsonModules;
    @NotNull
    private final Predicate<? super JSElement> myExportedFilter;
    @NotNull
    private final JSCompletionPlaceFilter myPlaceFilter;
    @NotNull
    private final GlobalSearchScope myScope;
    @NotNull
    private final Set<String> myPackageJsonModules;
    @Nullable
    private final VirtualFile myModuleRootDirectory;

    protected ES6ExportedCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
        PsiElement place = placeInfo.getPlace();
        Project project = place.getProject();
        boolean isTypeScript = DialectDetector.isTypeScript(place);
        this.myPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
        this.myExportedFilter = element -> !(element instanceof JSPsiElementBase && !this.myPlaceFilter.isAcceptable((JSPsiElementBase)element) || !ES6ExportedCandidatesProvider.isAcceptableForImport(placeInfo, placeInfo.importContext(), element) || ES6ExportedCandidatesProvider.needToCheckConfigAccess((PsiElement)element, isTypeScript) && !TypeScriptConfigService.Provider.isAccessible(project, placeInfo.getFile(), element.getContainingFile().getVirtualFile()));
        this.myScope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, place);
        this.myPackageJsonModules = JSNodeModulesHandlerScope.getAcceptableModules(project, placeInfo.getFile());
        this.myModuleRootDirectory = ES6ExportedCandidatesProvider.getRoot(placeInfo);
    }

    @NotNull
    private Map<String, Pair<List<JSFile>, CompactVirtualFileSet>> getResolvedPackageJsonModules() {
        if (this.myResolvedPackageJsonModules != null) {
            Map<String, Pair<List<JSFile>, CompactVirtualFileSet>> map2 = this.myResolvedPackageJsonModules;
            if (map2 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(1);
            }
            return map2;
        }
        PsiElement place = this.myPlaceInfo.getPlace();
        HashMap<String, Pair<List<JSFile>, CompactVirtualFileSet>> result2 = new HashMap<String, Pair<List<JSFile>, CompactVirtualFileSet>>();
        List toProcess = ContainerUtil.filter(this.myPackageJsonModules, el -> !el.startsWith("@types") && !JSLazyIndexedPackagesIndex.LAZY_PACKAGES.contains(el));
        for (String module : toProcess) {
            Collection<PsiElement> elements = JSFileReferencesUtil.resolveModuleReference(place, module);
            List tsElements = ((StreamEx)StreamEx.of(elements).select(JSFile.class).filter(el -> TypeScriptUtil.isDefinitionFile((PsiFile)el))).toList();
            if (tsElements.isEmpty()) continue;
            HashSet files = new HashSet();
            for (JSFile el2 : tsElements) {
                VirtualFile file2 = el2.getVirtualFile();
                if (file2 == null) continue;
                TypeScriptFileExportsImpl exports = new TypeScriptFileExportsImpl(place.getProject(), file2){

                    @Override
                    protected boolean isAcceptable(@Nullable VirtualFile resolved) {
                        return super.isAcceptable(resolved) && ES6ExportedCandidatesProvider.this.myScope.accept(resolved);
                    }
                };
                files.addAll(new TypeScriptImportGraph(exports).getNodes());
            }
            CompactVirtualFileSet compactSet = new CompactVirtualFileSet(files);
            compactSet.freeze();
            result2.put(module, (Pair<List<JSFile>, CompactVirtualFileSet>)Pair.create((Object)tsElements, (Object)compactSet));
        }
        this.myResolvedPackageJsonModules = result2;
        HashMap<String, Pair<List<JSFile>, CompactVirtualFileSet>> hashMap = result2;
        if (hashMap == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @Override
    public boolean processCandidates(@NotNull String name, @NotNull JSCandidatesProcessor processor, boolean forCompletion) {
        PsiElement place;
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(4);
        }
        if (!(place = this.myPlaceInfo.getPlace()).isValid()) {
            return true;
        }
        Project project = place.getProject();
        ArrayList<JSElement> candidates = new ArrayList<JSElement>();
        this.addExportedElements(name, project, this.myScope, candidates);
        this.addExportedDefaultAssignmentElements(name, project, this.myScope, candidates);
        this.addExternalModuleNames(name, candidates);
        Collection<JSElement> result2 = this.removeOverloads(candidates);
        StreamEx exported = ((StreamEx)((StreamEx)StreamEx.of(result2).filter(this.myExportedFilter)).distinct()).map(el -> this.createCandidate(name, (JSElement)el, place, forCompletion)).nonNull();
        List<JSImportCandidate> defaultExport = this.getProjectImports(name);
        Stream.concat(exported, defaultExport.stream()).forEach(processor::processCandidate);
        return true;
    }

    @Nullable
    private JSImportCandidate createCandidate(@NotNull String name, @NotNull JSElement el, @NotNull PsiElement place, boolean forCompletion) {
        VirtualFile file2;
        NodeModuleUtil.NodeModuleStructure structure;
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(5);
        }
        if (el == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(6);
        }
        if (place == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(7);
        }
        NodeModuleUtil.NodeModuleStructure nodeModuleStructure = structure = (file2 = PsiUtilCore.getVirtualFile((PsiElement)el)) == null ? null : NodeModuleUtil.getNodeModuleStructure(place.getProject(), file2);
        if (!(structure == null || this.myPackageJsonModules.isEmpty() || this.myPackageJsonModules.contains(structure.getPackageName()) || this.myPackageJsonModules.contains(structure.getOriginalPackageName()))) {
            if (!DialectDetector.isTypeScript((PsiElement)el) || el instanceof ES6ImportExportDeclarationPart) {
                return null;
            }
            Map<String, Pair<List<JSFile>, CompactVirtualFileSet>> modules = this.getResolvedPackageJsonModules();
            for (Map.Entry<String, Pair<List<JSFile>, CompactVirtualFileSet>> entry : modules.entrySet()) {
                String moduleName = entry.getKey();
                Pair<List<JSFile>, CompactVirtualFileSet> value = entry.getValue();
                if (!((CompactVirtualFileSet)value.second).contains((Object)file2)) continue;
                for (JSFile jsFile : (List)value.first) {
                    JSImportedElementDescriptor descriptor2 = ES6CreateImportUtil.resolveSymbolInModuleWithName(name, el, place, (JSElement)jsFile, false);
                    if (descriptor2 == null) continue;
                    final SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)el);
                    return new JSImportCandidateDescriptor(JSImportCandidate.SourceType.ES6, moduleName, descriptor2.getImportedName(), descriptor2.getExportedName(), descriptor2.getImportExportPrefixKind(), descriptor2.getImportType()){

                        @Override
                        @Nullable
                        public JSElement getElement() {
                            return (JSElement)pointer.getElement();
                        }
                    };
                }
            }
            return null;
        }
        return new ES6ImportCandidate(name, el, place, this.myPlaceInfo.importContext(), this.isUseImport(el, forCompletion));
    }

    private boolean isUseImport(@NotNull JSElement el, boolean forCompletion) {
        if (el == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(8);
        }
        PsiElement place = this.myPlaceInfo.getPlace();
        PsiFile file2 = place.getContainingFile();
        boolean skipNodeModulesImport = !DialectDetector.isTypeScript(place) && (!(file2 instanceof JSFile) || ((JSFile)file2).getModuleStatus() != JSFile.ModuleStatus.ES6);
        return this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.TAG || !forCompletion || !skipNodeModulesImport || !ES6ExportedCandidatesProvider.hasNodeModulesInPath((PsiElement)el);
    }

    public void addExportedDefaultAssignmentElements(@NotNull String name, Project project, GlobalSearchScope scope, List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(9);
        }
        if (this.myPlaceInfo.importContext() != JSImportPlaceInfo.ImportContext.SPECIFIER) {
            Processor assignmentProcessor = CommonProcessors.processAll(toProcess -> {
                JSElement expression = toProcess.getStubSafeElement();
                if (expression instanceof JSQualifiedNamedElement) {
                    if (expression.getName() == null) {
                        candidates.add(expression);
                    }
                } else {
                    candidates.add((JSElement)toProcess);
                }
            });
            StubIndex.getInstance().processElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)name, project, scope, JSExportAssignment.class, assignmentProcessor);
        }
    }

    public void addExportedElements(@NotNull String name, Project project, GlobalSearchScope scope, List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(10);
        }
        ArrayList exportSpecifiers = new ArrayList();
        HashSet scopesWithSpecifierExports = new HashSet();
        Processor processor = CommonProcessors.processAll(toProcess -> {
            if (toProcess instanceof ES6ExportSpecifier) {
                exportSpecifiers.add((ES6ExportSpecifier)toProcess);
                return;
            }
            if (ES6CreateImportUtil.isAvailableForImport((PsiElement)toProcess, this.myPlaceInfo)) {
                JSElement exportScope;
                JSPsiElementBase element;
                candidates.add((JSElement)toProcess);
                if (toProcess instanceof JSPsiElementBase && (element = (JSPsiElementBase)toProcess).isExported() && ES6PsiUtil.isExternalModule((PsiElement)(exportScope = ES6PsiUtil.getExportScope((PsiElement)element)))) {
                    scopesWithSpecifierExports.add(exportScope);
                }
            }
        });
        StubIndex.getInstance().processElements(ES6ExportedNamesIndex.KEY, (Object)name, project, scope, JSElement.class, processor);
        for (ES6ExportSpecifier specifier : exportSpecifiers) {
            JSElement exportScope = ES6PsiUtil.getExportScope((PsiElement)specifier);
            if (exportScope == null || scopesWithSpecifierExports.contains(exportScope) || exportScope == this.myPlaceInfo.getContainer() || !ES6CreateImportUtil.isAcceptableExportSpecifier(specifier)) continue;
            candidates.add((JSElement)specifier);
        }
    }

    private static boolean hasNodeModulesInPath(@NotNull PsiElement element) {
        VirtualFile file2;
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(11);
        }
        return (file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && NodeModuleUtil.hasNodeModulesDirInPath(file2, null);
    }

    @Override
    @NotNull
    public Set<String> getNames(@NotNull Predicate<String> keyFilter) {
        if (keyFilter == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(12);
        }
        Project project = this.myPlaceInfo.getPlace().getProject();
        Set namedKeys = StubIndex.getInstance().getAllKeys(ES6ExportedNamesIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        ProgressManager.checkCanceled();
        Set defaultAssignmentKeys = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER ? Collections.emptySet() : StubIndex.getInstance().getAllKeys(ES6DefaultAssignmentModuleIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        Set existingDefaultImportNames = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER ? Collections.emptySet() : StubIndex.getInstance().getAllKeys(ES6ImportDeclarationPartIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        Set<String> set = Stream.concat(Stream.concat(namedKeys.stream(), defaultAssignmentKeys.stream()), existingDefaultImportNames.stream()).collect(Collectors.toSet());
        if (set == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(13);
        }
        return set;
    }

    public static boolean needToCheckConfigAccess(@NotNull PsiElement element, boolean isTypeScript) {
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(14);
        }
        if (isTypeScript && element instanceof TypeScriptModule && ((TypeScriptModule)element).isExternal()) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        return isTypeScript && (!(file2 instanceof JSFile) || !((JSFile)file2).isCommonJSModule());
    }

    public static boolean isAcceptableForImport(@NotNull JSImportPlaceInfo info, @NotNull JSImportPlaceInfo.ImportContext importContext, @NotNull JSElement element) {
        JSElement container;
        if (info == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(15);
        }
        if (importContext == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(16);
        }
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(17);
        }
        if ((container = ES6PsiUtil.getExportScope((PsiElement)element)) == info.getContainer()) {
            return false;
        }
        if (importContext != JSImportPlaceInfo.ImportContext.SPECIFIER && element instanceof TypeScriptModule && ((TypeScriptModule)element).isExternal()) {
            return true;
        }
        if (importContext != JSImportPlaceInfo.ImportContext.BINDING && element instanceof ES6ExportSpecifier && ((ES6ExportSpecifier)element).getAlias() != null) {
            return true;
        }
        if (importContext == JSImportPlaceInfo.ImportContext.SPECIFIER && element instanceof JSPsiElementBase) {
            return ((JSPsiElementBase)element).isExported() && ES6PsiUtil.findExternalModule((PsiElement)element) != null;
        }
        if (importContext == JSImportPlaceInfo.ImportContext.BINDING) {
            if (element instanceof JSElementBase && ((JSElementBase)element).isExportedWithDefault()) {
                return true;
            }
            return element instanceof ES6ExportDefaultAssignment;
        }
        if (element instanceof ES6ExportSpecifier && !ES6CreateImportUtil.isAcceptableExportSpecifier((ES6ExportSpecifier)element)) {
            return false;
        }
        return element instanceof JSExportAssignment || (importContext == JSImportPlaceInfo.ImportContext.SPECIFIER ? ES6ImportHandler.isExternalModuleExport(element) : ES6CreateImportUtil.isAvailableForImport((PsiElement)element, info));
    }

    @NotNull
    protected Collection<JSElement> removeOverloads(@NotNull Collection<? extends JSElement> candidates) {
        if (candidates == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(18);
        }
        List list2 = ContainerUtil.filter(candidates, el -> !ES6ExportedCandidatesProvider.isOverloadDeclaration(el));
        if (list2 == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(19);
        }
        return list2;
    }

    private void addExternalModuleNames(@NotNull String name, @NotNull List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(20);
        }
        if (candidates == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(21);
        }
        if (this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.BINDING) {
            return;
        }
        MultiMap modules = this.myAllRegularExternalModules;
        if (modules == null) {
            modules = MultiMap.create();
            PsiElement myContext = this.myPlaceInfo.getPlace();
            for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(myContext.getProject(), myContext)) {
                String rawName = module.getExternalModuleText();
                if (rawName == null) continue;
                String moduleName = StringUtil.unquoteString((String)rawName).toLowerCase(Locale.ENGLISH);
                modules.putValue((Object)moduleName, (Object)module);
            }
            this.myAllRegularExternalModules = modules;
        }
        candidates.addAll(modules.get((Object)name.toLowerCase(Locale.ENGLISH)));
    }

    private static boolean isOverloadDeclaration(@NotNull JSElement element) {
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(22);
        }
        return element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration();
    }

    @NotNull
    private List<JSImportCandidate> getProjectImports(@NotNull String referenceName) {
        if (referenceName == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(23);
        }
        if (this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER) {
            List<JSImportCandidate> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(24);
            }
            return list2;
        }
        PsiElement node = this.myPlaceInfo.getPlace();
        DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(node)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return super.contains(file2) && !NodeModuleUtil.hasNodeModulesDirInPath(file2, null) && (ES6ExportedCandidatesProvider.this.myModuleRootDirectory == null || VfsUtilCore.isAncestor((VirtualFile)ES6ExportedCandidatesProvider.this.myModuleRootDirectory, (VirtualFile)file2, (boolean)true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider$3", "contains"));
            }
        };
        Collection elements = StubIndex.getElements(ES6ImportDeclarationPartIndex.KEY, (Object)referenceName, (Project)node.getProject(), (GlobalSearchScope)scope, ES6ImportExportDeclarationPart.class);
        if (elements.size() == 0) {
            List<JSImportCandidate> list3 = Collections.emptyList();
            if (list3 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(25);
            }
            return list3;
        }
        SmartList objects = new SmartList();
        HashSet<Pair<JSImportExportType, String>> visited = new HashSet<Pair<JSImportExportType, String>>();
        for (ES6ImportExportDeclarationPart part : elements) {
            ES6ImportPsiUtil.ImportExportType type;
            ES6ImportExportDeclaration declaration = part.getDeclaration();
            String text = ES6ExportedCandidatesProvider.getModuleNameFromDeclaration(declaration, type = part instanceof ES6ImportedBinding ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER, visited);
            if (text == null) continue;
            ContainerUtil.addIfNotNull((Collection)objects, (Object)this.createImportCandidateForPart(referenceName, part, declaration, type, text));
        }
        SmartList smartList = objects;
        if (smartList == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(26);
        }
        return smartList;
    }

    @Nullable
    private JSImportCandidate createImportCandidateForPart(@NotNull String referenceName, @NotNull ES6ImportExportDeclarationPart element, @NotNull ES6ImportExportDeclaration declaration, @NotNull JSImportExportType type, @NotNull String text) {
        if (referenceName == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(27);
        }
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(28);
        }
        if (declaration == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(29);
        }
        if (type == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(30);
        }
        if (text == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(31);
        }
        PsiElement node = this.myPlaceInfo.getPlace();
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = declaration.getImportExportPrefixKind();
        Optional result2 = ((StreamEx)((StreamEx)StreamEx.of(ES6PsiUtil.expandElements(node, Collections.singleton(element))).select(JSElement.class).filter(el -> !ES6ExportedCandidatesProvider.isOverloadDeclaration(el))).filter(t -> this.myExportedFilter.test((JSElement)t) && t instanceof JSPsiElementBase && this.myPlaceFilter.isAcceptable((JSPsiElementBase)t))).findAny();
        if (result2.isPresent()) {
            final SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)((JSElement)result2.get()));
            return new JSImportCandidateDescriptor(JSImportCandidate.SourceType.ES6, StringUtil.unquoteString((String)text), referenceName, null, kind, type){

                @Override
                public JSElement getElement() {
                    return (JSElement)pointer.getElement();
                }

                @Override
                public int getPriority() {
                    return 2;
                }
            };
        }
        return null;
    }

    @Contract(value="null,_,_->null")
    private static String getModuleNameFromDeclaration(@Nullable ES6ImportExportDeclaration declaration, @NotNull JSImportExportType type, @NotNull Set<Pair<JSImportExportType, String>> visited) {
        ES6FromClause clause;
        if (type == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(32);
        }
        if (visited == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(33);
        }
        ES6FromClause eS6FromClause = clause = declaration != null ? declaration.getFromClause() : null;
        if (clause == null) {
            return null;
        }
        String text = clause.getReferenceText();
        if (text == null) {
            return null;
        }
        String unquoted = StringUtil.unquoteString((String)text);
        if (!visited.add((Pair<JSImportExportType, String>)Pair.create((Object)type, (Object)unquoted)) || JSModuleFileReferenceSet.isRelative(unquoted)) {
            return null;
        }
        Collection resolvedElements = clause.resolveReferencedElements();
        if (resolvedElements.size() == 0) {
            return null;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem((Collection)resolvedElements);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)item);
        if (file2 == null) {
            return null;
        }
        if (!NodeModuleUtil.hasNodeModulesDirInPath(file2, null)) {
            return null;
        }
        return text;
    }

    @Nullable
    private static VirtualFile getRoot(@NotNull JSImportPlaceInfo placeInfo) {
        VirtualFile directory;
        TypeScriptConfig file2;
        PsiElement place;
        if (placeInfo == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(34);
        }
        if (DialectDetector.isTypeScript(place = placeInfo.getPlace()) && (file2 = TypeScriptConfigUtil.getConfigForPsiFile(place.getContainingFile())) != null && VfsUtilCore.isAncestor((VirtualFile)(directory = file2.getConfigDirectory()), (VirtualFile)placeInfo.getFile(), (boolean)true)) {
            return directory;
        }
        return NodeModuleUtil.getMainModuleRoot(place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importContext";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedPackageJsonModules";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "removeOverloads";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCandidate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUseImport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addExportedDefaultAssignmentElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addExportedElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasNodeModulesInPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "needToCheckConfigAccess";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableForImport";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeOverloads";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addExternalModuleNames";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isOverloadDeclaration";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getProjectImports";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createImportCandidateForPart";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameFromDeclaration";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            return new ES6ExportedCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

