/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.ecmascript6.actions.ES6AddImportExecutor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportCandidate;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ES6ImportCandidate
extends JSSimpleImportCandidate {
    @NotNull
    private final NotNullLazyValue<List<JSImportDescriptor>> myValue;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> myPointer;
    @NotNull
    private final JSImportPlaceInfo.ImportContext myContext;

    public ES6ImportCandidate(@NotNull String name, @NotNull JSElement candidate, @NotNull PsiElement place) {
        if (name == null) {
            ES6ImportCandidate.$$$reportNull$$$0(0);
        }
        if (candidate == null) {
            ES6ImportCandidate.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ES6ImportCandidate.$$$reportNull$$$0(2);
        }
        this(name, candidate, place, JSImportPlaceInfo.ImportContext.SIMPLE, true);
    }

    public ES6ImportCandidate(@NotNull String name, @NotNull JSElement candidate, @NotNull PsiElement place, @NotNull JSImportPlaceInfo.ImportContext context, boolean useImport) {
        if (name == null) {
            ES6ImportCandidate.$$$reportNull$$$0(3);
        }
        if (candidate == null) {
            ES6ImportCandidate.$$$reportNull$$$0(4);
        }
        if (place == null) {
            ES6ImportCandidate.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ES6ImportCandidate.$$$reportNull$$$0(6);
        }
        super(name, candidate, JSImportCandidate.SourceType.ES6, useImport);
        this.myPointer = SmartPointerManager.createPointer((PsiElement)place);
        this.myContext = context;
        this.myValue = NotNullLazyValue.atomicLazy(() -> {
            JSElement element = this.getElement();
            PsiElement effectivePlace = this.myPointer.getElement();
            if (element == null || effectivePlace == null) {
                return Collections.emptyList();
            }
            ES6AddImportExecutor myExecutor = new ES6AddImportExecutor(null, effectivePlace);
            return myExecutor.createDescriptors(this.getName(), element, this.myContext);
        });
    }

    @Override
    @NotNull
    public List<JSImportDescriptor> getDescriptors() {
        List list2 = (List)this.myValue.getValue();
        if (list2 == null) {
            ES6ImportCandidate.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ES6ImportCandidate candidate = (ES6ImportCandidate)o;
        return this.myPointer.equals(candidate.myPointer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myPointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/ES6ImportCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/ES6ImportCandidate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

