/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagram;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSStructuralDiagramItem {
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    @Nls
    private final String myName;
    private final boolean myIsFile;
    private JSStructuralDiagramItem myParent;
    @NotNull
    private final List<JSStructuralDiagramItem> myUsedExported = new ArrayList<JSStructuralDiagramItem>();
    @NotNull
    private final Set<JSStructuralDiagramItem> myExported;
    private boolean myIsInScope;
    private Icon myIcon;

    public JSStructuralDiagramItem(@Nullable SmartPsiElementPointer<PsiElement> elementPointer, @Nls String name, boolean isFile) {
        this.myElementPointer = elementPointer;
        this.myName = name;
        this.myIsFile = isFile;
        this.myExported = new HashSet<JSStructuralDiagramItem>();
    }

    @Nullable
    public SmartPsiElementPointer<PsiElement> getElementPointer() {
        return this.myElementPointer;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    @NotNull
    public List<JSStructuralDiagramItem> getUsedExported() {
        List<JSStructuralDiagramItem> list2 = Collections.unmodifiableList(this.myUsedExported);
        if (list2 == null) {
            JSStructuralDiagramItem.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public void addImportedOrExported(@NotNull JSStructuralDiagramItem item, boolean exported) {
        if (item == null) {
            JSStructuralDiagramItem.$$$reportNull$$$0(1);
        }
        this.myUsedExported.add(item);
        if (exported) {
            this.myExported.add(item);
        }
        item.setParent(this);
    }

    public boolean isExported(@NotNull JSStructuralDiagramItem item) {
        if (item == null) {
            JSStructuralDiagramItem.$$$reportNull$$$0(2);
        }
        return this.myExported.contains(item);
    }

    public void sortExported() {
        if (this.myUsedExported.isEmpty()) {
            return;
        }
        TreeSet<JSStructuralDiagramItem> set = new TreeSet<JSStructuralDiagramItem>((o1, o2) -> Comparing.compare((Comparable)((Object)o1.myName), (Comparable)((Object)o2.myName)));
        set.addAll(this.myUsedExported);
        this.myUsedExported.clear();
        this.myUsedExported.addAll(set);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSStructuralDiagramItem item = (JSStructuralDiagramItem)o;
        if (this.myIsFile != item.myIsFile) {
            return false;
        }
        if (this.myIsInScope != item.myIsInScope) {
            return false;
        }
        if (this.myElementPointer != null ? !this.myElementPointer.equals(item.myElementPointer) : item.myElementPointer != null) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(item.myName) : item.myName != null) {
            return false;
        }
        if (this.myParent != null ? !this.myParent.equals(item.myParent) : item.myParent != null) {
            return false;
        }
        if (!this.myUsedExported.equals(item.myUsedExported)) {
            return false;
        }
        return !(this.myIcon != null ? !this.myIcon.equals(item.myIcon) : item.myIcon != null);
    }

    public int hashCode() {
        int result2 = this.myElementPointer != null ? this.myElementPointer.hashCode() : 0;
        result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
        result2 = 31 * result2 + (this.myIsFile ? 1 : 0);
        return result2;
    }

    public boolean isInScope() {
        return this.myIsInScope;
    }

    public JSStructuralDiagramItem setInScope(boolean inScope) {
        this.myIsInScope = inScope;
        return this;
    }

    public JSStructuralDiagramItem getParent() {
        return this.myParent;
    }

    public JSStructuralDiagramItem setParent(JSStructuralDiagramItem parent) {
        this.myParent = parent;
        return this;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSStructuralDiagramItem";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedExported";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSStructuralDiagramItem";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addImportedOrExported";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

