/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInstaller
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(PackageInstaller.class);
    @NotNull
    private final NodeJsInterpreter myInterpreter;
    @NotNull
    private final String myPackageName;
    @Nullable
    private final String myVersion;
    @NotNull
    private final File myWorkingDir;
    @NotNull
    private final PackageManagementService.Listener myListener;
    @Nullable
    private final String myExtraOptions;
    @Nullable
    private @NlsContexts.DetailedDescription String myError;

    public PackageInstaller(@Nullable Project project, @NotNull NodeJsInterpreter interpreter, @NotNull String packageName, @Nullable String version, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener2, @Nullable String extraOptions) {
        if (interpreter == null) {
            PackageInstaller.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            PackageInstaller.$$$reportNull$$$0(1);
        }
        if (workingDir == null) {
            PackageInstaller.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            PackageInstaller.$$$reportNull$$$0(3);
        }
        super(project, JavaScriptBundle.message((String)"progress.title.install.npm.module", (Object[])new Object[]{packageName}), false);
        this.myInterpreter = interpreter;
        this.myPackageName = packageName;
        this.myVersion = version;
        this.myWorkingDir = workingDir;
        this.myListener = listener2;
        this.myExtraOptions = extraOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final @Nullable ProgressIndicator indicator) {
        GeneralCommandLine commandLine;
        Object packageAndVersion = this.myPackageName;
        if (this.myVersion != null) {
            packageAndVersion = (String)packageAndVersion + "@" + this.myVersion;
        }
        ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{packageAndVersion});
        if (this.myExtraOptions != null) {
            Collections.addAll(args, this.myExtraOptions.split(" +"));
        }
        if ((commandLine = (GeneralCommandLine)PackageInstaller.computeAndReportIfFailed(this.myListener, this.myPackageName, () -> NpmUtil.createNpmCommandLine(this.myProject, this.myWorkingDir, this.myInterpreter, NpmCommand.ADD, (List<String>)args))) == null) {
            return;
        }
        if (indicator != null) {
            indicator.pushState();
        }
        try {
            ProcessOutput output;
            this.myListener.operationStarted(this.myPackageName);
            KillableColoredProcessHandler processHandler = NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, false);
            CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
            if (indicator != null) {
                NodePackageRef npmPkgRef = this.myProject != null ? NpmManager.getInstance(this.myProject).getPackageRef() : NodePackageRef.create("npm");
                indicator.setText(JavaScriptBundle.message((String)"progress.subtitle.install", (Object[])new Object[]{packageAndVersion, NpmManager.getNpmPackagePresentableName(npmPkgRef)}));
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        String line;
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (ProcessOutputType.isStdout((Key)outputType) && (line = (String)ArrayUtil.getLastElement((Object[])StringUtil.splitByLines((String)event.getText(), (boolean)true))) != null) {
                            indicator.setText2(line.trim());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/modules/PackageInstaller$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            if ((output = runner.runProcess(EmptyProgressIndicator.notNullize((ProgressIndicator)indicator))).getExitCode() != 0) {
                this.myError = NodeCommandLineUtil.formatErrorMessage(commandLine, output);
            }
        }
        catch (ExecutionException e) {
            this.myError = e.getMessage();
        }
        finally {
            if (indicator != null) {
                indicator.popState();
            }
            this.myListener.operationFinished(this.myPackageName, PackageManagementService.ErrorDescription.fromMessage((String)this.myError));
            LocalFileSystem.getInstance().refresh(true);
        }
    }

    @Nullable
    public static <T, E extends Exception> T computeAndReportIfFailed(@NotNull PackageManagementService.Listener listener2, @NotNull String packageName, @NotNull ThrowableComputable<T, E> computable) {
        if (listener2 == null) {
            PackageInstaller.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            PackageInstaller.$$$reportNull$$$0(5);
        }
        if (computable == null) {
            PackageInstaller.$$$reportNull$$$0(6);
        }
        try {
            return (T)computable.compute();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            listener2.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)e.getMessage()));
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/PackageInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAndReportIfFailed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Component
    implements NpmPackageInstallerLight {
        @Override
        public void installPackage(@Nullable Project project, @NotNull NodeJsInterpreter localInterpreter, @NotNull String packageName, @Nullable String version, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener2, @Nullable String extraOptions) {
            if (localInterpreter == null) {
                Component.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                Component.$$$reportNull$$$0(1);
            }
            if (workingDir == null) {
                Component.$$$reportNull$$$0(2);
            }
            if (listener2 == null) {
                Component.$$$reportNull$$$0(3);
            }
            ProgressManager.getInstance().run((Task)new PackageInstaller(project, localInterpreter, packageName, version, workingDir, listener2, extraOptions));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localInterpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/PackageInstaller$Component";
            objectArray[2] = "installPackage";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

