/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSModuleNameInfoImpl
implements JSModuleNameInfo,
JSModuleDescriptor {
    @Nullable
    private final VirtualFile myModule;
    @NotNull
    private final VirtualFile myResolvedFile;
    @NotNull
    private final String myModuleName;
    private final SmartPsiElementPointer<PsiElement> myModulePsi;

    @NotNull
    private static JSModuleNameInfo.ExtensionSettings toSettings(boolean forceExtension) {
        JSModuleNameInfo.ExtensionSettings extensionSettings = forceExtension ? JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION : JSModuleNameInfo.ExtensionSettings.CODE_STYLE;
        if (extensionSettings == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(0);
        }
        return extensionSettings;
    }

    public JSModuleNameInfoImpl(@Nullable String unquotedModuleName, @Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull PsiElement place, String @NotNull [] extensions, boolean forceExtension) {
        if (resolvedFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(2);
        }
        if (extensions == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(3);
        }
        this(unquotedModuleName, moduleFileOrDirectory, resolvedFile, place, extensions, JSModuleNameInfoImpl.toSettings(forceExtension));
    }

    public JSModuleNameInfoImpl(@Nullable String unquotedModuleName, @NotNull VirtualFile module, @NotNull PsiElement place) {
        if (module == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(5);
        }
        this(unquotedModuleName, module, module, place, JSFileReference.IMPLICIT_EXTENSIONS, JSModuleNameInfo.ExtensionSettings.CODE_STYLE);
    }

    public JSModuleNameInfoImpl(@Nullable String unquotedModuleName, @Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull PsiElement place, String @NotNull [] extensions, @NotNull JSModuleNameInfo.ExtensionSettings pathSettings) {
        if (resolvedFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(7);
        }
        if (pathSettings == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(8);
        }
        if (extensions == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(9);
        }
        this.myModuleName = pathSettings == JSModuleNameInfo.ExtensionSettings.EXACT ? StringUtil.notNullize((String)unquotedModuleName) : JSModuleNameInfoImpl.getModuleName(unquotedModuleName, moduleFileOrDirectory, place, extensions, pathSettings);
        this.myModule = moduleFileOrDirectory;
        this.myResolvedFile = resolvedFile;
        PsiFile psiFile = place.getManager().findFile(moduleFileOrDirectory == null || moduleFileOrDirectory.isDirectory() ? resolvedFile : moduleFileOrDirectory);
        this.myModulePsi = psiFile != null ? SmartPointerManager.createPointer((PsiElement)psiFile) : null;
    }

    @NotNull
    public static String getModuleName(@Nullable String path, @Nullable VirtualFile moduleFileOrDirectory, @NotNull PsiElement place) {
        if (place == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(10);
        }
        return JSModuleNameInfoImpl.getModuleName(path, moduleFileOrDirectory, place, JSFileReference.IMPLICIT_EXTENSIONS, JSModuleNameInfo.ExtensionSettings.CODE_STYLE);
    }

    @NotNull
    public static String getModuleName(@Nullable String path, @Nullable VirtualFile moduleFileOrDirectory, @NotNull PsiElement place, String @NotNull [] extensions, @NotNull JSModuleNameInfo.ExtensionSettings pathSettings) {
        String extensionWithDot;
        if (place == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(11);
        }
        if (pathSettings == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(12);
        }
        if (extensions == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)path)) {
            return "";
        }
        if (pathSettings == JSModuleNameInfo.ExtensionSettings.EXACT) {
            String string = path;
            if (string == null) {
                JSModuleNameInfoImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        boolean isFile = moduleFileOrDirectory == null || !moduleFileOrDirectory.isDirectory();
        String string = extensionWithDot = isFile && (moduleFileOrDirectory == null || path.endsWith(moduleFileOrDirectory.getName())) ? JSFileReference.findExtension(path, extensions) : null;
        if (extensionWithDot == null) {
            String string2 = path;
            if (string2 == null) {
                JSModuleNameInfoImpl.$$$reportNull$$$0(15);
            }
            return string2;
        }
        if (pathSettings == JSModuleNameInfo.ExtensionSettings.CODE_STYLE) {
            pathSettings = TypeScriptImportsResolverProvider.getPathSettings(place, extensionWithDot);
        }
        if (pathSettings == JSModuleNameInfo.ExtensionSettings.FORCE_JS_EXTENSION) {
            String string3 = StringUtil.trimEnd((String)path, (String)extensionWithDot) + ".js";
            if (string3 == null) {
                JSModuleNameInfoImpl.$$$reportNull$$$0(16);
            }
            return string3;
        }
        String string4 = pathSettings == JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION ? path : StringUtil.trimEnd((String)path, (String)extensionWithDot);
        if (string4 == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(17);
        }
        return string4;
    }

    @Override
    public boolean isValid() {
        return !StringUtil.isEmpty((String)this.myModuleName);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getModuleFileOrDirectory() {
        VirtualFile virtualFile = this.myModule == null ? this.getResolvedFile() : this.myModule;
        if (virtualFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(19);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public PsiElement getModule() {
        return this.myModulePsi != null ? this.myModulePsi.getElement() : null;
    }

    @Override
    @NotNull
    public VirtualFile getResolvedFile() {
        VirtualFile virtualFile = this.myResolvedFile;
        if (virtualFile == null) {
            JSModuleNameInfoImpl.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    public String toString() {
        return "\"" + this.getModuleName() + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSModuleNameInfoImpl info = (JSModuleNameInfoImpl)o;
        return Objects.equals(this.myModule, info.myModule) && this.myResolvedFile.equals(info.myResolvedFile) && this.myModuleName.equals(info.myModuleName);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myResolvedFile, this.myModuleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleNameInfoImpl";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleNameInfoImpl";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFileOrDirectory";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

