/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.ImportES6ModuleFix;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.node.ImportNodeJsModuleFix;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.validation.fixes.ES6ImportFix;
import com.intellij.lang.javascript.validation.fixes.JSRequireFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportModulesSuggester
implements JsModulesSuggester {
    @NotNull
    protected final Set<VirtualFile> myPredefinedFiles;
    @NotNull
    protected final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    protected final PsiElement myNode;

    public JSImportModulesSuggester(@NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull PsiElement node) {
        if (moduleReferenceInfo == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(1);
        }
        this.myPredefinedFiles = JsModulesSuggester.getPredefinedLibraries(node);
        this.myModuleReferenceInfo = moduleReferenceInfo;
        this.myNode = node;
    }

    @Override
    public boolean isResolvedGlobally(@NotNull ResolveResult result2) {
        if (result2 == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(2);
        }
        return NodeModuleUtil.isResolvedGloballyCommonJS(result2, this.myPredefinedFiles);
    }

    @NotNull
    protected List<? extends JSImportCandidate> find(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(3);
        }
        List<? extends JSImportCandidate> list2 = new NodeJSModulesSearcher(this.myModuleReferenceInfo, this.myNode, resolveResults, this.myPredefinedFiles).find();
        if (list2 == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<LocalQuickFix> findFixes(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(5);
        }
        if (NodeModuleUtil.isWrappedInAmdDefinition(this.myNode)) {
            List<LocalQuickFix> list2 = Collections.emptyList();
            if (list2 == null) {
                JSImportModulesSuggester.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<? extends JSImportCandidate> descriptors = this.find(resolveResults);
        if (descriptors.isEmpty()) {
            List<LocalQuickFix> list3 = Collections.emptyList();
            if (list3 == null) {
                JSImportModulesSuggester.$$$reportNull$$$0(7);
            }
            return list3;
        }
        List es6Fixes = this.isAvailableForES6Import() ? this.toES6Fixes(descriptors) : Collections.emptyList();
        List nodeFixes = this.isAvailableForRequireImport(resolveResults) ? this.toNodeFixes(descriptors) : Collections.emptyList();
        JSFile.ModuleStatus status = JSImportModulesSuggester.detectResolveModuleKind(this.myNode, resolveResults);
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        if (status == JSFile.ModuleStatus.COMMONJS) {
            result2.addAll(nodeFixes);
            result2.addAll(es6Fixes);
        } else {
            result2.addAll(es6Fixes);
            result2.addAll(nodeFixes);
        }
        ArrayList<LocalQuickFix> arrayList = result2;
        if (arrayList == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private List<LocalQuickFix> toES6Fixes(@NotNull List<? extends JSImportCandidate> descriptors) {
        if (descriptors == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(9);
        }
        return this.createFixes(descriptors, (node, candidate, tail, needHint) -> new ImportES6ModuleFix(node, candidate, tail, needHint));
    }

    @NotNull
    private List<LocalQuickFix> toNodeFixes(@NotNull List<? extends JSImportCandidate> descriptors) {
        if (descriptors == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(10);
        }
        return this.createFixes(descriptors, (node, candidate, tail, needHint) -> new ImportNodeJsModuleFix(node, candidate, tail));
    }

    protected boolean isAvailableForES6Import() {
        PsiFile file2 = this.myNode.getContainingFile();
        String extension = FileUtilRt.getExtension((String)file2.getName());
        return !"cjs".equals(extension) && DialectDetector.isES6(this.myNode);
    }

    @Override
    @Nullable
    public String getMessage(@NotNull Collection<LocalQuickFix> fixes) {
        if (fixes == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(11);
        }
        for (LocalQuickFix fix : fixes) {
            if (fix instanceof ES6ImportFix) {
                return JavaScriptBundle.message((String)"js.inspection.missing.import", (Object[])new Object[0]);
            }
            if (!(fix instanceof JSRequireFix)) continue;
            return JavaScriptBundle.message((String)"node.js.missing.require", (Object[])new Object[0]);
        }
        return null;
    }

    @NotNull
    private List<LocalQuickFix> createFixes(@NotNull List<? extends JSImportCandidate> candidates, @NotNull FixFactory factory) {
        if (candidates == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(12);
        }
        if (factory == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(13);
        }
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        boolean hint = candidates.size() == 1 && this.myModuleReferenceInfo.needHint();
        for (JSImportCandidate jSImportCandidate : candidates) {
            ContainerUtil.addIfNotNull(result2, (Object)factory.create(this.myNode, jSImportCandidate, null, hint));
        }
        PsiElement parent = this.myModuleReferenceInfo.getParentRef();
        String string = this.myModuleReferenceInfo.getParentName();
        if (parent != null && string != null) {
            this.addTailCandidates(candidates, factory, result2, parent, string);
        }
        ArrayList<LocalQuickFix> arrayList = result2;
        if (arrayList == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private void addTailCandidates(@NotNull List<? extends JSImportCandidate> descriptors, @NotNull FixFactory factory, @NotNull List<LocalQuickFix> result2, @NotNull PsiElement parent, @NotNull String name) {
        if (descriptors == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(15);
        }
        if (factory == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(18);
        }
        if (name == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(19);
        }
        Project project = this.myNode.getProject();
        for (JSImportCandidate jSImportCandidate : descriptors) {
            JSImportExportType type;
            JSImportDescriptor descriptor2 = jSImportCandidate.getSingleDescriptorOrNull();
            if (descriptor2 == null || (type = descriptor2.getImportType()).isSpecifier() || this.myModuleReferenceInfo.getContext() == JSContext.INSTANCE) continue;
            JSPlaceTail tail = new JSPlaceTail((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(parent), new String[]{name});
            VirtualFile file2 = jSImportCandidate.getElementFile();
            if (file2 == null) continue;
            JSModuleDescriptor moduleDescriptor = descriptor2.getModuleDescriptor();
            JSImportCandidateDescriptor newDescriptor = new JSImportCandidateDescriptor(jSImportCandidate.getSourceType(), moduleDescriptor, name, name, descriptor2.getImportExportPrefixKind(), (JSImportExportType)ES6ImportPsiUtil.ImportExportType.SPECIFIER);
            ContainerUtil.addIfNotNull(result2, (Object)factory.create(parent, newDescriptor, tail, false));
        }
    }

    @NotNull
    private static JSFile.ModuleStatus detectResolveModuleKind(@NotNull PsiElement node, ResolveResult @NotNull [] resolveResults) {
        PsiElement module;
        if (node == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(20);
        }
        if (resolveResults == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(21);
        }
        if ((module = ES6PsiUtil.findExternalModule(node)) != null) {
            if (!(module instanceof JSFile)) {
                JSFile.ModuleStatus moduleStatus = JSFile.ModuleStatus.ES6;
                if (moduleStatus == null) {
                    JSImportModulesSuggester.$$$reportNull$$$0(22);
                }
                return moduleStatus;
            }
            JSFile file2 = (JSFile)module;
            JSFile.ModuleStatus status = file2.getModuleStatus();
            if (status == JSFile.ModuleStatus.ES6) {
                JSFile.ModuleStatus moduleStatus = JSFile.ModuleStatus.ES6;
                if (moduleStatus == null) {
                    JSImportModulesSuggester.$$$reportNull$$$0(23);
                }
                return moduleStatus;
            }
            if (status == JSFile.ModuleStatus.COMMONJS) {
                JSFile.ModuleStatus moduleStatus = JSFile.ModuleStatus.COMMONJS;
                if (moduleStatus == null) {
                    JSImportModulesSuggester.$$$reportNull$$$0(24);
                }
                return moduleStatus;
            }
        }
        if (resolveResults.length != 1) {
            JSFile.ModuleStatus moduleStatus = JSFile.ModuleStatus.NONE;
            if (moduleStatus == null) {
                JSImportModulesSuggester.$$$reportNull$$$0(25);
            }
            return moduleStatus;
        }
        PsiElement element = resolveResults[0].getElement();
        if (element == null) {
            JSFile.ModuleStatus moduleStatus = JSFile.ModuleStatus.NONE;
            if (moduleStatus == null) {
                JSImportModulesSuggester.$$$reportNull$$$0(26);
            }
            return moduleStatus;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        if (jsFile == null) {
            JSFile.ModuleStatus moduleStatus = JSFile.ModuleStatus.NONE;
            if (moduleStatus == null) {
                JSImportModulesSuggester.$$$reportNull$$$0(27);
            }
            return moduleStatus;
        }
        JSFile.ModuleStatus moduleStatus = jsFile.getModuleStatus();
        if (moduleStatus == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(28);
        }
        return moduleStatus;
    }

    private boolean isAvailableForRequireImport(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(29);
        }
        if (!(this.myNode instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement module = ES6PsiUtil.findExternalModule(this.myNode);
        if (DialectDetector.isJavaScript(this.myNode) && !DialectDetector.isES6(this.myNode) && JSImportModulesSuggester.isImportRequired(resolveResults)) {
            return true;
        }
        if (module != null) {
            return false;
        }
        JSFile file2 = (JSFile)ObjectUtils.tryCast((Object)this.myNode.getContainingFile(), JSFile.class);
        if (file2 == null) {
            return true;
        }
        String extension = FileUtilRt.getExtension((String)file2.getName());
        if ("mjs".equals(extension)) {
            return false;
        }
        JSFile.ModuleStatus status = file2.getModuleStatus();
        return status == JSFile.ModuleStatus.NONE || status == JSFile.ModuleStatus.COMMONJS;
    }

    private static boolean isImportRequired(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(30);
        }
        if (resolveResults.length > 0 && resolveResults[0] instanceof JSResolveResult) {
            return ((JSResolveResult)resolveResults[0]).getResolveProblemKey() == "javascript.element.need.to.be.imported";
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: 
            case 21: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportModulesSuggester";
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportModulesSuggester";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findFixes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "detectResolveModuleKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedGlobally";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFixes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toES6Fixes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toNodeFixes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addTailCandidates";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "detectResolveModuleKind";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForRequireImport";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isImportRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface FixFactory {
        @Nullable
        public LocalQuickFix create(@NotNull PsiElement var1, @NotNull JSImportCandidate var2, @Nullable JSPlaceTail var3, boolean var4);
    }
}

