/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.jshint.EditValueDialog;
import com.intellij.lang.javascript.linter.jshint.JSHintDocumentation;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionGroup;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.JSHintTreeCellRenderer;
import com.intellij.lang.javascript.linter.jshint.JSHintTreeNode;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintOptionsTreeView {
    @NonNls
    private static final String EMPTY_HTML = "<html><body></body></html>";
    @NonNls
    private static final String TREE_SCROLL_BAR_HORIZONTAL = "JSHintOptionsTreeView.TREE_SCROLL_BAR_HORIZONTAL";
    @NonNls
    private static final String TREE_SCROLL_BAR_VERTICAL = "JSHintOptionsTreeView.TREE_SCROLL_BAR_VERTICAL";
    @NonNls
    private static final String TREE_SELECTED_NODE_ID = "JSHintOptionsTreeView.TREE_SELECTED_NODE_ID";
    private static final float DEFAULT_PROPORTION = 0.7f;
    private JEditorPane myBrowser;
    private final CheckedTreeNode myRoot = new CheckedTreeNode(null);
    private final JPanel myMainPanel = this.createMainPanel();
    private Splitter myMainSplitter;
    private boolean myDisposed = false;
    private Map<JSHintOption, JSHintTreeNode> myNodeByOptionMap;
    private JSHintOptionsState myPrevFiredOptionsState;
    private boolean mySettingOptionsInProgress;
    private JScrollPane myTreeScrollPane;
    private Tree myTree;

    public JSHintOptionsTreeView(boolean fullModeDialog) {
        JBDimension preferredSize = fullModeDialog ? JBUI.size((int)800, (int)600) : JBUI.size((int)400, (int)300);
        this.myMainPanel.setPreferredSize((Dimension)preferredSize);
    }

    public Component getComponent() {
        return this.myMainPanel;
    }

    private JPanel createMainPanel() {
        JScrollPane treeScrollPane;
        this.myBrowser = JSHintOptionsTreeView.createBrowser();
        JPanel descriptionPanel = JSHintOptionsTreeView.createDescriptionPanel(this.myBrowser);
        JPanel treePanel = new JPanel(new BorderLayout());
        this.myTreeScrollPane = treeScrollPane = this.createTreeScrollPane();
        treePanel.add((Component)treeScrollPane, "Center");
        this.myMainSplitter = new JBSplitter("JSHintOptionsTreeView.MAIN_DIVIDER_PROPORTION", 0.7f);
        this.myMainSplitter.setFirstComponent((JComponent)treePanel);
        this.myMainSplitter.setSecondComponent((JComponent)descriptionPanel);
        this.myMainSplitter.setHonorComponentsMinimumSize(false);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myMainSplitter, "Center");
        return panel2;
    }

    private JScrollPane createTreeScrollPane() {
        JSHintTreeCellRenderer treeCellRenderer = new JSHintTreeCellRenderer();
        CheckboxTree tree = new CheckboxTree(treeCellRenderer, this.myRoot){
            private boolean myGroupNodeTriggered;
            {
                this.myGroupNodeTriggered = false;
            }

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, o -> {
                    JSHintTreeNode node = (JSHintTreeNode)((Object)((Object)o.getLastPathComponent()));
                    JSHintOption option = node.getUserDataAsOption();
                    if (option != null) {
                        return option.getShortDescription() + " " + option.getKey();
                    }
                    return node.getTitle();
                });
            }

            protected void onNodeStateChanged(CheckedTreeNode ctNode) {
                if (ctNode == JSHintOptionsTreeView.this.myRoot) {
                    return;
                }
                JSHintTreeNode node = (JSHintTreeNode)((Object)ObjectUtils.tryCast((Object)ctNode, JSHintTreeNode.class));
                if (node == null) {
                    return;
                }
                if (node.getUserDataAsOptionGroup() != null) {
                    this.myGroupNodeTriggered = true;
                    SwingUtilities.invokeLater(() -> {
                        this.myGroupNodeTriggered = false;
                        JSHintOptionsTreeView.this.onOptionsStateChanged();
                    });
                } else if (!this.myGroupNodeTriggered) {
                    JSHintOptionsTreeView.this.onOptionsStateChanged();
                }
            }

            public void scrollRectToVisible(Rectangle aRect) {
                if (JSHintOptionsTreeView.this.myTreeScrollPane != null) {
                    Point viewPosition = JSHintOptionsTreeView.this.myTreeScrollPane.getViewport().getViewPosition();
                    aRect.x = viewPosition.x;
                }
                super.scrollRectToVisible(aRect);
            }
        };
        this.myTree = tree;
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JSHintTreeNode node = (JSHintTreeNode)((Object)e.getPath().getLastPathComponent());
                if (node != null) {
                    HintHint hintHint = new HintHint((Component)JSHintOptionsTreeView.this.myBrowser, new Point(0, 0));
                    hintHint.setFont(JSHintOptionsTreeView.this.myBrowser.getFont());
                    String resultHtml = HintUtil.prepareHintText((String)node.getDescription(), (HintHint)hintHint);
                    JSHintOptionsTreeView.this.myBrowser.setText(resultHtml);
                }
            }
        });
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        tree.setSelectionModel((TreeSelectionModel)new DefaultTreeSelectionModel());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.myNodeByOptionMap = JSHintOptionsTreeView.addTreeNodes((Tree)tree);
        TreeUtil.expandAll((JTree)tree);
        TreeNode selectedNode = this.selectInitialNode((Tree)tree, this.myRoot.getChildAt(0));
        this.doInitialScrolling((Tree)tree, scrollPane, selectedNode);
        this.installSetLinkSupport((Tree)tree, treeCellRenderer);
        return scrollPane;
    }

    @NotNull
    private TreeNode selectInitialNode(@NotNull Tree tree, @NotNull TreeNode defaultNodeToSelect) {
        if (tree == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(0);
        }
        if (defaultNodeToSelect == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(1);
        }
        int selectedNodeId = StringUtil.parseInt((String)PropertiesComponent.getInstance().getValue(TREE_SELECTED_NODE_ID), (int)-1);
        TreeNode nodeToSelect = null;
        if (selectedNodeId != -1) {
            nodeToSelect = JSHintOptionsTreeView.findNodeByIdRec((TreeNode)this.myRoot, selectedNodeId, new AtomicInteger(0));
        }
        if (nodeToSelect == null) {
            nodeToSelect = defaultNodeToSelect;
        }
        tree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)nodeToSelect));
        TreeNode treeNode = nodeToSelect;
        if (treeNode == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(2);
        }
        return treeNode;
    }

    private void doInitialScrolling(@NotNull Tree tree, @NotNull JScrollPane scrollPane, @NotNull TreeNode selectedNode) {
        if (tree == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(3);
        }
        if (scrollPane == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(4);
        }
        if (selectedNode == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(5);
        }
        int verticalScrollValue = StringUtil.parseInt((String)PropertiesComponent.getInstance().getValue(TREE_SCROLL_BAR_VERTICAL), (int)-1);
        int horizontalScrollValue = StringUtil.parseInt((String)PropertiesComponent.getInstance().getValue(TREE_SCROLL_BAR_HORIZONTAL), (int)-1);
        TreePath selectedPath = TreeUtil.getPathFromRoot((TreeNode)selectedNode);
        if (verticalScrollValue != -1 && horizontalScrollValue != -1) {
            scrollPane.getViewport().setViewPosition(new Point(horizontalScrollValue, verticalScrollValue));
            return;
        }
        Rectangle bounds = tree.getPathBounds(selectedPath);
        Rectangle indentBounds = tree.getPathBounds(TreeUtil.getPathFromRoot((TreeNode)this.myRoot.getChildAt(0)));
        if (bounds != null) {
            if (indentBounds != null) {
                bounds.x = indentBounds.x;
            }
            tree.scrollRectToVisible(bounds);
        }
    }

    private void installSetLinkSupport(final @NotNull Tree tree, final @NotNull JSHintTreeCellRenderer cellRenderer) {
        if (tree == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(6);
        }
        if (cellRenderer == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(7);
        }
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                JSHintOption option;
                JSHintTreeNode node;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((node = JSHintOptionsTreeView.findNodeOfEditLink(tree, cellRenderer, e.getPoint())) != null && (option = node.getUserDataAsOption()) != null) {
                    node.setMouseInside(false);
                    EditValueDialog dialog = new EditValueDialog(JSHintOptionsTreeView.this.myMainPanel, node.getTitle(), option, node.getValue());
                    boolean isOK = dialog.showAndGet();
                    if (isOK) {
                        node.setValue(dialog.getValue());
                        JSHintOptionsTreeView.this.onOptionsStateChanged();
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/linter/jshint/JSHintOptionsTreeView$3", "onClick"));
            }
        }.installOn((Component)tree);
        tree.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){
            private final Cursor myOriginalCursor;
            private final Cursor myHandCursor;
            private JSHintTreeNode myPrevNode;
            {
                this.myOriginalCursor = tree.getCursor();
                this.myHandCursor = Cursor.getPredefinedCursor(12);
                this.myPrevNode = null;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JSHintTreeNode node = JSHintOptionsTreeView.findNodeOfEditLink(tree, cellRenderer, e.getPoint());
                Cursor newCursor = node == null ? this.myOriginalCursor : this.myHandCursor;
                Cursor currentCursor = tree.getCursor();
                if (!currentCursor.equals(newCursor)) {
                    tree.setCursor(newCursor);
                }
                if (this.myPrevNode != null) {
                    this.myPrevNode.setMouseInside(false);
                    tree.setToolTipText(null);
                }
                if (node != null) {
                    node.setMouseInside(true);
                    tree.setToolTipText(JavaScriptBundle.message((String)"jshint.options.tree.tooltip.set.a.new.value", (Object[])new Object[0]));
                }
                this.myPrevNode = node;
            }
        });
    }

    @Nullable
    private static JSHintTreeNode findNodeOfEditLink(@NotNull Tree tree, @NotNull JSHintTreeCellRenderer cellRenderer, @NotNull Point mousePoint) {
        int row;
        if (tree == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(8);
        }
        if (cellRenderer == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(9);
        }
        if (mousePoint == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(10);
        }
        if ((row = tree.getRowForLocation(mousePoint.x, mousePoint.y)) < 0) {
            return null;
        }
        Object o = tree.getPathForRow(row).getLastPathComponent();
        JSHintTreeNode node = (JSHintTreeNode)((Object)ObjectUtils.tryCast((Object)o, JSHintTreeNode.class));
        if (node == null) {
            return null;
        }
        if (!node.isEditLinkNeeded() || !node.isEnabled()) {
            return null;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        Point relativeToRow = new Point(mousePoint);
        relativeToRow.translate(-rowBounds.x, -rowBounds.y);
        if (cellRenderer.isPointInsideEditLink(node, relativeToRow)) {
            return node;
        }
        return null;
    }

    private void onOptionsStateChanged() {
        JSHintOptionsState newOptionsState;
        if (this.mySettingOptionsInProgress && !(newOptionsState = this.getOptionsState()).equals(this.myPrevFiredOptionsState)) {
            this.myPrevFiredOptionsState = newOptionsState;
        }
    }

    private static Map<JSHintOption, JSHintTreeNode> addTreeNodes(@NotNull Tree tree) {
        if (tree == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(11);
        }
        CheckedTreeNode root = (CheckedTreeNode)tree.getModel().getRoot();
        root.removeAllChildren();
        HashMap<JSHintOption, JSHintTreeNode> map2 = new HashMap<JSHintOption, JSHintTreeNode>();
        EnumSet<JSHintOption> unhandledOptions = EnumSet.allOf(JSHintOption.class);
        JSHintDocumentation documentation = JSHintDocumentation.getInstance();
        for (JSHintOptionGroup group : documentation.getGroups()) {
            JSHintTreeNode titleNode = new JSHintTreeNode(tree, group);
            titleNode.setAllowsChildren(true);
            root.add((MutableTreeNode)((Object)titleNode));
            ArrayList<JSHintOption> options = new ArrayList<JSHintOption>(group.getOptions());
            options.sort(Comparator.naturalOrder());
            for (JSHintOption option : options) {
                String description = group.getHtmlDescriptionByOption(option);
                description = StringUtil.notNullize((String)description);
                unhandledOptions.remove(option);
                JSHintTreeNode optionNode = new JSHintTreeNode(tree, option, description);
                optionNode.setAllowsChildren(false);
                map2.put(option, optionNode);
                titleNode.add((MutableTreeNode)((Object)optionNode));
            }
        }
        for (JSHintOption option : unhandledOptions) {
            String htmlDescription = documentation.getHtmlDescriptionForNonGroupOption(option);
            htmlDescription = StringUtil.notNullize((String)htmlDescription);
            JSHintTreeNode titleNode = new JSHintTreeNode(tree, option, htmlDescription);
            titleNode.setAllowsChildren(true);
            root.add((MutableTreeNode)((Object)titleNode));
            map2.put(option, titleNode);
        }
        return map2;
    }

    private static JEditorPane createBrowser() {
        JEditorPane browser = JSHintUtil.createReadonlyBrowser("text/html", EMPTY_HTML);
        browser.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)5, (int)5));
        browser.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        return browser;
    }

    private static JPanel createDescriptionPanel(@NotNull JEditorPane browser) {
        if (browser == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(12);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)browser);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaScriptBundle.message((String)"border.title.inspection.description.title", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insets((int)8, (int)0, (int)0, (int)0)).setShowLine(false));
        descriptionPanel.add((Component)scrollPane, "Center");
        return descriptionPanel;
    }

    private void applyOptionsState(@NotNull JSHintOptionsState optionsState) {
        if (optionsState == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(13);
        }
        for (Map.Entry<JSHintOption, JSHintTreeNode> entry : this.myNodeByOptionMap.entrySet()) {
            JSHintOption option = entry.getKey();
            JSHintTreeNode node = entry.getValue();
            if (OptionTypes.isBooleanOption(option)) {
                boolean checked = Boolean.TRUE == optionsState.getValue(option);
                node.setChecked(checked);
                continue;
            }
            Object value = optionsState.getValue(option);
            node.setValue(value);
        }
    }

    @NotNull
    private JSHintOptionsState createState() {
        JSHintOptionsState.Builder builder = new JSHintOptionsState.Builder();
        for (Map.Entry<JSHintOption, JSHintTreeNode> entry : this.myNodeByOptionMap.entrySet()) {
            JSHintOption option = entry.getKey();
            JSHintTreeNode node = entry.getValue();
            if (OptionTypes.isBooleanOption(option)) {
                builder.put(option, (Object)node.isChecked());
                continue;
            }
            builder.put(option, node.getValue());
        }
        JSHintOptionsState jSHintOptionsState = builder.build();
        if (jSHintOptionsState == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(14);
        }
        return jSHintOptionsState;
    }

    public void disposeUI() {
        if (!this.myDisposed) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            Point viewPosition = this.myTreeScrollPane.getViewport().getViewPosition();
            properties.setValue(TREE_SCROLL_BAR_HORIZONTAL, (int)viewPosition.getX(), -1);
            properties.setValue(TREE_SCROLL_BAR_VERTICAL, (int)viewPosition.getY(), -1);
            properties.setValue(TREE_SELECTED_NODE_ID, this.getSelectedNodeId(), -1);
        }
        this.myDisposed = true;
    }

    private int getSelectedNodeId() {
        TreePath selectedPath = this.myTree.getSelectionPath();
        TreeNode selectedNode = (TreeNode)ObjectUtils.tryCast((Object)selectedPath.getLastPathComponent(), TreeNode.class);
        if (selectedNode == null) {
            return -1;
        }
        return JSHintOptionsTreeView.assignIdToPath((TreeNode)this.myRoot, selectedNode, new AtomicInteger(0));
    }

    private static TreeNode findNodeByIdRec(@NotNull TreeNode node, int id, @NotNull AtomicInteger size) {
        if (node == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(15);
        }
        if (size == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(16);
        }
        if (id == size.get()) {
            return node;
        }
        size.incrementAndGet();
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TreeNode child = node.getChildAt(i);
            TreeNode found = JSHintOptionsTreeView.findNodeByIdRec(child, id, size);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static int assignIdToPath(@NotNull TreeNode treeNode, @NotNull TreeNode selectedNode, @NotNull AtomicInteger size) {
        if (treeNode == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(17);
        }
        if (selectedNode == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(18);
        }
        if (size == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(19);
        }
        if (treeNode == selectedNode) {
            return size.get();
        }
        size.incrementAndGet();
        int childCount = treeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TreeNode child = treeNode.getChildAt(i);
            int found = JSHintOptionsTreeView.assignIdToPath(child, selectedNode, size);
            if (found == -1) continue;
            return found;
        }
        return -1;
    }

    public void setOptionsState(@NotNull JSHintOptionsState optionsState) {
        if (optionsState == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.mySettingOptionsInProgress = false;
        this.applyOptionsState(optionsState);
        this.mySettingOptionsInProgress = true;
        this.onOptionsStateChanged();
    }

    public JSHintOptionsState getOptionsState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.createState();
    }

    public void setEnabled(boolean enabled) {
        JSHintOptionsTreeView.setEnabledRec(this.myRoot, enabled);
    }

    private static void setEnabledRec(@NotNull CheckedTreeNode node, boolean enabled) {
        if (node == null) {
            JSHintOptionsTreeView.$$$reportNull$$$0(21);
        }
        node.setEnabled(enabled);
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TreeNode treeNode = node.getChildAt(i);
            if (!(treeNode instanceof CheckedTreeNode)) continue;
            JSHintOptionsTreeView.setEnabledRec((CheckedTreeNode)treeNode, enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNodeToSelect";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionsTreeView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNode";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mousePoint";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsState";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionsTreeView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "selectInitialNode";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectInitialNode";
                break;
            }
            case 2: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInitialScrolling";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installSetLinkSupport";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findNodeOfEditLink";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTreeNodes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptionPanel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyOptionsState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findNodeByIdRec";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assignIdToPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setOptionsState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setEnabledRec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

