/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.base.Supplier;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.jshint.JSHintConfigurable;
import com.intellij.lang.javascript.linter.jshint.JSHintConfiguration;
import com.intellij.lang.javascript.linter.jshint.JSHintInspection;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigLookupResult;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionUtil;
import com.intellij.lang.javascript.linter.rhino.FunctionWithScope;
import com.intellij.lang.javascript.linter.rhino.RhinoFunctionManager;
import com.intellij.lang.javascript.linter.rhino.RhinoUtil;
import com.intellij.lang.javascript.linter.rhino.WrappedRhinoException;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;

public class JSHintExternalAnnotator
extends JSLinterExternalAnnotator<JSHintState> {
    private static final Logger LOG = Logger.getInstance(JSHintExternalAnnotator.class);
    private static final JSHintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new JSHintExternalAnnotator(false);
    private final Object myLock = new Object();
    private volatile Pair<String, RhinoFunctionManager> myVersionAndFunctionManager;

    @NotNull
    public static JSHintExternalAnnotator getInstanceForBatchInspection() {
        JSHintExternalAnnotator jSHintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (jSHintExternalAnnotator == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(0);
        }
        return jSHintExternalAnnotator;
    }

    public JSHintExternalAnnotator() {
        this(true);
    }

    public JSHintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<JSHintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(1);
        }
        return new JSHintConfigurable(project, true);
    }

    @Override
    protected Class<? extends JSLinterConfiguration<JSHintState>> getConfigurationClass() {
        return JSHintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return JSHintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(2);
        }
        return file2 instanceof JSFile && JSUtils.isJavaScriptFile(file2);
    }

    @Override
    public JSLinterAnnotationResult annotate(@NotNull JSLinterInput<JSHintState> collectedInfo) {
        Project project;
        if (collectedInfo == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(3);
        }
        if ((project = collectedInfo.getProject()).isDisposed()) {
            return null;
        }
        Context cx = Context.enter();
        try {
            VirtualFile configFile;
            JSHintOptionsState optionsState;
            JSHintState state = collectedInfo.getState();
            RhinoFunctionManager manager2 = this.getFunctionManager(project, state.getVersion());
            if (manager2 == null) {
                JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation(JavaScriptBundle.message((String)"jshint.inspection.message.not.loaded", (Object[])new Object[]{state.getVersion()})), null);
                return jSLinterAnnotationResult;
            }
            VirtualFile file2 = collectedInfo.getPsiFile().getVirtualFile();
            if (file2 == null) {
                JSLinterAnnotationResult jSLinterAnnotationResult = null;
                return jSLinterAnnotationResult;
            }
            boolean ignored = JSHintConfigFileUtil.isIgnored(project, file2);
            if (ignored) {
                JSLinterAnnotationResult jSLinterAnnotationResult = null;
                return jSLinterAnnotationResult;
            }
            if (!state.isConfigFileUsed()) {
                optionsState = state.getOptionsState();
                configFile = null;
            } else {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (!project.isDisposed()) {
                        JSHintConfigFileChangeTracker.getInstance(project).startIfNeeded();
                    }
                });
                JSHintConfigLookupResult configLookupResult = state.isCustomConfigFileUsed() ? JSHintConfigFileUtil.loadConfigByPath(state.getCustomConfigFilePath()) : JSHintConfigFileUtil.lookupConfig(project, file2);
                if (configLookupResult == null) {
                    JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(collectedInfo, new JSLinterFileLevelAnnotation(JavaScriptBundle.message((String)"jshint.inspection.message.config.not.found", (Object[])new Object[0])), null);
                    return jSLinterAnnotationResult;
                }
                configFile = configLookupResult.getConfigFile();
                optionsState = configLookupResult.getOptionsState();
                if (optionsState == null) {
                    String message = StringUtil.notNullize((String)configLookupResult.getErrorMessage(), (String)JavaScriptBundle.message((String)"jshint.inspection.message.malformed.config", (Object[])new Object[0]));
                    JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(message);
                    JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(collectedInfo, annotation, configFile);
                    return jSLinterAnnotationResult;
                }
            }
            List<JSLinterError> errors = JSHintExternalAnnotator.doLint(cx, manager2, optionsState, collectedInfo.getFileContent());
            if (errors != null) {
                JSHintAnnotationResult jSHintAnnotationResult = new JSHintAnnotationResult(collectedInfo.getColorsScheme(), errors, configFile, optionsState);
                return jSHintAnnotationResult;
            }
            JSLinterAnnotationResult jSLinterAnnotationResult = null;
            return jSLinterAnnotationResult;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RhinoFunctionManager getFunctionManager(@NotNull Project project, @NotNull String version) {
        Pair<String, RhinoFunctionManager> pair;
        if (project == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (version == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(5);
        }
        if ((pair = this.getCachedByVersion(version)) != null) {
            return (RhinoFunctionManager)pair.getSecond();
        }
        Object object = this.myLock;
        synchronized (object) {
            Pair<String, RhinoFunctionManager> local = this.getCachedByVersion(version);
            if (local != null) {
                return (RhinoFunctionManager)local.getSecond();
            }
            RhinoFunctionManager rfm = JSHintExternalAnnotator.createRhinoFunctionManager(project, version);
            this.myVersionAndFunctionManager = Pair.create((Object)version, (Object)rfm);
            return rfm;
        }
    }

    @Nullable
    private Pair<String, RhinoFunctionManager> getCachedByVersion(@NotNull String version) {
        String aVersion;
        Pair<String, RhinoFunctionManager> versionAndFunctionManager;
        if (version == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(6);
        }
        if ((versionAndFunctionManager = this.myVersionAndFunctionManager) != null && (aVersion = (String)versionAndFunctionManager.getFirst()).equals(version)) {
            return versionAndFunctionManager;
        }
        return null;
    }

    @Nullable
    private static RhinoFunctionManager createRhinoFunctionManager(@NotNull Project project, @NotNull String version) {
        String content;
        if (project == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(7);
        }
        if (version == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(8);
        }
        if (!JSHintVersionUtil.isSourceLocallyAvailable(version)) {
            JSHintExternalAnnotator.fetchSourceSync(project, version);
        }
        try {
            content = JSHintVersionUtil.loadSourceContentFromLocalDrive(version);
            if (content == null) {
                LOG.warn("No local source content found for " + version);
                return null;
            }
        }
        catch (IOException e) {
            LOG.warn("Can't load JSHint " + version, (Throwable)e);
            return null;
        }
        return new RhinoFunctionManager((Supplier<String>)((Supplier)() -> content), "JSHINT", version);
    }

    private static void fetchSourceSync(@NotNull Project project, @NotNull String version) {
        Application app;
        boolean headless;
        if (project == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(9);
        }
        if (version == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(10);
        }
        boolean bl = headless = (app = ApplicationManager.getApplication()).isUnitTestMode() || app.isCommandLine() || app.isHeadlessEnvironment();
        if (headless || app.isDispatchThread()) {
            try {
                JSHintVersionUtil.downloadSourceContent(version);
            }
            catch (IOException e) {
                LOG.warn("Can't download JSHint " + version, (Throwable)e);
            }
        } else {
            Semaphore semaphore = new Semaphore(0, true);
            UIUtil.invokeLaterIfNeeded(() -> JSHintVersionUtil.downloadSourceContentUnderProgress(project, version, () -> semaphore.release()));
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                LOG.warn("Thread has been interrupted unexpectedly", (Throwable)e);
            }
        }
    }

    @Nullable
    private static List<JSLinterError> doLint(Context cx, @NotNull RhinoFunctionManager manager2, @NotNull JSHintOptionsState optionsState, @NotNull String fileContent) throws WrappedRhinoException {
        Object status;
        Object[] args;
        if (manager2 == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(11);
        }
        if (optionsState == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(12);
        }
        if (fileContent == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(13);
        }
        NativeObject optionsNativeObject = JSHintExternalAnnotator.convertOptionsToRhinoObject(optionsState);
        Object predefObj = optionsState.getValue(JSHintOption.PREDEF);
        if (predefObj != null) {
            NativeObject predefRhinoObject = JSHintExternalAnnotator.convertPredefToRhinoMap(predefObj);
            args = new Object[]{fileContent, optionsNativeObject, predefRhinoObject};
        } else {
            args = new Object[]{fileContent, optionsNativeObject};
        }
        FunctionWithScope functionWithScope = manager2.getFunctionWithScope();
        Function function2 = functionWithScope.getFunction();
        Scriptable scope = functionWithScope.getScope();
        try {
            status = function2.call(cx, scope, scope, args);
        }
        catch (JavaScriptException e) {
            JSLinterError error;
            NativeObject nativeError = (NativeObject)ObjectUtils.tryCast((Object)e.getValue(), NativeObject.class);
            if (nativeError != null && (error = JSHintExternalAnnotator.toLinterError(nativeError)) != null) {
                return ContainerUtil.newArrayList((Object[])new JSLinterError[]{error});
            }
            throw new WrappedRhinoException((RhinoException)e);
        }
        Boolean noErrors = (Boolean)Context.jsToJava((Object)status, Boolean.class);
        if (!noErrors.booleanValue()) {
            Object errorsObj = function2.get("errors", scope);
            if (errorsObj == null || errorsObj == Scriptable.NOT_FOUND) {
                throw new RuntimeException(manager2.getFunctionName() + ".errors is " + errorsObj);
            }
            return JSHintExternalAnnotator.convertErrors((NativeArray)errorsObj);
        }
        return null;
    }

    @NotNull
    private static List<JSLinterError> convertErrors(@NotNull NativeArray errorsNativeArray) {
        if (errorsNativeArray == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(14);
        }
        ArrayList<JSLinterError> errors = new ArrayList<JSLinterError>(errorsNativeArray.size());
        for (Object errorObj : errorsNativeArray) {
            JSLinterError error;
            if (!(errorObj instanceof NativeObject) || (error = JSHintExternalAnnotator.toLinterError((NativeObject)errorObj)) == null) continue;
            errors.add(error);
        }
        ArrayList<JSLinterError> arrayList = errors;
        if (arrayList == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static JSLinterError toLinterError(@NotNull NativeObject nativeError) {
        if (nativeError == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(16);
        }
        int line = JSHintExternalAnnotator.toInt(nativeError.get((Object)"line"));
        int character = JSHintExternalAnnotator.toInt(nativeError.get((Object)"character"));
        if (line < 0 || character < 0) {
            return null;
        }
        String code = RhinoUtil.getStringKey((ScriptableObject)nativeError, "code");
        @NlsSafe String reason = RhinoUtil.getStringKey((ScriptableObject)nativeError, "reason");
        if (reason == null) {
            reason = RhinoUtil.getStringKey((ScriptableObject)nativeError, "message");
        }
        if (reason != null) {
            return new JSLinterError(line, character, reason, code);
        }
        return null;
    }

    private static int toInt(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return -1;
    }

    @NotNull
    private static NativeObject convertOptionsToRhinoObject(@NotNull JSHintOptionsState optionsState) {
        if (optionsState == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(17);
        }
        HashMap<String, Object> options = new HashMap<String, Object>(optionsState.getValueByOptionMap());
        options.remove(JSHintOption.PREDEF.getKey());
        NativeObject nativeObject = RhinoUtil.toRhinoMap(options);
        if (nativeObject == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(18);
        }
        return nativeObject;
    }

    @Override
    public void apply(@NotNull PsiFile file2, JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(19);
        }
        if (holder == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(20);
        }
        if (annotationResult == null) {
            return;
        }
        JSHintConfigurable configurable = new JSHintConfigurable(file2.getProject(), true);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditSettingsAction(new JSLinterEditSettingsAction(configurable, JavaScriptLanguageIcons.FileTypes.JsHint));
        new JSLinterAnnotationsBuilder(file2, annotationResult, holder, configurable, JavaScriptBundle.message((String)"jshint.inspection.message.prefix", (Object[])new Object[0]) + " ", this.getInspectionClass(), fixes).setTabSize(JSHintExternalAnnotator.getIndent(annotationResult)).setDefaultFileLevelErrorIcon(JavaScriptLanguageIcons.FileTypes.JsHint).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    private static int getIndent(@NotNull JSLinterAnnotationResult annotationResult) {
        Object obj;
        if (annotationResult == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(21);
        }
        int indent = 4;
        if (annotationResult instanceof JSHintAnnotationResult && (obj = ((JSHintAnnotationResult)annotationResult).myOptionsState.getValue(JSHintOption.INDENT)) instanceof Number) {
            indent = ((Number)obj).intValue();
        }
        return Math.max(1, indent);
    }

    @NotNull
    public static NativeObject convertPredefToRhinoMap(@NotNull Object predef) {
        if (predef == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(22);
        }
        HashMap<String, Boolean> map2 = new HashMap<String, Boolean>();
        if (predef instanceof String) {
            Map<String, Boolean> boolMap = JSHintExternalAnnotator.convertPredefStrToMap((String)predef);
            map2.putAll(boolMap);
        } else if (predef instanceof List) {
            for (Object o : (List)predef) {
                if (!(o instanceof String)) continue;
                map2.put((String)o, false);
            }
        } else if (predef instanceof Map) {
            for (Map.Entry entry : ((Map)predef).entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                map2.put((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        NativeObject nativeObject = RhinoUtil.toRhinoMap(map2);
        if (nativeObject == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(23);
        }
        return nativeObject;
    }

    @NotNull
    public static NativeArray convertPredefStrToNativeArray(@NotNull String predef, @NotNull Scriptable scope) {
        if (predef == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(25);
        }
        Map<String, Boolean> structure = JSHintExternalAnnotator.convertPredefStrToMap(predef);
        NativeArray array = RhinoUtil.toRhinoArray(new ArrayList<Object>(structure.keySet()));
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)array, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
        NativeArray nativeArray = array;
        if (nativeArray == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(26);
        }
        return nativeArray;
    }

    @NotNull
    private static Map<String, Boolean> convertPredefStrToMap(@NotNull String predef) {
        if (predef == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(27);
        }
        LinkedHashMap<String, Boolean> map2 = new LinkedHashMap<String, Boolean>();
        StringTokenizer st = new StringTokenizer(predef, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int ind = token.indexOf(58);
            String name = token;
            boolean readonly = false;
            if (ind >= 0) {
                String value = token.substring(ind + 1).trim();
                if (Boolean.toString(true).equals(value) || Boolean.toString(false).equals(value)) {
                    name = token.substring(0, ind).trim();
                    readonly = Boolean.parseBoolean(value);
                }
            }
            map2.put(name, readonly);
        }
        LinkedHashMap<String, Boolean> linkedHashMap = map2;
        if (linkedHashMap == null) {
            JSHintExternalAnnotator.$$$reportNull$$$0(28);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsState";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsNativeArray";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeError";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predef";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceForBatchInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertErrors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertOptionsToRhinoObject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPredefToRhinoMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPredefStrToNativeArray";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPredefStrToMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedByVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRhinoFunctionManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchSourceSync";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doLint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertErrors";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toLinterError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertOptionsToRhinoObject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertPredefToRhinoMap";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "convertPredefStrToNativeArray";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "convertPredefStrToMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSHintAnnotationResult
    extends JSLinterAnnotationResult {
        private final JSHintOptionsState myOptionsState;

        JSHintAnnotationResult(@Nullable EditorColorsScheme colorsScheme, @NotNull List<JSLinterError> errors, @Nullable VirtualFile configFile, @NotNull JSHintOptionsState optionsState) {
            if (errors == null) {
                JSHintAnnotationResult.$$$reportNull$$$0(0);
            }
            if (optionsState == null) {
                JSHintAnnotationResult.$$$reportNull$$$0(1);
            }
            super(colorsScheme, errors, null, configFile);
            this.myOptionsState = optionsState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "errors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "optionsState";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator$JSHintAnnotationResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

