/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintExternalAnnotator;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSFixAction;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSInspection;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSExternalAnnotator
extends JSLinterExternalAnnotator<StandardJSState> {
    public StandardJSExternalAnnotator() {
        this(true);
    }

    public StandardJSExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected EslintConfigurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(0);
        }
        return new EslintConfigurable(project, true);
    }

    @Override
    protected Class<? extends JSLinterConfiguration<StandardJSState>> getConfigurationClass() {
        return StandardJSConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return StandardJSInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(1);
        }
        return EslintUtil.isPossiblyAcceptableFileType(file2);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult annotate(@NotNull JSLinterInput<StandardJSState> input) {
        StandardJSState initialState;
        NodePackage standardPackage;
        if (input == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(2);
        }
        if ((standardPackage = (initialState = input.getState()).getNodePackage()).isEmptyPath()) {
            return null;
        }
        SemVer semVer = standardPackage.getVersion(input.getProject());
        if (semVer != null && !semVer.isGreaterOrEqualThan(StandardJSUtil.MIN_VERSION)) {
            return JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(JavaScriptBundle.message((String)"standardjs.error.unsupported.package", (Object[])new Object[]{StandardJSUtil.MIN_VERSION.getRawVersion()})), null);
        }
        JSLinterInput eslintInput = (JSLinterInput)ReadAction.compute(() -> {
            EslintState eslintState = StandardJSExternalAnnotator.createESLintInput(input.getVirtualFile(), input.getProject(), standardPackage);
            return JSLinterInput.create(input.getPsiFile(), eslintState, input.getColorsScheme());
        });
        return StandardJSLanguageServiceManager.getInstance(input.getProject()).useService(input.getVirtualFile(), ((EslintState)eslintInput.getState()).getNodePackageRef(), service -> {
            if (service == null) {
                return JSLinterAnnotationResult.empty();
            }
            return EsLintExternalRunner.highlight(eslintInput, service, this.isOnTheFly());
        });
    }

    @Override
    public void apply(@NotNull PsiFile file2, @Nullable JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (annotationResult == null) {
            return;
        }
        String caption = JavaScriptBundle.message((String)"standardjs.name", (Object[])new Object[0]);
        IntentionAction fixFileAction = new StandardJSFixAction().asIntentionAction();
        String editSettingsAction = JavaScriptBundle.message((String)"standardjs.edit.settings.caption", (Object[])new Object[0]);
        EslintExternalAnnotator.apply(file2, annotationResult, holder, fixFileAction, caption, null, false, editSettingsAction, this.getInspectionClass());
    }

    @NotNull
    public static EslintState createESLintInput(@NotNull StandardJSState standardJSState, @NotNull VirtualFile fileToLint, @NotNull Project project) {
        if (standardJSState == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (fileToLint == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (project == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(7);
        }
        return StandardJSExternalAnnotator.createESLintInput(fileToLint, project, standardJSState.getNodePackage());
    }

    @NotNull
    private static EslintState createESLintInput(@NotNull VirtualFile fileToLint, @NotNull Project project, @NotNull NodePackage standardPackage) {
        if (fileToLint == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(8);
        }
        if (project == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(9);
        }
        if (standardPackage == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(10);
        }
        VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(fileToLint);
        StandardJSUtil.ConfigData packageJsonData = StandardJSUtil.getPackageJsonConfigData(project, packageJson);
        EslintState eslintState = new EslintState.Builder().setEslintPackage(NodePackageRef.create(standardPackage)).setExtraOptions(StandardJSExternalAnnotator.getIgnoreOptions(packageJsonData)).build();
        if (eslintState == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(11);
        }
        return eslintState;
    }

    @NotNull
    private static String getIgnoreOptions(@Nullable StandardJSUtil.ConfigData configData) {
        ArrayList commandLine = ContainerUtil.newArrayList((Object[])new String[]{"--no-eslintrc"});
        if (configData != null) {
            StandardJSExternalAnnotator.addListArgument(commandLine, "--ignore-pattern", configData.ignored);
        }
        String string = StringUtil.join((Collection)commandLine, (String)" ");
        if (string == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void addListArgument(@NotNull List<String> commandLine, @NotNull String name, @NotNull List<String> values) {
        if (commandLine == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(13);
        }
        if (name == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(14);
        }
        if (values == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(15);
        }
        if (!values.isEmpty()) {
            commandLine.add(name);
            commandLine.add(StringUtil.join(values, (String)","));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardJSState";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardPackage";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createESLintInput";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createESLintInput";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addListArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

