/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.GlobPatternUtil;
import com.intellij.lang.javascript.linter.MultiRootJSLinterLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.service.ESLintLanguageService;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EslintLanguageServiceManager
extends MultiRootJSLinterLanguageServiceManager<ESLintLanguageService> {
    public EslintLanguageServiceManager(@NotNull Project project) {
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(0);
        }
        super(project, "eslint");
    }

    @NotNull
    public static EslintLanguageServiceManager getInstance(@NotNull Project project) {
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(1);
        }
        EslintLanguageServiceManager eslintLanguageServiceManager = (EslintLanguageServiceManager)ServiceManager.getService((Project)project, EslintLanguageServiceManager.class);
        if (eslintLanguageServiceManager == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(2);
        }
        return eslintLanguageServiceManager;
    }

    @Override
    @NotNull
    protected ESLintLanguageService createServiceInstance(@NotNull NodePackage resolvedPackage, @NotNull VirtualFile workingDirectory) {
        if (resolvedPackage == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(3);
        }
        if (workingDirectory == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(4);
        }
        return new ESLintLanguageService(this.myProject, resolvedPackage, workingDirectory);
    }

    @Override
    protected boolean hasLinterSpecificConfiguration(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(5);
        }
        for (VirtualFile child : packageJson.getParent().getChildren()) {
            if (child.isDirectory() || !EslintUtil.isEslintConfigFile(child)) continue;
            return true;
        }
        Set<String> properties = PackageJsonData.getOrCreate(packageJson).getTopLevelProperties();
        return properties.contains("eslintConfig");
    }

    @Override
    @NotNull
    protected VirtualFile getWorkingDirectory(@NotNull NodePackage resolvedPackage, @NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile wd;
        if (resolvedPackage == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(6);
        }
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(8);
        }
        if ((wd = EslintLanguageServiceManager.getConfiguredWorkingDirectoryForFile(project, file2)) != null) {
            VirtualFile virtualFile = wd;
            if (virtualFile == null) {
                EslintLanguageServiceManager.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }
        Ref workingDir = new Ref();
        JSProjectUtil.processDirectoriesUpToContentRoot(project, file2, (Processor<? super VirtualFile>)((Processor)dir -> {
            Set<String> properties;
            for (VirtualFile child : dir.getChildren()) {
                if (child.isDirectory() || !child.getName().equals(".eslintignore") && !EslintUtil.isEslintConfigFile(child)) continue;
                workingDir.set(dir);
                return false;
            }
            VirtualFile packageJson = dir.findChild("package.json");
            if (packageJson != null && ((properties = PackageJsonData.getOrCreate(packageJson).getTopLevelProperties()).contains("eslintIgnore") || properties.contains("eslintConfig"))) {
                workingDir.set(dir);
                return false;
            }
            return true;
        }));
        VirtualFile virtualFile = !workingDir.isNull() ? (VirtualFile)workingDir.get() : super.getWorkingDirectory(resolvedPackage, project, file2);
        if (virtualFile == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile getConfiguredWorkingDirectoryForFile(@NotNull Project project, @NotNull VirtualFile file2) {
        String patternsString;
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(12);
        }
        if ((patternsString = ((EslintState)EslintConfiguration.getInstance(project).getExtendedState().getState()).getWorkDirPatterns()).isEmpty()) {
            return null;
        }
        List patterns = ContainerUtil.mapNotNull((Collection)StringUtil.split((String)patternsString, (String)";"), s -> StringUtil.nullize((String)StringUtil.trimStart((String)Strings.trimEnd((String)s.trim(), (char)'/'), (String)"./")));
        VirtualFile dir = file2.getParent();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        while (fileIndex.isInContent(dir)) {
            for (String pattern : patterns) {
                if (pattern.equals(".") && dir.getPath().equals(project.getBasePath())) {
                    return dir;
                }
                if (pattern.equals(dir.getPath())) {
                    return dir;
                }
                if (!GlobPatternUtil.isFileMatchingGlobPattern(project, pattern, dir)) continue;
                return dir;
            }
            dir = dir.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/service/EslintLanguageServiceManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/service/EslintLanguageServiceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createServiceInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasLinterSpecificConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredWorkingDirectoryForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

