/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.nodejs.NpmInstallQuickFix;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.ConfigureNodePathIntentionAction;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLinterUtil {
    public static final Logger LOG = Logger.getInstance(JSLinterUtil.class);
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Linters");
    private static final HtmlChunk.Element RED_FONT = HtmlChunk.tag((String)"font").attr("color", "#" + ColorUtil.toHex((Color)JBColor.RED));

    private JSLinterUtil() {
    }

    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        VirtualFile file2;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(0);
        }
        return (file2 = JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, Collections.singletonList("package.json"))) != null ? PackageJsonData.getOrCreate(file2) : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull HighlightSeverity severity, @Nullable TextAttributes forcedTextAttributes, @NotNull TextRange range, @NotNull @InspectionMessage String message) {
        if (holder == null) {
            JSLinterUtil.$$$reportNull$$$0(1);
        }
        if (severity == null) {
            JSLinterUtil.$$$reportNull$$$0(2);
        }
        if (range == null) {
            JSLinterUtil.$$$reportNull$$$0(3);
        }
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(4);
        }
        DeprecatedMethodException.report((String)"Use AnnotationHolder.newAnnotation() instead");
        if (forcedTextAttributes != null) {
            Annotation annotation = holder.createAnnotation(severity, range, message);
            annotation.setEnforcedTextAttributes(forcedTextAttributes);
            annotation.setNeedsUpdateOnTyping(false);
            Annotation annotation2 = annotation;
            if (annotation2 == null) {
                JSLinterUtil.$$$reportNull$$$0(5);
            }
            return annotation2;
        }
        Annotation annotation = severity == HighlightSeverity.ERROR ? holder.createErrorAnnotation(range, message) : holder.createWarningAnnotation(range, message);
        annotation.setNeedsUpdateOnTyping(false);
        String escaped = XmlStringUtil.escapeString((String)message);
        escaped = StringUtil.convertLineSeparators((String)escaped, (String)"\n").replace("\n", "<br/>");
        @NonNls String tooltip = XmlStringUtil.wrapInHtml((CharSequence)escaped);
        annotation.setTooltip(tooltip);
        Annotation annotation3 = annotation;
        if (annotation3 == null) {
            JSLinterUtil.$$$reportNull$$$0(6);
        }
        return annotation3;
    }

    static void createAnnotation(@NotNull AnnotationHolder holder, @NotNull HighlightSeverity severity, @Nullable TextAttributes forcedTextAttributes, @NotNull TextRange range, @NotNull @InspectionMessage String message, @NotNull @NlsContexts.Tooltip String tooltip, boolean afterEndOfLine, @NotNull List<? extends IntentionAction> fixes, @NotNull HighlightDisplayKey key, @Nullable ProblemGroup problemGroup) {
        if (holder == null) {
            JSLinterUtil.$$$reportNull$$$0(7);
        }
        if (severity == null) {
            JSLinterUtil.$$$reportNull$$$0(8);
        }
        if (range == null) {
            JSLinterUtil.$$$reportNull$$$0(9);
        }
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(10);
        }
        if (tooltip == null) {
            JSLinterUtil.$$$reportNull$$$0(11);
        }
        if (fixes == null) {
            JSLinterUtil.$$$reportNull$$$0(12);
        }
        if (key == null) {
            JSLinterUtil.$$$reportNull$$$0(13);
        }
        AnnotationBuilder builder = holder.newAnnotation(severity, message).range(range).needsUpdateOnTyping(false).tooltip(tooltip);
        if (forcedTextAttributes != null) {
            builder = builder.enforcedTextAttributes(forcedTextAttributes);
        }
        if (afterEndOfLine) {
            builder = builder.afterEndOfLine();
        }
        if (problemGroup != null) {
            builder = builder.problemGroup(problemGroup);
        }
        for (IntentionAction intentionAction : fixes) {
            builder = builder.newFix(intentionAction).key(key).registerFix();
        }
        builder.create();
    }

    @NotNull
    public static TextAttributes getTextAttributes(@Nullable EditorColorsScheme editorColorsScheme, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightSeverity severity) {
        TextAttributes textAttributes;
        if (severityRegistrar == null) {
            JSLinterUtil.$$$reportNull$$$0(14);
        }
        if (severity == null) {
            JSLinterUtil.$$$reportNull$$$0(15);
        }
        if ((textAttributes = severityRegistrar.getTextAttributesBySeverity(severity)) != null) {
            TextAttributes textAttributes2 = textAttributes;
            if (textAttributes2 == null) {
                JSLinterUtil.$$$reportNull$$$0(16);
            }
            return textAttributes2;
        }
        EditorColorsScheme colorsScheme = JSLinterUtil.getColorsScheme(editorColorsScheme);
        HighlightInfoType.HighlightInfoTypeImpl infoType = severityRegistrar.getHighlightInfoTypeBySeverity(severity);
        TextAttributesKey key = infoType.getAttributesKey();
        TextAttributes textAttributes3 = colorsScheme.getAttributes(key);
        if (textAttributes3 == null) {
            JSLinterUtil.$$$reportNull$$$0(17);
        }
        return textAttributes3;
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            EditorColorsScheme editorColorsScheme = customScheme;
            if (editorColorsScheme == null) {
                JSLinterUtil.$$$reportNull$$$0(18);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            JSLinterUtil.$$$reportNull$$$0(19);
        }
        return editorColorsScheme;
    }

    @NotNull
    public static List<JSLinterError> limitErrorsAtTheSamePosition(@NotNull List<? extends JSLinterError> errors, int limit) {
        if (errors == null) {
            JSLinterUtil.$$$reportNull$$$0(20);
        }
        errors.sort((o1, o2) -> o1.compareFully((JSLinterError)o2));
        JSLinterError prev = null;
        ArrayList<JSLinterError> limited = new ArrayList<JSLinterError>();
        int count = 0;
        for (JSLinterError jSLinterError : errors) {
            if (prev != null && prev.compareLogicalPositionTo(jSLinterError) == 0) {
                if (prev.getDescription().equals(jSLinterError.getDescription())) continue;
                ++count;
            } else {
                count = 1;
            }
            if (count <= limit) {
                limited.add(jSLinterError);
            }
            prev = jSLinterError;
        }
        ArrayList<JSLinterError> arrayList = limited;
        if (arrayList == null) {
            JSLinterUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    public static TextFieldWithBrowseButton createTextFieldWithBrowseButton(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String description, @NotNull Disposable uiDisposable) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(22);
        }
        if (description == null) {
            JSLinterUtil.$$$reportNull$$$0(23);
        }
        if (uiDisposable == null) {
            JSLinterUtil.$$$reportNull$$$0(24);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(new JTextField(0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        JTextField textField = (JTextField)textFieldWithBrowseButton.getChildComponent();
        textField.setDisabledTextColor(UIUtil.getLabelDisabledForeground());
        textFieldWithBrowseButton.addBrowseFolderListener(description, null, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, uiDisposable);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            JSLinterUtil.$$$reportNull$$$0(25);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public static JEditorPane createDefaultContent(@NotNull @Nls String message) {
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(26);
        }
        return JSLinterUtil.createHtmlViewer(message, null);
    }

    @NotNull
    public static JEditorPane createHtmlViewer(@NotNull @Nls String innerBodyHtml, @Nullable Font font) {
        if (innerBodyHtml == null) {
            JSLinterUtil.$$$reportNull$$$0(27);
        }
        if (font == null) {
            font = StartupUiUtil.getLabelFont();
        }
        JEditorPane pane = SwingHelper.createHtmlViewer((boolean)true, (Font)font, null, null);
        String html = HtmlChunk.html().children(new HtmlChunk[]{HtmlChunk.head().addRaw(UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getLabelForeground(), null, null)), HtmlChunk.body().addRaw(innerBodyHtml)}).toString();
        pane.setText(html);
        JEditorPane jEditorPane = pane;
        if (jEditorPane == null) {
            JSLinterUtil.$$$reportNull$$$0(28);
        }
        return jEditorPane;
    }

    private static int getRadioIconWidth() {
        Icon icon = UIManager.getIcon("RadioButton.icon");
        if (icon != null) {
            return icon.getIconWidth();
        }
        return 12;
    }

    public static int getMarginForRadioButton(@NotNull JRadioButton radioButton) {
        if (radioButton == null) {
            JSLinterUtil.$$$reportNull$$$0(29);
        }
        return radioButton.getInsets().left + radioButton.getMargin().left + JSLinterUtil.getRadioIconWidth() + radioButton.getIconTextGap();
    }

    public static boolean isVueFile(@NotNull PsiFile file2) {
        Language vue;
        if (file2 == null) {
            JSLinterUtil.$$$reportNull$$$0(30);
        }
        return (vue = Language.findLanguageByID((String)"Vue")) != null && vue.equals(file2.getLanguage());
    }

    public static boolean isPureHtmlFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSLinterUtil.$$$reportNull$$$0(31);
        }
        if (file2.getLanguage() == HTMLLanguage.INSTANCE) {
            FileType fileTypeByName = FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getName());
            return fileTypeByName == HtmlFileType.INSTANCE;
        }
        return false;
    }

    @NotNull
    public static String getAbsoluteOrRelativePathToProjectRoot(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile root;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(32);
        }
        if (file2 == null) {
            JSLinterUtil.$$$reportNull$$$0(33);
        }
        if ((root = project.getBaseDir()) != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    JSLinterUtil.$$$reportNull$$$0(34);
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                JSLinterUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
        if (string == null) {
            JSLinterUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Nullable
    public static IntentionAction createDetailsAction(@NotNull Project project, @NotNull VirtualFile fileToLint, @Nullable GeneralCommandLine commandLine, @NotNull ProcessOutput output, @Nullable Icon icon) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(37);
        }
        if (fileToLint == null) {
            JSLinterUtil.$$$reportNull$$$0(38);
        }
        if (output == null) {
            JSLinterUtil.$$$reportNull$$$0(39);
        }
        if (!StringUtil.containsLineBreak((CharSequence)output.getStderr())) {
            return null;
        }
        String presentableFilePath = (String)ReadAction.compute(() -> project.isDisposed() ? fileToLint.getPresentableUrl() : JSLinterUtil.getAbsoluteOrRelativePathToProjectRoot(project, fileToLint));
        return new JsqtViewProcessOutputAction(JavaScriptBundle.message((String)"javascript.linter.error.failed.to.lint", (Object[])new Object[]{presentableFilePath}), icon, commandLine, null, output);
    }

    @NotNull
    public static VirtualFile checkPath(@NotNull String path, boolean isDir, @NotNull String fieldName) throws ExecutionException {
        VirtualFile result2;
        if (path == null) {
            JSLinterUtil.$$$reportNull$$$0(40);
        }
        if (fieldName == null) {
            JSLinterUtil.$$$reportNull$$$0(41);
        }
        if ((result2 = JSLinterUtil.createVirtualFileOrNull(path, isDir)) == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"javascript.linter.error.specify.correct.path.to", (Object[])new Object[]{fieldName}));
        }
        VirtualFile virtualFile = result2;
        if (virtualFile == null) {
            JSLinterUtil.$$$reportNull$$$0(42);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile createVirtualFileOrNull(@NotNull String path, boolean isDir) {
        VirtualFile virtualFile;
        if (path == null) {
            JSLinterUtil.$$$reportNull$$$0(43);
        }
        if ((virtualFile = JSLinterConfigFileUtil.findLocalFileByPath(path)) == null || !virtualFile.isValid() || isDir != virtualFile.isDirectory()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    public static JSLinterFileLevelAnnotation validateInterpreterAndPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable NodePackage nodePackage, @NotNull String packageName, @Nullable VirtualFile contextFile) {
        String errorMessage;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(44);
        }
        if (packageName == null) {
            JSLinterUtil.$$$reportNull$$$0(45);
        }
        if ((errorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter)) != null) {
            JSLinterStandardFixes fixes = new JSLinterStandardFixes().setShowEditSettings(false).setEditConfig(false).setOtherFixes(Collections.singletonList(new ConfigureNodePathIntentionAction()));
            return new JSLinterFileLevelAnnotation(null, StringUtil.decapitalize((String)errorMessage), HighlightSeverity.ERROR, fixes);
        }
        if (nodePackage == null || !nodePackage.isValid(project)) {
            return JSLinterUtil.createLinterPackageError(project, nodePackage != null ? nodePackage.getSystemDependentPath() : "", packageName, contextFile);
        }
        return null;
    }

    public static JSLinterFileLevelAnnotation createLinterPackageError(@NotNull Project project, @NotNull String packagePath, @NonNls @NotNull String packageName, @Nullable VirtualFile contextFile) {
        String projectBasePath;
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(46);
        }
        if (packagePath == null) {
            JSLinterUtil.$$$reportNull$$$0(47);
        }
        if (packageName == null) {
            JSLinterUtil.$$$reportNull$$$0(48);
        }
        if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
            LOG.debug(String.format("Path to package %s is empty", packageName));
            return new JSLinterFileLevelAnnotation(JavaScriptBundle.message((String)"javascript.linter.error.no.path.to.package", (Object[])new Object[]{packageName}));
        }
        File path = new File(packagePath);
        if (path.getParentFile() != null && "node_modules".equals(path.getParentFile().getName()) && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((File)new File(projectBasePath), (File)path, (boolean)true)) {
            VirtualFile packageJson;
            LOG.debug(String.format("Package %s is not installed in path %s", packageName, packagePath));
            String message = JavaScriptBundle.message((String)"javascript.linter.error.package.not.installed", (Object[])new Object[]{packageName});
            JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(null, message, HighlightSeverity.ERROR, new JSLinterStandardFixes());
            VirtualFile virtualFile = packageJson = contextFile != null ? PackageJsonUtil.findUpPackageJson(contextFile) : null;
            if (packageJson != null) {
                annotation.getFixes().setOtherFixes(Collections.singletonList(new NpmInstallQuickFix(project, packageJson)));
            }
            return annotation;
        }
        LOG.debug(String.format("Path to package %s is invalid: %s", packageName, packagePath));
        return new JSLinterFileLevelAnnotation(JavaScriptBundle.message((String)"javascript.linter.error.invalid.path.to.package", (Object[])new Object[]{packageName}));
    }

    @Nullable
    public static Document getDocumentForElement(@NotNull PsiElement element) {
        if (element == null) {
            JSLinterUtil.$$$reportNull$$$0(49);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && psiFile.isValid()) {
            psiFile = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile.getOriginalFile());
            return PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        }
        return null;
    }

    public static void reportCodeStyleSettingsAlreadyImported(@NotNull Project project, String toolName) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(50);
        }
        NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message((String)"javascript.linter.import.nothing.to.import", (Object[])new Object[]{toolName}), NotificationType.INFORMATION).notify(project);
    }

    public static void reportCodeStyleSettingsImported(@NotNull Project project, @NotNull String linterName, @NotNull VirtualFile file2, @NotNull Collection<String> importedRuleNames, @Nullable Runnable resetAction) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(51);
        }
        if (linterName == null) {
            JSLinterUtil.$$$reportNull$$$0(52);
        }
        if (file2 == null) {
            JSLinterUtil.$$$reportNull$$$0(53);
        }
        if (importedRuleNames == null) {
            JSLinterUtil.$$$reportNull$$$0(54);
        }
        Object message = JavaScriptBundle.message((String)"javascript.linter.import.notification", (Object[])new Object[]{linterName, file2.getName()});
        if (!importedRuleNames.isEmpty()) {
            String rulesText = StringUtil.join(importedRuleNames, (String)", ");
            message = (String)message + "\n" + JavaScriptBundle.message((String)"javascript.linter.import.notification.rules.applied", (Object[])new Object[]{importedRuleNames.size() == 1 ? "rule was" : "rules were", rulesText});
        }
        JSLinterUtil.reportCodeStyleSettingsImported(project, (String)message, file2, resetAction);
    }

    public static void reportCodeStyleSettingsImported(final @NotNull Project project, @NotNull @NlsContexts.NotificationContent String message, final @Nullable VirtualFile file2, final @Nullable Runnable resetAction) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(55);
        }
        if (message == null) {
            JSLinterUtil.$$$reportNull$$$0(56);
        }
        Notification notification2 = NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION);
        if (file2 != null) {
            notification2.addAction((AnAction)new NotificationAction(JavaScriptBundle.message((String)"javascript.linter.import.notification.edit", (Object[])new Object[]{file2.getName()})){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!file2.isValid()) {
                        return;
                    }
                    if (project.isDisposed()) {
                        return;
                    }
                    PsiNavigationSupport.getInstance().createNavigatable(project, file2, 0).navigate(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterUtil$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (resetAction != null) {
            notification2.addAction((AnAction)new NotificationAction(JavaScriptBundle.message((String)"javascript.linter.import.notification.reset", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (project.isDisposed()) {
                        return;
                    }
                    resetAction.run();
                    NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message((String)"javascript.linter.import.notification.restored", (Object[])new Object[0]), NotificationType.INFORMATION).notify(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterUtil$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification2.notify(project);
    }

    @NotNull
    @Nls
    public static String getRedErrorTextHtml(@InspectionMessage String errorMessage) {
        String string = new HtmlBuilder().append((HtmlChunk)RED_FONT.addText(errorMessage)).wrapWithHtmlBody().toString();
        if (string == null) {
            JSLinterUtil.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static CharSequence convertLineSeparatorsToFileOriginal(@NotNull Project project, @NotNull CharSequence fileContent, @NotNull VirtualFile file2) {
        if (project == null) {
            JSLinterUtil.$$$reportNull$$$0(58);
        }
        if (fileContent == null) {
            JSLinterUtil.$$$reportNull$$$0(59);
        }
        if (file2 == null) {
            JSLinterUtil.$$$reportNull$$$0(60);
        }
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(project, fileContent, file2);
        if (charSequence == null) {
            JSLinterUtil.$$$reportNull$$$0(61);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 57: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 57: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: 
            case 10: 
            case 26: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiDisposable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerBodyHtml";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "radioButton";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 53: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedRuleNames";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "limitErrorsAtTheSamePosition";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextFieldWithBrowseButton";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlViewer";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteOrRelativePathToProjectRoot";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPath";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedErrorTextHtml";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparatorsToFileOriginal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelPackageJsonData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 57: 
            case 61: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "limitErrorsAtTheSamePosition";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createTextFieldWithBrowseButton";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlViewer";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getMarginForRadioButton";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVueFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isPureHtmlFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteOrRelativePathToProjectRoot";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsAction";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkPath";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualFileOrNull";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "validateInterpreterAndPackage";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createLinterPackageError";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentForElement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "reportCodeStyleSettingsAlreadyImported";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "reportCodeStyleSettingsImported";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToFileOriginal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 57: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

