/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.typings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesCollector;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="TypeScriptExternalDefinitionsRegistry", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003012B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\nJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020\u000fJ\u001d\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b&J\n\u0010'\u001a\u0004\u0018\u00010\u0002H\u0016J(\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0)2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010.\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0012H\u0007R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$State;", "Lcom/intellij/openapi/Disposable;", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "installingPackages", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleDependencies", "", "", "resolveDefinitionsVersionCache", "Ljava/util/Optional;", "Lcom/intellij/util/text/SemVer;", "collectModuleDependencies", "", "typingsPackage", "createInstallationDirectory", "Ljava/io/File;", "createInterpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "project", "Lcom/intellij/openapi/project/Project;", "dispose", "ensureExternalDefinitionsInstalled", "", "ensureExternalDefinitionsInstalled$intellij_javascript_impl", "findMatchedTypingsVersion", "sourcePackage", "sourcePackageVersion", "typingsPackageName", "getCachedModuleDependencies", "packageName", "getCachedModuleDependencies$intellij_javascript_impl", "getState", "installPackage", "Ljava/util/concurrent/Future;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadState", "state", "setTypingsVersionForPackage", "version", "Companion", "ModuleDependenciesState", "State", "intellij.javascript.impl"})
@ApiStatus.Experimental
public final class TypeScriptExternalDefinitionsRegistry
implements PersistentStateComponent<State>,
Disposable {
    private final ConcurrentHashMap<TypeScriptPackageName, CompletableFuture<VirtualFile>> installingPackages = new ConcurrentHashMap();
    private final ConcurrentHashMap<TypeScriptPackageName, Set<String>> moduleDependencies = new ConcurrentHashMap();
    private ConcurrentHashMap<TypeScriptPackageName, Optional<SemVer>> resolveDefinitionsVersionCache = new ConcurrentHashMap();
    private final ExecutorService executor;
    private static final Logger LOG;
    @NotNull
    public static final String REGISTRY_KEY = "typescript.external.type.definitions";
    @TestOnly
    @Nullable
    private static String testTypingsRootPath;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Set<String> getCachedModuleDependencies$intellij_javascript_impl(@NotNull TypeScriptPackageName packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.moduleDependencies.get(packageName);
    }

    private final void collectModuleDependencies(TypeScriptPackageName typingsPackage) {
        Object object;
        VirtualFile nodeModulesDir;
        block13: {
            block12: {
                boolean bl;
                Object object2;
                block11: {
                    block10: {
                        if (this.getCachedModuleDependencies$intellij_javascript_impl(typingsPackage) != null) {
                            return;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Collecting dependencies for " + typingsPackage);
                        }
                        String string = Companion.getTypingsVersionPath(typingsPackage);
                        if (string == null) {
                            return;
                        }
                        String path = string;
                        object2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.join((String[])new String[]{path, "node_modules"}));
                        if (object2 == null) break block10;
                        VirtualFile virtualFile = object2;
                        boolean bl2 = false;
                        bl = false;
                        VirtualFile it = virtualFile;
                        boolean bl3 = false;
                        VirtualFile virtualFile2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                        object2 = virtualFile2.isValid() ? virtualFile : null;
                        if (object2 != null) break block11;
                    }
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"LocalFileSystem.getInsta\u2026 { it.isValid } ?: return");
                nodeModulesDir = object2;
                object = nodeModulesDir.findFileByRelativePath(typingsPackage.getName());
                if (object == null) break block12;
                VirtualFile virtualFile = object;
                bl = false;
                boolean bl4 = false;
                VirtualFile it = virtualFile;
                boolean bl5 = false;
                VirtualFile virtualFile3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
                object = virtualFile3.isValid() ? virtualFile : null;
                if (object != null) break block13;
            }
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeModulesDir.findFileB\u2026 { it.isValid } ?: return");
        VirtualFile moduleDir = object;
        Set<String> packages = new TypeScriptRelatedPackagesCollector(moduleDir, nodeModulesDir).collectFullPackageNames();
        ((Map)this.moduleDependencies).put(typingsPackage, packages);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collected dependencies for " + typingsPackage + ": " + packages);
        }
    }

    @Nullable
    public final SemVer findMatchedTypingsVersion(@NotNull TypeScriptPackageName sourcePackage) {
        Intrinsics.checkNotNullParameter((Object)sourcePackage, (String)"sourcePackage");
        Optional<SemVer> optional = this.resolveDefinitionsVersionCache.get(sourcePackage);
        if (optional != null) {
            Optional<SemVer> optional2 = optional;
            boolean bl = false;
            boolean bl2 = false;
            Optional<SemVer> it = optional2;
            boolean bl3 = false;
            return it.orElse(null);
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return null;
        }
        try {
            String typingsPackageName = TypeScriptDefinitionsUtils.getTypingsPackageName(sourcePackage.getName());
            AvailablePackageVersions availablePackageVersions = NpmRegistryService.getInstance().getCachedOrFetchPackageVersionsFuture(typingsPackageName).get();
            if (availablePackageVersions == null) {
                return null;
            }
            AvailablePackageVersions packageVersions = availablePackageVersions;
            SemVer semVer = sourcePackage.getVersion();
            List<SemVer> list2 = packageVersions.getVersions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"packageVersions.versions");
            SemVer semVer2 = TypeScriptDefinitionsUtils.getMatchedVersion(semVer, (Collection<SemVer>)list2);
            if (semVer2 == null) {
                List<SemVer> list3 = packageVersions.getVersions();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"packageVersions.versions");
                semVer2 = (SemVer)CollectionsKt.firstOrNull(list3);
            }
            SemVer matchedVersion = semVer2;
            Map map2 = this.resolveDefinitionsVersionCache;
            Optional<SemVer> optional3 = Optional.ofNullable(matchedVersion);
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"Optional.ofNullable(matchedVersion)");
            map2.put(sourcePackage, optional3);
            return matchedVersion;
        }
        catch (Exception e) {
            LOG.warn("An error occurred during resolving typings version for " + sourcePackage, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final SemVer findMatchedTypingsVersion(@Nullable SemVer sourcePackageVersion, @NotNull String typingsPackageName) {
        Intrinsics.checkNotNullParameter((Object)typingsPackageName, (String)"typingsPackageName");
        return this.findMatchedTypingsVersion(new TypeScriptPackageName(TypeScriptDefinitionsUtils.getSourcePackageName(typingsPackageName), sourcePackageVersion));
    }

    @NotNull
    public final Future<VirtualFile> installPackage(@NotNull TypeScriptPackageName typingsPackage, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
        Future failedFuture = completableFuture;
        NodeJsInterpreter interpreter = this.createInterpreter(project);
        if (interpreter == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to create interpreter for package installation: " + typingsPackage);
            }
            return failedFuture;
        }
        File file2 = this.createInstallationDirectory(typingsPackage);
        if (file2 == null) {
            return failedFuture;
        }
        File installationDir = file2;
        CompletableFuture future = new CompletableFuture();
        Runnable installRunnable2 = new Runnable(this, typingsPackage, installationDir, future, indicator, interpreter){
            final /* synthetic */ TypeScriptExternalDefinitionsRegistry this$0;
            final /* synthetic */ TypeScriptPackageName $typingsPackage;
            final /* synthetic */ File $installationDir;
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ NodeJsInterpreter $interpreter;

            public final void run() {
                TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().info("Installing typings package: " + this.$typingsPackage + "; path=" + this.$installationDir.getPath());
                try {
                    PackageManagementService.Listener listener2 = new PackageManagementService.Listener(this){
                        final /* synthetic */ installPackage.installRunnable.1 this$0;

                        public void operationStarted(@Nullable String packageName) {
                            if (TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().isDebugEnabled()) {
                                TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().debug("Install operation started: " + packageName);
                            }
                        }

                        public void operationFinished(@Nullable String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                            if (errorDescription != null) {
                                TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().warn("Install operation failed " + this.this$0.$typingsPackage + ": " + errorDescription);
                                this.this$0.$future.complete(null);
                            } else {
                                if (TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().isDebugEnabled()) {
                                    TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().debug("Install operation finished: " + this.this$0.$typingsPackage);
                                }
                                Application application = ApplicationManager.getApplication();
                                Runnable runnable = new Runnable(this, application){
                                    final /* synthetic */ installPackage.installRunnable.listener.1 this$0;
                                    final /* synthetic */ Application $application;

                                    public final void run() {
                                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (File[])new File[]{this.this$0.this$0.$installationDir});
                                        if (TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().isDebugEnabled()) {
                                            TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().debug("VFS update successful: " + this.this$0.this$0.$typingsPackage);
                                        }
                                        this.$application.executeOnPooledThread(new Runnable(this){
                                            final /* synthetic */ installPackage.installRunnable.listener.operationFinished.1 this$0;

                                            public final void run() {
                                                if (this.this$0.this$0.this$0.this$0.ensureExternalDefinitionsInstalled$intellij_javascript_impl(this.this$0.this$0.this$0.$typingsPackage)) {
                                                    TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().info("Package was installed successfully: " + this.this$0.this$0.this$0.$typingsPackage);
                                                    boolean $i$f$runReadAction = false;
                                                    this.this$0.this$0.this$0.$future.complete(ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                                                        final /* synthetic */ installPackage.installRunnable.listener.operationFinished.1 this$0;
                                                        {
                                                            this.this$0 = var1_1;
                                                        }

                                                        public final T compute() {
                                                            boolean bl = false;
                                                            return (T)LocalFileSystem.getInstance().findFileByIoFile(this.this$0.this$0.this$0.this$0.$installationDir);
                                                        }
                                                    }));
                                                } else {
                                                    TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().warn("Package was installed but not found in FS: " + this.this$0.this$0.this$0.$typingsPackage);
                                                    this.this$0.this$0.this$0.$future.complete(null);
                                                }
                                            }
                                            {
                                                this.this$0 = var1_1;
                                            }
                                        });
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$application = application;
                                    }
                                };
                                ProgressIndicator progressIndicator = this.this$0.$indicator;
                                if (progressIndicator == null || (progressIndicator = progressIndicator.getModalityState()) == null) {
                                    progressIndicator = ModalityState.NON_MODAL;
                                }
                                application.invokeLaterOnWriteThread(runnable, (ModalityState)progressIndicator);
                            }
                        }
                        {
                            this.this$0 = this$0;
                        }
                    };
                    SemVer semVer = this.$typingsPackage.getVersion();
                    new PackageInstaller(null, this.$interpreter, this.$typingsPackage.getName(), semVer != null ? semVer.getParsedVersion() : null, this.$installationDir, listener2, "--ignore-scripts").run(this.$indicator);
                }
                catch (Exception e) {
                    TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().warn("Error during installation of " + this.$typingsPackage, (Throwable)e);
                    this.$future.complete(null);
                }
            }
            {
                this.this$0 = typeScriptExternalDefinitionsRegistry;
                this.$typingsPackage = typeScriptPackageName;
                this.$installationDir = file2;
                this.$future = completableFuture;
                this.$indicator = progressIndicator;
                this.$interpreter = nodeJsInterpreter;
            }
        };
        CompletableFuture<VirtualFile> completableFuture2 = this.installingPackages.computeIfAbsent(typingsPackage, new Function<TypeScriptPackageName, CompletableFuture<VirtualFile>>(this, installRunnable2, future, typingsPackage){
            final /* synthetic */ TypeScriptExternalDefinitionsRegistry this$0;
            final /* synthetic */ Runnable $installRunnable;
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ TypeScriptPackageName $typingsPackage;

            @NotNull
            public final CompletableFuture<VirtualFile> apply(@NotNull TypeScriptPackageName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TypeScriptExternalDefinitionsRegistry.access$getExecutor$p(this.this$0).execute(this.$installRunnable);
                return this.$future.handle(new BiFunction<VirtualFile, Throwable, VirtualFile>(this){
                    final /* synthetic */ installPackage.1 this$0;

                    @Nullable
                    public final VirtualFile apply(@Nullable VirtualFile file2, Throwable $noName_1) {
                        TypeScriptExternalDefinitionsRegistry.access$getInstallingPackages$p(this.this$0.this$0).remove(this.this$0.$typingsPackage);
                        return file2;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = typeScriptExternalDefinitionsRegistry;
                this.$installRunnable = runnable;
                this.$future = completableFuture;
                this.$typingsPackage = typeScriptPackageName;
            }
        });
        Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"installingPackages.compu\u2026handle file\n      }\n    }");
        return completableFuture2;
    }

    private final File createInstallationDirectory(TypeScriptPackageName typingsPackage) {
        String installationPath = Companion.getTypingsVersionPath(typingsPackage);
        if (installationPath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No path provided: " + typingsPackage);
            }
            return null;
        }
        String string = FileUtil.join((String[])new String[]{installationPath, "node_modules"});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.join(installati\u2026eModuleUtil.NODE_MODULES)");
        String nodeModulesPath = string;
        if (!FileUtil.createDirectory((File)new File(nodeModulesPath))) {
            LOG.warn("Unable to create a node_modules directory for " + typingsPackage + ": " + installationPath);
            return null;
        }
        File file2 = new File(installationPath);
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        return it.exists() ? file2 : null;
    }

    public final boolean ensureExternalDefinitionsInstalled$intellij_javascript_impl(@NotNull TypeScriptPackageName typingsPackage) {
        Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ensure external definitions installed: " + typingsPackage);
        }
        String string = Companion.getExactModuleTypingsPath(typingsPackage);
        if (string == null) {
            return false;
        }
        String path = string;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Module path: " + path);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ath(path) ?: return false");
        VirtualFile dir = virtualFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Directory exists: " + path);
        }
        Object object = ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Boolean, Throwable>(this, dir, typingsPackage){
            final /* synthetic */ TypeScriptExternalDefinitionsRegistry this$0;
            final /* synthetic */ VirtualFile $dir;
            final /* synthetic */ TypeScriptPackageName $typingsPackage;

            public final Boolean compute() {
                if (PackageJsonUtil.findChildPackageJsonFile(this.$dir) == null) {
                    return false;
                }
                if (TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().isDebugEnabled()) {
                    TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().debug("Existing module was found: " + this.$typingsPackage);
                }
                TypeScriptExternalDefinitionsRegistry.access$collectModuleDependencies(this.this$0, this.$typingsPackage);
                return true;
            }
            {
                this.this$0 = typeScriptExternalDefinitionsRegistry;
                this.$dir = virtualFile;
                this.$typingsPackage = typeScriptPackageName;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Boole\u2026return@compute true\n    }");
        return (Boolean)object;
    }

    private final NodeJsInterpreter createInterpreter(Project project) {
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        return nodeJsInterpreterManager.getInterpreter();
    }

    @TestOnly
    public final void setTypingsVersionForPackage(@NotNull TypeScriptPackageName sourcePackage, @NotNull SemVer version) {
        Intrinsics.checkNotNullParameter((Object)sourcePackage, (String)"sourcePackage");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Map map2 = this.resolveDefinitionsVersionCache;
        Optional<SemVer> optional = Optional.of(version);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"Optional.of(version)");
        map2.put(sourcePackage, optional);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public State getState() {
        Collection<ModuleDependenciesState> collection;
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.moduleDependencies;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = ((TypeScriptPackageName)it.getKey()).getName();
            Object object = ((TypeScriptPackageName)it.getKey()).getVersion();
            if (object == null || (object = object.getParsedVersion()) == null) {
                object = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.key.version?.parsedVersion ?: \"\"");
            ModuleDependenciesState moduleDependenciesState = new ModuleDependenciesState(string, (String)object, (Collection)it.getValue());
            collection.add(moduleDependenciesState);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        return new State(collection2);
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Iterable $this$forEach$iv = state.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependenciesState it = (ModuleDependenciesState)element$iv;
            boolean bl = false;
            CharSequence charSequence = it.getVersion();
            boolean bl2 = false;
            if (charSequence.length() == 0) continue;
            this.moduleDependencies.putIfAbsent(TypeScriptPackageName.Companion.from(it.getName(), it.getVersion()), CollectionsKt.toSet((Iterable)it.getDependencies()));
        }
    }

    public void dispose() {
        this.executor.shutdownNow();
    }

    public TypeScriptExternalDefinitionsRegistry() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"TypeScript External Definitions Registry", (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026Definitions Registry\", 2)");
        this.executor = executorService;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypeScriptExternalDefinitionsRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(TypeScriptExternalDefinitionsRegistry $this) {
        return $this.executor;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getInstallingPackages$p(TypeScriptExternalDefinitionsRegistry $this) {
        return $this.installingPackages;
    }

    public static final /* synthetic */ void access$collectModuleDependencies(TypeScriptExternalDefinitionsRegistry $this, TypeScriptPackageName typingsPackage) {
        $this.collectModuleDependencies(typingsPackage);
    }

    @NotNull
    public static final TypeScriptExternalDefinitionsRegistry getInstance() {
        return Companion.getInstance();
    }

    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @NotNull
    public static final String getTypingsContainerPath(@NotNull TypeScriptPackageName typingsPackage) {
        return Companion.getTypingsContainerPath(typingsPackage);
    }

    @JvmStatic
    @Nullable
    public static final String getTypingsVersionPath(@NotNull TypeScriptPackageName typingsPackage) {
        return Companion.getTypingsVersionPath(typingsPackage);
    }

    @JvmStatic
    @Nullable
    public static final String getExactModuleTypingsPath(@NotNull TypeScriptPackageName typingsPackage) {
        return Companion.getExactModuleTypingsPath(typingsPackage);
    }

    @Nullable
    public static final String getTestTypingsRootPath() {
        Companion companion = Companion;
        return testTypingsRootPath;
    }

    public static final void setTestTypingsRootPath(@Nullable String string) {
        Companion companion = Companion;
        testTypingsRootPath = string;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$State;", "", "dependencies", "", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$ModuleDependenciesState;", "(Ljava/util/Collection;)V", "getDependencies", "()Ljava/util/Collection;", "setDependencies", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.impl"})
    public static final class State {
        @XCollection(propertyElementName="modules")
        @NotNull
        private Collection<ModuleDependenciesState> dependencies;

        @NotNull
        public final Collection<ModuleDependenciesState> getDependencies() {
            return this.dependencies;
        }

        public final void setDependencies(@NotNull Collection<ModuleDependenciesState> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.dependencies = collection;
        }

        public State(@NotNull Collection<ModuleDependenciesState> dependencies) {
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            this.dependencies = dependencies;
        }

        public /* synthetic */ State(Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                collection = new ArrayList();
            }
            this(collection);
        }

        public State() {
            this(null, 1, null);
        }

        @NotNull
        public final Collection<ModuleDependenciesState> component1() {
            return this.dependencies;
        }

        @NotNull
        public final State copy(@NotNull Collection<ModuleDependenciesState> dependencies) {
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            return new State(dependencies);
        }

        public static /* synthetic */ State copy$default(State state, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                collection = state.dependencies;
            }
            return state.copy(collection);
        }

        @NotNull
        public String toString() {
            return "State(dependencies=" + this.dependencies + ")";
        }

        public int hashCode() {
            Collection<ModuleDependenciesState> collection = this.dependencies;
            return collection != null ? ((Object)collection).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.dependencies, state.dependencies)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Tag(value="module")
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$ModuleDependenciesState;", "", "name", "", "version", "dependencies", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;)V", "getDependencies", "()Ljava/util/Collection;", "setDependencies", "(Ljava/util/Collection;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getVersion", "setVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.impl"})
    public static final class ModuleDependenciesState {
        @Tag(value="name")
        @NotNull
        private String name;
        @Tag(value="version")
        @NotNull
        private String version;
        @XCollection(propertyElementName="dependencies", elementName="dependency")
        @NotNull
        private Collection<String> dependencies;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.version = string;
        }

        @NotNull
        public final Collection<String> getDependencies() {
            return this.dependencies;
        }

        public final void setDependencies(@NotNull Collection<String> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.dependencies = collection;
        }

        public ModuleDependenciesState(@NotNull String name, @NotNull String version, @NotNull Collection<String> dependencies) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            this.name = name;
            this.version = version;
            this.dependencies = dependencies;
        }

        public /* synthetic */ ModuleDependenciesState(String string, String string2, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                boolean bl = false;
                collection = new LinkedHashSet();
            }
            this(string, string2, collection);
        }

        public ModuleDependenciesState() {
            this(null, null, null, 7, null);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final Collection<String> component3() {
            return this.dependencies;
        }

        @NotNull
        public final ModuleDependenciesState copy(@NotNull String name, @NotNull String version, @NotNull Collection<String> dependencies) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            return new ModuleDependenciesState(name, version, dependencies);
        }

        public static /* synthetic */ ModuleDependenciesState copy$default(ModuleDependenciesState moduleDependenciesState, String string, String string2, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleDependenciesState.name;
            }
            if ((n & 2) != 0) {
                string2 = moduleDependenciesState.version;
            }
            if ((n & 4) != 0) {
                collection = moduleDependenciesState.dependencies;
            }
            return moduleDependenciesState.copy(string, string2, collection);
        }

        @NotNull
        public String toString() {
            return "ModuleDependenciesState(name=" + this.name + ", version=" + this.version + ", dependencies=" + this.dependencies + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.version;
            Collection<String> collection = this.dependencies;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleDependenciesState)) break block3;
                    ModuleDependenciesState moduleDependenciesState = (ModuleDependenciesState)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)moduleDependenciesState.name) || !Intrinsics.areEqual((Object)this.version, (Object)moduleDependenciesState.version) || !Intrinsics.areEqual(this.dependencies, moduleDependenciesState.dependencies)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\r\u0010\u0010R&\u0010\u0011\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REGISTRY_KEY", "", "instance", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "getInstance$annotations", "getInstance", "()Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "isEnabled", "", "isEnabled$annotations", "()Z", "testTypingsRootPath", "getTestTypingsRootPath$annotations", "getTestTypingsRootPath", "()Ljava/lang/String;", "setTestTypingsRootPath", "(Ljava/lang/String;)V", "getExactModuleTypingsPath", "typingsPackage", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "getRootDefinitionsDir", "getTypingsContainerPath", "getTypingsScope", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfigService$IntPredicate;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTypingsVersionPath", "intellij.javascript.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final TypeScriptExternalDefinitionsRegistry getInstance() {
            Object object = ApplicationManager.getApplication().getService(TypeScriptExternalDefinitionsRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026ionsRegistry::class.java)");
            return (TypeScriptExternalDefinitionsRegistry)object;
        }

        @JvmStatic
        public static /* synthetic */ void isEnabled$annotations() {
        }

        public final boolean isEnabled() {
            return Registry.is((String)TypeScriptExternalDefinitionsRegistry.REGISTRY_KEY, (boolean)true);
        }

        @Nullable
        public final String getRootDefinitionsDir() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            return application.isUnitTestMode() ? this.getTestTypingsRootPath() : PathManager.getSystemPath() + File.separatorChar + "javascript" + File.separatorChar + "typings";
        }

        @Nullable
        public final TypeScriptConfigService.IntPredicate getTypingsScope(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode() && this.getTestTypingsRootPath() == null) {
                return null;
            }
            String startWith = FileUtil.toCanonicalPath((String)this.getRootDefinitionsDir());
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            CharSequence charSequence = string;
            String string2 = startWith;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"startWith");
            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) {
                return getTypingsScope.1.INSTANCE;
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final String getTypingsContainerPath(@NotNull TypeScriptPackageName typingsPackage) {
            Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
            String root = this.getRootDefinitionsDir();
            if (root != null) {
                String string = FileUtil.join((String[])new String[]{root, TypeScriptDefinitionsUtils.getSourcePackageName(typingsPackage.getName())});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.join(root, getS\u2026ame(typingsPackage.name))");
                return string;
            }
            throw (Throwable)new RuntimeException("Missing root path");
        }

        @JvmStatic
        @Nullable
        public final String getTypingsVersionPath(@NotNull TypeScriptPackageName typingsPackage) {
            Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
            SemVer semVer = typingsPackage.getVersion();
            if (semVer == null) {
                return null;
            }
            SemVer version = semVer;
            return FileUtil.join((String[])new String[]{this.getTypingsContainerPath(typingsPackage), version.getParsedVersion()});
        }

        @JvmStatic
        @Nullable
        public final String getExactModuleTypingsPath(@NotNull TypeScriptPackageName typingsPackage) {
            String string;
            Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
            String string2 = this.getTypingsVersionPath(typingsPackage);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = FileUtil.join((String[])new String[]{it, "node_modules", typingsPackage.getName()});
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        public static /* synthetic */ void getTestTypingsRootPath$annotations() {
        }

        @Nullable
        public final String getTestTypingsRootPath() {
            return testTypingsRootPath;
        }

        public final void setTestTypingsRootPath(@Nullable String string) {
            testTypingsRootPath = string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

