/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.impl.DownloadableFileDescriptionImpl;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.util.JsonUtil;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAllStubsFile {
    private static final Logger LOG = Logger.getInstance(TypeScriptAllStubsFile.class);
    public static final TypeScriptAllStubsFile INSTANCE = new TypeScriptAllStubsFile();
    private static final String URL_ALL = "https://api.github.com/repos/DefinitelyTyped/DefinitelyTyped/git/trees/master?recursive=1";
    private static final String TYPES_DIR = "types/";
    private static final String FILE_URL = "https://github.com/DefinitelyTyped/DefinitelyTyped/raw/master/types/";
    private static final String URL_ITEM = "https://api.github.com/repos/DefinitelyTyped/DefinitelyTyped/contents/types/";
    private static final String D_TS_FILE = "d.ts";
    private static final String D_TSX_FILE = "d.tsx";
    private final ReentrantLock myLock = new ReentrantLock();
    private volatile SoftReference<List<DownloadableFileSetDescriptionWithUrl>> myListSoftReference;

    @NotNull
    static File getAllTsStubDescriptionsCacheFile() {
        return new File(PathManager.getConfigPath() + File.separatorChar + "javascript" + File.separatorChar + "all-ts-stub-descriptions-cache.json");
    }

    public void downloadTsStubDescriptionsCacheFile(boolean wait) throws IOException {
        File file2 = TypeScriptAllStubsFile.getAllTsStubDescriptionsCacheFile();
        if (!this.myLock.tryLock()) {
            if (!wait) {
                return;
            }
            this.myLock.lock();
            this.myLock.unlock();
            return;
        }
        try {
            HttpRequests.request((String)URL_ALL).connect(request -> {
                try {
                    return request.saveToFile(file2, null);
                }
                catch (IOException e) {
                    FileUtil.delete((File)file2);
                    throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)true), e);
                }
            });
        }
        finally {
            this.myLock.unlock();
            this.myListSoftReference = null;
        }
    }

    public DownloadableFileSetDescriptionWithUrl getDownloadableFileSetDescription(@NotNull String name) {
        List<DownloadableFileSetDescriptionWithUrl> urls;
        if (name == null) {
            TypeScriptAllStubsFile.$$$reportNull$$$0(0);
        }
        if ((urls = this.getCachedUrls()) != null) {
            for (DownloadableFileSetDescriptionWithUrl url : urls) {
                if (!name.equals(url.getName())) continue;
                return url;
            }
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.downloadTsStubDescriptionsCacheFile(false);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        });
        return new LazyDefinitelyTypedFileSetDescription(name);
    }

    @Nullable
    private List<DownloadableFileSetDescriptionWithUrl> getCachedUrls() {
        List cachedData = (List)SoftReference.deref(this.myListSoftReference);
        if (cachedData != null) {
            return cachedData;
        }
        File cachedFile = TypeScriptAllStubsFile.getAllTsStubDescriptionsCacheFile();
        if (cachedFile.exists()) {
            try {
                return this.parseDescriptions(cachedFile);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    List<DownloadableFileSetDescriptionWithUrl> parseDescriptions(@NotNull File tsStubDescriptionsJsonFile) throws IOException {
        if (tsStubDescriptionsJsonFile == null) {
            TypeScriptAllStubsFile.$$$reportNull$$$0(1);
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(tsStubDescriptionsJsonFile), StandardCharsets.UTF_8));
        List<DownloadableFileSetDescriptionWithUrl> urls = TypeScriptAllStubsFile.parseTypes(reader);
        this.myListSoftReference = new SoftReference(urls);
        List<DownloadableFileSetDescriptionWithUrl> list2 = urls;
        if (list2 == null) {
            TypeScriptAllStubsFile.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private static List<DownloadableFileSetDescriptionWithUrl> parseTypes(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            TypeScriptAllStubsFile.$$$reportNull$$$0(3);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Unable to parse types: root element is not an object");
        }
        ArrayList<DownloadableFileSetDescriptionWithUrl> versions = new ArrayList<DownloadableFileSetDescriptionWithUrl>();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("tree".equals(name)) {
                if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                    throw new IOException("Unable to parse types: tree child is not an array");
                }
                reader.beginArray();
                while (reader.hasNext()) {
                    String typeName = TypeScriptAllStubsFile.parseTypeName(reader);
                    if (typeName == null) continue;
                    versions.add(new LazyDefinitelyTypedFileSetDescription(typeName));
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        ArrayList<DownloadableFileSetDescriptionWithUrl> arrayList = versions;
        if (arrayList == null) {
            TypeScriptAllStubsFile.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static String parseTypeName(@NotNull JsonReader reader) throws IOException {
        String subPath;
        if (reader == null) {
            TypeScriptAllStubsFile.$$$reportNull$$$0(5);
        }
        Map map2 = JsonUtil.getTopLevelStringValues((JsonReader)reader, (Set)ContainerUtil.newHashSet((Object[])new String[]{"path", "type"}));
        String path = (String)map2.get("path");
        String type = (String)map2.get("type");
        if (path != null && "tree".equals(type) && path.startsWith(TYPES_DIR) && !(subPath = path.substring(TYPES_DIR.length())).contains("/")) {
            return subPath;
        }
        return null;
    }

    @Nullable
    private static String getDefinitionFileExtension(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(".d.ts")) {
            return D_TS_FILE;
        }
        if (name.endsWith(".d.tsx")) {
            return D_TSX_FILE;
        }
        return null;
    }

    private static boolean isFile(@Nullable String type) {
        return "file".equals(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsStubDescriptionsJsonFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/download/TypeScriptAllStubsFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/download/TypeScriptAllStubsFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDescriptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDownloadableFileSetDescription";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseDescriptions";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LazyDefinitelyTypedFileSetDescription
    implements DownloadableFileSetDescriptionWithUrl {
        @NotNull
        private final String myName;
        private final NotNullLazyValue<List<DownloadableFileDescription>> myDescriptions;

        LazyDefinitelyTypedFileSetDescription(@NotNull String name) {
            if (name == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(0);
            }
            this.myDescriptions = NotNullLazyValue.atomicLazy(() -> this.downloadDescriptions());
            this.myName = name;
        }

        public void downloadLibrary(@NotNull Project project, @NotNull LangScriptingContextProvider provider, @Nullable Component notificationAreaComponent, @Nullable Runnable onLibraryCreated) {
            if (project == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(1);
            }
            if (provider == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(2);
            }
            TypeScriptDefinitionFilesRootsProvider.LibraryCreator.downloadTypesLibrary(project, (DownloadableFileSetDescription)this, notificationAreaComponent, onLibraryCreated);
        }

        @NotNull
        public String getUrl() {
            String string = TypeScriptAllStubsFile.FILE_URL + this.myName + "/";
            if (string == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getVersionString() {
            return "@types";
        }

        @NotNull
        private List<DownloadableFileDescription> downloadDescriptions() {
            Collection<String> files = LazyDefinitelyTypedFileSetDescription.filterDuplicateFilesWithVersion(this.downloadUrlList());
            List list2 = ContainerUtil.map(files, name -> {
                String fileNameWithoutExtension = LazyDefinitelyTypedFileSetDescription.getFileNameWithoutExtension(name);
                String extension = TypeScriptAllStubsFile.getDefinitionFileExtension(name);
                assert (extension != null);
                return new DownloadableFileDescriptionImpl(TypeScriptAllStubsFile.FILE_URL + this.myName + "/" + name, fileNameWithoutExtension, extension);
            });
            if (list2 == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(5);
            }
            return list2;
        }

        @NotNull
        public List<? extends DownloadableFileDescription> getFiles() {
            List list2 = (List)this.myDescriptions.getValue();
            if (list2 == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        private static Collection<String> filterDuplicateFilesWithVersion(Collection<String> names) {
            LinkedHashMap<String, String> fileNamesWithoutExtensionsToFullNames = new LinkedHashMap<String, String>();
            for (String name : names) {
                String fileNameWithoutExtension = LazyDefinitelyTypedFileSetDescription.getFileNameWithoutExtension(name);
                if (StringUtil.isEmpty((String)fileNameWithoutExtension)) continue;
                fileNamesWithoutExtensionsToFullNames.put(fileNameWithoutExtension, name);
            }
            Set fileNamesWithoutExtensions = fileNamesWithoutExtensionsToFullNames.keySet();
            ArrayList<String> results = new ArrayList<String>();
            for (Map.Entry entry : fileNamesWithoutExtensionsToFullNames.entrySet()) {
                String normalizedName;
                String nameWithoutExtension = (String)entry.getKey();
                if (!nameWithoutExtension.equals(normalizedName = LazyDefinitelyTypedFileSetDescription.getNormalizedName(nameWithoutExtension)) && fileNamesWithoutExtensions.contains(normalizedName)) continue;
                results.add((String)entry.getValue());
            }
            ArrayList<String> arrayList = results;
            if (arrayList == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static String getNormalizedName(@NotNull String name) {
            int nextIndex;
            if (name == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(8);
            }
            int i = name.indexOf("-");
            while (i > 0 && (nextIndex = i + 1) < name.length()) {
                char nextChar = name.charAt(nextIndex);
                if (StringUtil.isDecimalDigit((char)nextChar)) {
                    return name.substring(0, i);
                }
                i = name.indexOf("-", nextIndex);
            }
            return name;
        }

        private static String getFileNameWithoutExtension(String fullName) {
            return FileUtilRt.getNameWithoutExtension((String)FileUtilRt.getNameWithoutExtension((String)fullName));
        }

        @NotNull
        private Collection<String> downloadUrlList() {
            final ArrayList<String> files = new ArrayList<String>();
            HttpRequests.request((String)(TypeScriptAllStubsFile.URL_ITEM + this.myName)).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                public Object process(@NotNull HttpRequests.Request request) throws IOException {
                    JsonElement jsonElement;
                    if (request == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((jsonElement = new JsonParser().parse((Reader)request.getReader())) instanceof JsonArray) {
                        for (JsonElement element : (JsonArray)jsonElement) {
                            if (!element.isJsonObject()) continue;
                            JsonObject jsonObject = element.getAsJsonObject();
                            String name = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"name");
                            String type = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"type");
                            String extension = TypeScriptAllStubsFile.getDefinitionFileExtension(name);
                            if (!TypeScriptAllStubsFile.isFile(type) || extension == null) continue;
                            files.add(name);
                        }
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/lang/javascript/library/download/TypeScriptAllStubsFile$LazyDefinitelyTypedFileSetDescription$1", "process"));
                }
            }, null, null);
            ArrayList<String> arrayList = files;
            if (arrayList == null) {
                LazyDefinitelyTypedFileSetDescription.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/download/TypeScriptAllStubsFile$LazyDefinitelyTypedFileSetDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/download/TypeScriptAllStubsFile$LazyDefinitelyTypedFileSetDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadDescriptions";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterDuplicateFilesWithVersion";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadUrlList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadLibrary";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

