/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCorePredefinedLibrariesProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(JSCorePredefinedLibrariesProvider.class);
    public static final String LIB_HTML = "HTML";
    public static final String LIB_NASHORN = "Nashorn";
    public static final String LIB_NODE = "Node.js Core";
    public static final String LIB_ES6 = "ECMAScript 6+";
    public static final String ECMASCRIPT5_JS = "lib.es5.d.ts";
    public static final String BROWSER_D_TS = "browser.d.ts";
    public static final String FLOW_UTILITIES_D_TS = "flow.utilities.d.ts";
    public static final String ES2019_DECORATORS_D_TS = "es2019decorators.d.ts";
    private static final String[] ES6_LIB_FILES = new String[]{"lib.esnext.bigint.d.ts", "es2019decorators.d.ts", "esnext.weakref.d.ts"};
    public static final String[] HTML_FILES = new String[]{"lib.dom.d.ts", "lib.dom.iterable.d.ts", "lib.scripthost.d.ts", "lib.webworker.d.ts", "lib.webworker.importscripts.d.ts", "browser.d.ts", "xpath.d.ts", "websql.d.ts"};
    @NotNull
    private static final Map<String, String[]> ourLibMappings = ContainerUtil.immutableMapBuilder().put((Object)"HTML", (Object)HTML_FILES).put((Object)"react.d.ts", (Object)new String[]{"react.d.ts"}).put((Object)"lib.es5.d.ts", (Object)new String[]{"lib.es5.d.ts"}).put((Object)"ECMAScript 6+", (Object)ES6_LIB_FILES).put((Object)"flow.utilities.d.ts", (Object)new String[]{"flow.utilities.d.ts"}).build();
    @NotNull
    private static final ConcurrentMap<String, Set<VirtualFile>> ourLibFiles = new ConcurrentHashMap<String, Set<VirtualFile>>();
    @NotNull
    private static final ConcurrentMap<String, Ref<VirtualFile>> ourLibFileCache = new ConcurrentHashMap<String, Ref<VirtualFile>>();
    private static final NotNullLazyValue<Set<VirtualFile>> ourFlowJSPredefLibFiles = NotNullLazyValue.atomicLazy(() -> {
        VirtualFile flow = JSCorePredefinedLibrariesProvider.getAndCacheFromCompilerFolder("flow");
        if (flow == null) {
            return Collections.emptySet();
        }
        return ((StreamEx)StreamEx.of((Object[])flow.getChildren()).filter(el -> el.isValid() && !el.isDirectory())).toImmutableSet();
    });
    private static final NotNullLazyValue<Set<VirtualFile>> ourJSPredefLibFiles = NotNullLazyValue.atomicLazy(() -> {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getHtmlLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getLibFiles((Condition<? super String>)((Condition)JSCorePredefinedLibrariesProvider::isES6Lib), false));
        result2.addAll(JSCorePredefinedLibrariesProvider.getES6CorePredefinedLibraryFiles());
        return result2;
    });
    private static final NotNullLazyValue<Set<VirtualFile>> ourAllJSAndTSPredefLibFiles = NotNullLazyValue.atomicLazy(() -> {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getHtmlLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getLibFiles((Condition<? super String>)Conditions.alwaysTrue(), false));
        result2.addAll(JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles());
        return result2;
    });

    @NotNull
    private static Set<VirtualFile> getFilesByLibName(@NotNull String name) {
        if (name == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(0);
        }
        Set set = ourLibFiles.computeIfAbsent(name, libName -> {
            String[] strings = ourLibMappings.get(libName);
            assert (strings != null);
            VirtualFile folder = JSCorePredefinedLibrariesProvider.getAndCacheFromCompilerFolder("external");
            if (folder == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(JSCorePredefinedLibrariesProvider.getFilesByNames(folder, strings));
        });
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(1);
        }
        return set;
    }

    public static boolean isECMAScriptLibraryFileName(String fileName) {
        for (VirtualFile file2 : (Set)ourJSPredefLibFiles.getValue()) {
            if (!fileName.equals(file2.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isWebLibraryFileName(String fileName) {
        return ArrayUtil.indexOf((Object[])HTML_FILES, (Object)fileName) >= 0;
    }

    public static boolean isCoreLibraryFile(@Nullable VirtualFile libFile) {
        return libFile != null && JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(libFile) && !JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles().contains(libFile);
    }

    public static boolean isLibraryElement(@Nullable PsiElement element) {
        VirtualFile file2;
        PsiFile psiFile = element != null ? element.getContainingFile() : null;
        psiFile = psiFile != null ? psiFile.getOriginalFile() : null;
        VirtualFile virtualFile = file2 = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file2 == null) {
            file2 = (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)psiFile);
        }
        if (file2 == null && psiFile != null) {
            file2 = psiFile.getViewProvider().getVirtualFile();
        }
        if (file2 instanceof LightVirtualFile) {
            file2 = ((LightVirtualFile)file2).getOriginalFile();
        }
        return file2 != null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(file2);
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptPredefinedLibraryFiles() {
        Set set = (Set)ourJSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getJSXPredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName("react.d.ts");
    }

    @NotNull
    public static VirtualFile getReactLibraryFile() {
        VirtualFile virtualFile = JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles().iterator().next();
        if (virtualFile == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptCorePredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName(ECMASCRIPT5_JS);
    }

    @NotNull
    public static Set<VirtualFile> getES6CorePredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName(LIB_ES6);
    }

    public static Set<VirtualFile> getHtmlLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName(LIB_HTML);
    }

    @NotNull
    public static Set<VirtualFile> getFlowJSCorePredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName(FLOW_UTILITIES_D_TS);
    }

    public static Set<VirtualFile> getFlowJSPredefinedLibraryFiles() {
        return (Set)ourFlowJSPredefLibFiles.getValue();
    }

    @Override
    public ScriptingLibraryModel @NotNull [] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(4);
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{ScriptingLibraryModel.createPredefinedLibrary((String)LIB_HTML, (VirtualFile[])VfsUtilCore.toVirtualFileArray(JSCorePredefinedLibrariesProvider.getHtmlLibraryFiles()), (boolean)true)};
        if (scriptingLibraryModelArray == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(5);
        }
        return scriptingLibraryModelArray;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesToIndex() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve(@NotNull Project project) {
        if (project == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(7);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        JSLanguageLevel level = JSRootConfiguration.getInstance(project).getLanguageLevel();
        if (level.isES6Compatible()) {
            files.addAll(JSCorePredefinedLibrariesProvider.getLibFiles((Condition<? super String>)((Condition)JSCorePredefinedLibrariesProvider::isES6Lib), false));
            files.addAll(JSCorePredefinedLibrariesProvider.getES6CorePredefinedLibraryFiles());
        }
        files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getAllJSPredefinedLibraryFiles() {
        Set set = (Set)ourAllJSAndTSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static boolean isES6Lib(@NotNull String fileName) {
        if (fileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(10);
        }
        if (ArrayUtil.contains((String)fileName, (String[])ES6_LIB_FILES)) {
            return true;
        }
        if (fileName.endsWith(".full.d.ts")) {
            return false;
        }
        String exactLibName = TypeScriptUtil.getLibraryName(fileName);
        if (StringUtil.isEmpty((String)exactLibName) || exactLibName.length() <= 4) {
            return false;
        }
        return TypeScriptUtil.isES6LibName(exactLibName);
    }

    @Nullable
    private static Ref<VirtualFile> getCachedExternalFileRef(String name) {
        return (Ref)ourLibFileCache.get(name);
    }

    @NotNull
    private static Set<VirtualFile> getFilesByNames(@NotNull VirtualFile folder, String ... predefinedFileNames) {
        if (folder == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(11);
        }
        if (predefinedFileNames == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(12);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(predefinedFileNames.length);
        boolean isRefreshStarted = false;
        for (String predefinedFileName : predefinedFileNames) {
            VirtualFile file2 = folder.findChild(predefinedFileName);
            if (file2 == null || !file2.isValid()) {
                LOG.warn("Cannot find valid library file " + predefinedFileName + ", the installation is possibly broken.");
                if (isRefreshStarted) continue;
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{folder});
                isRefreshStarted = true;
                continue;
            }
            files.add(file2);
        }
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getLibFiles(@NotNull Condition<? super String> includeCondition, boolean includeInvalid) {
        VirtualFile virtualFileExternalDirectory;
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(14);
        }
        if ((virtualFileExternalDirectory = JSCorePredefinedLibrariesProvider.getAndCacheFromCompilerFolder("external")) == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(15);
            }
            return set;
        }
        return JSCorePredefinedLibrariesProvider.getLibDtsFilesByVFS(virtualFileExternalDirectory, includeCondition, includeInvalid);
    }

    @Nullable
    private static VirtualFile getAndCacheFromCompilerFolder(@NotNull String externalResourceDirName) {
        Ref<VirtualFile> fileRef;
        VirtualFile virtualFileExternalDirectory;
        if (externalResourceDirName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(16);
        }
        if ((virtualFileExternalDirectory = (VirtualFile)Ref.deref(fileRef = JSCorePredefinedLibrariesProvider.getCachedExternalFileRef(externalResourceDirName))) != null && virtualFileExternalDirectory.isValid()) {
            return virtualFileExternalDirectory;
        }
        String rawPath = TypeScriptUtil.getTypeScriptCompilerFolderFile().getAbsolutePath();
        String path = FileUtil.toSystemIndependentName((String)rawPath) + "/" + externalResourceDirName;
        virtualFileExternalDirectory = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        JSLibraryUtil.cacheFile(externalResourceDirName, virtualFileExternalDirectory, ourLibFileCache);
        if (virtualFileExternalDirectory == null) {
            LOG.error("Cannot find external directory " + rawPath + ", the installation is possibly broken.");
            return null;
        }
        return virtualFileExternalDirectory;
    }

    @NotNull
    public static Set<VirtualFile> getLibDtsFilesByVFS(@NotNull VirtualFile directory, @NotNull Condition<? super String> includeCondition, boolean includeInvalid) {
        if (directory == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(17);
        }
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(18);
        }
        VirtualFile[] children = directory.getChildren();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(children.length);
        for (VirtualFile child : children) {
            String name;
            if (child.isDirectory() || !child.isValid() && !includeInvalid || !JSCorePredefinedLibrariesProvider.isLibFileAcceptable(includeCondition, name = child.getName())) continue;
            result2.add(child);
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static boolean isLibFileAcceptable(@NotNull Condition<? super String> includeCondition, @NotNull String name) {
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(20);
        }
        if (name == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(21);
        }
        return name.startsWith("lib.") && TypeScriptUtil.isDefinitionFile(name) && includeCondition.value((Object)name);
    }

    @NotNull
    public static List<VirtualFile> getLibFilesByIO(@NotNull File libFolder, @NotNull Condition<? super String> includeCondition, boolean includeInvalid) {
        if (libFolder == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(22);
        }
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(23);
        }
        if (!libFolder.exists() || !libFolder.isDirectory()) {
            LOG.error("Cannot find external directory, the installation is possibly broken.");
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(24);
            }
            return list2;
        }
        File[] files = libFolder.listFiles();
        if (files == null) {
            LOG.error("Cannot find files in the external directory, the installation is possibly broken.");
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(25);
            }
            return list3;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.length);
        for (File file2 : files) {
            String name;
            ProgressManager.checkCanceled();
            if (file2.isDirectory() || !JSCorePredefinedLibrariesProvider.isLibFileAcceptable(includeCondition, name = file2.getName())) continue;
            ContainerUtil.addIfNotNull(result2, (Object)JSLibraryUtil.findFileByIO(file2, includeInvalid));
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFileNames";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeCondition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalResourceDirName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByLibName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptPredefinedLibraryFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReactLibraryFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesToIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJSPredefinedLibraryFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibDtsFilesByVFS";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibFilesByIO";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByLibName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isES6Lib";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAndCacheFromCompilerFolder";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLibDtsFilesByVFS";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isLibFileAcceptable";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLibFilesByIO";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

