/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCDNLibManager {
    private static final List<JSCDNLibraryProvider> ourProviders = new ArrayList<JSCDNLibraryProvider>();

    @Nullable
    public static JSCDNLibrary getLibraryForUrl(@NotNull String url) {
        if (url == null) {
            JSCDNLibManager.$$$reportNull$$$0(0);
        }
        for (JSCDNLibraryProvider provider : ourProviders) {
            JSCDNLibrary library = provider.getLibraryForUrl(url);
            if (library == null) continue;
            return library;
        }
        return null;
    }

    static {
        ourProviders.add(new NPMSourcedCDNLibraryProvider("https://unpkg.com/"));
        ourProviders.add(new NPMSourcedCDNLibraryProvider("https://cdn.jsdelivr.net/npm/"));
        ourProviders.add(new CDNJSCDNLibraryProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/library/JSCDNLibManager", "getLibraryForUrl"));
    }

    private static final class CDNJSLibrary
    implements JSCDNLibrary {
        private final String myOriginalUrl;

        private CDNJSLibrary(@NotNull String originalUrl) {
            if (originalUrl == null) {
                CDNJSLibrary.$$$reportNull$$$0(0);
            }
            this.myOriginalUrl = originalUrl;
        }

        @Override
        @NotNull
        public String getOriginalUrl() {
            String string = this.myOriginalUrl;
            if (string == null) {
                CDNJSLibrary.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getLibraryName() {
            int prefixLength = "https://cdnjs.cloudflare.com/ajax/libs/".length();
            int nextSegment = this.myOriginalUrl.indexOf(47, prefixLength);
            if (nextSegment < 0) {
                nextSegment = this.myOriginalUrl.length();
            }
            String string = this.myOriginalUrl.substring(prefixLength, nextSegment);
            if (string == null) {
                CDNJSLibrary.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getNonMinifiedUrl(boolean forDownload) {
            String string = JSLibraryUtil.convertLocationSuffixToNonMinimized(this.myOriginalUrl);
            if (string == null) {
                CDNJSLibrary.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalUrl";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/JSCDNLibManager$CDNJSLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/JSCDNLibManager$CDNJSLibrary";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalUrl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNonMinifiedUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CDNJSCDNLibraryProvider
    implements JSCDNLibraryProvider {
        private static final String CDNJS_PREFIX = "https://cdnjs.cloudflare.com/ajax/libs/";

        private CDNJSCDNLibraryProvider() {
        }

        @Override
        @Nullable
        public JSCDNLibrary getLibraryForUrl(@NotNull String url) {
            if (url == null) {
                CDNJSCDNLibraryProvider.$$$reportNull$$$0(0);
            }
            if (url.startsWith(CDNJS_PREFIX)) {
                return new CDNJSLibrary(url);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/library/JSCDNLibManager$CDNJSCDNLibraryProvider", "getLibraryForUrl"));
        }
    }

    private static final class NPMSourcedCDNLibrary
    implements JSCDNLibrary {
        private final String myOriginalUrl;
        private final String myUrlPrefix;

        private NPMSourcedCDNLibrary(@NotNull String originalUrl, @NotNull String urlPrefix) {
            if (originalUrl == null) {
                NPMSourcedCDNLibrary.$$$reportNull$$$0(0);
            }
            if (urlPrefix == null) {
                NPMSourcedCDNLibrary.$$$reportNull$$$0(1);
            }
            this.myOriginalUrl = originalUrl;
            this.myUrlPrefix = urlPrefix;
        }

        @Override
        @NotNull
        public String getOriginalUrl() {
            String string = this.myOriginalUrl;
            if (string == null) {
                NPMSourcedCDNLibrary.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getLibraryName() {
            String string = this.parseUrl().name;
            if (string == null) {
                NPMSourcedCDNLibrary.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getNonMinifiedUrl(boolean forDownload) {
            LibUrlSegments segments = this.parseUrl();
            if (segments.filePath == null) {
                if (forDownload) {
                    if (segments.name.equals("vue")) {
                        String string = this.myOriginalUrl + (this.myOriginalUrl.endsWith("/") ? "" : "/") + "dist/vue.js";
                        if (string == null) {
                            NPMSourcedCDNLibrary.$$$reportNull$$$0(4);
                        }
                        return string;
                    }
                } else {
                    String string = this.myOriginalUrl + ".js";
                    if (string == null) {
                        NPMSourcedCDNLibrary.$$$reportNull$$$0(5);
                    }
                    return string;
                }
            }
            String string = JSLibraryUtil.convertLocationSuffixToNonMinimized(this.myOriginalUrl);
            if (string == null) {
                NPMSourcedCDNLibrary.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        private LibUrlSegments parseUrl() {
            int secondSegmentEnd;
            Object libName;
            int prefixLength = this.myUrlPrefix.length();
            int nameSegmentEnd = this.myOriginalUrl.indexOf(47, prefixLength);
            if (nameSegmentEnd < 0) {
                nameSegmentEnd = this.myOriginalUrl.length();
            }
            if (((String)(libName = this.myOriginalUrl.substring(prefixLength, nameSegmentEnd))).startsWith("@") && (secondSegmentEnd = this.myOriginalUrl.indexOf(47, nameSegmentEnd + 1)) > 0) {
                libName = (String)libName + this.myOriginalUrl.substring(nameSegmentEnd, secondSegmentEnd);
                nameSegmentEnd = secondSegmentEnd;
            }
            int versionPartStart = ((String)libName).lastIndexOf(64);
            String version = null;
            if (versionPartStart > 0) {
                version = ((String)libName).substring(versionPartStart + 1);
                libName = ((String)libName).substring(0, versionPartStart);
            }
            String filePath = nameSegmentEnd + 1 < this.myOriginalUrl.length() ? this.myOriginalUrl.substring(nameSegmentEnd + 1) : null;
            return new LibUrlSegments((String)libName, version, filePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlPrefix";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/JSCDNLibManager$NPMSourcedCDNLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/JSCDNLibManager$NPMSourcedCDNLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNonMinifiedUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class LibUrlSegments {
            @NotNull
            final String name;
            @Nullable
            final String version;
            @Nullable
            final String filePath;

            private LibUrlSegments(@NotNull String name, @Nullable String version, @Nullable String filePath) {
                if (name == null) {
                    LibUrlSegments.$$$reportNull$$$0(0);
                }
                this.name = name;
                this.version = version;
                this.filePath = filePath;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/library/JSCDNLibManager$NPMSourcedCDNLibrary$LibUrlSegments", "<init>"));
            }
        }
    }

    private static class NPMSourcedCDNLibraryProvider
    implements JSCDNLibraryProvider {
        private final String myUrlPrefix;

        NPMSourcedCDNLibraryProvider(String urlPrefix) {
            this.myUrlPrefix = urlPrefix;
        }

        @Override
        @Nullable
        public JSCDNLibrary getLibraryForUrl(@NotNull String url) {
            if (url == null) {
                NPMSourcedCDNLibraryProvider.$$$reportNull$$$0(0);
            }
            if (url.startsWith(this.myUrlPrefix)) {
                return new NPMSourcedCDNLibrary(url, this.myUrlPrefix);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/library/JSCDNLibManager$NPMSourcedCDNLibraryProvider", "getLibraryForUrl"));
        }
    }

    private static interface JSCDNLibraryProvider {
        @Nullable
        public JSCDNLibrary getLibraryForUrl(@NotNull String var1);
    }

    public static interface JSCDNLibrary {
        @NotNull
        public String getOriginalUrl();

        @NotNull
        public String getLibraryName();

        @NotNull
        public String getNonMinifiedUrl(boolean var1);
    }
}

