/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JSQuoteUnquotePropertiesIntentionBase;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JSUnquoteLiteralPropertiesIntention
extends JSQuoteUnquotePropertiesIntentionBase {
    @Override
    protected String getActionName() {
        return JavaScriptBundle.message((String)"js.quote.unquote.intention.unquote", (Object[])new Object[0]);
    }

    @Override
    protected boolean canPerformAction(Collection<JSProperty> properties, Project project) {
        if (properties.isEmpty()) {
            return false;
        }
        for (JSProperty property : properties) {
            String name;
            if (PsiUtilCore.getElementType((PsiElement)property.getNameIdentifier()) != JSTokenTypes.STRING_LITERAL || (name = property.getName()) == null || !JSRefactoringUtil.isValidIdentifier(name, project)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSUnquoteLiteralPropertiesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSUnquoteLiteralPropertiesIntention.$$$reportNull$$$0(1);
        }
        for (JSProperty property : JSUnquoteLiteralPropertiesIntention.collectProperties(element, editor)) {
            String name;
            PsiElement identifier = property.getNameIdentifier();
            if (PsiUtilCore.getElementType((PsiElement)identifier) != JSTokenTypes.STRING_LITERAL || (name = property.getName()) == null || !JSRefactoringUtil.isValidIdentifier(name, project)) continue;
            identifier.replace(JSChangeUtil.createTokenElement((PsiElement)property, JSTokenTypes.IDENTIFIER, name));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/intentions/JSUnquoteLiteralPropertiesIntention";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

