/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6AddExportModifierIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ES6AddExportModifierIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.intention.add.export.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6AddExportModifierIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ES6AddExportModifierIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ES6AddExportModifierIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element) || !DialectDetector.hasFeature(element, JSLanguageFeature.EXPORT_DECLARATIONS)) {
            return false;
        }
        return ES6AddExportModifierIntention.isAcceptableElement(ES6AddExportModifierIntention.findParentNamedElement(element, JSNamedElement.class));
    }

    @Nullable
    static PsiElement getModuleIfTopLevel(@Nullable JSNamedElement namedElement) {
        JSVarStatement sourceElement;
        Object object = sourceElement = namedElement instanceof JSVariable ? ((JSVariable)namedElement).getStatement() : (JSSourceElement)ObjectUtils.tryCast((Object)namedElement, JSSourceElement.class);
        if (sourceElement == null) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        return parent instanceof JSFile && ((JSFile)parent).getModuleStatus() == JSFile.ModuleStatus.ES6 || parent instanceof TypeScriptModule || ES6PsiUtil.isEmbeddedModule(parent) ? parent : null;
    }

    static boolean isAcceptableElement(@Nullable JSNamedElement namedElement) {
        PsiElement module;
        return (namedElement instanceof JSVariable || namedElement instanceof JSClass || namedElement instanceof JSFunction) && (module = ES6AddExportModifierIntention.getModuleIfTopLevel(namedElement)) != null && !ES6ImportHandler.isExportedWithNameOrDefaultOrAssignment((PsiElement)namedElement);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            ES6AddExportModifierIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ES6AddExportModifierIntention.$$$reportNull$$$0(5);
        }
        ES6AddExportModifierIntention.applyExportStatus(ES6AddExportModifierIntention.findParentNamedElement(element, JSAttributeListOwner.class), true);
    }

    static void applyExportStatus(@Nullable JSAttributeListOwner namedElement, boolean exported) {
        JSAttributeListOwner target;
        Object object = target = namedElement instanceof JSVariable ? ((JSVariable)namedElement).getStatement() : namedElement;
        if (target == null) {
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(target);
        wrapper.overrideModifier(JSAttributeList.ModifierType.EXPORT, exported);
        wrapper.applyTo(target);
    }

    @NotNull
    public static LocalQuickFixOnPsiElement createFixForElement(@NotNull JSNamedElement element) {
        if (element == null) {
            ES6AddExportModifierIntention.$$$reportNull$$$0(6);
        }
        return new Fix((PsiElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6AddExportModifierIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6AddExportModifierIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFixForElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Fix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        @IntentionName
        private final String myMessage;

        private Fix(@NotNull PsiElement element) {
            if (element == null) {
                Fix.$$$reportNull$$$0(0);
            }
            super(element);
            PsiFile containingFile = element.getContainingFile();
            this.myMessage = JavaScriptBundle.message((String)"javascript.intention.add.export.fix.text", (Object[])new Object[]{new JSNamedElementPresenter(element).describeWithShortName(), containingFile.getName()});
        }

        @NotNull
        public String getText() {
            String string = this.myMessage;
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"javascript.intention.add.export.family.name", (Object[])new Object[0]);
            if (string == null) {
                Fix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                Fix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                Fix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                Fix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                Fix.$$$reportNull$$$0(6);
            }
            ES6AddExportModifierIntention.applyExportStatus((JSAttributeListOwner)ObjectUtils.tryCast((Object)startElement, JSAttributeListOwner.class), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6AddExportModifierIntention$Fix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6AddExportModifierIntention$Fix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

