/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.unusedsymbols;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSUnusedGlobalCandidatesCollector
extends JSElementVisitor {
    private final Set<? super PsiElement> myCandidates;
    private final boolean myReportUnusedProperties;
    private final boolean myReportUnusedDefinitions;
    private static final Set<String> INTERNALLY_USED_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"toString", "prototype", "valueOf"});

    public JSUnusedGlobalCandidatesCollector(@NotNull Set<? super PsiElement> outCandidates, @NotNull JSUnusedGlobalSymbolsInspection tool) {
        if (outCandidates == null) {
            JSUnusedGlobalCandidatesCollector.$$$reportNull$$$0(0);
        }
        if (tool == null) {
            JSUnusedGlobalCandidatesCollector.$$$reportNull$$$0(1);
        }
        this.myCandidates = outCandidates;
        this.myReportUnusedProperties = tool.myReportUnusedProperties;
        this.myReportUnusedDefinitions = tool.myReportUnusedDefinitions;
    }

    private void queueCandidate(@NotNull PsiElement element) {
        if (element == null) {
            JSUnusedGlobalCandidatesCollector.$$$reportNull$$$0(2);
        }
        if (!JSUnusedGlobalCandidatesCollector.isImplicitlyUsed(element)) {
            this.myCandidates.add((PsiElement)element);
        }
    }

    private static boolean isImplicitlyUsed(@NotNull PsiElement element) {
        if (element == null) {
            JSUnusedGlobalCandidatesCollector.$$$reportNull$$$0(3);
        }
        boolean isObjectProperty = element instanceof JSProperty || element instanceof JSDefinitionExpression || element instanceof JSField || element instanceof JSRecordType.PropertySignature;
        return isObjectProperty && element instanceof PsiNamedElement && INTERNALLY_USED_NAMES.contains(((PsiNamedElement)element).getName());
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (!JSResolveUtil.isSelfReference((PsiElement)node) || !(node.getParent() instanceof JSNamedElement)) {
            return;
        }
        JSNamedElement parent = (JSNamedElement)node.getParent();
        if (parent instanceof JSNamedExpression) {
            return;
        }
        this.queueCandidate((PsiElement)node);
    }

    public void visitJSClass(JSClass aClass) {
        if (!(aClass instanceof JSNamedExpression)) {
            this.queueCandidate((PsiElement)aClass);
        }
    }

    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.queueCandidate((PsiElement)node);
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.queueCandidate((PsiElement)exportDeclaration);
    }

    public void visitJSFunctionExpression(JSFunctionExpression node) {
        this.queueCandidate((PsiElement)node);
    }

    public void visitJSFunctionDeclaration(JSFunction node) {
        this.queueCandidate((PsiElement)node);
    }

    public void visitJSVariable(JSVariable node) {
        this.queueCandidate((PsiElement)node);
    }

    public void visitJSDefinitionExpression(JSDefinitionExpression node) {
        JSExpression expression = node.getExpression();
        if (expression instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            boolean doCheck = this.myReportUnusedDefinitions;
            if (qualifier instanceof JSThisExpression || qualifier instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
                doCheck = true;
            }
            if (doCheck) {
                this.queueCandidate((PsiElement)node);
            }
        }
    }

    public void visitJSProperty(JSProperty node) {
        if (this.myReportUnusedProperties || JSUnusedGlobalCandidatesCollector.isFunctionProperty(node)) {
            this.queueCandidate((PsiElement)node);
        }
    }

    private static boolean isFunctionProperty(@NotNull JSProperty node) {
        if (node == null) {
            JSUnusedGlobalCandidatesCollector.$$$reportNull$$$0(4);
        }
        if (node.tryGetFunctionInitializer() != null) {
            return true;
        }
        JSExpression value = node.getValue();
        if (!(value instanceof JSReferenceExpression) || ((JSReferenceExpression)value).getQualifier() != null || !Objects.equals(((JSReferenceExpression)value).getReferenceName(), node.getName())) {
            return false;
        }
        PsiElement resolve = ((JSReferenceExpression)value).resolve();
        return resolve instanceof JSFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outCandidates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalCandidatesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "queueCandidate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitlyUsed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

