/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.JSImportModulesSuggester;
import com.intellij.lang.javascript.modules.JSSimpleModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportElementFilter;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXNamespaceValidationInspection
extends JSInspection
implements JSXNamespaceProvider {
    private static final Key<Boolean> VALIDATED_FLAG = Key.create((String)"JSX.Inspection.Namespace.Validation");
    private static final Pattern JSX_PRAGMA = Pattern.compile("^@jsx\\s+(\\S+)\\s*.*");
    private static final SemVer REACT_17 = new SemVer("17.0.0", 17, 0, 0);
    public boolean importPopup = false;
    @NlsSafe
    public String requiredNamespace = "React";

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (!(node.getContainingFile() instanceof JSFile)) {
                    return;
                }
                if (!DialectDetector.isJSX((PsiElement)node)) {
                    return;
                }
                if (!(node instanceof JSXmlLiteralExpression)) {
                    return;
                }
                if (Boolean.TRUE.equals(session.getUserData(VALIDATED_FLAG))) {
                    return;
                }
                String namespace = JSXNamespaceValidationInspection.this.getNamespace((PsiElement)node);
                if (StringUtil.isEmpty((String)namespace)) {
                    return;
                }
                JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)node, JSExecutionScope.class);
                if (scope == null) {
                    return;
                }
                final Ref hasElement = Ref.create((Object)Boolean.FALSE);
                JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, new JSResolveProcessorBase(namespace){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        hasElement.set((Object)Boolean.TRUE);
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$1$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, true);
                if (((Boolean)hasElement.get()).booleanValue()) {
                    return;
                }
                JSXNamespaceValidationInspection.this.registerProblem(holder, session, node, namespace);
            }
        };
    }

    @Override
    @Nullable
    public String getNamespace(@NotNull PsiElement context) {
        String pragma;
        if (context == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(2);
        }
        return (pragma = JSXNamespaceValidationInspection.calcNamespaceFromContext(context.getContainingFile())) != null ? pragma : this.requiredNamespace;
    }

    @Nullable
    private static String calcNamespaceFromContext(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(3);
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            PsiComment comment;
            TypeScriptConfig config2;
            CachedValueProvider.Result<String> resultReact17 = JSXNamespaceValidationInspection.checkReact17(file2);
            if (resultReact17 != null) {
                return resultReact17;
            }
            if (DialectDetector.isTypeScript((PsiElement)file2) && (config2 = TypeScriptConfigUtil.getConfigForPsiFile(file2)) != null) {
                String factory = config2.jsxFactory();
                if (factory != null) {
                    int qualifierSeparator = factory.indexOf(".");
                    return CachedValueProvider.Result.create((Object)(qualifierSeparator > 0 ? factory.substring(0, qualifierSeparator) : factory), (Object[])new Object[]{file2});
                }
                String namespace = config2.getRawCompilerOption("reactNamespace");
                if (!StringUtil.isEmpty((String)namespace)) {
                    return CachedValueProvider.Result.create((Object)namespace, (Object[])new Object[]{file2, config2.getConfigFile(), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
                }
            }
            if ((comment = JSPsiImplUtils.findTopLevelComment(file2, (Condition<? super PsiComment>)((Condition)el -> el.getText().contains("@jsx ")))) == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{file2});
            }
            String text = StringUtil.trim((String)JSDocumentationUtils.unwrapCommentDelimiters(comment.getText()));
            Matcher matcher = JSX_PRAGMA.matcher(text);
            if (!matcher.matches()) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{file2, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            }
            String result2 = matcher.group(1);
            if (StringUtil.isEmpty((String)result2)) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{file2, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            }
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{file2, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        });
    }

    @Nullable
    private static CachedValueProvider.Result<String> checkReact17(@NotNull PsiFile file2) {
        SemVer ver;
        PackageJsonData create;
        PackageJsonData.PackageJsonDependencyEntry react;
        VirtualFile packageJson;
        VirtualFile root;
        ResolvedModuleInfo info;
        if (file2 == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(4);
        }
        if ((info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(file2.getVirtualFile(), "react", NodeModuleDirectorySearchProcessor.PROCESSOR)) != null) {
            PackageJsonData data;
            VirtualFile packageJson2 = PackageJsonUtil.findChildPackageJsonFile(info.getModuleSourceRoot());
            PackageJsonData packageJsonData = data = packageJson2 == null ? null : PackageJsonData.getOrCreate(packageJson2);
            if (data != null) {
                SemVer version = data.getVersion();
                if (version != null && version.isGreaterOrEqualThan(REACT_17)) {
                    return CachedValueProvider.Result.create((Object)"", (Object[])new Object[]{packageJson2, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
                }
                return null;
            }
        }
        if ((root = NodeModuleUtil.findMainModuleRoot(file2.getProject(), file2.getVirtualFile())) != null && (packageJson = root.findChild("package.json")) != null && (react = (create = PackageJsonData.getOrCreate(packageJson)).getAllDependencyEntries().get("react")) != null && (ver = react.parseVersion()) != null && ver.isGreaterOrEqualThan(REACT_17)) {
            return CachedValueProvider.Result.create((Object)"", (Object[])new Object[]{packageJson, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        }
        return null;
    }

    private void registerProblem(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, @NotNull JSLiteralExpression context, @NotNull String namespace) {
        if (holder == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(5);
        }
        if (session == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(7);
        }
        if (namespace == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(8);
        }
        session.putUserData(VALIDATED_FLAG, (Object)Boolean.TRUE);
        PsiReference reference = context.getReference();
        if (reference != null) {
            if (context.getContainingFile().getVirtualFile() instanceof VirtualFileWindow) {
                return;
            }
            List<LocalQuickFix> fixes = this.getFixes(context, namespace);
            holder.registerProblemForReference(reference, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JavaScriptBundle.message((String)"jsx.missing.namespace.inspection.text", (Object[])new Object[]{namespace}), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private List<LocalQuickFix> getFixes(@NotNull JSLiteralExpression context, final @NotNull String namespace) {
        if (context == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(9);
        }
        if (namespace == null) {
            JSXNamespaceValidationInspection.$$$reportNull$$$0(10);
        }
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        if (DialectDetector.isTypeScript((PsiElement)context)) {
            ASTNode nameNode = context.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME);
            if (nameNode != null) {
                result2.add((LocalQuickFix)new TypeScriptAddImportStatementFix(namespace, nameNode.getPsi(), this.importPopup, JSImportElementFilter.EMPTY){

                    @Override
                    protected boolean isValidContext(@Nullable PsiElement element) {
                        return true;
                    }

                    @Override
                    @Nls
                    @NotNull
                    public String getText() {
                        String string = JavaScriptBundle.message((String)"tsx.missing.name.quick.fix.name", (Object[])new Object[]{"'" + namespace + "'"});
                        if (string == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$2", "getText"));
                    }
                });
            }
        } else {
            JSSimpleModuleReferenceInfo info = new JSSimpleModuleReferenceInfo(namespace, this.importPopup);
            JSImportModulesSuggester suggester = new JSImportModulesSuggester(info, (PsiElement)context);
            result2.addAll(suggester.findFixes(ResolveResult.EMPTY_ARRAY));
        }
        return result2;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        final JBTextField namespace = new JBTextField(this.requiredNamespace);
        namespace.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                JSXNamespaceValidationInspection.this.requiredNamespace = namespace.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$3", "textChanged"));
            }
        });
        CheckBox importPopup = new CheckBox("", (InspectionProfileEntry)this, "importPopup");
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent(JavaScriptBundle.message((String)"label.import.popup", (Object[])new Object[0]), (JComponent)importPopup);
        builder.addLabeledComponent(JavaScriptBundle.message((String)"label.namespace", (Object[])new Object[0]), (JComponent)namespace);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)builder.getPanel(), "North");
        return wrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamespace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcNamespaceFromContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReact17";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

