/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedLocalSymbolsInspection
extends JSInspection {
    public boolean myIgnoreUnusedFunctionParameters;
    public boolean myIgnoreParametersBeforeUsed = true;
    public boolean myIgnoreUnusedCatchParameters = true;
    public static final String SHORT_NAME = JSUnusedLocalSymbolsInspection.calcShortNameFromClass(JSUnusedLocalSymbolsInspection.class);

    protected boolean shouldVisitVariable(@NotNull JSVariable node) {
        PsiElement statement;
        PsiElement parent;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = parent = (statement = node.getParent()) != null ? statement.getParent() : null;
        if (parent instanceof JSForInStatement) {
            return ((JSForInStatement)parent).getVarDeclaration() != statement;
        }
        return true;
    }

    protected boolean shouldVisitParameter(@NotNull JSParameterListElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(1);
        }
        return true;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(3);
        }
        return new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                if (JSUnusedLocalSymbolsInspection.this.shouldVisitVariable(node) && !(node instanceof JSParameter)) {
                    JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
                }
            }

            public void visitJSCatchBlock(JSCatchBlock node) {
                if (JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedCatchParameters || !node.hasParameter()) {
                    return;
                }
                JSParameter parameter = node.getParameter();
                if (parameter != null && JSUnusedLocalSymbolsInspection.this.shouldVisitParameter((JSParameterListElement)parameter) && JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)parameter) && !JSUnusedLocalSymbolsInspection.isReferencedOrIgnored((JSNamedElement)parameter, (PsiElement)node)) {
                    JSUnusedLocalSymbolsInspection.reportUnused((PsiElement)node, (JSNamedElement)parameter, holder);
                }
            }

            public void visitJSParameterList(JSParameterList parameterList) {
                boolean breakAfterUsed;
                JSParameterListElement[] variables = parameterList.getParameters();
                JSParameterListElement first = Arrays.stream(variables).filter(p -> !TypeScriptPsiUtil.isThisParameter((JSParameterItem)p)).findFirst().orElse(null);
                if (first == null || !JSUnusedLocalSymbolsInspection.this.shouldVisitParameter(first)) {
                    return;
                }
                JSFunction function2 = first.getDeclaringFunction();
                if (function2 == null || function2 instanceof TypeScriptFunctionType) {
                    return;
                }
                Processor scopeSkipChecker = scopeNode -> scopeNode == null || scopeNode instanceof JSFunction && (JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedFunctionParameters || JSPsiImplUtils.getFunctionBody(function2) == null);
                boolean isTypescript = DialectDetector.isTypeScript((PsiElement)function2);
                boolean bl = breakAfterUsed = JSUnusedLocalSymbolsInspection.this.myIgnoreParametersBeforeUsed && (!isTypescript || function2.getAccessType() != JSAttributeList.AccessType.PRIVATE);
                if (isTypescript && function2.isConstructor()) {
                    Convertor scopeProvider = variable -> {
                        PsiElement varScope = JSUnusedLocalSymbolsInspection.getUseScopeElement((JSNamedElement)variable);
                        return scopeSkipChecker.process((Object)varScope) ? null : varScope;
                    };
                    this.checkFunctionParameters(variables, (Convertor<JSParameter, PsiElement>)scopeProvider, breakAfterUsed, false);
                    return;
                }
                if (scopeSkipChecker.process((Object)function2)) {
                    return;
                }
                if (first instanceof JSParameter && !JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)first)) {
                    return;
                }
                this.checkFunctionParameters(variables, (Convertor<JSParameter, PsiElement>)((Convertor)variable -> function2), breakAfterUsed, true);
            }

            private void checkFunctionParameters(JSParameterListElement @NotNull [] variables, @NotNull Convertor<JSParameter, PsiElement> scopeProvider, boolean breakAfterUsed, boolean localityDefined) {
                if (scopeProvider == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (variables == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (int i = variables.length - 1; i >= 0; --i) {
                    JSParameterListElement listElement = variables[i];
                    List params = listElement instanceof JSParameter ? Collections.singletonList((JSParameter)listElement) : ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)listElement).forceIgnore(e -> e instanceof JSParameterList)).filter(JSParameter.class).toList();
                    int unused = 0;
                    boolean hadUsed = false;
                    for (JSParameter variable : params) {
                        boolean isLocal;
                        PsiElement scopeNode = (PsiElement)scopeProvider.convert((Object)variable);
                        if (scopeNode == null || !(isLocal = localityDefined || JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)variable))) continue;
                        if (!JSUnusedLocalSymbolsInspection.isReferencedOrIgnored((JSNamedElement)variable, scopeNode)) {
                            JSUnusedLocalSymbolsInspection.reportUnused(scopeNode, (JSNamedElement)variable, holder);
                            ++unused;
                            continue;
                        }
                        hadUsed = true;
                    }
                    if (hadUsed && unused != params.size() && breakAfterUsed) break;
                }
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
            }

            public void visitJSNamespaceDeclaration(JSNamespaceDeclaration node) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)node, holder);
            }

            public void visitJSClass(JSClass aClass) {
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration((JSNamedElement)aClass, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scopeProvider";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variables";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection$1";
                objectArray[2] = "checkFunctionParameters";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isJSAbstractMethod(JSFunction function2) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)function2);
        boolean js = dialect != null && dialect.isJavaScript();
        JSElement body = JSPsiImplUtils.getFunctionBody(function2);
        if (js && !function2.isArrowFunction() && (body == null || body instanceof JSBlockStatement && PsiTreeUtil.findChildOfAnyType((PsiElement)body, (Class[])new Class[]{JSStatement.class, JSExpression.class}) == null)) {
            return true;
        }
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)function2);
        return docComment instanceof JSDocComment && ((JSDocComment)docComment).hasAbstractTag();
    }

    private static boolean isSupportedFunction(JSFunction element) {
        return !(element instanceof JSFunctionExpression) && !(element.getContext() instanceof JSProperty);
    }

    private void processNamedDeclaration(@NotNull JSNamedElement node, @NotNull ProblemsHolder holder) {
        PsiElement scopeNode;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(5);
        }
        if ((scopeNode = JSUnusedLocalSymbolsInspection.getUseScopeElement(node)) == null) {
            return;
        }
        if (this.isLocallyDefined(node) && !JSUnusedLocalSymbolsInspection.isReferencedOrIgnored(node, scopeNode)) {
            JSUnusedLocalSymbolsInspection.reportUnused(scopeNode, node, holder);
        }
    }

    private static boolean isReferencedOrIgnored(@NotNull JSNamedElement node, @NotNull PsiElement scopeNode) {
        String name;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(6);
        }
        if (scopeNode == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(7);
        }
        if ((name = node.getName()) != null && (name.startsWith("ignore") || node instanceof JSParameter && name.startsWith("_"))) {
            return true;
        }
        if (RefUtil.isImplicitUsage((PsiElement)node)) {
            return true;
        }
        PsiElement originalScopeNode = scopeNode;
        if ((scopeNode = JSUnusedLocalSymbolsInspection.getInjectedScopeOrCurrent(node, scopeNode)) == null) {
            return false;
        }
        Processor processor = reference -> reference instanceof PsiElement && (JSResolveUtil.isSelfReference((PsiElement)reference) || node instanceof JSFunction && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)((PsiElement)reference), (boolean)false));
        return JSUnusedLocalSymbolsInspection.checkUsages(node, scopeNode, originalScopeNode, (Processor<? super PsiReference>)processor);
    }

    @Nullable
    public static PsiElement getInjectedScopeOrCurrent(@NotNull JSNamedElement node, @NotNull PsiElement scopeNode) {
        PsiLanguageInjectionHost host;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(8);
        }
        if (scopeNode == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(9);
        }
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)node.getProject());
        if (scopeNode instanceof JSEmbeddedContent) {
            scopeNode = scopeNode.getContainingFile();
        } else if (ilm.isInjectedFragment(scopeNode.getContainingFile()) && (host = ilm.getInjectionHost((PsiElement)scopeNode.getContainingFile())) != null) {
            scopeNode = host.getContainingFile();
        }
        return scopeNode;
    }

    public static boolean checkUsages(@NotNull JSNamedElement node, @NotNull PsiElement injectionHolderScopeNode, @NotNull PsiElement scopeNode, @NotNull Processor<? super PsiReference> processor) {
        PsiElement[] psiElementArray;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(10);
        }
        if (injectionHolderScopeNode == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(11);
        }
        if (scopeNode == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(13);
        }
        if (injectionHolderScopeNode != scopeNode) {
            PsiElement[] psiElementArray2 = new PsiElement[2];
            psiElementArray2[0] = injectionHolderScopeNode;
            psiElementArray = psiElementArray2;
            psiElementArray2[1] = scopeNode;
        } else {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = scopeNode;
        }
        PsiElement[] scopeElements = psiElementArray;
        LocalSearchScope scope = new LocalSearchScope(scopeElements, null);
        return !ReferencesSearch.search((PsiElement)node, (SearchScope)scope, (boolean)true).forEach(processor);
    }

    private static void reportUnused(@NotNull PsiElement scope, @NotNull JSNamedElement namedElement, @NotNull ProblemsHolder holder) {
        PsiElement highlightedElement;
        if (scope == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(14);
        }
        if (namedElement == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(15);
        }
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(16);
        }
        boolean asInfo = false;
        if (namedElement instanceof JSParameter) {
            if (namedElement.getName() == null) {
                return;
            }
            if (scope instanceof JSFunction) {
                boolean ecma;
                boolean bl = ecma = scope.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                if (ecma && scope instanceof JSFunctionExpression) {
                    return;
                }
                JSFunction fun = (JSFunction)scope;
                JSDestructuringProperty[] attributeList = fun.getAttributeList();
                boolean bl2 = asInfo = holder.isOnTheFly() && (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || JSInheritanceUtil.participatesInHierarchy(fun) || JSUnusedLocalSymbolsInspection.isJSAbstractMethod(fun));
            }
        }
        if (namedElement instanceof JSVariable) {
            PsiElement parent;
            JSDestructuringProperty prop = (JSDestructuringProperty)ObjectUtils.tryCast((Object)namedElement.getParent(), JSDestructuringProperty.class);
            PsiElement psiElement = parent = prop == null || prop.isRest() ? null : prop.getParent();
            if (parent instanceof JSDestructuringObject) {
                for (JSDestructuringProperty property : ((JSDestructuringObject)parent).getProperties()) {
                    if (!property.isRest()) continue;
                    return;
                }
            }
        }
        if ((highlightedElement = namedElement.getNameIdentifier()) == null || highlightedElement.getTextRange().isEmpty()) {
            return;
        }
        SmartList fixes = new SmartList();
        if (!(asInfo || scope instanceof JSFunction && ((JSFunction)scope).isSetProperty())) {
            FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(new JSNamedElementPresenter((PsiElement)namedElement).describeWithShortName());
            fix.registerElementRefForFix(highlightedElement, null);
            fixes.add(fix);
        }
        if (holder.isOnTheFly() && scope instanceof JSFunction && namedElement instanceof JSParameter) {
            JSFixFactory.getInstance().addFixesForFields((JSFunction)scope, highlightedElement, namedElement.getName(), (List<LocalQuickFix>)fixes);
        }
        LocalQuickFix[] quickFixes = fixes.size() == 0 ? LocalQuickFix.EMPTY_ARRAY : fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        ProblemHighlightType highlightType = asInfo ? ProblemHighlightType.INFORMATION : ProblemHighlightType.LIKE_UNUSED_SYMBOL;
        holder.registerProblem(highlightedElement, JSUnusedLocalSymbolsInspection.unusedMessage((PsiElement)namedElement), highlightType, quickFixes);
    }

    @NotNull
    @InspectionMessage
    public static String unusedMessage(PsiElement element) {
        String string = JavaScriptBundle.message((String)"js.unused.symbol", (Object[])new Object[]{new JSNamedElementPresenter(element).describeElementKind()});
        if (string == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean isNotGloballyDefined(@NotNull JSNamedElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(18);
        }
        return JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node) || JSUnusedLocalSymbolsInspection.locallyDefinedInScope(node);
    }

    protected boolean isLocallyDefined(JSNamedElement node) {
        return JSUnusedLocalSymbolsInspection.locallyDefinedInScope(node) && !JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node);
    }

    private static boolean isNonDefinitionExpression(@NotNull JSNamedElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(19);
        }
        return node instanceof JSExpression && !(node instanceof JSDefinitionExpression);
    }

    private static boolean locallyDefinedInScope(JSNamedElement node) {
        if (node instanceof JSFunction && !JSUnusedLocalSymbolsInspection.isSupportedFunction((JSFunction)node)) {
            return false;
        }
        return JSUseScopeProvider.getUseScopeElement(node) != null;
    }

    private static PsiElement getUseScopeElement(JSNamedElement node) {
        if (node instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)node).getStub() != null) {
            return null;
        }
        return JSUseScopeProvider.getUseScopeElement(node);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        JBPanel wrapper = new JBPanel((LayoutManager)new BorderLayout());
        JLabel label = new JLabel(JavaScriptBundle.message((String)"javascript.ignore.unused.function.parameters", (Object[])new Object[0]));
        EmptyBorder border = new EmptyBorder((Insets)JBUI.insets((int)0, (int)5, (int)5, (int)5));
        label.setBorder(border);
        wrapper.add((Component)label, (Object)"West");
        JComboBox<MyIgnoreUnusedParametersOption> comboBox = new JComboBox<MyIgnoreUnusedParametersOption>(MyIgnoreUnusedParametersOption.values());
        label.setLabelFor(comboBox);
        comboBox.setEditable(false);
        comboBox.setBorder(border);
        comboBox.setSelectedItem((Object)(this.myIgnoreUnusedFunctionParameters ? MyIgnoreUnusedParametersOption.all : (this.myIgnoreParametersBeforeUsed ? MyIgnoreUnusedParametersOption.beforeUsed : MyIgnoreUnusedParametersOption.none)));
        comboBox.addActionListener(e -> {
            Object selected = comboBox.getSelectedItem();
            if (MyIgnoreUnusedParametersOption.all.equals(selected)) {
                this.myIgnoreUnusedFunctionParameters = true;
                this.myIgnoreParametersBeforeUsed = false;
            } else {
                this.myIgnoreUnusedFunctionParameters = false;
                this.myIgnoreParametersBeforeUsed = MyIgnoreUnusedParametersOption.beforeUsed.equals(selected);
            }
        });
        wrapper.add(comboBox, (Object)"East");
        optionsPanel.addComponent((JComponent)wrapper);
        optionsPanel.addCheckbox(JavaScriptBundle.message((String)"javascript.ignore.unused.catch.parameters", (Object[])new Object[0]), "myIgnoreUnusedCatchParameters");
        return optionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHolderScopeNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "unusedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldVisitVariable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldVisitParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNamedDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedOrIgnored";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedScopeOrCurrent";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkUsages";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportUnused";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNotGloballyDefined";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isNonDefinitionExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum MyIgnoreUnusedParametersOption {
        all("All"),
        beforeUsed("Before used"),
        none("None");

        private final String myText;

        private MyIgnoreUnusedParametersOption(String text) {
            if (text == null) {
                MyIgnoreUnusedParametersOption.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection$MyIgnoreUnusedParametersOption", "<init>"));
        }
    }
}

