/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalCandidatesCollector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolsPass;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JSUnusedGlobalSymbolsInspection
extends JSInspection
implements PairedUnfairLocalInspectionTool {
    public static final String SHORT_NAME = JSUnusedGlobalSymbolsInspection.calcShortNameFromClass(JSUnusedGlobalSymbolsInspection.class);
    public boolean myReportUnusedDefinitions;
    public boolean myReportUnusedProperties;
    private static final Key<Set<PsiElement>> CANDIDATE_ELEMENTS_KEY = Key.create((String)"js.unused.global.symbols.candidates");

    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(1);
        }
        if (this.myOnTheFly) {
            JSElementVisitor jSElementVisitor = JSElementVisitor.NOP_ELEMENT_VISITOR;
            if (jSElementVisitor == null) {
                JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(2);
            }
            return jSElementVisitor;
        }
        HashSet candidates = new HashSet();
        session.putUserData(CANDIDATE_ELEMENTS_KEY, candidates);
        return new JSUnusedGlobalCandidatesCollector(candidates, this);
    }

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(4);
        }
        if (problemsHolder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(5);
        }
        if (this.myOnTheFly) {
            return;
        }
        ConcurrentLinkedQueue unusedSymbols = new ConcurrentLinkedQueue();
        Set candidates = (Set)session.getUserData(CANDIDATE_ELEMENTS_KEY);
        if (candidates == null) {
            return;
        }
        JSUnusedGlobalSymbolsPass.searchForUnusedSymbols(session.getFile(), candidates, unusedSymbols);
        for (PsiElement unusedSymbol : unusedSymbols) {
            JSUnusedGlobalSymbolsPass.JSUnusedSymbolProblemDescriptor descriptor2 = JSUnusedGlobalSymbolsPass.registerProblem(unusedSymbol);
            if (descriptor2 == null) continue;
            TextRange range = descriptor2.myRange;
            if (range != null) {
                range = range.shiftLeft(descriptor2.myIdentifier.getTextRange().getStartOffset());
            }
            problemsHolder.registerProblem(descriptor2.myIdentifier, range, descriptor2.myMessage, descriptor2.myFixes);
        }
    }

    @NotNull
    public static GlobalSearchScope skipLibraryFiles(final @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(7);
        }
        return new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile(file2, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$1", "contains"));
            }
        };
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JavaScriptBundle.message((String)"javascript.report.unused.properties", (Object[])new Object[0]), "myReportUnusedProperties");
        optionsPanel.addCheckbox(JavaScriptBundle.message((String)"javascript.report.unused.definitions", (Object[])new Object[0]), "myReportUnusedDefinitions");
        return optionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionForBatchShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipLibraryFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

