/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.javascript.validation.JavaScriptReferenceProblemReporter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnresolvedVariableInspection
extends JSInspection {
    public boolean myStrictlyCheckGlobalDefinitions;
    public boolean myStrictlyCheckProperties = true;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSUnresolvedVariableInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel result2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        result2.addCheckbox(JavaScriptBundle.message((String)"javascript.strictly.check.global.vars", (Object[])new Object[0]), "myStrictlyCheckGlobalDefinitions");
        result2.addCheckbox(JavaScriptBundle.message((String)"javascript.strictly.check.object.properties", (Object[])new Object[0]), "myStrictlyCheckProperties");
        return result2;
    }

    @Nullable
    public static JSCallLikeExpression getCallIfMethodExpression(@NotNull JSReferenceExpression expression) {
        JSExpression methodExpression;
        PsiElement parent;
        if (expression == null) {
            JSUnresolvedVariableInspection.$$$reportNull$$$0(1);
        }
        return (parent = (methodExpression = JSUtils.getTopmostParenthesizedOrSelf((JSExpression)expression)).getParent()) instanceof JSCallLikeExpression && ((JSCallLikeExpression)parent).getMethodExpression() == methodExpression ? (JSCallLikeExpression)parent : null;
    }

    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnresolvedVariableInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSUnresolvedVariableInspection.$$$reportNull$$$0(3);
        }
        return new JSUnresolvedVariableInspectionVisitor(new JavaScriptReferenceProblemReporter(holder){

            @Override
            @Nullable
            public Void registerProblem(PsiElement referenceNameElement, @Nullable TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                PsiElement parent;
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JSUnresolvedVariableInspection.this.myStrictlyCheckProperties && !(parent = referenceNameElement.getParent()).getFirstChild().equals(referenceNameElement)) {
                    return null;
                }
                if (JSUnresolvedVariableInspection.this.myStrictlyCheckGlobalDefinitions && (parent = referenceNameElement.getParent()) instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
                    highlightType = ProblemHighlightType.ERROR;
                }
                return super.registerProblem(referenceNameElement, rangeWithinElement, message, highlightType, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/inspections/JSUnresolvedVariableInspection$1", "registerProblem"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnresolvedVariableInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedVariableInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCallIfMethodExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSUnresolvedVariableInspectionVisitor
    extends JSReferenceInspectionVisitor {
        protected JSUnresolvedVariableInspectionVisitor(@NotNull JSProblemReporter<?> reporter) {
            if (reporter == null) {
                JSUnresolvedVariableInspectionVisitor.$$$reportNull$$$0(0);
            }
            super(reporter);
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            if (JSUnresolvedVariableInspection.getCallIfMethodExpression(node) != null) {
                return;
            }
            ResolveResult[] results = node.multiResolve(false);
            if (JSAccessibilityCheckInspection.isSymbolNotAccessible(results)) {
                return;
            }
            JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkRefExpression(node);
        }

        public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            ES6ExportDeclaration declaration = node.getDeclaration();
            if (declaration != null && declaration.getFromClause() == null) {
                ResolveResult result2;
                ResolveResult[] results = node.multiResolve(false);
                if (results.length == 0) {
                    this.myReporter.registerProblem((PsiElement)node, null, XmlHighlightVisitor.getErrorDescription((PsiReference)node), null, JSReferenceChecker.getCreateFixesForUnresolvedRef((ES6ImportExportDeclarationPart)node));
                } else if (results.length == 1 && !(result2 = results[0]).isValidResult()) {
                    String key;
                    String message = null;
                    if (result2 instanceof JSResolveResult && (key = ((JSResolveResult)result2).getResolveProblemKey()) != null) {
                        message = JavaScriptBundle.message((String)key, (Object[])new Object[0]);
                    }
                    String s = message != null ? message : XmlHighlightVisitor.getErrorDescription((PsiReference)node);
                    this.myReporter.registerProblem((PsiElement)node, null, s, null, new LocalQuickFix[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/javascript/inspections/JSUnresolvedVariableInspection$JSUnresolvedVariableInspectionVisitor", "<init>"));
        }
    }
}

