/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSUnresolvedReactComponentInspection
extends JSInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSUnresolvedReactComponentInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnresolvedReactComponentInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUnresolvedReactComponentInspection.$$$reportNull$$$0(2);
        }
        return new JSUnresolvedReactComponentInspectionVisitor(new JSReferenceProblemReporter(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnresolvedReactComponentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedReactComponentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSUnresolvedReactComponentInspectionVisitor
    extends JSReferenceInspectionVisitor {
        public JSUnresolvedReactComponentInspectionVisitor(@NotNull JSProblemReporter<?> reporter) {
            if (reporter == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(0);
            }
            super(reporter);
        }

        public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
            if (node == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(1);
            }
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            if (node instanceof JSXXmlLiteralExpressionImpl) {
                this.processXmlLiteralExpression((JSXXmlLiteralExpressionImpl)node);
            }
            super.visitJSLiteralExpression(node);
        }

        private void processXmlLiteralExpression(JSXmlLiteralExpression expression) {
            ASTNode nameNode;
            if (!StringUtil.isCapitalized((String)expression.getName())) {
                return;
            }
            if (!JSXResolveUtil.areReferencesResolvedOrEmpty(expression) && (nameNode = expression.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME)) != null) {
                PsiElement psi = nameNode.getPsi();
                LocalQuickFix[] fixes = JSUnresolvedReactComponentInspectionVisitor.getUnresolvedXmlLiteralFixes(expression);
                if (fixes.length > 0 || DialectDetector.isTypeScript((PsiElement)expression) || ES6PsiUtil.findExternalModule((PsiElement)expression) != null) {
                    this.myReporter.registerProblem(psi, null, JavaScriptBundle.message((String)"javascript.validation.message.unresolved.component", (Object[])new Object[]{nameNode.getText()}), null, fixes);
                }
            }
        }

        private static LocalQuickFix @NotNull [] getUnresolvedXmlLiteralFixes(@NotNull JSXmlLiteralExpression expression) {
            if (expression == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(2);
            }
            ArrayList quickFixes = new ArrayList();
            JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl info = new JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl(quickFixes);
            for (JSUnresolvedReferenceErrorUpdater provider : JSUnresolvedReferenceErrorUpdater.EP_NAME.getExtensionList()) {
                provider.updateError(info, expression);
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            if (localQuickFixArray == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(3);
            }
            return localQuickFixArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reporter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnresolvedReactComponentInspection$JSUnresolvedReactComponentInspectionVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedReactComponentInspection$JSUnresolvedReactComponentInspectionVisitor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedXmlLiteralFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSLiteralExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnresolvedXmlLiteralFixes";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

