/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSConvertLoopsUtils;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReplaceForOfWithIndexedIntention
extends JavaScriptIntention {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && JSReplaceForOfWithIndexedIntention.isForOfStatement(element) && DialectDetector.hasFeature(element, JSLanguageFeature.FOR_OF) && JSReplaceForOfWithIndexedIntention.isAvailable(element);
    }

    private static boolean isAvailable(@NotNull PsiElement element) {
        JSForInStatement statement;
        if (element == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(2);
        }
        if ((statement = JSReplaceForOfWithIndexedIntention.getForOfStatement(element)) == null) {
            return false;
        }
        JSExpression collectionExpression = statement.getCollectionExpression();
        return (statement.getVarDeclaration() != null || statement.getVariableExpression() != null) && JSConvertLoopsUtils.isArrayType(collectionExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(4);
        }
        PsiElement parent = element.getParent();
        assert (parent instanceof JSForInStatement);
        JSForInStatement forInStatement = (JSForInStatement)parent;
        JSStatement newStatement = JSConvertLoopsUtils.getIndexedStatementFromForOf(forInStatement);
        forInStatement.replace(newStatement);
    }

    @Nullable
    private static JSForInStatement getForOfStatement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(5);
        }
        if (!((parent = element.getParent()) instanceof JSForInStatement)) {
            return null;
        }
        return (JSForInStatement)parent;
    }

    private static boolean isForOfStatement(@NotNull PsiElement element) {
        JSForInStatement statement;
        if (element == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(6);
        }
        if ((statement = JSReplaceForOfWithIndexedIntention.getForOfStatement(element)) == null) {
            return false;
        }
        return statement.isForEach();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"js.convert.for.of.to.indexed.intention.family", (Object[])new Object[0]);
        if (string == null) {
            JSReplaceForOfWithIndexedIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSReplaceForOfWithIndexedIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSReplaceForOfWithIndexedIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getForOfStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isForOfStatement";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

