/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSConvertLoopsUtils;
import com.intellij.lang.javascript.intentions.ES6ConvertMapToForOfIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReplaceForEachWithForOfIntention
extends JavaScriptIntention {
    private final boolean myFromInnerFunction;

    public JSReplaceForEachWithForOfIntention() {
        this(false);
    }

    public JSReplaceForEachWithForOfIntention(boolean fromInnerFunction) {
        this.myFromInnerFunction = fromInnerFunction;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && DialectDetector.hasFeature(element, JSLanguageFeature.FOR_OF) && this.isAvailable(element);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSCallExpression callExpression;
        if (project == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(3);
        }
        if ((callExpression = this.findFunctionCall(element)) == null) {
            return;
        }
        PsiElement jsStatement = JSUtils.getParentSkipParentheses((PsiElement)callExpression);
        if (jsStatement == null) {
            return;
        }
        JSFunction function2 = JSConvertLoopsUtils.getFunction(callExpression);
        if (function2 == null) {
            return;
        }
        JSStatement forInStatement = this.getStatement(callExpression, function2);
        if (forInStatement == null) {
            return;
        }
        jsStatement.replace((PsiElement)forInStatement);
    }

    @Nullable
    protected JSStatement getStatement(@NotNull JSCallExpression callExpression, @NotNull JSFunction function2) {
        if (callExpression == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(4);
        }
        if (function2 == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(5);
        }
        return JSConvertLoopsUtils.getForInStatementFromForEachCall(callExpression, function2, JSConvertLoopsUtils.LoopType.FOR_OF);
    }

    protected boolean isAvailable(@NotNull PsiElement element) {
        JSCallExpression callExpression;
        if (element == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(6);
        }
        if (JSConvertLoopsUtils.isForEachCall(callExpression = this.findFunctionCall(element)) && JSUtils.getParentSkipParentheses((PsiElement)callExpression) instanceof JSStatement) {
            JSFunction function2 = JSConvertLoopsUtils.getFunction(callExpression);
            JSType expressionType = JSResolveUtil.getExpressionJSType(JSConvertLoopsUtils.getCollectionExpression(callExpression));
            if (function2 == null) {
                return false;
            }
            boolean hasIndexOf = JSConvertLoopsUtils.hasMemberInArrayLike(expressionType, "indexOf");
            if (!ES6ConvertMapToForOfIntention.hasOnlySupportedParameters(function2, callExpression, hasIndexOf ? 2 : 1)) {
                return false;
            }
            return this.isExpressionAcceptable(function2, callExpression, expressionType);
        }
        return false;
    }

    protected boolean isExpressionAcceptable(@NotNull JSFunction function2, @NotNull JSCallExpression callExpression, @Nullable JSType expressionType) {
        JSParameterListElement[] parameters;
        if (function2 == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(7);
        }
        if (callExpression == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(8);
        }
        if ((parameters = function2.getParameters()).length > 1 && parameters[0] instanceof JSDestructuringParameter) {
            return false;
        }
        return !JSConvertLoopsUtils.isTypeWithNames(expressionType, JSCommonTypeNames.MAP_ITERABLES);
    }

    @Nullable
    private JSCallExpression findFunctionCall(@NotNull PsiElement element) {
        if (element == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(9);
        }
        if (this.myFromInnerFunction) {
            PsiElement grandParent;
            JSFunctionExpression parent = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunctionExpression.class);
            if (parent != null && parent.getParent() instanceof JSArgumentList && (grandParent = parent.getParent().getParent()) instanceof JSCallExpression) {
                return (JSCallExpression)grandParent;
            }
            return null;
        }
        return JSReplaceForEachWithForOfIntention.findCallExpression(element);
    }

    @Nullable
    public static JSCallExpression findCallExpression(@NotNull PsiElement element) {
        PsiElement call;
        if (element == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(10);
        }
        if (element instanceof JSCallExpression) {
            return (JSCallExpression)element;
        }
        if (Holder.PRIMITIVES.contains(element.getNode().getElementType()) || JSTokenTypes.OPERATIONS.contains(element.getNode().getElementType())) {
            element = element.getParent();
        }
        if (element.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
            element = element.getParent();
        }
        if (JSTokenTypes.LITERALS.contains(element.getNode().getElementType()) && element.getParent() instanceof JSLiteralExpression) {
            element = element.getParent();
        }
        while (element instanceof JSExpression && !(element instanceof JSReferenceExpression)) {
            element = element.getParent();
        }
        if (element instanceof JSReferenceExpression && (call = JSResolveUtil.getTopReferenceParent(element)) instanceof JSCallExpression) {
            return (JSCallExpression)call;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"js.convert.for.each.to.for.of.intention.family", (Object[])new Object[0]);
        if (string == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSReplaceForEachWithForOfIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSReplaceForEachWithForOfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSReplaceForEachWithForOfIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionAcceptable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findCallExpression";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final TokenSet PRIMITIVES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DOT, JSTokenTypes.ELVIS, JSElementTypes.DOT_SHARP, JSTokenTypes.COMMA, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR});

        private Holder() {
        }
    }
}

