/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPotentiallyInvalidTargetOfIndexedPropertyAccess
extends JSInspection {
    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
                PsiElement resolve;
                JSExpression indexExpression = node.getIndexExpression();
                if (indexExpression instanceof JSBinaryExpression && ((JSBinaryExpression)indexExpression).getOperationSign() == JSTokenTypes.COMMA) {
                    indexExpression = ((JSBinaryExpression)indexExpression).getROperand();
                }
                JSExpression qualifier = node.getQualifier();
                if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral() && qualifier instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) instanceof JSClass || JSPotentiallyInvalidTargetOfIndexedPropertyAccess.this.isInvalidUsage(resolve))) {
                    PsiElement element = ((JSReferenceExpression)qualifier).getReferenceNameElement();
                    holder.registerProblem((PsiElement)(element != null ? element : qualifier), JavaScriptBundle.message((String)"javascript.potentially.invalid.target.of.indexed.property.access", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    public boolean isInvalidUsage(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return false;
        }
        if (resolve instanceof JSClass) {
            return true;
        }
        if (resolve instanceof TypeScriptVariable) {
            JSType type = ((TypeScriptVariable)resolve).getJSType();
            if (type == null || type instanceof JSArrayType || type instanceof JSTupleType) {
                return false;
            }
            JSRecordType recordType = type.asRecordType();
            return !recordType.hasIndexers() && !recordType.getCallSignatures().isEmpty();
        }
        return resolve instanceof JSFunction && !((JSFunction)resolve).isGetProperty();
    }
}

