/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSOctalIntegerInspection
extends JSInspection {
    public boolean myReportNonStrictEs5;

    public JSOctalIntegerInspection() {
    }

    public JSOctalIntegerInspection(boolean reportNonStrictEs5) {
        this.myReportNonStrictEs5 = reportNonStrictEs5;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSOctalIntegerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSOctalIntegerInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                JSLiteralExpressionKind expressionKind = node.getExpressionKind(true);
                if (expressionKind == JSLiteralExpressionKind.OBSOLETE_OCT) {
                    if (DialectDetector.isES6((PsiElement)node) || DialectDetector.isTypeScript((PsiElement)node)) {
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"javascript.octal.literals.are.not.allowed.es6.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithEs6OctLiteralFix(node, "0o" + node.getText().substring(1))});
                    } else if (JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"javascript.octal.literals.are.not.allowed.in.strict.mode", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else if (JSOctalIntegerInspection.this.myReportNonStrictEs5) {
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"javascript.octal.literals.are.not.allowed.es5.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JavaScriptBundle.message((String)"javascript.octal.literals.warn.always", (Object[])new Object[0]), null, "myReportNonStrictEs5");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ReplaceWithEs6OctLiteralFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myNewText;

        private ReplaceWithEs6OctLiteralFix(JSLiteralExpression node, String newText) {
            super((PsiElement)node);
            this.myNewText = newText;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.replace.with.literal", (Object[])new Object[]{"0o"});
            if (string == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"js.replace.with.literal", (Object[])new Object[]{this.myNewText});
            if (string == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(5);
            }
            startElement.replace((PsiElement)JSPsiElementFactory.createJSExpression(this.myNewText, startElement));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection$ReplaceWithEs6OctLiteralFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection$ReplaceWithEs6OctLiteralFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

