/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMethodCanBeStaticInspection
extends JSInspection {
    protected static final String ONLY_PRIVATE_ATTR_NAME = "myOnlyPrivate";
    public boolean myOnlyPrivate = true;

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSFunctionDeclaration(final @NotNull JSFunction function2) {
                TypeScriptFunction tsFunction;
                Condition[] classAttributeList;
                JSClass clazz;
                if (function2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((clazz = JSUtils.getMemberContainingClass((PsiElement)function2)) == null) {
                    return;
                }
                if (clazz.isInterface()) {
                    return;
                }
                if (clazz.getName() == null) {
                    return;
                }
                PsiElement nameIdentifier = function2.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                JSAttributeList attributeList = function2.getAttributeList();
                if (attributeList == null || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                    return;
                }
                if (attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE && JSMethodCanBeStaticInspection.this.myOnlyPrivate) {
                    return;
                }
                if (function2.isConstructor() || "toString".equals(function2.getName())) {
                    return;
                }
                if (!attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && (classAttributeList = clazz.getAttributeList()) != null && classAttributeList.findAttributeByName("Abstract") != null) {
                    return;
                }
                for (Condition addin : (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions()) {
                    if (!addin.value((Object)function2)) continue;
                    return;
                }
                if (JSMethodCanBeStaticInspection.hasEmptyBody(function2)) {
                    return;
                }
                if (function2 instanceof TypeScriptFunction && (tsFunction = (TypeScriptFunction)function2).hasOverloadDeclarations()) {
                    return;
                }
                JSDocComment docComment = JSDocumentationUtils.findOwnDocComment((PsiElement)function2);
                if (docComment != null && docComment.hasInstanceTag()) {
                    return;
                }
                final Ref dependsOnInstance = new Ref();
                function2.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                    public void visitJSThisExpression(JSThisExpression node) {
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    public void visitJSSuperExpression(JSSuperExpression superExpression) {
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node)) {
                            ResolveResult[] resolveResults = node.multiResolve(false);
                            if (resolveResults.length == 0) {
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                            for (ResolveResult resolveResult : resolveResults) {
                                if (!JSMethodCanBeStaticInspection.checkReferenceResolveResultDependsOnInstance(resolveResult, function2)) continue;
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                        }
                        super.visitJSReferenceExpression(node);
                    }

                    public boolean visitAsFunction(JSFunction function22) {
                        this.checkFunForExternals((JSFunctionBaseImpl)function22);
                        return true;
                    }

                    private void checkFunForExternals(JSFunctionBaseImpl node) {
                        HashSet<String> usedExternalVars = new HashSet<String>();
                        node.addReferencedExternalNames(usedExternalVars);
                        if (usedExternalVars.size() > 0 || node.isArrowFunction() && node.isReferencesThis()) {
                            dependsOnInstance.set((Object)Boolean.TRUE);
                        }
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (dependsOnInstance.get() != null) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection$1$1", "visitElement"));
                    }
                });
                for (ImplicitUsageProvider usageProvider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
                    if (!usageProvider.isImplicitUsage((PsiElement)function2)) continue;
                    return;
                }
                if (dependsOnInstance.get() == null && !JSInheritanceUtil.participatesInMemberHierarchy((JSQualifiedNamedElement)function2)) {
                    holder.registerProblem(nameIdentifier, JavaScriptBundle.message((String)"js.method.can.be.static", (Object[])new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().makeMethodStaticFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection$1", "visitJSFunctionDeclaration"));
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JavaScriptBundle.message((String)"js.method.can.be.static.option", (Object[])new Object[0]), null, ONLY_PRIVATE_ATTR_NAME);
    }

    private static boolean hasEmptyBody(@NotNull JSFunction function2) {
        JSBlockStatement block;
        if (function2 == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(2);
        }
        return (block = function2.getBlock()) == null || block.getStatementListItems().length == 0;
    }

    private static boolean checkReferenceResolveResultDependsOnInstance(@NotNull ResolveResult resolveResult, @NotNull JSFunction function2) {
        PsiElement resolvedMemberParent;
        JSAttributeList resolvedMemberAttrList;
        TypeScriptTypeParameterListOwner parameterOwner;
        if (resolveResult == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(3);
        }
        if (function2 == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(4);
        }
        if (!resolveResult.isValidResult()) {
            return true;
        }
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof ImplicitJSVariableImpl && ("hostComponent".equals(((ImplicitJSVariableImpl)resolve).getName()) || "outerDocument".equals(((ImplicitJSVariableImpl)resolve).getName()))) {
            return true;
        }
        if (resolve instanceof TypeScriptTypeParameter && (parameterOwner = ((TypeScriptTypeParameter)resolve).getOwner()) instanceof JSClass) {
            return true;
        }
        return resolve instanceof JSAttributeListOwner && !(resolve instanceof JSClass) ? (resolvedMemberAttrList = ((JSAttributeListOwner)resolve).getAttributeList()) != null && !resolvedMemberAttrList.hasModifier(JSAttributeList.ModifierType.STATIC) && !JSResolveUtil.isConstructorFunction(resolve) && resolve != function2 && (resolvedMemberParent = JSResolveUtil.findParent(resolve)) instanceof JSClass : resolve instanceof JSImplicitElement && ((JSImplicitElement)resolve).getType() == JSImplicitElement.Type.Tag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEmptyBody";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferenceResolveResultDependsOnInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

