/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JSFileReferencesInspection
extends JSInspection {
    public boolean myIgnoreComplexCases = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaScriptBundle.message((String)"js.file.references.inspection.ignore.complex.cases", (Object[])new Object[0]), (InspectionProfileEntry)this, "myIgnoreComplexCases");
    }

    public static boolean acceptsReference(@NotNull PsiReference reference) {
        PsiElement element;
        DialectOptionHolder holder;
        if (reference == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(0);
        }
        if ((holder = DialectDetector.dialectOfElement((element = reference.getElement()) instanceof PsiComment ? element.getParent() : element)) == null) {
            return false;
        }
        if (holder.isTypeScript) {
            if (element instanceof ES6FromClause || element instanceof PsiComment || element.getParent() instanceof ES6ImportCall || element instanceof ES6ImportExportSpecifier || element instanceof TypeScriptExternalModuleReference) {
                return false;
            }
            if (TypeScriptPsiUtil.isLiteralModuleAugmentationName(element)) {
                return false;
            }
        }
        return !holder.isECMA4;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!node.isQuotedLiteral()) {
                    return;
                }
                JSFileReferencesInspection.checkReferences((PsiElement)node, holder, JSFileReferencesInspection.this.myIgnoreComplexCases, (Condition<? super PsiReference>)((Condition)JSFileReferencesInspection::acceptsReference));
            }

            public void visitES6FromClause(@NotNull ES6FromClause fromClause) {
                if (fromClause == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!fromClause.resolveReferencedElements().isEmpty()) {
                    return;
                }
                JSFileReferencesInspection.checkReferences((PsiElement)fromClause, holder, JSFileReferencesInspection.this.myIgnoreComplexCases, (Condition<? super PsiReference>)((Condition)JSFileReferencesInspection::acceptsReference));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fromClause";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFileReferencesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6FromClause";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static void checkReferences(@NotNull PsiElement node, @NotNull ProblemsHolder holder, boolean ignoreComplexCases, @NotNull Condition<? super PsiReference> acceptsReference) {
        if (node == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(4);
        }
        if (acceptsReference == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(5);
        }
        HashMap<TextRange, PsiFileReference> hardRefs = new HashMap<TextRange, PsiFileReference>();
        MultiMap softRefs = MultiMap.create();
        for (PsiReference ref : node.getReferences()) {
            if (!(ref instanceof PsiFileReference) || !acceptsReference.value((Object)ref)) continue;
            PsiFileReference fileRef = (PsiFileReference)ref;
            TextRange range = ref.getRangeInElement();
            if (ref.isSoft() && ignoreComplexCases) {
                softRefs.putValue((Object)range, (Object)fileRef);
                continue;
            }
            if (hardRefs.containsKey(range) && hardRefs.get(range) == null) continue;
            ResolveResult[] results = fileRef.multiResolve(false);
            if (results.length != 0) {
                hardRefs.put(range, null);
                continue;
            }
            hardRefs.put(range, fileRef);
        }
        block1: for (Map.Entry entry : hardRefs.entrySet()) {
            PsiFileReference ref = (PsiFileReference)entry.getValue();
            if (ref == null) continue;
            for (PsiFileReference softRef : softRefs.get((Object)((TextRange)entry.getKey()))) {
                if (softRef.multiResolve(false).length <= 0) continue;
                continue block1;
            }
            String message = XmlHighlightVisitor.getErrorDescription((PsiReference)ref);
            LocalQuickFix[] fixes = ref instanceof LocalQuickFixProvider ? ((LocalQuickFixProvider)ref).getQuickFixes() : LocalQuickFix.EMPTY_ARRAY;
            holder.registerProblem(node, ref.getRangeInElement(), message, fixes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptsReference";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFileReferencesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

