/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSCommentMatchesSignatureInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            public void visitJSDocComment(JSDocComment docComment) {
                JSFunction function2 = JSDocumentationUtils.findFunctionAppliedTo(docComment);
                if (function2 != null) {
                    UpdateFunctionCommentQuickFix fix = null;
                    JSDocumentationUtils.JSDocParametersMappingToFunctionInfo info = JSDocumentationUtils.checkDocCommentMatchesFunctionSignature(docComment, function2);
                    if (info != null && info.hasParamTag()) {
                        JSParameter[] parameters;
                        List<Pair<Integer, String>> paramsToAdd = info.getParamsToAdd();
                        Map<Integer, String> paramsToRemove = info.getParamsToRemove();
                        HashSet<Integer> paramsIndicesToRemove = new HashSet<Integer>(paramsToRemove.size());
                        fix = new UpdateFunctionCommentQuickFix(paramsIndicesToRemove, paramsToAdd);
                        JSDocTag[] tags = paramsToRemove.isEmpty() ? JSDocTag.EMPTY_ARRAY : docComment.getTags();
                        for (Map.Entry entry : paramsToRemove.entrySet()) {
                            JSDocTag elementToHighlight;
                            int a = (Integer)entry.getKey();
                            String b = (String)entry.getValue();
                            paramsIndicesToRemove.add(a);
                            JSDocTag tag = tags[a];
                            ASTNode type = tag.getNode().findChildByType(JSDocTokenTypes.DOC_COMMENT_DATA);
                            Object object = elementToHighlight = type != null ? type.getPsi() : tag;
                            if (b != null) continue;
                            String message = JavaScriptBundle.message((String)"js.comment.matches.signature.inspection.problem2", (Object[])new Object[]{"without name"});
                            holder.registerProblem((PsiElement)elementToHighlight, message, new LocalQuickFix[]{fix});
                        }
                        JSParameter[] jSParameterArray = parameters = paramsToAdd.isEmpty() ? null : function2.getParameterVariables();
                        if (parameters != null) {
                            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(parameters.length);
                            for (int i = 0; i < parameters.length; ++i) {
                                hashMap.put(parameters[i].getName(), i);
                            }
                            for (Pair<Integer, String> entry : paramsToAdd) {
                                holder.registerProblem((PsiElement)parameters[(Integer)hashMap.get(entry.getSecond())], JavaScriptBundle.message((String)"js.comment.matches.signature.inspection.problem1", (Object[])new Object[]{entry.getSecond()}), new LocalQuickFix[]{fix});
                            }
                        }
                    }
                    for (JSDocTag tag : docComment.getTags()) {
                        for (PsiReference ref : tag.getReferences()) {
                            if (!(ref instanceof JSDocParamReference) || !XmlHighlightVisitor.hasBadResolve((PsiReference)ref, (boolean)false)) continue;
                            holder.registerProblem(ref.getElement(), ref.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)ref), new LocalQuickFix[]{fix});
                        }
                    }
                }
            }
        };
    }

    private static class UpdateFunctionCommentQuickFix
    implements LocalQuickFix {
        private final Set<Integer> myParamsToRemove;
        private final List<? extends Pair<Integer, String>> myParamsToAdd;

        UpdateFunctionCommentQuickFix(Set<Integer> paramsToRemove, List<? extends Pair<Integer, String>> paramsToAdd) {
            this.myParamsToRemove = paramsToRemove;
            this.myParamsToAdd = paramsToAdd;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.comment.matches.signature.inspection.quickfix", (Object[])new Object[0]);
            if (string == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            JSFunction function2;
            PsiElement element;
            if (project == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) instanceof JSParameter) {
                JSFunction function22 = ((JSParameter)element).getDeclaringFunction();
            } else {
                JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, JSDocComment.class);
                JSFunction jSFunction = function2 = docComment != null ? JSDocumentationUtils.findFunctionAppliedTo(docComment) : null;
            }
            if (function2 == null) {
                return;
            }
            ArrayList<Pair<Integer, String>> tagsToAdd = new ArrayList<Pair<Integer, String>>(this.myParamsToAdd.size());
            for (Pair<Integer, String> pair : this.myParamsToAdd) {
                tagsToAdd.add((Pair<Integer, String>)Pair.create((Object)((Integer)pair.first), (Object)("param " + (String)pair.second)));
            }
            JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes((PsiElement)function2, tagsToAdd, null, this.myParamsToRemove);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

